/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;

public class MenuSwitch
extends MenuItem {
    public boolean value;
    public MenuProc callback;
    char[] onMessage;
    char[] offMessage;
    public BuildFont switchFont;

    public MenuSwitch(Object text, BuildFont font, int x, int y, int width, boolean value, MenuProc callback, String onMessage, String offMessage) {
        super(text, font);
        this.flags = 7;
        this.x = x;
        this.y = y;
        this.width = width;
        this.value = value;
        this.callback = callback;
        this.onMessage = onMessage != null ? onMessage.toCharArray() : new char[]{'O', 'n'};
        this.offMessage = offMessage != null ? offMessage.toCharArray() : new char[]{'O', 'f', 'f'};
        this.switchFont = font;
    }

    @Override
    public void draw(MenuHandler handler) {
        int shade = handler.getShade(this);
        int pal = handler.getPal(this.font, this);
        if (this.text != null) {
            this.font.drawText(this.x, this.y, this.text, shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        }
        char[] sw = this.offMessage;
        if (this.value) {
            sw = this.onMessage;
        }
        this.switchFont.drawText(this.x + this.width - 1 - this.switchFont.getWidth(sw), this.y + (this.font.getHeight() - this.switchFont.getHeight()) / 2, sw, shade, handler.getPal(this.switchFont, this), BuildFont.TextAlign.Left, 2, this.fontShadow);
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (opt == MenuHandler.MenuOpt.LEFT || opt == MenuHandler.MenuOpt.RIGHT || opt == MenuHandler.MenuOpt.ENTER || opt == MenuHandler.MenuOpt.LMB) {
            if ((this.flags & 4) == 0) {
                return false;
            }
            boolean bl = this.value = !this.value;
            if (this.callback != null) {
                this.callback.run(handler, this);
            }
            return false;
        }
        return this.m_pMenu.mNavigation(opt);
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        int fontx;
        int px;
        if (this.text != null && mx > this.x && mx < this.x + this.font.getWidth(this.text) && my > this.y && my < this.y + this.font.getHeight()) {
            return true;
        }
        char[] sw = this.offMessage;
        if (this.value) {
            sw = this.onMessage;
        }
        if (mx > (px = this.x + this.width - 1 - (fontx = this.font.getWidth(sw))) && mx < px + fontx) {
            return my > this.y && my < this.y + this.font.getHeight();
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

