/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Strhandler;

public abstract class ConnectAdapter
extends ScreenAdapter {
    protected BuildGame game;
    private NetFlag gNetFlag;
    private String[] gNetParam;
    private int ConnectStep = 0;
    private final int nTile;
    private final BuildFont style;

    public ConnectAdapter(BuildGame game, int nTile, BuildFont style) {
        this.game = game;
        this.nTile = nTile;
        this.style = style;
    }

    public abstract void back();

    public abstract void connect();

    @Override
    public void show() {
        this.game.pNet.ResetNetwork();
        Mmulti.initmultiplayers(this.gNetParam, 0);
        this.ConnectStep = 0;
    }

    public ScreenAdapter setFlag(NetFlag flag, String[] param) {
        this.gNetFlag = flag;
        this.gNetParam = param;
        return this;
    }

    @Override
    public void render(float delta) {
        this.game.pEngine.clearview(0);
        this.game.pEngine.rotatesprite(0xA00000, 0x640000, 65536, 0, this.nTile, 0, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        switch (this.gNetFlag) {
            case Create: 
            case Connect: {
                if (Mmulti.inet.waiting()) {
                    if (Mmulti.myconnectindex == Mmulti.connecthead) {
                        this.style.drawText(160, 150, Strhandler.toCharArray("Local IP: " + Mmulti.inet.myip), -128, 0, BuildFont.TextAlign.Center, 2, false);
                        if (Mmulti.inet.useUPnP) {
                            String extip = "Public IP: ";
                            if (Mmulti.inet.extip != null) {
                                extip = extip + Mmulti.inet.extip;
                            }
                            this.style.drawText(160, 160, Strhandler.toCharArray(extip), -128, 0, BuildFont.TextAlign.Center, 2, false);
                        }
                    }
                    if (Mmulti.inet.message != null && !Mmulti.inet.message.isEmpty()) {
                        this.style.drawText(160, 180, Strhandler.toCharArray(Mmulti.inet.message), -128, 0, BuildFont.TextAlign.Center, 2, false);
                    } else {
                        this.style.drawText(160, 180, Strhandler.toCharArray("Initializing..."), -128, 0, BuildFont.TextAlign.Center, 2, false);
                    }
                    this.game.pEngine.nextpage();
                    return;
                }
                if (Mmulti.inet.netready == 0) {
                    Console.Println(Mmulti.inet.message, Console.OSDTEXT_YELLOW);
                    this.back();
                    this.game.pEngine.nextpage();
                    return;
                }
                if (this.ConnectStep == 0) {
                    if (Mmulti.inet.message != null) {
                        this.style.drawText(160, 180, Strhandler.toCharArray(Mmulti.inet.message), -128, 0, BuildFont.TextAlign.Center, 2, false);
                    } else {
                        this.style.drawText(160, 180, Strhandler.toCharArray("Connected! Waiting for other players..."), -128, 0, BuildFont.TextAlign.Center, 2, false);
                    }
                    this.ConnectStep = 1;
                    this.game.pNet.StartWaiting(5000);
                    this.game.pEngine.nextpage();
                    return;
                }
                this.connect();
            }
        }
        this.game.pEngine.nextpage();
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }

    public static enum NetFlag {
        Create,
        Connect;

    }
}

