/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class DefaultMapSettings
implements IOverheadMapSettings {
    @Override
    public boolean isShowSprites(IOverheadMapSettings.MapView view) {
        return false;
    }

    @Override
    public boolean isShowFloorSprites() {
        return false;
    }

    @Override
    public boolean isShowRedWalls() {
        return true;
    }

    @Override
    public boolean isShowAllPlayers() {
        return false;
    }

    @Override
    public boolean isSpriteVisible(IOverheadMapSettings.MapView view, int index) {
        if (view == IOverheadMapSettings.MapView.Polygons) {
            return false;
        }
        switch (Engine.sprite[index].cstat & 0x30) {
            case 0: {
                return true;
            }
            case 16: {
                return false;
            }
            case 32: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWallVisible(int w, int s) {
        WALL wal = Engine.wall[w];
        SECTOR sec = Engine.sector[s];
        if (wal.nextsector != 0) {
            return wal.nextwall <= w && (Engine.sector[wal.nextsector].ceilingz != sec.ceilingz || Engine.sector[wal.nextsector].floorz != sec.floorz || ((wal.cstat | Engine.wall[wal.nextwall].cstat) & 0x30) != 0 || !this.isFullMap() && (Engine.show2dsector[wal.nextsector >> 3] & 1 << (wal.nextsector & 7)) == 0);
        }
        return true;
    }

    @Override
    public int getWallColor(int w, int sec) {
        WALL wal = Engine.wall[w];
        return 31;
    }

    @Override
    public int getSpriteColor(int s) {
        SPRITE spr = Engine.sprite[s];
        return 31;
    }

    @Override
    public int getPlayerSprite(int player) {
        return -1;
    }

    @Override
    public int getPlayerPicnum(int player) {
        int spr = this.getPlayerSprite(player);
        return spr != -1 ? (int)Engine.sprite[spr].picnum : -1;
    }

    @Override
    public int getPlayerZoom(int player, int czoom) {
        SPRITE pPlayer = Engine.sprite[this.getPlayerSprite(player)];
        int nZoom = Pragmas.mulscale(Engine.yxaspect, czoom * (Pragmas.klabs(Engine.sector[pPlayer.sectnum].floorz - pPlayer.z >> 8) + pPlayer.yrepeat), 16);
        return Gameutils.BClipRange(nZoom, 22000, 131072);
    }

    @Override
    public boolean isFullMap() {
        return false;
    }

    @Override
    public boolean isScrollMode() {
        return false;
    }

    @Override
    public int getViewPlayer() {
        return 0;
    }

    @Override
    public int getSpriteX(int spr) {
        return Engine.sprite[spr].x;
    }

    @Override
    public int getSpriteY(int spr) {
        return Engine.sprite[spr].y;
    }

    @Override
    public int getSpritePicnum(int spr) {
        return Engine.sprite[spr].picnum;
    }

    @Override
    public int getWallX(int w) {
        return Engine.wall[w].x;
    }

    @Override
    public int getWallY(int w) {
        return Engine.wall[w].y;
    }
}

