/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public class GDXOrtho
extends OrphoRenderer {
    protected Mesh mesh;
    protected Mesh linesMesh;
    protected final float[] vertices;
    protected int idx = 0;
    protected GLTile lastTexture = null;
    protected GLTile lineTile = null;
    protected int lastType = 4;
    protected float invTexWidth = 0.0f;
    protected float invTexHeight = 0.0f;
    protected boolean drawing = false;
    protected final Matrix4 projectionMatrix = new Matrix4();
    protected boolean blendingDisabled = false;
    protected float color = Color.WHITE_FLOAT_BITS;
    protected final GDXRenderer parent;
    protected int cx1;
    protected int cy1;
    protected int cx2;
    protected int cy2;
    protected ShaderManager manager;
    private SPRITE hudsprite;
    private final int maxSpriteCount = 128;

    public GDXOrtho(GDXRenderer parent, IOverheadMapSettings settings) {
        super(parent.engine, settings);
        this.parent = parent;
        this.manager = parent.manager;
        int VERTEX_SIZE = 5;
        int SPRITE_SIZE = 4 * VERTEX_SIZE;
        this.vertices = new float[128 * SPRITE_SIZE];
    }

    @Override
    public void init() {
        int size = 128;
        this.mesh = new Mesh(false, size * 4, size * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.linesMesh = new Mesh(false, size * 2, 0, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"));
        this.resize(Engine.xdim, Engine.ydim);
        int len = size * 6;
        short[] indices = new short[len];
        short j = 0;
        int i = 0;
        while (i < len) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.mesh.setIndices(indices);
        this.lineTile = this.allocLineTile();
    }

    @Override
    public void uninit() {
        this.mesh.dispose();
        this.linesMesh.dispose();
        this.lineTile.dispose();
        this.idx = 0;
        this.drawing = false;
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
        ShaderManager.Shader shader;
        GLTile atlas;
        if (col < 0) {
            return;
        }
        if (font.type == TileFont.FontType.Tilemap) {
            int nTile;
            if (Engine.palookup[col] == null) {
                col = 0;
            }
            if (!this.engine.getTile(nTile = ((Integer)font.ptr).intValue()).isLoaded() && this.engine.loadtile(nTile) == null) {
                return;
            }
        }
        if ((atlas = font.getGL(this.parent.textureCache, this.parent.getTexFormat(), col)) == null) {
            return;
        }
        xpos <<= 16;
        ypos <<= 16;
        BuildGdx.gl.glDisable(2884);
        BuildGdx.gl.glDisable(2929);
        ShaderManager.Shader shader2 = font.type == TileFont.FontType.Tilemap ? (atlas.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBWorldShader : ShaderManager.Shader.IndexedWorldShader) : (shader = ShaderManager.Shader.BitmapShader);
        if (!this.isDrawing()) {
            this.begin(shader);
        }
        this.setType(4);
        this.switchShader(shader);
        if (font.type == TileFont.FontType.Tilemap) {
            float alpha = 1.0f;
            if (bit == Renderer.Transparent.Bit1) {
                alpha = Engine.TRANSLUSCENT1;
            }
            if (bit == Renderer.Transparent.Bit2) {
                alpha = Engine.TRANSLUSCENT2;
            }
            if (atlas.getPixelFormat() != TileData.PixelFormat.Pal8) {
                float sh = (float)(Engine.numshades - Math.min(Math.max(shade, 0), Engine.numshades)) / (float)Engine.numshades;
                this.setColor(sh, sh, sh, alpha);
            } else {
                this.switchTextureParams(col, shade, alpha, false);
            }
        } else {
            this.setColor((float)Engine.curpalette.getRed(col) / 255.0f, (float)Engine.curpalette.getGreen(col) / 255.0f, (float)Engine.curpalette.getBlue(col) / 255.0f, 1.0f);
        }
        this.enableBlending();
        int oxpos = xpos;
        int line = 0;
        int df = font.sizx / font.cols;
        for (int c = 0; c < text.length && text[c] != '\u0000'; ++c) {
            if (text[c] == '\n') {
                text[c] = '\u0000';
                ++line;
                xpos = oxpos - (int)(scale * (float)font.charsizx);
            }
            if (text[c] == '\r') {
                text[c] = '\u0000';
            }
            int yoffs = (int)(scale * (float)line * (float)font.charsizy);
            float tx = text[c] % font.cols * df;
            float ty = text[c] / font.cols * df;
            this.draw(atlas, xpos, ypos, font.charsizx, font.charsizy, 0, -yoffs, tx, ty, font.charsizx, font.charsizy, 0, (int)(scale * 65536.0f), 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            xpos = (int)((float)xpos + scale * (float)(font.charsizx << 16));
        }
        BuildGdx.gl.glDepthMask(true);
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        this.printext(fontsize == 0 ? Engine.pTextfont : Engine.pSmallTextfont, xpos, ypos, text, col, 0, Renderer.Transparent.None, scale);
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        float sx1 = (float)x1 / 4096.0f;
        float sy1 = (float)y1 / 4096.0f;
        float sx2 = (float)x2 / 4096.0f;
        float sy2 = (float)y2 / 4096.0f;
        if (sx1 < 0.0f && sx2 < 0.0f || sx1 > (float)Engine.xdim && sx2 > (float)Engine.xdim) {
            return;
        }
        if (sy1 < 0.0f && sy2 < 0.0f || sy1 > (float)Engine.ydim && sy2 > (float)Engine.ydim) {
            return;
        }
        col = Engine.palookup[0][col] & 0xFF;
        Gdx.gl.glDisable(2884);
        Gdx.gl.glDisable(2929);
        if (!this.isDrawing()) {
            this.begin(ShaderManager.Shader.BitmapShader);
        }
        this.setType(1);
        this.switchShader(ShaderManager.Shader.BitmapShader);
        this.switchTexture(this.lineTile);
        this.setColor((float)Engine.curpalette.getRed(col) / 255.0f, (float)Engine.curpalette.getGreen(col) / 255.0f, (float)Engine.curpalette.getBlue(col) / 255.0f, 1.0f);
        this.disableBlending();
        if (this.idx >= 256) {
            this.flush();
        }
        float color = this.color;
        int idx = this.idx;
        float[] vertices = this.vertices;
        vertices[idx + 0] = sx1;
        vertices[idx + 1] = sy1;
        vertices[idx + 2] = color;
        vertices[idx + 3] = sx2;
        vertices[idx + 4] = sy2;
        vertices[idx + 5] = color;
        this.idx = idx + 6;
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        ShaderManager.Shader shader;
        GLTile pth;
        Tile pic;
        if (!Gameutils.isValidTile(picnum)) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        if (GLSettings.useModels.get().booleanValue() && this.parent.defs != null && this.parent.defs.mdInfo.getHudInfo(picnum, dastat) != null && this.parent.defs.mdInfo.getHudInfo((int)picnum, (int)dastat).angadd != 0) {
            Tile2model entry;
            Tile2model tile2model = entry = this.parent.defs != null ? this.parent.defs.mdInfo.getParams(picnum) : null;
            if (entry != null && entry.model != null && entry.framenum >= 0 && this.dorotatesprite3d(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2)) {
                return;
            }
        }
        if (this.engine.getTile(picnum).getType() != Tile.AnimType.None) {
            picnum += this.engine.animateoffs(picnum, 49152);
        }
        if (!(pic = this.engine.getTile(picnum)).hasSize()) {
            return;
        }
        int method = 0;
        if ((dastat & 0x40) == 0) {
            method = 1;
            if ((dastat & 1) != 0) {
                method = (dastat & 0x20) == 0 ? 2 : 3;
            }
        } else {
            method |= 0x100;
        }
        method |= 4;
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = pic.getOffsetX() + (xsiz >> 1);
            yoff = pic.getOffsetY() + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        if (picnum >= Engine.MAXTILES) {
            picnum = 0;
        }
        if (Engine.palookup[dapalnum & 0xFF] == null) {
            dapalnum = 0;
        }
        this.engine.setgotpic(picnum);
        if (!pic.isLoaded()) {
            this.engine.loadtile(picnum);
        }
        if ((pth = this.parent.textureCache.get(this.parent.getTexFormat(), picnum, dapalnum, 0, method)) == null) {
            return;
        }
        pth.bind();
        if ((method & 3) == 0) {
            this.disableBlending();
        } else {
            this.enableBlending();
        }
        float alpha = 1.0f;
        switch (method & 3) {
            case 2: {
                alpha = Engine.TRANSLUSCENT1;
                break;
            }
            case 3: {
                alpha = Engine.TRANSLUSCENT2;
            }
        }
        Gdx.gl.glDisable(2884);
        Gdx.gl.glDisable(2929);
        ShaderManager.Shader shader2 = shader = pth.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBWorldShader : ShaderManager.Shader.IndexedWorldShader;
        if (!this.isDrawing()) {
            this.begin(shader);
        }
        this.switchShader(shader);
        this.setType(4);
        this.setViewport(cx1, cy1, cx2, cy2);
        if (pth.getPixelFormat() != TileData.PixelFormat.Pal8) {
            float shade;
            float r = shade = (float)(Engine.numshades - Math.min(Math.max(dashade, 0), Engine.numshades)) / (float)Engine.numshades;
            float g = shade;
            float b = shade;
            if (pth.isHighTile() && this.parent.defs != null && this.parent.defs.texInfo != null) {
                if (pth.getPal() != dapalnum) {
                    Palette p = this.parent.defs.texInfo.getTints(dapalnum);
                    r *= (float)p.r / 255.0f;
                    g *= (float)p.g / 255.0f;
                    b *= (float)p.b / 255.0f;
                }
                Palette pdetail = this.parent.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    r *= (float)pdetail.r / 255.0f;
                    g *= (float)pdetail.g / 255.0f;
                    b *= (float)pdetail.b / 255.0f;
                }
            }
            this.setColor(r, g, b, alpha);
        } else {
            this.switchTextureParams(dapalnum, dashade, alpha, this.blendingDisabled || (method & 0x100) != 0);
        }
        this.draw(pth, sx, sy, xsiz, ysiz, xoff, yoff, a, z, dastat, cx1, cy1, cx2, cy2);
    }

    public boolean dorotatesprite3d(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        Hudtyp hudInfo;
        if (this.parent.defs == null || (hudInfo = this.parent.defs.mdInfo.getHudInfo(picnum, dastat)) != null && (hudInfo.flags & 1) != 0) {
            return true;
        }
        if (this.isDrawing()) {
            this.end();
        }
        float yaw = (float)Gameutils.AngleToRadians(Engine.globalang);
        float gcosang = MathUtils.cos(yaw);
        float gsinang = MathUtils.sin(yaw);
        float x1 = hudInfo.xadd;
        float y1 = hudInfo.yadd;
        float z1 = hudInfo.zadd;
        if ((hudInfo.flags & 2) == 0) {
            float fx = (float)sx * 1.5258789E-5f;
            float fy = (float)sy * 1.5258789E-5f;
            if ((dastat & 0x10) != 0) {
                float sinang;
                float cosang;
                Tile pic = this.engine.getTile(picnum);
                int xsiz = pic.getWidth();
                int ysiz = pic.getHeight();
                int xoff = pic.getOffsetX() + (xsiz >> 1);
                int yoff = pic.getOffsetY() + (ysiz >> 1);
                float d = (float)z / 1.0737418E9f;
                float cosang2 = cosang = (float)Engine.sintable[a + 512 & 0x7FF] * d;
                float sinang2 = sinang = (float)Engine.sintable[a & 0x7FF] * d;
                if ((dastat & 2) != 0 || (dastat & 8) == 0) {
                    d = (float)Engine.xyaspect / 65536.0f;
                    cosang2 *= d;
                    sinang2 *= d;
                }
                fx += (float)(-xoff) * cosang2 + (float)yoff * sinang2;
                fy += (float)(-xoff) * sinang - (float)yoff * cosang;
            }
            if ((dastat & 2) == 0) {
                x1 += fx / (float)(Engine.xdim << 15) - 1.0f;
                y1 += fy / (float)(Engine.ydim << 15) - 1.0f;
            } else {
                x1 += fx / 160.0f - 1.0f;
                y1 += fy / 100.0f - 1.0f;
            }
        }
        if ((dastat & 4) != 0) {
            x1 = -x1;
            y1 = -y1;
        }
        if (this.hudsprite == null) {
            this.hudsprite = new SPRITE();
        }
        this.hudsprite.reset((byte)0);
        this.hudsprite.ang = (short)((float)hudInfo.angadd + Engine.globalang);
        this.hudsprite.yrepeat = (short)32;
        this.hudsprite.xrepeat = (short)32;
        this.hudsprite.x = (int)((gcosang * z1 - gsinang * x1) * 800.0f + (float)Engine.globalposx);
        this.hudsprite.y = (int)((gsinang * z1 + gcosang * x1) * 800.0f + (float)Engine.globalposy);
        this.hudsprite.z = (int)((float)Engine.globalposz + y1 * 16384.0f * 0.8f);
        this.hudsprite.picnum = (short)picnum;
        this.hudsprite.shade = (byte)dashade;
        this.hudsprite.pal = (short)dapalnum;
        this.hudsprite.owner = (short)Engine.MAXSPRITES;
        this.hudsprite.cstat = (short)((dastat & 1) + ((dastat & 0x20) << 4) + (dastat & 4) << 1);
        if ((dastat & 0xA) == 2) {
            this.parent.resizeglcheck();
        } else {
            this.parent.set2dview();
        }
        if ((hudInfo.flags & 8) != 0) {
            BuildGdx.gl.glDisable(2929);
        } else {
            BuildGdx.gl.glEnable(2929);
            BuildGdx.gl.glClear(256);
        }
        BuildCamera cam = this.parent.cam;
        float aspect = (float)Engine.xdim / (float)Engine.ydim;
        float f = 1.0f;
        if (hudInfo.fov != -1) {
            f = (float)hudInfo.fov / 420.0f;
        }
        cam.projection.setToProjection(cam.near, cam.far, 90.0f * f, aspect);
        cam.view.setToLookAt(cam.direction.set(gcosang, gsinang, 0.0f), cam.up.set(0.0f, 0.0f, (dastat & 4) != 0 ? 1.0f : -1.0f)).translate(-cam.position.x, -cam.position.y, -cam.position.z);
        cam.combined.set(cam.projection);
        Matrix4.mul(cam.combined.val, cam.view.val);
        return this.parent.mdR.mddraw(this.parent.modelManager.getModel(picnum, dapalnum), this.hudsprite);
    }

    public void draw(GLTile tex, int sx, int sy, int sizx, int sizy, int xoffset, int yoffset, int angle, int z, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.draw(tex, sx, sy, sizx, sizy, xoffset, yoffset, 0.0f, 0.0f, sizx, sizy, angle, z, dastat, cx1, cy1, cx2, cy2);
    }

    @Override
    public void nextpage() {
        if (this.isDrawing()) {
            this.end();
        }
    }

    protected void drawoverheadline(int w, int cposx, int cposy, float cos, float sin, int col) {
        if (col < 0) {
            return;
        }
        WALL wal = Engine.wall[w];
        int ox = cposx - this.mapSettings.getWallX(w);
        int oy = cposy - this.mapSettings.getWallY(w);
        float x1 = (float)ox * cos - (float)oy * sin + (float)(Engine.xdim * 2048);
        float y1 = (float)ox * sin + (float)oy * cos + (float)(Engine.ydim * 2048);
        ox = cposx - this.mapSettings.getWallX(wal.point2);
        oy = cposy - this.mapSettings.getWallY(wal.point2);
        float x2 = (float)ox * cos - (float)oy * sin + (float)(Engine.xdim * 2048);
        float y2 = (float)ox * sin + (float)oy * cos + (float)(Engine.ydim * 2048);
        this.drawline256((int)x1, (int)y1, (int)x2, (int)y2, col);
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        int y2;
        int x2;
        float dy;
        int i;
        float cos = (float)Math.cos((float)(512 - cang) * 0.0030679617f) * (float)czoom / 4.0f;
        float sin = (float)Math.sin((float)(512 - cang) * 0.0030679617f) * (float)czoom / 4.0f;
        for (i = 0; i < Engine.numsectors; ++i) {
            if (!this.mapSettings.isFullMap() && (Engine.show2dsector[i >> 3] & 1 << (i & 7)) == 0 || !Gameutils.isValidSector(i)) continue;
            SECTOR sec = Engine.sector[i];
            if (!Gameutils.isValidWall(sec.wallptr) || sec.wallnum < 3) continue;
            int walnum = sec.wallptr;
            int j = 0;
            while (j < sec.wallnum) {
                if (Gameutils.isValidWall(walnum) && Gameutils.isValidWall(Engine.wall[walnum].point2)) {
                    Tile pic;
                    WALL wal = Engine.wall[walnum];
                    if (this.mapSettings.isShowRedWalls() && Gameutils.isValidWall(wal.nextwall) && Gameutils.isValidSector(wal.nextsector) && this.mapSettings.isWallVisible(walnum, i)) {
                        this.drawoverheadline(walnum, cposx, cposy, cos, sin, this.mapSettings.getWallColor(walnum, i));
                    }
                    if (wal.nextwall < 0 && (pic = this.engine.getTile(wal.picnum)).hasSize()) {
                        this.drawoverheadline(walnum, cposx, cposy, cos, sin, this.mapSettings.getWallColor(walnum, i));
                    }
                }
                ++j;
                ++walnum;
            }
        }
        if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Lines)) {
            for (i = 0; i < Engine.numsectors; ++i) {
                if (!this.mapSettings.isFullMap() && (Engine.show2dsector[i >> 3] & 1 << (i & 7)) == 0) continue;
                short j = Engine.headspritesect[i];
                while (j >= 0) {
                    SPRITE spr = Engine.sprite[j];
                    if ((spr.cstat & 0x8000) == 0 && spr.xrepeat != 0 && spr.yrepeat != 0 && this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Lines, j)) {
                        switch (spr.cstat & 0x30) {
                            case 0: {
                                if ((Engine.gotsector[i >> 3] & 1 << (i & 7)) <= 0 || czoom <= 96) break;
                                int ox = cposx - this.mapSettings.getSpriteX(j);
                                int oy = cposy - this.mapSettings.getSpriteY(j);
                                float dx = (float)ox * cos - (float)oy * sin;
                                dy = (float)ox * sin + (float)oy * cos;
                                int daang = spr.ang - cang & 0x7FF;
                                int nZoom = czoom * spr.yrepeat;
                                int sx = (int)(dx + (float)(Engine.xdim * 2048));
                                int sy = (int)(dy + (float)(Engine.ydim * 2048));
                                this.rotatesprite(sx * 16, sy * 16, nZoom, (short)daang, spr.picnum, spr.shade, spr.pal, (spr.cstat & 2) >> 1, Engine.wx1, Engine.wy1, Engine.wx2, Engine.wy2);
                                break;
                            }
                            case 16: {
                                Tile pic = this.engine.getTile(spr.picnum);
                                int x1 = this.mapSettings.getSpriteX(j);
                                int y1 = this.mapSettings.getSpriteY(j);
                                byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                                if ((spr.cstat & 4) > 0) {
                                    xoff = -xoff;
                                }
                                int dax = Engine.sintable[spr.ang & 0x7FF] * spr.xrepeat;
                                int day = Engine.sintable[spr.ang + 1536 & 0x7FF] * spr.xrepeat;
                                int k = (pic.getWidth() >> 1) + xoff;
                                x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, pic.getWidth(), 16);
                                y2 = (y1 -= Pragmas.mulscale(day, k, 16)) + Pragmas.mulscale(day, pic.getWidth(), 16);
                                int ox = cposx - x1;
                                int oy = cposy - y1;
                                x1 = (int)((float)ox * cos - (float)oy * sin) + (Engine.xdim << 11);
                                y1 = (int)((float)ox * sin + (float)oy * cos) + (Engine.ydim << 11);
                                ox = cposx - x2;
                                oy = cposy - y2;
                                x2 = (int)((float)ox * cos - (float)oy * sin) + (Engine.xdim << 11);
                                y2 = (int)((float)ox * sin + (float)oy * cos) + (Engine.ydim << 11);
                                int col = this.mapSettings.getSpriteColor(j);
                                if (col < 0) break;
                                this.drawline256(x1, y1, x2, y2, col);
                                break;
                            }
                            case 32: {
                                Tile pic = this.engine.getTile(spr.picnum);
                                byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                                byte yoff = (byte)(pic.getOffsetY() + spr.yoffset);
                                if ((spr.cstat & 4) > 0) {
                                    xoff = -xoff;
                                }
                                if ((spr.cstat & 8) > 0) {
                                    yoff = -yoff;
                                }
                                short cosang = Engine.sintable[spr.ang + 512 & 0x7FF];
                                short sinang = Engine.sintable[spr.ang & 0x7FF];
                                int dax = ((pic.getWidth() >> 1) + xoff) * spr.xrepeat;
                                int day = ((pic.getHeight() >> 1) + yoff) * spr.yrepeat;
                                int x1 = this.mapSettings.getSpriteX(j) + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                                int y1 = this.mapSettings.getSpriteY(j) + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                                int l = pic.getWidth() * spr.xrepeat;
                                int x22 = x1 - Pragmas.mulscale(sinang, l, 16);
                                int y22 = y1 + Pragmas.mulscale(cosang, l, 16);
                                l = pic.getHeight() * spr.yrepeat;
                                int k = -Pragmas.mulscale(cosang, l, 16);
                                int x3 = x22 + k;
                                int x4 = x1 + k;
                                k = -Pragmas.mulscale(sinang, l, 16);
                                int y3 = y22 + k;
                                int y4 = y1 + k;
                                int ox = cposx - x1;
                                int oy = cposy - y1;
                                x1 = (int)((float)ox * cos - (float)oy * sin) + (Engine.xdim << 11);
                                y1 = (int)((float)ox * sin + (float)oy * cos) + (Engine.ydim << 11);
                                ox = cposx - x22;
                                oy = cposy - y22;
                                x22 = (int)((float)ox * cos - (float)oy * sin) + (Engine.xdim << 11);
                                y22 = (int)((float)ox * sin + (float)oy * cos) + (Engine.ydim << 11);
                                ox = cposx - x3;
                                oy = cposy - y3;
                                x3 = (int)((float)ox * cos - (float)oy * sin) + (Engine.xdim << 11);
                                y3 = (int)((float)ox * sin + (float)oy * cos) + (Engine.ydim << 11);
                                ox = cposx - x4;
                                oy = cposy - y4;
                                x4 = (int)((float)ox * cos - (float)oy * sin) + (Engine.xdim << 11);
                                y4 = (int)((float)ox * sin + (float)oy * cos) + (Engine.ydim << 11);
                                int col = this.mapSettings.getSpriteColor(j);
                                if (col < 0) break;
                                this.drawline256(x1, y1, x22, y22, col);
                                this.drawline256(x22, y22, x3, y3, col);
                                this.drawline256(x3, y3, x4, y4, col);
                                this.drawline256(x4, y4, x1, y1, col);
                            }
                        }
                    }
                    j = Engine.nextspritesect[j];
                }
            }
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            int spr = this.mapSettings.getPlayerSprite(i);
            if (spr != -1 && Gameutils.isValidSector(Engine.sprite[spr].sectnum)) {
                SPRITE pPlayer = Engine.sprite[spr];
                int ox = cposx - this.mapSettings.getSpriteX(spr);
                int oy = cposy - this.mapSettings.getSpriteY(spr);
                float dx = (float)ox * cos - (float)oy * sin;
                dy = (float)ox * sin + (float)oy * cos;
                int dang = pPlayer.ang - cang & 0x7FF;
                int viewindex = this.mapSettings.getViewPlayer();
                if (i == viewindex && !this.mapSettings.isScrollMode()) {
                    dx = 0.0f;
                    dy = viewindex ^ i;
                    dang = 0;
                }
                if (i == viewindex || this.mapSettings.isShowAllPlayers()) {
                    int picnum = this.mapSettings.getPlayerPicnum(i);
                    if (picnum == -1) {
                        x2 = 0;
                        y2 = -(this.mapSettings.getPlayerZoom(i, czoom) << 1);
                        int col = this.mapSettings.getSpriteColor(spr);
                        if (col >= 0) {
                            int sx = (int)dx;
                            int sy = (int)dy;
                            this.drawline256(sx - x2 + (Engine.xdim << 11), sy - y2 + (Engine.ydim << 11), sx + x2 + (Engine.xdim << 11), sy + y2 + (Engine.ydim << 11), col);
                            this.drawline256(sx - y2 + (Engine.xdim << 11), sy + x2 + (Engine.ydim << 11), sx + x2 + (Engine.xdim << 11), sy + y2 + (Engine.ydim << 11), col);
                            this.drawline256(sx + y2 + (Engine.xdim << 11), sy - x2 + (Engine.ydim << 11), sx + x2 + (Engine.xdim << 11), sy + y2 + (Engine.ydim << 11), col);
                        }
                    } else {
                        int nZoom = this.mapSettings.getPlayerZoom(i, czoom);
                        int sx = (int)(dx + (float)(Engine.xdim * 2048));
                        int sy = (int)(dy + (float)(Engine.ydim * 2048));
                        this.rotatesprite(sx * 16, sy * 16, nZoom, (short)dang, picnum, pPlayer.shade, pPlayer.pal, (pPlayer.cstat & 2) >> 1, Engine.wx1, Engine.wy1, Engine.wx2, Engine.wy2);
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        Engine.beforedrawrooms = 0;
        Arrays.fill(Engine.gotsector, (byte)0);
        if (this.isDrawing()) {
            this.end();
        }
        Matrix4 tmpMat = this.parent.transform;
        BuildCamera cam = this.parent.cam;
        cam.projection.setToOrtho(Engine.xdim / 2, -Engine.xdim / 2, -(Engine.ydim / 2), Engine.ydim / 2, 0.0f, 1.0f);
        cam.projection.scale((float)zoome / 32.0f, (float)zoome / 32.0f, 0.0f);
        cam.view.set(this.parent.identity);
        cam.combined.set(cam.projection);
        Matrix4.mul(cam.combined.val, cam.view.val);
        int showSprites = this.mapSettings.isShowFloorSprites() ? 1 : 0;
        showSprites |= this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Polygons) ? 2 : 0;
        int sortnum = 0;
        for (int s = 0; s < Engine.numsectors; ++s) {
            short i;
            SECTOR sec = Engine.sector[s];
            if (!this.mapSettings.isFullMap() && (Engine.show2dsector[s >> 3] & Engine.pow2char[s & 7]) == 0) continue;
            if ((showSprites & 1) != 0) {
                i = Engine.headspritesect[s];
                while (i >= 0) {
                    if ((Engine.sprite[i].cstat & 0x30) == 32) {
                        if (sortnum >= 1024) break;
                        if ((Engine.sprite[i].cstat & 0x48) != 72 && this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Polygons, i)) {
                            if (Engine.tsprite[sortnum] == null) {
                                Engine.tsprite[sortnum] = new SPRITE();
                            }
                            Engine.tsprite[sortnum].set(Engine.sprite[i]);
                            Engine.tsprite[sortnum++].owner = i;
                        }
                    }
                    i = Engine.nextspritesect[i];
                }
            }
            if ((showSprites & 2) != 0) {
                i = Engine.headspritesect[s];
                while (i >= 0) {
                    if ((Engine.sprite[i].cstat & 0x30) != 32 && (Engine.show2dsprite[i >> 3] & Engine.pow2char[i & 7]) != 0) {
                        if (sortnum >= 1024) break;
                        if (this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Polygons, i) && i != this.mapSettings.getPlayerSprite(this.mapSettings.getViewPlayer())) {
                            if (Engine.tsprite[sortnum] == null) {
                                Engine.tsprite[sortnum] = new SPRITE();
                            }
                            Engine.tsprite[sortnum].set(Engine.sprite[i]);
                            Engine.tsprite[sortnum++].owner = i;
                        }
                    }
                    i = Engine.nextspritesect[i];
                }
            }
            int n = s >> 3;
            Engine.gotsector[n] = (byte)(Engine.gotsector[n] | Engine.pow2char[s & 7]);
            if (sec.isParallaxFloor()) continue;
            Engine.globalpal = sec.floorpal;
            int globalpicnum = sec.floorpicnum;
            if (globalpicnum >= Engine.MAXTILES) {
                globalpicnum = 0;
            }
            this.engine.setgotpic(globalpicnum);
            Tile pic = this.engine.getTile(globalpicnum);
            if (!pic.hasSize()) continue;
            if (pic.getType() != Tile.AnimType.None) {
                globalpicnum += this.engine.animateoffs(globalpicnum, s);
                pic = this.engine.getTile(globalpicnum);
            }
            if (!pic.isLoaded()) {
                this.engine.loadtile(globalpicnum);
            }
            Engine.globalshade = Math.max(Math.min(sec.floorshade, Engine.numshades - 1), 0);
            WorldMesh.GLSurface flor = this.parent.world.getFloor(s);
            if (flor == null) continue;
            tmpMat.setToRotation(0.0f, 0.0f, 1.0f, (float)(512 - ang) * 0.17578125f);
            tmpMat.translate((float)(-dax) / this.parent.cam.xscale, (float)(-day) / this.parent.cam.xscale, (float)(-Engine.sector[s].floorz) / this.parent.cam.yscale);
            this.parent.drawSurf(flor, 0, tmpMat, null);
        }
        if (showSprites != 0) {
            float cos = (float)Math.cos((float)(512 - ang) * 0.0030679617f) * (float)zoome / 4.0f;
            float sin = (float)Math.sin((float)(512 - ang) * 0.0030679617f) * (float)zoome / 4.0f;
            int gap = 1;
            while (gap < sortnum) {
                gap = (gap << 1) + 1;
            }
            gap >>= 1;
            while (gap > 0) {
                for (int i = 0; i < sortnum - gap; ++i) {
                    for (int j = i; j >= 0 && Engine.sprite[Engine.tsprite[j].owner].z > Engine.sprite[Engine.tsprite[j + gap].owner].z; j -= gap) {
                        short tmp = Engine.tsprite[j].owner;
                        Engine.tsprite[j].owner = Engine.tsprite[j + gap].owner;
                        Engine.tsprite[j + gap].owner = tmp;
                    }
                }
                gap >>= 1;
            }
            for (int s = sortnum - 1; s >= 0; --s) {
                short j = Engine.tsprite[s].owner;
                SPRITE spr = Engine.sprite[j];
                if ((spr.cstat & 0x8000) != 0) continue;
                if (spr.picnum >= Engine.MAXTILES) {
                    spr.picnum = 0;
                }
                int ox = dax - this.mapSettings.getSpriteX(j);
                int oy = day - this.mapSettings.getSpriteY(j);
                float dx = (float)ox * cos - (float)oy * sin;
                float dy = (float)ox * sin + (float)oy * cos;
                int daang = spr.ang - ang & 0x7FF;
                int nZoom = zoome * spr.yrepeat;
                int sx = (int)(dx + (float)(Engine.xdim * 2048));
                int sy = (int)(dy + (float)(Engine.ydim * 2048));
                this.rotatesprite(sx * 16, sy * 16, nZoom, (short)daang, this.mapSettings.getSpritePicnum(j), spr.shade, spr.pal, (spr.cstat & 2) >> 1 | 8, Engine.wx1, Engine.wy1, Engine.wx2, Engine.wy2);
            }
        }
        this.flush();
        this.manager.unbind();
    }

    protected void resize(int width, int height) {
        this.projectionMatrix.setToOrtho(0.0f, width - 1, height - 1, 0.0f, 0.0f, 1.0f);
    }

    protected void begin(ShaderManager.Shader shader) {
        if (this.drawing) {
            throw new IllegalStateException("GdxBatch.end must be called before begin.");
        }
        BuildGdx.gl20.glDepthMask(false);
        this.manager.bind(shader);
        this.setupMatrices();
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("GdxBatch.begin must be called before end.");
        }
        if (this.idx > 0) {
            this.flush();
        }
        this.lastTexture = null;
        this.cx1 = 0;
        this.cy1 = 0;
        this.cx2 = 0;
        this.cy2 = 0;
        this.lastType = -1;
        this.drawing = false;
        GL20 gl = BuildGdx.gl20;
        gl.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gl.glDisable(3042);
        }
        this.manager.unbind();
    }

    protected void flush() {
        Mesh mesh;
        int count;
        if (this.idx == 0) {
            return;
        }
        this.lastTexture.bind();
        if (this.lastType == 1) {
            int spritesInBatch = this.idx / 6;
            count = spritesInBatch * 2;
            mesh = this.linesMesh;
            mesh.setVertices(this.vertices, 0, this.idx);
        } else {
            int spritesInBatch = this.idx / 20;
            count = spritesInBatch * 6;
            mesh = this.mesh;
            mesh.setVertices(this.vertices, 0, this.idx);
            mesh.getIndicesBuffer().position(0);
            mesh.getIndicesBuffer().limit(count);
        }
        if (this.blendingDisabled) {
            BuildGdx.gl20.glDisable(3042);
        } else {
            BuildGdx.gl20.glEnable(3042);
        }
        this.manager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.manager.textureTransform(this.parent.texture_transform.idt(), 0);
        mesh.render(this.manager.getProgram(), this.lastType, 0, count);
        this.idx = 0;
    }

    public void draw(GLTile tex, int sx, int sy, int sizx, int sizy, int xoffset, int yoffset, float srcX, float srcY, float srcWidth, float srcHeight, int angle, int z, int dastat, int cx1, int cy1, int cx2, int cy2) {
        float v2;
        float v;
        float y3;
        float x3;
        float y2;
        float x2;
        float y4;
        float x4;
        float y1;
        float x1;
        if (!this.drawing) {
            throw new IllegalStateException("GdxBatch.begin must be called before draw.");
        }
        this.switchTexture(tex);
        if (this.idx == this.vertices.length) {
            this.flush();
        }
        int ourxyaspect = Engine.xyaspect;
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * Engine.xdim) {
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = Engine.xdim;
            int ouryxaspect = Engine.yxaspect;
            ourxyaspect = Engine.xyaspect;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * xdim) {
                xdim = 4 * Engine.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = cx1 + cx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(Engine.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = Engine.xdimenscale;
                sy = (cy1 + cy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (Engine.ydim << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        float aspectFix = (dastat & 2) != 0 || (dastat & 8) == 0 ? (float)ourxyaspect / 65536.0f : 1.0f;
        float scale = (float)z / 65536.0f;
        float xoffs = (float)xoffset * scale;
        float yoffs = (float)yoffset * scale;
        float width = scale * (float)sizx;
        float height = scale * (float)sizy;
        float[] vertices = this.vertices;
        float OriginX = (float)sx / 65536.0f;
        float OriginY = (float)sy / 65536.0f;
        if (angle != 0) {
            float rotation = 360.0f * (float)angle / 2048.0f;
            float cos = MathUtils.cosDeg(rotation);
            float sin = MathUtils.sinDeg(rotation);
            x1 = OriginX + (sin * yoffs - cos * xoffs) * aspectFix;
            y1 = OriginY - xoffs * sin - yoffs * cos;
            x4 = x1 + width * cos * aspectFix;
            y4 = y1 + width * sin;
            x2 = x1 - height * sin * aspectFix;
            y2 = y1 + height * cos;
            x3 = x2 + (x4 - x1);
            y3 = y2 + (y4 - y1);
        } else {
            x1 = x2 = OriginX - xoffs * aspectFix;
            y1 = y4 = OriginY - yoffs;
            x3 = x4 = x1 + width * aspectFix;
            y2 = y3 = y1 + height;
        }
        if ((dastat & 8) == 0) {
            float yaspect = (float)Engine.windowy2 / (float)Engine.ydim;
            y1 *= yaspect;
            y2 *= yaspect;
            y3 *= yaspect;
            y4 *= yaspect;
        }
        if (tex.isHighTile()) {
            srcWidth = tex.getWidth();
            for (sizy = 1; sizy < tex.getHeight(); sizy += sizy) {
            }
            float scaley = (float)sizy / (float)tex.getHeight();
            srcHeight = (float)tex.getHeight() / scaley;
        }
        float u = srcX * this.invTexWidth;
        float u2 = (srcX + srcWidth) * this.invTexWidth;
        if ((dastat & 4) == 0) {
            v = srcY * this.invTexHeight;
            v2 = (srcY + srcHeight) * this.invTexHeight;
        } else {
            v = (srcY + srcHeight) * this.invTexHeight;
            v2 = srcY * this.invTexHeight;
        }
        if (tex.isHighTile() && (tex.getHiresXScale() != 1.0f || tex.getHiresYScale() != 1.0f)) {
            u *= tex.getHiresXScale();
            v *= tex.getHiresYScale();
            u2 *= tex.getHiresXScale();
            v2 *= tex.getHiresYScale();
        }
        float color = this.color;
        int idx = this.idx;
        vertices[idx + 0] = x1;
        vertices[idx + 1] = y1;
        vertices[idx + 2] = color;
        vertices[idx + 3] = u;
        vertices[idx + 4] = v;
        vertices[idx + 5] = x2;
        vertices[idx + 6] = y2;
        vertices[idx + 7] = color;
        vertices[idx + 8] = u;
        vertices[idx + 9] = v2;
        vertices[idx + 10] = x3;
        vertices[idx + 11] = y3;
        vertices[idx + 12] = color;
        vertices[idx + 13] = u2;
        vertices[idx + 14] = v2;
        vertices[idx + 15] = x4;
        vertices[idx + 16] = y4;
        vertices[idx + 17] = color;
        vertices[idx + 18] = u2;
        vertices[idx + 19] = v;
        this.idx = idx + 20;
    }

    protected void switchTextureParams(int pal, int shade, float alpha, boolean drawLastIndex) {
        IndexedShader shader = (IndexedShader)this.manager.getProgram();
        if (shader.getDrawLastIndex() == drawLastIndex && shader.getPal() == pal && shader.getShade() == shade && shader.getTransparent() == alpha) {
            return;
        }
        this.flush();
        this.manager.textureParams8(pal, shade, alpha, drawLastIndex);
    }

    protected void switchTexture(GLTile texture) {
        if (texture == this.lastTexture) {
            return;
        }
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
    }

    protected void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.color = NumberUtils.intToFloatColor(intBits);
    }

    protected boolean isBlendingEnabled() {
        return !this.blendingDisabled;
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    protected void disableBlending() {
        if (this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = true;
    }

    protected void enableBlending() {
        if (!this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = false;
    }

    protected void switchShader(ShaderManager.Shader shader) {
        if (shader == this.manager.getShader()) {
            return;
        }
        if (this.isDrawing()) {
            this.flush();
        }
        this.manager.bind(shader);
        this.setupMatrices();
    }

    private void setupMatrices() {
        this.manager.mirror(false);
        this.manager.fog(false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.manager.getShader() != ShaderManager.Shader.BitmapShader) {
            this.manager.projection(this.projectionMatrix).view(this.parent.identity);
            this.manager.transform(this.parent.identity);
            this.manager.viewport(0, 0, Engine.xdim - 1, Engine.ydim - 1);
            this.cy1 = 0;
            this.cx1 = 0;
            this.cx2 = Engine.xdim - 1;
            this.cy2 = Engine.ydim - 1;
        } else {
            this.manager.projection(this.projectionMatrix);
        }
    }

    protected void setType(int type) {
        if (type == this.lastType) {
            return;
        }
        this.flush();
        this.lastType = type;
    }

    protected GLTile allocLineTile() {
        DummyTileData data = new DummyTileData(TileData.PixelFormat.Bitmap, 1, 1);
        ByteBuffer b = data.getPixels();
        b.put((byte)-1);
        b.rewind();
        return this.parent.textureCache.newTile(data, 0, false);
    }

    protected void setViewport(int cx1, int cy1, int cx2, int cy2) {
        if (cx1 == this.cx1 && cx2 == this.cx2 && cy1 == this.cy1 && cy2 == this.cy2) {
            return;
        }
        this.flush();
        this.manager.viewport(cx1, cy1, cx2, cy2);
        this.cx1 = cx1;
        this.cx2 = cx2;
        this.cy1 = cy1;
        this.cy2 = cy2;
    }
}

