/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXModelManager;
import ru.m210projects.Build.Render.GdxRender.GDXModelRenderer;
import ru.m210projects.Build.Render.GdxRender.GDXOrtho;
import ru.m210projects.Build.Render.GdxRender.Scanner.SectorScanner;
import ru.m210projects.Build.Render.GdxRender.Scanner.VisibleSector;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.GdxRender.SpriteRenderer;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDAnimation;
import ru.m210projects.Build.Render.ModelHandle.ModelManager;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.GLTileArray;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileAtlas;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.FadeEffect;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public class GDXRenderer
implements GLRenderer {
    public GLRenderer.Rendering rendering = GLRenderer.Rendering.Nothing;
    protected TextureManager textureCache;
    protected ModelManager modelManager;
    protected final Engine engine;
    protected boolean isInited = false;
    protected GL20 gl;
    protected float defznear = 0.001f;
    protected float defzfar = 1.0f;
    protected float fov = 90.0f;
    protected float gtang = 0.0f;
    protected WorldMesh world;
    protected SectorScanner scanner;
    protected BuildCamera cam;
    protected SpriteRenderer sprR;
    protected GDXModelRenderer mdR;
    protected GDXOrtho orphoRen;
    protected DefScript defs;
    protected ShaderManager manager;
    protected boolean isUseIndexedTextures;
    private ByteBuffer pix32buffer;
    private ByteBuffer pix8buffer;
    protected Matrix4 transform = new Matrix4();
    protected Matrix3 texture_transform = new Matrix3();
    protected Matrix4 identity = new Matrix4();
    private boolean clearStatus = false;
    private float glox1;
    private float gloy1;
    private float glox2;
    private float gloy2;
    private boolean drunk;
    private float drunkIntensive = 1.0f;
    private GLTile frameTexture;
    private int framew;
    private int frameh;
    protected ArrayList<VisibleSector> sectors = new ArrayList();
    private final ArrayList<WorldMesh.GLSurface> bunchfirst = new ArrayList();
    protected boolean[] mirrorTextures = new boolean[Engine.MAXTILES];
    protected int FOGDISTCONST = 48;
    protected final float FULLVIS_BEGIN = 2.9E30f;
    protected final float FULLVIS_END = 3.0E30f;
    protected final GLTileArray skycache = new GLTileArray(Engine.MAXTILES);

    public GDXRenderer(Engine engine, IOverheadMapSettings settings) {
        this.engine = engine;
        this.textureCache = this.getTextureManager();
        this.modelManager = new GDXModelManager(this);
        this.manager = new ShaderManager();
        this.sprR = new SpriteRenderer(engine, this);
        this.mdR = new GDXModelRenderer(this);
        this.orphoRen = this.allocOrphoRenderer(settings);
        this.scanner = new SectorScanner(engine){

            @Override
            protected Matrix4 getSpriteMatrix(SPRITE tspr) {
                Tile pic = this.engine.getTile(tspr.picnum);
                return GDXRenderer.this.sprR.getMatrix(tspr, pic.getWidth(), pic.getHeight());
            }
        };
        Arrays.fill(this.mirrorTextures, false);
        int[] mirrors = this.getMirrorTextures();
        if (mirrors != null) {
            for (int i = 0; i < mirrors.length; ++i) {
                this.mirrorTextures[mirrors[i]] = true;
            }
        }
        System.err.println("create");
    }

    @Override
    public void init() {
        try {
            if (BuildGdx.graphics.getFrameType() != BuildFrame.FrameType.GL) {
                BuildGdx.app.setFrame(BuildFrame.FrameType.GL);
            }
            GLInfo.init();
            this.gl = BuildGdx.graphics.getGL20();
            this.enableIndexedShader(GLSettings.usePaletteShader.get());
            this.gl.glBlendFunc(770, 771);
            this.gl.glPixelStorei(3333, 1);
            this.cam = new BuildCamera(this.fov, Engine.xdim, Engine.ydim, 512.0f, 8192.0f);
            this.manager.init(this.textureCache);
            if (!this.manager.isInited()) {
                return;
            }
            this.textureCache.changePalette(Engine.curpalette.getBytes());
            Console.Println("Polygdx renderer is initialized", Console.OSDTEXT_GOLD);
            Console.Println(BuildGdx.graphics.getGLVersion().getRendererString() + " " + this.gl.glGetString(7938), Console.OSDTEXT_GOLD);
            this.orphoRen.init();
            if (this.world != null && this.world.isInvalid()) {
                this.world = new WorldMesh(this.engine);
            }
            System.err.println("init");
            this.isInited = true;
        }
        catch (Throwable t) {
            this.isInited = false;
        }
    }

    @Override
    public void uninit() {
        System.err.println("uninit");
        this.isInited = false;
        if (this.world != null) {
            this.world.dispose();
        }
        this.orphoRen.uninit();
        this.manager.dispose();
        FadeEffect.uninit();
        this.texturesUninit();
        this.modelManager.dispose();
    }

    private void texturesUninit() {
        this.textureCache.uninit();
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.skycache.dispose(i);
        }
    }

    @Override
    public void drawrooms() {
        int i;
        if (this.orphoRen.isDrawing()) {
            this.orphoRen.end();
        }
        this.gl.glClear(256);
        this.gl.glDisable(3042);
        this.gl.glEnable(3553);
        this.gl.glEnable(2929);
        this.gl.glDepthFunc(513);
        this.gl.glDepthRangef(this.defznear, this.defzfar);
        this.gl.glEnable(2884);
        this.gl.glFrontFace(2304);
        this.resizeglcheck();
        this.cam.setPosition(Engine.globalposx, Engine.globalposy, Engine.globalposz);
        this.cam.setDirection(Engine.globalang, Engine.globalhoriz, this.gtang);
        this.cam.update(true);
        Engine.globalvisibility = Engine.visibility << 2;
        if (Engine.globalcursectnum >= Engine.MAXSECTORS) {
            Engine.globalcursectnum = (short)(Engine.globalcursectnum - Engine.MAXSECTORS);
        } else {
            i = Engine.globalcursectnum;
            if ((Engine.globalcursectnum = this.engine.updatesectorz(Engine.globalposx, Engine.globalposy, Engine.globalposz, Engine.globalcursectnum)) < 0) {
                Engine.globalcursectnum = i;
            }
        }
        this.sectors.clear();
        this.scanner.clear();
        this.scanner.process(this.sectors, this.cam, this.world, Engine.globalcursectnum);
        this.rendering = GLRenderer.Rendering.Nothing;
        if (Engine.inpreparemirror) {
            this.gl.glCullFace(1028);
        } else {
            this.gl.glCullFace(1029);
        }
        this.prerender(this.sectors);
        this.drawbackground();
        int n = i = Engine.inpreparemirror ? 1 : 0;
        while (i < this.sectors.size()) {
            this.drawSector(this.sectors.get(i));
            ++i;
        }
        Engine.spritesortcnt = this.scanner.getSpriteCount();
        Engine.tsprite = this.scanner.getSprites();
        this.manager.unbind();
    }

    @Override
    public void drawmasks() {
        int[] maskwalls = this.scanner.getMaskwalls();
        int maskwallcnt = this.scanner.getMaskwallCount();
        this.sprR.sort(Engine.tsprite, Engine.spritesortcnt);
        while (Engine.spritesortcnt > 0 && maskwallcnt > 0) {
            int j = maskwalls[maskwallcnt - 1];
            if (!this.spritewallfront(Engine.tsprite[Engine.spritesortcnt - 1], j)) {
                this.drawsprite(--Engine.spritesortcnt);
                continue;
            }
            for (int i = Engine.spritesortcnt - 2; i >= 0; --i) {
                if (this.spritewallfront(Engine.tsprite[i], j)) continue;
                this.drawsprite(i);
                Engine.tsprite[i] = null;
            }
            this.drawmaskwall(--maskwallcnt);
        }
        while (Engine.spritesortcnt != 0) {
            if (Engine.tsprite[--Engine.spritesortcnt] == null) continue;
            this.drawsprite(Engine.spritesortcnt);
        }
        while (maskwallcnt > 0) {
            this.drawmaskwall(--maskwallcnt);
        }
        this.renderDrunkEffect();
        this.manager.unbind();
    }

    private void drawMask(int w) {
        this.gl.glDepthFunc(513);
        this.gl.glDepthRangef(1.0E-4f, 0.99999f);
        this.drawSurf(this.world.getMaskedWall(w), 0, null, null);
        this.gl.glDepthFunc(513);
        this.gl.glDepthRangef(this.defznear, this.defzfar);
    }

    protected void renderDrunkEffect() {
    }

    public void drawsprite(int i) {
        SPRITE tspr = Engine.tsprite[i];
        if (tspr == null || tspr.owner == -1) {
            return;
        }
        Spriteext sprext = this.defs.mapInfo.getSpriteInfo(tspr.owner);
        if (sprext == null || !sprext.isNotModel()) {
            GLModel md;
            this.rendering = GLRenderer.Rendering.Model.setIndex(i);
            if (GLSettings.useModels.get().booleanValue() && (md = this.modelManager.getModel(tspr.picnum, tspr.pal)) != null) {
                if (tspr.owner < 0 || tspr.owner >= Engine.MAXSPRITES ? this.mdR.mddraw(md, tspr) : this.mdR.mddraw(md, tspr)) {
                    return;
                }
            } else if (BuildSettings.useVoxels.get().booleanValue()) {
                GLVoxel vox;
                int dist;
                int picnum = tspr.picnum;
                if (this.engine.getTile(picnum).getType() != Tile.AnimType.None) {
                    picnum += this.engine.animateoffs(picnum, tspr.owner + 32768);
                }
                if ((long)(dist = (tspr.x - Engine.globalposx) * (tspr.x - Engine.globalposx) + (tspr.y - Engine.globalposy) * (tspr.y - Engine.globalposy)) < 2304000000L && (vox = (GLVoxel)this.modelManager.getVoxel(picnum)) != null) {
                    if ((tspr.cstat & 0x30) != 48) {
                        if (this.mdR.mddraw(vox, tspr)) {
                            return;
                        }
                    } else if ((tspr.cstat & 0x30) == 48) {
                        this.mdR.mddraw(vox, tspr);
                        return;
                    }
                }
            }
        }
        this.rendering = GLRenderer.Rendering.Sprite.setIndex(i);
        this.sprR.begin(this.cam);
        this.sprR.draw(tspr);
        this.sprR.end();
    }

    private void drawmaskwall(int i) {
        this.rendering = GLRenderer.Rendering.MaskWall.setIndex(i);
        this.drawMask(this.scanner.getMaskwalls()[i]);
    }

    protected void drawbackground() {
        int i;
        this.rendering = GLRenderer.Rendering.Skybox;
        this.drawSkyPlanes();
        int n = i = Engine.inpreparemirror ? 1 : 0;
        while (i < this.sectors.size()) {
            this.drawSkySector(this.sectors.get(i));
            ++i;
        }
    }

    private void prerender(ArrayList<VisibleSector> sectors) {
        int i;
        if (Engine.inpreparemirror) {
            return;
        }
        this.bunchfirst.clear();
        for (i = 0; i < sectors.size(); ++i) {
            int z;
            int w;
            VisibleSector sec = sectors.get(i);
            int sectnum = sec.index;
            if ((sec.secflags & 1) != 0) {
                this.checkMirror(this.world.getFloor(sectnum));
            }
            if ((sec.secflags & 2) != 0) {
                this.checkMirror(this.world.getCeiling(sectnum));
            }
            for (w = 0; w < sec.walls.size; ++w) {
                z = sec.walls.get(w);
                int flags = sec.wallflags.get(w);
                this.checkMirror(this.world.getWall(z, sectnum));
                if ((flags & 1) != 0) {
                    this.checkMirror(this.world.getLower(z, sectnum));
                }
                if ((flags & 2) != 0) {
                    this.checkMirror(this.world.getUpper(z, sectnum));
                }
                this.checkMirror(this.world.getMaskedWall(z));
            }
            for (w = 0; w < sec.skywalls.size; ++w) {
                z = sec.skywalls.get(w);
                this.checkMirror(this.world.getParallaxCeiling(z));
                this.checkMirror(this.world.getParallaxFloor(z));
            }
        }
        for (i = 0; i < this.bunchfirst.size(); ++i) {
            this.drawSurf(this.bunchfirst.get(i), 0, null, null);
        }
    }

    private void checkMirror(WorldMesh.GLSurface surf) {
        if (surf == null) {
            return;
        }
        int picnum = surf.picnum;
        if (this.mirrorTextures[picnum]) {
            this.bunchfirst.add(surf);
        }
    }

    private void drawSkyPlanes() {
        short picnum;
        byte shade;
        short pal;
        this.gl.glDisable(2884);
        this.gl.glDepthMask(false);
        SECTOR skysector = this.scanner.getLastSkySector(WorldMesh.Heinum.SkyUpper);
        if (skysector != null) {
            pal = skysector.ceilingpal;
            shade = skysector.ceilingshade;
            picnum = skysector.ceilingpicnum;
            this.drawSky(this.world.getQuad(), picnum, shade, pal, 0, this.transform.setToTranslation(this.cam.position.x, this.cam.position.y, this.cam.position.z - 100.0f).scale(this.cam.far, this.cam.far, 1.0f));
        }
        if ((skysector = this.scanner.getLastSkySector(WorldMesh.Heinum.SkyLower)) != null) {
            pal = skysector.floorpal;
            shade = skysector.floorshade;
            picnum = skysector.floorpicnum;
            this.drawSky(this.world.getQuad(), picnum, shade, pal, 0, this.transform.setToTranslation(this.cam.position.x, this.cam.position.y, this.cam.position.z + 100.0f).scale(this.cam.far, this.cam.far, 1.0f));
        }
        this.gl.glDepthMask(true);
        this.gl.glEnable(2884);
    }

    private void drawSector(VisibleSector sec) {
        int sectnum = sec.index;
        int n = sectnum >> 3;
        Engine.gotsector[n] = (byte)(Engine.gotsector[n] | Engine.pow2char[sectnum & 7]);
        if ((sec.secflags & 1) != 0) {
            this.rendering = GLRenderer.Rendering.Floor.setIndex(sectnum);
            this.drawSurf(this.world.getFloor(sectnum), 0, null, sec.clipPlane);
        }
        if ((sec.secflags & 2) != 0) {
            this.rendering = GLRenderer.Rendering.Ceiling.setIndex(sectnum);
            this.drawSurf(this.world.getCeiling(sectnum), 0, null, sec.clipPlane);
        }
        for (int w = 0; w < sec.walls.size; ++w) {
            int flags = sec.wallflags.get(w);
            int z = sec.walls.get(w);
            this.rendering = GLRenderer.Rendering.Wall.setIndex(z);
            this.drawSurf(this.world.getWall(z, sectnum), flags, null, sec.clipPlane);
            this.drawSurf(this.world.getUpper(z, sectnum), flags, null, sec.clipPlane);
            this.drawSurf(this.world.getLower(z, sectnum), flags, null, sec.clipPlane);
        }
    }

    public void drawSkySector(VisibleSector sec) {
        for (int w = 0; w < sec.skywalls.size; ++w) {
            WorldMesh.GLSurface floor;
            int z = sec.skywalls.get(w);
            WorldMesh.GLSurface ceil = this.world.getParallaxCeiling(z);
            if (ceil != null) {
                this.drawSky(ceil, ceil.picnum, ceil.getShade(), ceil.getPal(), ceil.getMethod(), this.identity);
            }
            if ((floor = this.world.getParallaxFloor(z)) == null) continue;
            this.drawSky(floor, floor.picnum, floor.getShade(), floor.getPal(), floor.getMethod(), this.identity);
        }
    }

    private void drawSky(WorldMesh.GLSurface surf, int picnum, int shade, int palnum, int method, Matrix4 worldTransform) {
        GLTile pth;
        Tile pic;
        if (surf.count == 0) {
            return;
        }
        if (this.engine.getTile(picnum).getType() != Tile.AnimType.None) {
            picnum += this.engine.animateoffs(picnum, 0);
        }
        if (!(pic = this.engine.getTile(picnum)).isLoaded()) {
            this.engine.loadtile(picnum);
        }
        if (!pic.isLoaded()) {
            method = 1;
        }
        this.engine.setgotpic(picnum);
        if (Engine.palookup[palnum] == null) {
            palnum = 0;
        }
        if ((pth = this.bindSky(picnum, palnum, shade, method)) != null) {
            Gdx.gl.glDisable(3042);
            if ((method & 3) != 0) {
                Gdx.gl.glEnable(3042);
            }
            this.manager.fog(false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.manager.transform(worldTransform);
            this.manager.frustum(null);
            surf.render(this.manager.getProgram());
        }
    }

    protected void drawSurf(WorldMesh.GLSurface surf, int flags, Matrix4 worldTransform, Plane[] clipPlane) {
        if (surf == null) {
            return;
        }
        if (surf.count != 0 && (flags == 0 || (surf.visflag & flags) != 0)) {
            Tile pic;
            int picnum = surf.picnum;
            if (this.engine.getTile(picnum).getType() != Tile.AnimType.None) {
                picnum += this.engine.animateoffs(picnum, 0);
            }
            if (!(pic = this.engine.getTile(picnum)).isLoaded()) {
                this.engine.loadtile(picnum);
            }
            int method = surf.getMethod();
            if (!pic.isLoaded()) {
                method = 1;
            }
            this.engine.setgotpic(picnum);
            GLTile pth = this.bind(picnum, surf.getPal(), surf.getShade(), 0, method);
            if (pth != null) {
                int combvis = Engine.globalvisibility;
                int vis = surf.getVisibility();
                if (vis != 0) {
                    combvis = Pragmas.mulscale(Engine.globalvisibility, vis + 16 & 0xFF, 4);
                }
                if (pth.getPixelFormat() == TileData.PixelFormat.Pal8) {
                    ((IndexedShader)this.manager.getProgram()).setVisibility((int)((float)(-combvis) / 64.0f));
                } else {
                    this.calcFog(surf.getPal(), surf.getShade(), combvis);
                }
                this.manager.color(1.0f, 1.0f, 1.0f, 1.0f);
                if (pth.isHighTile()) {
                    int tsizy;
                    for (tsizy = 1; tsizy < pic.getHeight(); tsizy += tsizy) {
                    }
                    if ((float)pic.getWidth() / (float)pic.getHeight() != (float)pth.getWidth() / (float)pth.getHeight()) {
                        this.texture_transform.scale(1.0f, (float)tsizy * pth.getYScale() / (float)pth.getHeight());
                    }
                    this.manager.textureTransform(this.texture_transform, 0);
                    if (this.defs != null && this.defs.texInfo != null) {
                        float r = 1.0f;
                        float g = 1.0f;
                        float b = 1.0f;
                        if (pth.getPal() != surf.getPal()) {
                            Palette p = this.defs.texInfo.getTints(surf.getPal());
                            r *= (float)p.r / 255.0f;
                            g *= (float)p.g / 255.0f;
                            b *= (float)p.b / 255.0f;
                        }
                        Palette pdetail = this.defs.texInfo.getTints(255);
                        if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                            r *= (float)pdetail.r / 255.0f;
                            g *= (float)pdetail.g / 255.0f;
                            b *= (float)pdetail.b / 255.0f;
                        }
                        this.manager.color(r, g, b, 1.0f);
                    }
                }
                if (worldTransform == null) {
                    this.manager.transform(this.identity);
                } else {
                    this.manager.transform(worldTransform);
                }
                if (clipPlane != null && !Engine.inpreparemirror) {
                    this.manager.frustum(clipPlane);
                } else {
                    this.manager.frustum(null);
                }
                if ((method & 3) == 0) {
                    Gdx.gl.glDisable(3042);
                } else {
                    Gdx.gl.glEnable(3042);
                }
                surf.render(this.manager.getProgram());
            }
        }
    }

    protected void calcFog(int pal, int shade, float combvis) {
        float start = 2.9E30f;
        float end = 3.0E30f;
        if (combvis != 0.0f) {
            if (shade >= Engine.numshades - 1) {
                start = -1.0f;
                end = 0.001f;
            } else {
                start = shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * shade)) / combvis;
                end = (float)(this.FOGDISTCONST * (Engine.numshades - 1 - shade)) / combvis;
            }
        }
        float r = (float)Engine.palookupfog[pal][0] / 63.0f;
        float g = (float)Engine.palookupfog[pal][1] / 63.0f;
        float b = (float)Engine.palookupfog[pal][2] / 63.0f;
        this.manager.fog(true, start, end, r, g, b);
    }

    @Override
    public void clearview(int dacol) {
        this.gl.glClearColor((float)Engine.curpalette.getRed(dacol) / 255.0f, (float)Engine.curpalette.getGreen(dacol) / 255.0f, (float)Engine.curpalette.getBlue(dacol) / 255.0f, 0.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void changepalette(byte[] palette) {
        this.textureCache.changePalette(palette);
    }

    @Override
    public void nextpage() {
        this.clearStatus = false;
        if (this.world != null) {
            this.world.nextpage();
        }
        this.orphoRen.nextpage();
        this.manager.reset();
        this.textureCache.unbind();
        MDAnimation.omdtims = MDAnimation.mdtims;
        MDAnimation.mdtims = this.engine.getticks();
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            ModelsInfo.SpriteAnim sprext;
            if (MDAnimation.mdpause == 0 || (sprext = this.defs.mdInfo.getAnimParams(i)) == null) continue;
            boolean isAnimationDisabled = false;
            Spriteext inf = this.defs.mapInfo.getSpriteInfo(i);
            if (inf != null) {
                isAnimationDisabled = inf.isAnimationDisabled();
            }
            if ((MDAnimation.mdpause == 0 || sprext.mdanimtims == 0L) && !isAnimationDisabled) continue;
            sprext.mdanimtims += MDAnimation.mdtims - MDAnimation.omdtims;
        }
        Engine.beforedrawrooms = 1;
    }

    @Override
    public void setview(int x1, int y1, int x2, int y2) {
        this.orphoRen.resize(x2, y2);
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.rendering = GLRenderer.Rendering.Tile.setIndex(picnum);
        this.set2dview();
        this.orphoRen.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2);
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.set2dview();
        this.orphoRen.drawmapview(dax, day, zoome, ang);
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        this.set2dview();
        this.orphoRen.drawoverheadmap(cposx, cposy, czoom, cang);
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
        this.rendering = GLRenderer.Rendering.Tile.setIndex(0);
        this.set2dview();
        this.orphoRen.printext(font, xpos, ypos, text, col, shade, bit, scale);
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        this.rendering = GLRenderer.Rendering.Tile.setIndex(0);
        this.set2dview();
        this.orphoRen.printext(xpos, ypos, col, backcol, text, fontsize, scale);
    }

    @Override
    public ByteBuffer getFrame(TileData.PixelFormat format, int xsiz, int ysiz) {
        if (this.pix32buffer != null) {
            this.pix32buffer.clear();
        }
        boolean reverse = false;
        if (ysiz < 0) {
            ysiz *= -1;
            reverse = true;
        }
        int byteperpixel = 3;
        int fmt = 6407;
        if (BuildGdx.app.getPlatform() == BuildApplication.Platform.Android) {
            byteperpixel = 4;
            fmt = 6408;
        }
        if (this.pix32buffer == null || this.pix32buffer.capacity() < xsiz * ysiz * byteperpixel) {
            this.pix32buffer = BufferUtils.newByteBuffer(xsiz * ysiz * byteperpixel);
        }
        this.gl.glPixelStorei(3333, 1);
        this.gl.glReadPixels(0, Engine.ydim - ysiz, xsiz, ysiz, fmt, 5121, this.pix32buffer);
        if (format == TileData.PixelFormat.Rgb) {
            if (reverse) {
                int b2 = 0;
                for (int y = 0; y < ysiz / 2; ++y) {
                    int b1 = byteperpixel * (ysiz - y - 1) * xsiz;
                    for (int x = 0; x < xsiz; ++x) {
                        for (int p = 0; p < byteperpixel; ++p) {
                            byte tmp = this.pix32buffer.get(b1 + p);
                            this.pix32buffer.put(b1 + p, this.pix32buffer.get(b2 + p));
                            this.pix32buffer.put(b2 + p, tmp);
                        }
                        b1 += byteperpixel;
                        b2 += byteperpixel;
                    }
                }
            }
            this.pix32buffer.rewind();
            return this.pix32buffer;
        }
        if (format == TileData.PixelFormat.Pal8) {
            if (this.pix8buffer != null) {
                this.pix8buffer.clear();
            }
            if (this.pix8buffer == null || this.pix8buffer.capacity() < xsiz * ysiz) {
                this.pix8buffer = BufferUtils.newByteBuffer(xsiz * ysiz);
            }
            int base = 0;
            if (reverse) {
                for (int y = 0; y < ysiz; ++y) {
                    base = byteperpixel * (ysiz - y - 1) * xsiz;
                    for (int x = 0; x < xsiz; ++x) {
                        int r = (this.pix32buffer.get(base++) & 0xFF) >> 2;
                        int g = (this.pix32buffer.get(base++) & 0xFF) >> 2;
                        int b = (this.pix32buffer.get(base++) & 0xFF) >> 2;
                        this.pix8buffer.put(this.engine.getclosestcol(Engine.palette, r, g, b));
                    }
                }
            } else {
                for (int i = 0; i < this.pix8buffer.capacity(); ++i) {
                    int r = (this.pix32buffer.get(base++) & 0xFF) >> 2;
                    int g = (this.pix32buffer.get(base++) & 0xFF) >> 2;
                    int b = (this.pix32buffer.get(base++) & 0xFF) >> 2;
                    if (byteperpixel == 4) {
                        ++base;
                    }
                    this.pix8buffer.put(this.engine.getclosestcol(Engine.palette, r, g, b));
                }
            }
            this.pix8buffer.rewind();
            return this.pix8buffer;
        }
        return null;
    }

    @Override
    public byte[] screencapture(int newwidth, int newheight) {
        byte[] capture = new byte[newwidth * newheight];
        int xf = Pragmas.divscale(Engine.xdim, newwidth, 16);
        int yf = Pragmas.divscale(Engine.ydim, newheight, 16);
        ByteBuffer frame = this.getFrame(TileData.PixelFormat.Rgb, Engine.xdim, -Engine.ydim);
        int byteperpixel = 3;
        if (BuildGdx.app.getType() == Application.ApplicationType.Android) {
            byteperpixel = 4;
        }
        for (int fy = 0; fy < newheight; ++fy) {
            int base = Pragmas.mulscale(fy, yf, 16) * Engine.xdim;
            for (int fx = 0; fx < newwidth; ++fx) {
                int pos = base + Pragmas.mulscale(fx, xf, 16);
                frame.position(byteperpixel * pos);
                int r = (frame.get() & 0xFF) >> 2;
                int g = (frame.get() & 0xFF) >> 2;
                int b = (frame.get() & 0xFF) >> 2;
                capture[newheight * fx + fy] = this.engine.getclosestcol(Engine.palette, r, g, b);
            }
        }
        return capture;
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        this.set2dview();
        this.orphoRen.drawline256(x1, y1, x2, y2, col);
    }

    @Override
    public void settiltang(int tilt) {
        this.gtang = tilt == 0 ? 0.0f : (float)Gameutils.AngleToDegrees(tilt);
    }

    @Override
    public void setDefs(DefScript defs) {
        this.textureCache.setTextureInfo(defs != null ? defs.texInfo : null);
        this.modelManager.setModelsInfo(defs != null ? defs.mdInfo : null);
        if (this.defs != null) {
            this.gltexinvalidateall(GLRenderer.GLInvalidateFlag.Uninit, GLRenderer.GLInvalidateFlag.All);
        }
        this.defs = defs;
    }

    @Override
    public TextureManager getTextureManager() {
        if (this.textureCache == null) {
            this.textureCache = new TextureManager(this.engine, TextureManager.ExpandTexture.Vertical);
        }
        return this.textureCache;
    }

    @Override
    public void enableIndexedShader(boolean enable) {
        if (this.isUseIndexedTextures != enable) {
            if (this.isInited) {
                this.texturesUninit();
            }
            this.clearskins(false);
            this.isUseIndexedTextures = enable;
        }
    }

    public void clearskins(boolean bit8only) {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.modelManager.clearSkins(i, bit8only);
        }
    }

    @Override
    public void palfade(HashMap<String, FadeEffect> fades) {
        if (this.orphoRen.isDrawing()) {
            this.orphoRen.end();
        }
        this.gl.glDisable(2929);
        this.gl.glDisable(3553);
        this.gl.glEnable(3042);
        this.set2dview();
        FadeEffect.FadeShader shader = (FadeEffect.FadeShader)this.manager.bind(ShaderManager.Shader.FadeShader);
        Engine.palfadergb.draw(shader);
        if (fades != null) {
            for (FadeEffect obj : fades.values()) {
                obj.draw(shader);
            }
        }
        this.gl.glBlendFunc(770, 771);
    }

    @Override
    public void preload(GLRenderer.GLPreloadFlag ... flags) {
        System.err.println("Preload");
        block4: for (int f = 0; f < flags.length; ++f) {
            switch (flags[f]) {
                case Models: {
                    int i;
                    for (i = Engine.MAXTILES - 1; i >= 0; --i) {
                        int pal = 0;
                        this.modelManager.preload(i, pal, false);
                    }
                    continue block4;
                }
                case Other: {
                    int i;
                    if (this.world != null) {
                        this.world.dispose();
                    }
                    this.world = new WorldMesh(this.engine);
                    this.scanner.init();
                    for (i = 0; i < Engine.MAXSPRITES; ++i) {
                        this.removeSpriteCorr(i);
                        SPRITE spr = Engine.sprite[i];
                        if (spr == null || (spr.cstat >> 4 & 3) != 1 || spr.statnum == 1024) continue;
                        this.addSpriteCorr(i);
                    }
                    continue block4;
                }
            }
        }
    }

    @Override
    public void precache(int dapicnum, int dapalnum, int datype) {
        if (Engine.palookup[dapalnum] == null && dapalnum < 252) {
            return;
        }
        this.textureCache.precache(this.getTexFormat(), dapicnum, dapalnum, datype);
        if (datype == 0) {
            return;
        }
        this.modelManager.preload(dapicnum, dapalnum, true);
    }

    @Override
    public void gltexapplyprops() {
        GLFilter filter = GLSettings.textureFilter.get();
        this.textureCache.setFilter(filter);
        int anisotropy = GLSettings.textureAnisotropy.get();
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.skycache.setFilter(i, filter, anisotropy);
        }
        this.modelManager.setTextureFilter(filter, GLSettings.textureAnisotropy.get());
    }

    @Override
    public void gltexinvalidateall(GLRenderer.GLInvalidateFlag ... flags) {
        if (flags.length == 0) {
            this.textureCache.invalidateall();
            this.clearskins(true);
            return;
        }
        block6: for (int i = 0; i < flags.length; ++i) {
            switch (flags[i]) {
                case Uninit: {
                    this.texturesUninit();
                    continue block6;
                }
                case SkinsOnly: {
                    this.clearskins(true);
                    continue block6;
                }
                case TexturesOnly: 
                case IndexedTexturesOnly: 
                case All: {
                    this.textureCache.invalidateall();
                    continue block6;
                }
                case Palookup: {
                    for (int j = 0; j < 256; ++j) {
                        this.textureCache.invalidatepalookup(j);
                    }
                    continue block6;
                }
            }
        }
    }

    @Override
    public void invalidatetile(int tilenume, int pal, int how) {
        int firstpal;
        int numpal;
        TileData.PixelFormat fmt = this.textureCache.getFmt(tilenume);
        if (fmt == null) {
            return;
        }
        if (fmt == TileData.PixelFormat.Pal8) {
            numpal = 1;
            firstpal = 0;
        } else if (pal < 0) {
            numpal = 256;
            firstpal = 0;
        } else {
            numpal = 1;
            firstpal = pal % 256;
        }
        for (int hp = 0; hp < 8; hp += 4) {
            if ((how & Engine.pow2long[hp]) == 0) continue;
            for (int np = firstpal; np < firstpal + numpal; ++np) {
                this.textureCache.invalidate(tilenume, np, this.textureCache.clampingMode(hp));
            }
        }
    }

    @Override
    public void setdrunk(float intensive) {
        if (intensive == 0.0f) {
            this.drunk = false;
            this.drunkIntensive = 0.0f;
        } else {
            this.drunk = true;
            this.drunkIntensive = intensive;
        }
    }

    @Override
    public float getdrunk() {
        return this.drunkIntensive;
    }

    protected GLTile bind(int dapicnum, int dapalnum, int dashade, int skybox, int method) {
        GLTile pth;
        if (Engine.palookup[dapalnum] == null) {
            dapalnum = 0;
        }
        if ((pth = this.textureCache.get(this.getTexFormat(), dapicnum, dapalnum, skybox, method)) == null) {
            return null;
        }
        this.textureCache.bind(pth);
        if (this.manager.getShader() == null || this.isSkyShader() || pth.getPixelFormat() != this.manager.getPixelFormat()) {
            this.switchShader(pth.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBWorldShader : ShaderManager.Shader.IndexedWorldShader);
        }
        this.setTextureParameters(pth, dapicnum, dapalnum, dashade, skybox, method);
        return pth;
    }

    protected GLTile bindSky(int dapicnum, int dapalnum, int dashade, int method) {
        GLTile pth;
        if (Engine.palookup[dapalnum] == null) {
            dapalnum = 0;
        }
        if ((pth = this.getSkyTexture(this.getTexFormat(), dapicnum, dapalnum)) == null) {
            return null;
        }
        this.textureCache.bind(pth);
        if (this.manager.getShader() == null || !this.isSkyShader() || pth.getPixelFormat() != this.manager.getPixelFormat()) {
            this.switchShader(pth.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBSkyShader : ShaderManager.Shader.IndexedSkyShader);
        }
        this.setTextureParameters(pth, dapicnum, dapalnum, dashade, 0, 0);
        return pth;
    }

    public void setTextureParameters(GLTile tile, int tilenum, int pal, int shade, int skybox, int method) {
        float alpha = 1.0f;
        switch (method & 3) {
            case 2: {
                alpha = Engine.TRANSLUSCENT1;
                break;
            }
            case 3: {
                alpha = Engine.TRANSLUSCENT2;
            }
        }
        if (tilenum != -1 && !this.engine.getTile(tilenum).isLoaded()) {
            alpha = 0.01f;
        }
        if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
            this.manager.textureTransform(this.texture_transform.idt(), 0);
            this.manager.textureParams8(pal, shade, alpha, (method & 3) == 0 || !this.textureCache.alphaMode(method));
        } else {
            float b;
            this.texture_transform.idt();
            if (tile.isHighTile() && (tile.getHiresXScale() != 1.0f || tile.getHiresYScale() != 1.0f) && GLRenderer.Rendering.Skybox.getIndex() == 0) {
                this.texture_transform.scale(tile.getHiresXScale(), tile.getHiresYScale());
            }
            this.manager.textureTransform(this.texture_transform, 0);
            if (GLInfo.multisample == 0 || !GLSettings.useHighTile.get().booleanValue() || GLRenderer.Rendering.Skybox.getIndex() == 0) {
                // empty if block
            }
            float fshade = Math.min(Math.max((float)shade * 1.04f, 0.0f), (float)Engine.numshades);
            float g = b = ((float)Engine.numshades - fshade) / (float)Engine.numshades;
            float r = b;
            if (this.defs != null && tile.isHighTile() && this.defs.texInfo != null) {
                if (tile.getPal() != pal) {
                    Palette p = this.defs.texInfo.getTints(pal);
                    r *= (float)p.r / 255.0f;
                    g *= (float)p.g / 255.0f;
                    b *= (float)p.b / 255.0f;
                }
                Palette pdetail = this.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    r *= (float)pdetail.r / 255.0f;
                    g *= (float)pdetail.g / 255.0f;
                    b *= (float)pdetail.b / 255.0f;
                }
            }
            this.manager.color(r, g, b, alpha);
        }
    }

    public void setFieldOfView(final float fov) {
        if (this.cam != null) {
            this.cam.setFieldOfView(fov);
        } else {
            BuildGdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    GDXRenderer.this.cam.setFieldOfView(fov);
                }
            });
        }
    }

    @Override
    public void addSpriteCorr(int snum) {
    }

    @Override
    public void removeSpriteCorr(int snum) {
    }

    @Override
    public void completemirror() {
        Engine.inpreparemirror = false;
    }

    private boolean spritewallfront(SPRITE s, int w) {
        if (s == null) {
            return false;
        }
        WALL wal = Engine.wall[w];
        int x1 = wal.x;
        int y1 = wal.y;
        wal = Engine.wall[wal.point2];
        return Pragmas.dmulscale(wal.x - x1, s.y - y1, -(s.x - x1), wal.y - y1, 32) >= 0;
    }

    protected void set2dview() {
        if (this.gloy1 != -1.0f) {
            this.gl.glViewport(0, 0, Engine.xdim, Engine.ydim);
            this.orphoRen.resize(Engine.xdim, Engine.ydim);
        }
        this.gloy1 = -1.0f;
    }

    protected void resizeglcheck() {
        if (this.glox1 != (float)Engine.windowx1 || this.gloy1 != (float)Engine.windowy1 || this.glox2 != (float)Engine.windowx2 || this.gloy2 != (float)Engine.windowy2) {
            this.glox1 = Engine.windowx1;
            this.gloy1 = Engine.windowy1;
            this.glox2 = Engine.windowx2;
            this.gloy2 = Engine.windowy2;
            this.gl.glViewport(Engine.windowx1, Engine.ydim - (Engine.windowy2 + 1), Engine.windowx2 - Engine.windowx1 + 1, Engine.windowy2 - Engine.windowy1 + 1);
            this.cam.viewportWidth = Engine.windowx2;
            this.cam.viewportHeight = Engine.windowy2;
        }
    }

    protected GDXOrtho allocOrphoRenderer(IOverheadMapSettings settings) {
        return new GDXOrtho(this, settings);
    }

    protected int[] getMirrorTextures() {
        return null;
    }

    @Override
    public Renderer.RenderType getType() {
        return Renderer.RenderType.PolyGDX;
    }

    @Override
    public TileData.PixelFormat getTexFormat() {
        return this.isUseIndexedTextures ? TileData.PixelFormat.Pal8 : TileData.PixelFormat.Rgba;
    }

    @Override
    public boolean isInited() {
        return this.isInited;
    }

    protected ShaderProgram switchShader(ShaderManager.Shader shader) {
        ShaderProgram out = this.manager.bind(shader);
        this.manager.mirror(Engine.inpreparemirror);
        this.manager.prepare(this.cam);
        return out;
    }

    protected GLTile getSkyTexture(TileData.PixelFormat fmt, int picnum, int palnum) {
        if (!this.engine.getTile(picnum).hasSize()) {
            return this.textureCache.get(this.getTexFormat(), picnum, palnum, 0, 0);
        }
        GLTile tile = this.skycache.get(picnum, palnum, false, 0);
        boolean useMipMaps = GLSettings.textureFilter.get().mipmaps;
        if (tile != null) {
            if (tile.isInvalidated()) {
                tile.setInvalidated(false);
                TileData data = this.loadPic(fmt, picnum, palnum);
                tile.update(data, palnum, useMipMaps);
            }
        } else {
            TileData data = this.loadPic(fmt, picnum, palnum);
            if (data == null) {
                return null;
            }
            this.skycache.add(this.textureCache.newTile(data, fmt == TileData.PixelFormat.Pal8 ? 0 : palnum, useMipMaps), picnum);
        }
        return tile;
    }

    protected TileData loadPic(TileData.PixelFormat fmt, int picnum, int palnum) {
        short[] dapskyoff = Engine.zeropskyoff;
        short dapskybits = Engine.pskybits;
        if (dapskybits < 0) {
            dapskybits = 0;
        }
        Tile tile = this.engine.getTile(picnum);
        TileAtlas sky = new TileAtlas(fmt, tile.getWidth() * (1 << dapskybits), tile.getHeight(), tile.getWidth(), tile.getHeight(), false);
        for (int i = 0; i < 1 << dapskybits; ++i) {
            int pic = dapskyoff[i] + picnum;
            TileData dat = fmt == TileData.PixelFormat.Pal8 ? new IndexedTileData(this.engine.getTile(pic), false, false, 0) : new RGBTileData(this.engine.getTile(pic), palnum, false, false, 0);
            sky.addTile(pic, dat);
        }
        return sky.atlas.get(0);
    }

    protected boolean isSkyShader() {
        return this.manager.getShader() == ShaderManager.Shader.RGBSkyShader || this.manager.getShader() == ShaderManager.Shader.IndexedSkyShader;
    }
}

