/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import java.util.ArrayList;

public abstract class Pool<T> {
    private int free;
    private final ArrayList<T> instances = new ArrayList();

    protected abstract T newObject();

    public void reset() {
        this.free = this.instances.size();
    }

    public T obtain() {
        if (this.free == 0) {
            T v = this.newObject();
            this.instances.add(v);
            return v;
        }
        return this.reset(this.instances.get(--this.free));
    }

    protected T reset(T object) {
        if (object instanceof Poolable) {
            ((Poolable)object).reset();
        }
        return object;
    }

    public int getSize() {
        return this.instances.size();
    }

    public String toString() {
        String text = "\r\n";
        text = text + "[free / size]: " + this.free + " / " + this.instances.size() + "\r\n";
        text = text + "used : " + (this.instances.size() - this.free) * 100 / this.instances.size() + "% \r\n";
        return text;
    }

    public static interface Poolable {
        public void reset();
    }
}

