/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.math.Plane;
import java.util.ArrayList;
import ru.m210projects.Build.Render.GdxRender.Pool;
import ru.m210projects.Build.Render.GdxRender.Tesselator;

public class PolygonClipper {
    private final Pool<Tesselator.Vertex> vecs = new Pool<Tesselator.Vertex>(){

        @Override
        protected Tesselator.Vertex newObject() {
            return new Tesselator.Vertex(0, 0);
        }
    };
    ArrayList<Tesselator.Vertex> list = new ArrayList();

    private void ClipPlane(Plane p, ArrayList<Tesselator.Vertex> src, ArrayList<Tesselator.Vertex> dst) {
        dst.clear();
        for (int i = 0; i < src.size(); ++i) {
            int j = i + 1;
            if (j >= src.size()) {
                j = 0;
            }
            Tesselator.Vertex v1 = src.get(i);
            Tesselator.Vertex v2 = src.get(j);
            float t1 = p.distance(v1);
            float t2 = p.distance(v2);
            if (t1 >= 0.0f) {
                dst.add(v1);
            }
            if (t1 >= 0.0f == t2 >= 0.0f) continue;
            float r = t1 / (t1 - t2);
            dst.add((Tesselator.Vertex)this.vecs.obtain().set(v2).sub(v1).scl(r).add(v1));
        }
    }

    public ArrayList<Tesselator.Vertex> ClipPolygon(Frustum frustum, ArrayList<Tesselator.Vertex> src) {
        this.vecs.reset();
        Plane[] planes = frustum.planes;
        this.ClipPlane(planes[2], src, this.list);
        for (int i = 3; i < 6; ++i) {
            if (i % 2 != 0) {
                this.ClipPlane(planes[i], this.list, src);
                continue;
            }
            this.ClipPlane(planes[i], src, this.list);
        }
        return src;
    }
}

