/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.WALL;

public class SectorInfo {
    public Engine.Clockdir[] loopinfo = new Engine.Clockdir[Engine.MAXWALLS];
    public boolean[] isOccluder = new boolean[Engine.MAXWALLS];
    public boolean[] isContour = new boolean[Engine.MAXWALLS];
    public int[] numloops = new int[Engine.MAXSECTORS];
    public boolean[] hasOccluders = new boolean[Engine.MAXSECTORS];
    public boolean[] isCorrupt = new boolean[Engine.MAXSECTORS];

    public void init(Engine engine) {
        for (int i = 0; i < Engine.numsectors; ++i) {
            SECTOR sec = Engine.sector[i];
            SECTOR.SectorIterator it = sec.iterator();
            this.hasOccluders[i] = false;
            Engine.Clockdir dir = engine.clockdir(sec.wallptr);
            boolean hasContour = false;
            int numloops = 0;
            while (it.hasNext()) {
                short z = it.nexti();
                this.loopinfo[z] = dir == null ? engine.clockdir(z) : dir;
                WALL wal = Engine.wall[z];
                short nextsector = wal.nextsector;
                if (dir == Engine.Clockdir.CCW && nextsector == -1) {
                    this.isOccluder[z] = true;
                    this.hasOccluders[i] = true;
                } else {
                    this.isOccluder[z] = false;
                }
                boolean bl = this.isContour[z] = dir == Engine.Clockdir.CW && nextsector == -1;
                if (wal.point2 >= z) continue;
                ++numloops;
                if (dir == Engine.Clockdir.CW) {
                    hasContour = true;
                }
                dir = null;
            }
            this.numloops[i] = numloops;
            if (numloops > 0 && !hasContour) {
                this.isCorrupt[i] = true;
                System.err.println("Error: sector " + i + " has not contour!");
                continue;
            }
            this.isCorrupt[i] = false;
        }
    }

    public boolean isCorruptSector(int i) {
        return this.isCorrupt[i];
    }

    public boolean isInnerWall(int i) {
        return this.loopinfo[i] == Engine.Clockdir.CCW;
    }

    public boolean isContourWall(int i) {
        return this.isContour[i];
    }

    public boolean isOccluderWall(int i) {
        return this.isOccluder[i];
    }

    public boolean hasOccluders(int sectnum) {
        return this.hasOccluders[sectnum];
    }

    public int getNumloops(int sectnum) {
        return this.numloops[sectnum];
    }
}

