/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Shaders;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.Shaders.IndexedSkyShaderProgram;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.FadeEffect;

public class ShaderManager {
    protected IndexedSkyShaderProgram skyshader;
    protected IndexedShader texshader;
    protected ShaderProgram skyshader32;
    protected ShaderProgram texshader32;
    protected ShaderProgram bitmapShader;
    protected FadeEffect.FadeShader fadeshader;
    protected ShaderProgram currentShaderProgram;
    protected Shader currentShader;
    private int world_projTrans;
    private int world_modelView;
    private int world_invProjectionView;
    private int world_viewport;
    private int world_mirror;
    private int world_planeClipping;
    private int world_plane0;
    private int world_plane1;
    private int world_transform;
    private int world_texture_transform;
    private int world32_texture_transform;
    private int world32_color;

    public Shader getShader() {
        return this.currentShader;
    }

    public TileData.PixelFormat getPixelFormat() {
        switch (this.currentShader) {
            case IndexedSkyShader: 
            case IndexedWorldShader: {
                return TileData.PixelFormat.Pal8;
            }
            case RGBWorldShader: 
            case RGBSkyShader: 
            case BitmapShader: 
            case FadeShader: {
                return TileData.PixelFormat.Rgba;
            }
        }
        return null;
    }

    public ShaderProgram getProgram() {
        return this.currentShaderProgram;
    }

    protected ShaderProgram check(Shader shader) {
        ShaderProgram sh = shader.get();
        if (this.currentShaderProgram != sh) {
            sh.begin();
            this.currentShader = shader;
        }
        return sh;
    }

    public void init(TextureManager textureCache) {
        this.skyshader = this.allocIndexedSkyShader(textureCache);
        Shader.IndexedSkyShader.set(this.skyshader);
        this.skyshader32 = this.allocRgbSkyShader();
        Shader.RGBSkyShader.set(this.skyshader32);
        this.texshader = this.allocIndexedShader(textureCache);
        Shader.IndexedWorldShader.set(this.texshader);
        this.texshader32 = this.allocRgbShader();
        Shader.RGBWorldShader.set(this.texshader32);
        this.bitmapShader = this.allocBitmapShader();
        Shader.BitmapShader.set(this.bitmapShader);
        this.fadeshader = this.allocFadeShader();
        Shader.FadeShader.set(this.fadeshader);
    }

    public boolean isInited() {
        return this.skyshader != null && this.skyshader32 != null && this.texshader != null && this.texshader32 != null && this.bitmapShader != null && this.fadeshader != null;
    }

    public void dispose() {
        if (this.skyshader != null) {
            this.skyshader.dispose();
        }
        if (this.skyshader32 != null) {
            this.skyshader32.dispose();
        }
        if (this.texshader != null) {
            this.texshader.dispose();
        }
        if (this.texshader32 != null) {
            this.texshader32.dispose();
        }
        if (this.bitmapShader != null) {
            this.bitmapShader.dispose();
        }
        if (this.fadeshader != null) {
            this.fadeshader.dispose();
        }
        for (Shader sh : Shader.values()) {
            sh.set(null);
        }
    }

    public void fog(boolean enable, float start, float end, float r, float g, float b) {
        switch (this.getShader()) {
            case RGBWorldShader: {
                this.texshader32.setUniformi("u_fogEnable", enable ? 1 : 0);
                this.texshader32.setUniformf("u_fogStart", start);
                this.texshader32.setUniformf("u_fogEnd", end);
                this.texshader32.setUniformf("u_fogColor", r, g, b);
            }
        }
    }

    public void fog(Shader shader, boolean enable, float start, float end, float r, float g, float b) {
        this.check(shader);
        switch (shader) {
            case RGBWorldShader: {
                this.texshader32.setUniformi("u_fogEnable", enable ? 1 : 0);
                this.texshader32.setUniformf("u_fogStart", start);
                this.texshader32.setUniformf("u_fogEnd", end);
                this.texshader32.setUniformf("u_fogColor", r, g, b);
            }
        }
    }

    public void mirror(boolean mirror) {
        switch (this.getShader()) {
            case IndexedWorldShader: {
                this.texshader.setUniformi(this.world_mirror, mirror ? 1 : 0);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformi("u_mirror", mirror ? 1 : 0);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.mirror(mirror);
                break;
            }
            case RGBSkyShader: {
                this.skyshader32.setUniformi("u_mirror", mirror ? 1 : 0);
            }
        }
    }

    public void mirror(Shader shader, boolean mirror) {
        this.check(shader);
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformi(this.world_mirror, mirror ? 1 : 0);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformi("u_mirror", mirror ? 1 : 0);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.mirror(mirror);
                break;
            }
            case RGBSkyShader: {
                this.skyshader32.setUniformi("u_mirror", mirror ? 1 : 0);
            }
        }
    }

    public void viewport(int cx1, int cy1, int cx2, int cy2) {
        Shader shader = this.getShader();
        if (shader == Shader.IndexedWorldShader) {
            if (cx1 == 0 && cy1 == 0 && cx2 == 0 && cy2 == 0) {
                this.texshader.setUniformi(this.world_planeClipping, 0);
                return;
            }
            this.texshader.setUniformi(this.world_planeClipping, 2);
            this.texshader.setUniformf(this.world_viewport, (float)cx1, (float)(Engine.ydim - cy1), (float)(cx2 + 1), (float)(Engine.ydim - cy2 - 1));
        } else if (shader == Shader.RGBWorldShader) {
            if (cx1 == 0 && cy1 == 0 && cx2 == 0 && cy2 == 0) {
                this.texshader32.setUniformi("u_planeClipping", 0);
                return;
            }
            this.texshader32.setUniformi("u_planeClipping", 2);
            this.texshader32.setUniformf("u_viewport", (float)cx1, (float)(Engine.ydim - cy1), (float)(cx2 + 1), (float)(Engine.ydim - cy2 - 1));
        }
    }

    public void viewport(Shader shader, int cx1, int cy1, int cx2, int cy2) {
        this.check(shader);
        if (shader == Shader.IndexedWorldShader) {
            if (cx1 == 0 && cy1 == 0 && cx2 == 0 && cy2 == 0) {
                this.texshader.setUniformi(this.world_planeClipping, 0);
                return;
            }
            this.texshader.setUniformi(this.world_planeClipping, 2);
            this.texshader.setUniformf(this.world_viewport, (float)cx1, (float)(Engine.ydim - cy1), (float)(cx2 + 1), (float)(Engine.ydim - cy2 - 1));
        } else if (shader == Shader.RGBWorldShader) {
            if (cx1 == 0 && cy1 == 0 && cx2 == 0 && cy2 == 0) {
                this.texshader32.setUniformi("u_planeClipping", 0);
                return;
            }
            this.texshader32.setUniformi("u_planeClipping", 2);
            this.texshader32.setUniformf("u_viewport", (float)cx1, (float)(Engine.ydim - cy1), (float)(cx2 + 1), (float)(Engine.ydim - cy2 - 1));
        }
    }

    public void frustum(Plane[] clipPlane) {
        Shader shader = this.getShader();
        if (shader == Shader.IndexedWorldShader) {
            if (clipPlane == null) {
                this.texshader.setUniformi(this.world_planeClipping, 0);
                return;
            }
            this.texshader.setUniformi(this.world_planeClipping, 1);
            this.texshader.setUniformf(this.world_plane0, clipPlane[0].normal.x, clipPlane[0].normal.y, clipPlane[0].normal.z, clipPlane[0].d);
            this.texshader.setUniformf("u_plane[1]", clipPlane[1].normal.x, clipPlane[1].normal.y, clipPlane[1].normal.z, clipPlane[1].d);
        } else if (shader == Shader.RGBWorldShader) {
            if (clipPlane == null) {
                this.texshader32.setUniformi("u_planeClipping", 0);
                return;
            }
            this.texshader32.setUniformi("u_planeClipping", 1);
            this.texshader32.setUniformf("u_plane[0]", clipPlane[0].normal.x, clipPlane[0].normal.y, clipPlane[0].normal.z, clipPlane[0].d);
            this.texshader32.setUniformf("u_plane[1]", clipPlane[1].normal.x, clipPlane[1].normal.y, clipPlane[1].normal.z, clipPlane[1].d);
        }
    }

    public void frustum(Shader shader, Plane[] clipPlane) {
        this.check(shader);
        if (shader == Shader.IndexedWorldShader) {
            if (clipPlane == null) {
                this.texshader.setUniformi(this.world_planeClipping, 0);
                return;
            }
            this.texshader.setUniformi(this.world_planeClipping, 1);
            this.texshader.setUniformf(this.world_plane0, clipPlane[0].normal.x, clipPlane[0].normal.y, clipPlane[0].normal.z, clipPlane[0].d);
            this.texshader.setUniformf("u_plane[1]", clipPlane[1].normal.x, clipPlane[1].normal.y, clipPlane[1].normal.z, clipPlane[1].d);
        } else if (shader == Shader.RGBWorldShader) {
            if (clipPlane == null) {
                this.texshader32.setUniformi("u_planeClipping", 0);
                return;
            }
            this.texshader32.setUniformi("u_planeClipping", 1);
            this.texshader32.setUniformf("u_plane[0]", clipPlane[0].normal.x, clipPlane[0].normal.y, clipPlane[0].normal.z, clipPlane[0].d);
            this.texshader32.setUniformf("u_plane[1]", clipPlane[1].normal.x, clipPlane[1].normal.y, clipPlane[1].normal.z, clipPlane[1].d);
        }
    }

    public ShaderManager transform(Matrix4 transform) {
        Shader shader = this.getShader();
        if (shader == null) {
            return this;
        }
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_transform, transform);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformMatrix("u_transform", transform);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.transform(transform);
                break;
            }
            case RGBSkyShader: {
                this.skyshader32.setUniformMatrix("u_transform", transform);
            }
        }
        return this;
    }

    public ShaderManager textureTransform(Matrix3 transform, int unit) {
        Shader shader = this.getShader();
        if (shader == null) {
            return this;
        }
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_texture_transform, transform);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformMatrix(this.world32_texture_transform, transform);
            }
        }
        return this;
    }

    public ShaderManager projection(Matrix4 projection) {
        Shader shader = this.getShader();
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_projTrans, projection);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformMatrix("u_projTrans", projection);
                break;
            }
            case BitmapShader: {
                this.bitmapShader.setUniformMatrix("u_projTrans", projection);
            }
        }
        return this;
    }

    public ShaderManager view(Matrix4 view) {
        Shader shader = this.getShader();
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_modelView, view);
                break;
            }
            case RGBWorldShader: {
                break;
            }
        }
        return this;
    }

    public void transform(Shader shader, Matrix4 transform) {
        this.check(shader);
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_transform, transform);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformMatrix("u_transform", transform);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.transform(transform);
                break;
            }
            case RGBSkyShader: {
                this.skyshader32.setUniformMatrix("u_transform", transform);
            }
        }
    }

    public void textureParams8(Shader shader, int pal, int shade, float alpha, boolean lastIndex) {
        this.check(shader);
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setTextureParams(pal, shade);
                this.texshader.setDrawLastIndex(lastIndex);
                this.texshader.setTransparent(alpha);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.setTextureParams(pal, shade);
                this.skyshader.setDrawLastIndex(lastIndex);
                this.skyshader.setTransparent(alpha);
            }
        }
    }

    public void textureParams8(int pal, int shade, float alpha, boolean lastIndex) {
        Shader shader = this.getShader();
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setTextureParams(pal, shade);
                this.texshader.setDrawLastIndex(lastIndex);
                this.texshader.setTransparent(alpha);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.setTextureParams(pal, shade);
                this.skyshader.setDrawLastIndex(lastIndex);
                this.skyshader.setTransparent(alpha);
            }
        }
    }

    public void color(Shader shader, float r, float g, float b) {
        this.check(shader);
        switch (shader) {
            case RGBWorldShader: {
                this.texshader32.setUniformf("u_color", r, g, b);
            }
        }
    }

    public void color(float r, float g, float b, float a) {
        Shader shader = this.getShader();
        switch (shader) {
            case RGBWorldShader: {
                this.texshader32.setUniformf("u_color", r, g, b, a);
            }
        }
    }

    public void prepare(BuildCamera cam) {
        Shader shader = this.getShader();
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_projTrans, cam.combined);
                this.texshader.setUniformMatrix(this.world_modelView, cam.view);
                this.texshader.setUniformMatrix(this.world_invProjectionView, cam.invProjectionView);
                this.texshader.setUniformf(this.world_viewport, (float)Engine.windowx1, (float)Engine.windowy1, (float)(Engine.windowx2 - Engine.windowx1 + 1), (float)(Engine.windowy2 - Engine.windowy1 + 1));
                this.texshader.setUniformi(this.world_planeClipping, 0);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformMatrix("u_projTrans", cam.combined);
                this.texshader32.setUniformMatrix("u_invProjectionView", cam.invProjectionView);
                this.texshader32.setUniformf("u_viewport", (float)Engine.windowx1, (float)Engine.windowy1, (float)(Engine.windowx2 - Engine.windowx1 + 1), (float)(Engine.windowy2 - Engine.windowy1 + 1));
                this.texshader32.setUniformi("u_planeClipping", 0);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.prepare(cam);
                break;
            }
            case RGBSkyShader: {
                this.skyshader32.setUniformf("u_camera", cam.position.x, cam.position.y, cam.position.z);
                this.skyshader32.setUniformMatrix("u_projTrans", cam.combined);
            }
        }
    }

    public void prepare(Shader shader, BuildCamera cam) {
        this.check(shader);
        switch (shader) {
            case IndexedWorldShader: {
                this.texshader.setUniformMatrix(this.world_projTrans, cam.combined);
                this.texshader.setUniformMatrix(this.world_modelView, cam.view);
                this.texshader.setUniformMatrix(this.world_invProjectionView, cam.invProjectionView);
                this.texshader.setUniformf(this.world_viewport, (float)Engine.windowx1, (float)Engine.windowy1, (float)(Engine.windowx2 - Engine.windowx1 + 1), (float)(Engine.windowy2 - Engine.windowy1 + 1));
                this.texshader.setUniformi(this.world_planeClipping, 0);
                break;
            }
            case RGBWorldShader: {
                this.texshader32.setUniformMatrix("u_projTrans", cam.combined);
                this.texshader32.setUniformMatrix("u_invProjectionView", cam.invProjectionView);
                this.texshader32.setUniformf("u_viewport", (float)Engine.windowx1, (float)Engine.windowy1, (float)(Engine.windowx2 - Engine.windowx1 + 1), (float)(Engine.windowy2 - Engine.windowy1 + 1));
                this.texshader32.setUniformi("u_planeClipping", 0);
                break;
            }
            case IndexedSkyShader: {
                this.skyshader.prepare(cam);
                break;
            }
            case RGBSkyShader: {
                this.skyshader32.setUniformf("u_camera", cam.position.x, cam.position.y, cam.position.z);
                this.skyshader32.setUniformMatrix("u_projTrans", cam.combined);
            }
        }
    }

    public ShaderProgram get(Shader shader) {
        switch (shader) {
            case IndexedWorldShader: {
                return this.texshader;
            }
            case RGBWorldShader: {
                return this.texshader32;
            }
            case IndexedSkyShader: {
                return this.skyshader;
            }
            case RGBSkyShader: {
                return this.skyshader32;
            }
            case BitmapShader: {
                return this.bitmapShader;
            }
            case FadeShader: {
                return this.fadeshader;
            }
        }
        return null;
    }

    public ShaderProgram bind(Shader shader) {
        ShaderProgram sh;
        if (this.currentShaderProgram != null) {
            this.currentShaderProgram.end();
        }
        if ((sh = shader.get()) != null) {
            sh.begin();
            this.currentShader = shader;
            return sh;
        }
        this.currentShaderProgram = null;
        this.currentShader = null;
        return sh;
    }

    public void reset() {
        for (Shader sh : Shader.values()) {
            this.textureParams8(sh, 0, 0, 0.0f, false);
            this.fog(sh, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.viewport(sh, 0, 0, 0, 0);
            this.color(sh, 0.0f, 0.0f, 0.0f);
            this.mirror(sh, false);
        }
        this.unbind();
    }

    public void unbind() {
        if (this.currentShaderProgram != null) {
            this.currentShaderProgram.end();
        }
        this.currentShaderProgram = null;
        this.currentShader = null;
    }

    public FadeEffect.FadeShader allocFadeShader() {
        return new FadeEffect.FadeShader(){

            @Override
            public void begin() {
                super.begin();
                ShaderManager.this.currentShaderProgram = this;
            }
        };
    }

    public IndexedSkyShaderProgram allocIndexedSkyShader(final TextureManager textureCache) {
        try {
            IndexedSkyShaderProgram skyshader = new IndexedSkyShaderProgram(){

                @Override
                public void begin() {
                    super.begin();
                    ShaderManager.this.currentShaderProgram = this;
                }

                @Override
                public void bindPalette(int unit) {
                    BuildGdx.gl.glActiveTexture(unit);
                    textureCache.getPalette().bind(0);
                }

                @Override
                public void bindPalookup(int unit, int pal) {
                    BuildGdx.gl.glActiveTexture(unit);
                    textureCache.getPalookup(pal).bind(0);
                }
            };
            if (!skyshader.isCompiled()) {
                System.err.println("Shader compile error: " + skyshader.getLog());
            }
            return skyshader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ShaderProgram allocRgbSkyShader() {
        try {
            ShaderProgram shader = new ShaderProgram("attribute vec4 a_position;\n\nuniform mat4 u_projTrans;\nuniform mat4 u_transform;\nuniform bool u_mirror;\nvarying vec4 v_pos;\n\nvoid main()\n{\n    v_pos = u_transform * a_position;\n    gl_Position = u_projTrans * v_pos;\n    if(u_mirror)\n        gl_Position.x *= -1.0;\n};\n", "uniform sampler2D u_sky;\nuniform vec3 u_camera;\nvarying vec4 v_pos;\nconst float PI = 3.1415926538;\n\nvoid main()\n{\n    vec4 pix = normalize(v_pos - vec4(u_camera, 1.0));\n    vec2 uv = vec2((atan(pix.y, pix.x) + PI) / (2.0 * PI), pix.z / 2.0);\n    uv = uv + 0.5;\n    gl_FragColor = texture2D(u_sky, uv);\n};"){

                @Override
                public void begin() {
                    super.begin();
                    ShaderManager.this.currentShaderProgram = this;
                }
            };
            if (!shader.isCompiled()) {
                throw new IllegalArgumentException("Error compiling shader: " + shader.getLog());
            }
            return shader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IndexedShader allocIndexedShader(final TextureManager textureCache) {
        try {
            IndexedShader shader = new IndexedShader("#ifdef GL_ES\n#define LOWP lowp\n    precision mediump float;\n#else\n#define LOWP\n#endif\n\nattribute vec4 a_position;\nattribute vec2 a_texCoord0;\nattribute vec4 a_color;\n\nuniform mat4 u_modelView;\nuniform mat4 u_projTrans;\nuniform mat4 u_transform;\nuniform mat3 u_texture_transform;\nuniform bool u_mirror;\n\nvarying LOWP float v_dist;\nvarying vec2 v_texCoords;\nvarying vec4 v_color;\n\nvoid main() {\n    v_texCoords = vec2(u_texture_transform * vec3(a_texCoord0, 1.0));\n    v_color = a_color;\n    v_color.a = v_color.a * (255.0/254.0);\n    vec4 mv = u_modelView * u_transform  * a_position;\n    gl_Position = u_projTrans * u_transform * a_position;\n    if(u_mirror)\n        gl_Position.x *= -1.0;\n    v_dist = mv.z / mv.w;\n};\n", "uniform sampler2D u_texture;\nuniform sampler2D u_palette;\nuniform sampler2D u_palookup;\n\nuniform int u_numshades;\nuniform float u_visibility;\nuniform int u_shade;\nuniform bool u_draw255;\nuniform float u_alpha;\n\nvarying float v_dist;\nvarying vec2 v_texCoords;\n\nuniform mat4 u_invProjectionView;\nuniform vec4 u_plane[2];\nuniform vec4 u_viewport;\nuniform int u_planeClipping;\n\nfloat getpalookup(int dashade) {\n    float davis = v_dist * u_visibility;\n    float shade = (min(max(float(dashade) + davis, 0.0), float(u_numshades - 1)));\n    return shade / 64.0;\n}\n\nvec4 getPos() {\n    vec4 ndc;\n\t   vec2 xy = gl_FragCoord.xy - vec2(u_viewport.xy);    ndc.xy = (2.0 * xy) / u_viewport.zw - 1.0;\n    ndc.z = (2.0 * gl_FragCoord.z) - 1.0;\n    ndc.w = 1.0;\n    \n    vec4 worldCoords = u_invProjectionView * ndc;\n    worldCoords.xyz /= worldCoords.w;\n    worldCoords.xyz *= vec3(512.0, 512.0, 8192.0); // BuildEngine coords scale\n    worldCoords.w = 1.0;\n    return worldCoords;\n}\n\nbool isvisible() {\n    vec4 pos = getPos();\n    for(int i = 0; i < 2; i++) {\n        if(dot(u_plane[i], pos) < 0.0)\n            return false;\n    }\n    return true;\n}\n\nvoid main() {  \n    if((u_planeClipping == 1 && !isvisible()))\n        discard;\n\n\t   if(u_planeClipping == 2 && (gl_FragCoord.x < u_viewport.x || gl_FragCoord.x > u_viewport.z\n\t\t || gl_FragCoord.y < u_viewport.w || gl_FragCoord.y > u_viewport.y))\t\t   discard;\n    float fi = texture2D(u_texture, v_texCoords).r;\n    if(fi == 1.0) {\n        if(!u_draw255) {\n            if(u_alpha >= 0.5)\n               discard;\n            gl_FragColor = vec4(0.01);\n            return;\n        }\n        fi -= 0.5 / 256.0;\n    }\n    float index = texture2D(u_palookup, vec2(fi, getpalookup(u_shade))).r;\n    if(index == 1.0) index -= 0.5 / 256.0;\n\n    gl_FragColor = vec4(texture2D(u_palette, vec2(index, 0.0)).rgb, u_alpha);\n}"){

                @Override
                public void bindPalette(int unit) {
                    BuildGdx.gl.glActiveTexture(unit);
                    textureCache.getPalette().bind(0);
                }

                @Override
                public void bindPalookup(int unit, int pal) {
                    BuildGdx.gl.glActiveTexture(unit);
                    textureCache.getPalookup(pal).bind(0);
                }

                @Override
                public void begin() {
                    super.begin();
                    ShaderManager.this.currentShaderProgram = this;
                }
            };
            this.world_projTrans = shader.getUniformLocation("u_projTrans");
            this.world_modelView = shader.getUniformLocation("u_modelView");
            this.world_invProjectionView = shader.getUniformLocation("u_invProjectionView");
            this.world_viewport = shader.getUniformLocation("u_viewport");
            this.world_mirror = shader.getUniformLocation("u_mirror");
            this.world_planeClipping = shader.getUniformLocation("u_planeClipping");
            this.world_plane0 = shader.getUniformLocation("u_plane[0]");
            this.world_plane1 = shader.getUniformLocation("u_plane[1]");
            this.world_transform = shader.getUniformLocation("u_transform");
            this.world_texture_transform = shader.getUniformLocation("u_texture_transform");
            return shader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ShaderProgram allocRgbShader() {
        try {
            ShaderProgram shader = new ShaderProgram("#ifdef GL_ES\n#define LOWP lowp\n    precision mediump float;\n#else\n#define LOWP\n#endif\n\nattribute vec4 a_position;\nattribute vec2 a_texCoord0;\nattribute vec4 a_color;\n\nuniform mat4 u_modelView;\nuniform mat4 u_projTrans;\nuniform mat4 u_transform;\nuniform mat3 u_texture_transform;\nuniform bool u_mirror;\n\nvarying LOWP float v_dist;\nvarying vec2 v_texCoords;\nvarying vec4 v_color;\n\nvoid main() {\n    v_texCoords = vec2(u_texture_transform * vec3(a_texCoord0, 1.0));\n    v_color = a_color;\n    v_color.a = v_color.a * (255.0/254.0);\n    vec4 mv = u_modelView * u_transform  * a_position;\n    gl_Position = u_projTrans * u_transform * a_position;\n    if(u_mirror)\n        gl_Position.x *= -1.0;\n    v_dist = mv.z / mv.w;\n};\n", "uniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nvarying vec4 v_color;\n\nuniform mat4 u_invProjectionView;\nuniform vec4 u_plane[2];\nuniform vec4 u_viewport;\nuniform vec4 u_color;\nuniform int u_planeClipping;\nuniform bool u_fogEnable;\nuniform float u_fogEnd;\nuniform float u_fogStart;\nuniform vec3 u_fogColor;\n\nfloat calcFog(float dist) { \n\t   return clamp(1.0 - (u_fogEnd - dist) / (u_fogEnd - u_fogStart), 0.0, 1.0); \n} \nvec4 getPos() {\n    vec4 ndc;\n\t   vec2 xy = gl_FragCoord.xy - vec2(u_viewport.xy);    ndc.xy = (2.0 * xy) / u_viewport.zw - 1.0;\n    ndc.z = (2.0 * gl_FragCoord.z) - 1.0;\n    ndc.w = 1.0;\n    \n    vec4 worldCoords = u_invProjectionView * ndc;\n    worldCoords.xyz /= worldCoords.w;\n    worldCoords.xyz *= vec3(512.0, 512.0, 8192.0); // BuildEngine coords scale\n    worldCoords.w = 1.0;\n    return worldCoords;\n}\n\nbool isvisible() {\n    vec4 pos = getPos();\n    for(int i = 0; i < 2; i++) {\n        if(dot(u_plane[i], pos) < 0.0)\n            return false;\n    }\n    return true;\n}\n\nvoid main() {  \n    if((u_planeClipping == 1 && !isvisible()))\n        discard;\n\n\t   if(u_planeClipping == 2 && (gl_FragCoord.x < u_viewport.x || gl_FragCoord.x > u_viewport.z\n\t\t || gl_FragCoord.y < u_viewport.w || gl_FragCoord.y > u_viewport.y))\t\t   discard;\n    vec4 tex_color = texture2D(u_texture, v_texCoords);\n    if(tex_color.a == 0.0)\n\t\t   discard;\t   vec4 src = u_color * v_color * tex_color;\n\t   if(u_fogEnable) {\n        gl_FragColor = mix(src, vec4(u_fogColor, 1.0), calcFog((gl_FragCoord.z / gl_FragCoord.w) / 64.0));\n        gl_FragColor.a = src.a;\n    }\n    else gl_FragColor = src;\n}"){

                @Override
                public void begin() {
                    super.begin();
                    ShaderManager.this.currentShaderProgram = this;
                }
            };
            if (!shader.isCompiled()) {
                throw new IllegalArgumentException("Error compiling shader: " + shader.getLog());
            }
            this.world32_texture_transform = shader.getUniformLocation("u_texture_transform");
            this.world32_color = shader.getUniformLocation("u_color");
            return shader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ShaderProgram allocBitmapShader() {
        ShaderProgram shader = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\tfloat alpha = texture2D(u_texture, v_texCoords).a;\tgl_FragColor = vec4(v_color.rgb, alpha);\n}"){

            @Override
            public void begin() {
                super.begin();
                ShaderManager.this.currentShaderProgram = this;
            }
        };
        if (!shader.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + shader.getLog());
        }
        return shader;
    }

    public String toString() {
        String out = "Current shader: ";
        Enum current = null;
        for (Shader sh : Shader.values()) {
            if (sh.get() != this.currentShaderProgram) continue;
            current = sh;
            break;
        }
        out = current != null ? out + current.name() : out + "NULL";
        return out;
    }

    public static enum Shader {
        IndexedWorldShader,
        RGBWorldShader,
        IndexedSkyShader,
        RGBSkyShader,
        BitmapShader,
        FadeShader;

        private ShaderProgram shader;

        public void set(ShaderProgram shader) {
            this.shader = shader;
        }

        public ShaderProgram get() {
            return this.shader;
        }
    }
}

