/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Shaders;

public class WorldShader {
    public static final String vertex = "#ifdef GL_ES\n#define LOWP lowp\n    precision mediump float;\n#else\n#define LOWP\n#endif\n\nattribute vec4 a_position;\nattribute vec2 a_texCoord0;\nattribute vec4 a_color;\n\nuniform mat4 u_modelView;\nuniform mat4 u_projTrans;\nuniform mat4 u_transform;\nuniform mat3 u_texture_transform;\nuniform bool u_mirror;\n\nvarying LOWP float v_dist;\nvarying vec2 v_texCoords;\nvarying vec4 v_color;\n\nvoid main() {\n    v_texCoords = vec2(u_texture_transform * vec3(a_texCoord0, 1.0));\n    v_color = a_color;\n    v_color.a = v_color.a * (255.0/254.0);\n    vec4 mv = u_modelView * u_transform  * a_position;\n    gl_Position = u_projTrans * u_transform * a_position;\n    if(u_mirror)\n        gl_Position.x *= -1.0;\n    v_dist = mv.z / mv.w;\n};\n";
    public static final String fragment = "uniform sampler2D u_texture;\nuniform sampler2D u_palette;\nuniform sampler2D u_palookup;\n\nuniform int u_numshades;\nuniform float u_visibility;\nuniform int u_shade;\nuniform bool u_draw255;\nuniform float u_alpha;\n\nvarying float v_dist;\nvarying vec2 v_texCoords;\n\nuniform mat4 u_invProjectionView;\nuniform vec4 u_plane[2];\nuniform vec4 u_viewport;\nuniform int u_planeClipping;\n\nfloat getpalookup(int dashade) {\n    float davis = v_dist * u_visibility;\n    float shade = (min(max(float(dashade) + davis, 0.0), float(u_numshades - 1)));\n    return shade / 64.0;\n}\n\nvec4 getPos() {\n    vec4 ndc;\n\t   vec2 xy = gl_FragCoord.xy - vec2(u_viewport.xy);    ndc.xy = (2.0 * xy) / u_viewport.zw - 1.0;\n    ndc.z = (2.0 * gl_FragCoord.z) - 1.0;\n    ndc.w = 1.0;\n    \n    vec4 worldCoords = u_invProjectionView * ndc;\n    worldCoords.xyz /= worldCoords.w;\n    worldCoords.xyz *= vec3(512.0, 512.0, 8192.0); // BuildEngine coords scale\n    worldCoords.w = 1.0;\n    return worldCoords;\n}\n\nbool isvisible() {\n    vec4 pos = getPos();\n    for(int i = 0; i < 2; i++) {\n        if(dot(u_plane[i], pos) < 0.0)\n            return false;\n    }\n    return true;\n}\n\nvoid main() {  \n    if((u_planeClipping == 1 && !isvisible()))\n        discard;\n\n\t   if(u_planeClipping == 2 && (gl_FragCoord.x < u_viewport.x || gl_FragCoord.x > u_viewport.z\n\t\t || gl_FragCoord.y < u_viewport.w || gl_FragCoord.y > u_viewport.y))\t\t   discard;\n    float fi = texture2D(u_texture, v_texCoords).r;\n    if(fi == 1.0) {\n        if(!u_draw255) {\n            if(u_alpha >= 0.5)\n               discard;\n            gl_FragColor = vec4(0.01);\n            return;\n        }\n        fi -= 0.5 / 256.0;\n    }\n    float index = texture2D(u_palookup, vec2(fi, getpalookup(u_shade))).r;\n    if(index == 1.0) index -= 0.5 / 256.0;\n\n    gl_FragColor = vec4(texture2D(u_palette, vec2(index, 0.0)).rgb, u_alpha);\n}";
    public static final String fragmentRGB = "uniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nvarying vec4 v_color;\n\nuniform mat4 u_invProjectionView;\nuniform vec4 u_plane[2];\nuniform vec4 u_viewport;\nuniform vec4 u_color;\nuniform int u_planeClipping;\nuniform bool u_fogEnable;\nuniform float u_fogEnd;\nuniform float u_fogStart;\nuniform vec3 u_fogColor;\n\nfloat calcFog(float dist) { \n\t   return clamp(1.0 - (u_fogEnd - dist) / (u_fogEnd - u_fogStart), 0.0, 1.0); \n} \nvec4 getPos() {\n    vec4 ndc;\n\t   vec2 xy = gl_FragCoord.xy - vec2(u_viewport.xy);    ndc.xy = (2.0 * xy) / u_viewport.zw - 1.0;\n    ndc.z = (2.0 * gl_FragCoord.z) - 1.0;\n    ndc.w = 1.0;\n    \n    vec4 worldCoords = u_invProjectionView * ndc;\n    worldCoords.xyz /= worldCoords.w;\n    worldCoords.xyz *= vec3(512.0, 512.0, 8192.0); // BuildEngine coords scale\n    worldCoords.w = 1.0;\n    return worldCoords;\n}\n\nbool isvisible() {\n    vec4 pos = getPos();\n    for(int i = 0; i < 2; i++) {\n        if(dot(u_plane[i], pos) < 0.0)\n            return false;\n    }\n    return true;\n}\n\nvoid main() {  \n    if((u_planeClipping == 1 && !isvisible()))\n        discard;\n\n\t   if(u_planeClipping == 2 && (gl_FragCoord.x < u_viewport.x || gl_FragCoord.x > u_viewport.z\n\t\t || gl_FragCoord.y < u_viewport.w || gl_FragCoord.y > u_viewport.y))\t\t   discard;\n    vec4 tex_color = texture2D(u_texture, v_texCoords);\n    if(tex_color.a == 0.0)\n\t\t   discard;\t   vec4 src = u_color * v_color * tex_color;\n\t   if(u_fogEnable) {\n        gl_FragColor = mix(src, vec4(u_fogColor, 1.0), calcFog((gl_FragCoord.z / gl_FragCoord.w) / 64.0));\n        gl_FragColor.a = src.a;\n    }\n    else gl_FragColor = src;\n}";
}

