/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Matrix4;
import java.util.Comparator;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Types.QuickSort;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;

public class SpriteRenderer {
    private final Matrix4 transform;
    private BuildCamera cam;
    private final SpriteComparator comp;
    private final GDXRenderer parent;
    private final Engine engine;
    private final int[] spritesz = new int[Engine.MAXSPRITES];

    public SpriteRenderer(Engine engine, GDXRenderer parent) {
        this.transform = new Matrix4();
        this.comp = new SpriteComparator();
        this.parent = parent;
        this.engine = engine;
    }

    public void sort(SPRITE[] array, int len) {
        for (int i = 0; i < len; ++i) {
            SPRITE spr = array[i];
            short s = spr.owner;
            if (s == -1) continue;
            this.spritesz[s] = spr.z;
            if (!Gameutils.isValidTile(spr.picnum) || (spr.cstat & 0x30) == 32) continue;
            Tile pic = this.engine.getTile(spr.picnum);
            byte yoff = (byte)(pic.getOffsetY() + spr.yoffset);
            short s2 = s;
            this.spritesz[s2] = this.spritesz[s2] - (yoff * spr.yrepeat << 2);
            int yspan = pic.getHeight() * spr.yrepeat << 2;
            if ((spr.cstat & 0x80) == 0) {
                short s3 = s;
                this.spritesz[s3] = this.spritesz[s3] - (yspan >> 1);
            }
            if (Pragmas.klabs(this.spritesz[s] - Engine.globalposz) >= yspan >> 1) continue;
            this.spritesz[s] = Engine.globalposz;
        }
        QuickSort.sort(array, len, this.comp);
    }

    public void begin(BuildCamera cam) {
        this.cam = cam;
    }

    public Matrix4 getMatrix(SPRITE tspr, int texx, int texy) {
        int picnum = tspr.picnum;
        short orientation = tspr.cstat;
        short spritenum = tspr.owner;
        Tile pic = this.engine.getTile(picnum);
        int xoff = 0;
        int yoff = 0;
        if ((orientation & 0x30) != 48) {
            if (pic.getType() != Tile.AnimType.None) {
                picnum += this.engine.animateoffs(picnum, spritenum + 32768);
                pic = this.engine.getTile(picnum);
            }
            xoff = tspr.xoffset;
            yoff = tspr.yoffset;
            xoff += pic.getOffsetX();
            yoff += pic.getOffsetY();
        }
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (tsizx <= 0 || tsizy <= 0) {
            return null;
        }
        boolean xflip = (orientation & 4) != 0;
        boolean yflip = (orientation & 8) != 0;
        float posx = tspr.x;
        float posy = tspr.y;
        float posz = tspr.z;
        this.transform.setToTranslation(posx, posy, posz);
        switch (orientation >> 4 & 3) {
            case 0: {
                float xspans = 5.0f;
                int ang = (int)Engine.globalang - 512 & 0x7FF;
                if (xflip ^ yflip) {
                    ang += 1024;
                    if (!xflip) {
                        xoff = -xoff;
                    }
                    if (yflip) {
                        xspans = -xspans;
                    }
                } else if (xflip) {
                    xoff = -xoff;
                    xspans = -xspans;
                }
                this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * texy) * (yflip ? 2.0f : -2.0f));
                this.transform.rotate(0.0f, 0.0f, 1.0f, (int)Gameutils.AngleToDegrees(ang));
                this.transform.translate((float)(tspr.xrepeat * xoff) / 5.0f, 0.0f, -(yoff * tspr.yrepeat << 2));
                if ((tsizx & 1) == 0) {
                    this.transform.translate((float)(tspr.xrepeat >> 1) / xspans, 0.0f, 0.0f);
                }
                if ((orientation & 0x80) != 0) {
                    float zoffs = tsizy * tspr.yrepeat << 1;
                    if ((tsizy & 1) != 0) {
                        zoffs += (float)(tspr.yrepeat << 1);
                    }
                    this.transform.translate(0.0f, 0.0f, zoffs);
                }
                if (yflip) {
                    this.transform.rotate(0.0f, 1.0f, 0.0f, 180.0f);
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * texy) * 4.0f);
                } else {
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * (texy - tsizy)) * 4.0f);
                }
                this.transform.scale((float)(tspr.xrepeat * texx) / 5.0f, 0.0f, 4 * tspr.yrepeat * texy);
                break;
            }
            case 1: {
                int dang;
                if (yflip) {
                    yoff = -yoff;
                }
                int wang = (int)Gameutils.AngleToDegrees(tspr.ang + (xflip ^ yflip ? 1536 : 512) & 0x7FF);
                if ((orientation & 0x40) == 0 && ((dang = (tspr.ang - this.engine.getangle(tspr.x - Engine.globalposx, tspr.y - Engine.globalposy) & 0x7FF) - 1024) > 512 || dang < -512)) {
                    xflip = !xflip;
                }
                float xspans = 4.0f;
                if (xflip ^ yflip) {
                    if (!xflip) {
                        xoff = -xoff;
                    }
                    if (yflip) {
                        xspans = -xspans;
                    }
                } else if (xflip) {
                    xoff = -xoff;
                    xspans = -xspans;
                }
                this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * texy) * (yflip ? 2.0f : -2.0f));
                this.transform.rotate(0.0f, 0.0f, 1.0f, wang);
                this.transform.translate((float)(tspr.xrepeat * xoff) / 4.0f, 0.0f, (float)(-(tspr.yrepeat * yoff)) * 4.0f);
                if ((orientation & 0x80) != 0) {
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * tsizy) * 2.0f);
                }
                if ((tsizx & 1) == 0) {
                    this.transform.translate((float)(tspr.xrepeat >> 1) / xspans, 0.0f, 0.0f);
                }
                if (yflip) {
                    this.transform.rotate(0.0f, 1.0f, 0.0f, 180.0f);
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * texy) * 4.0f);
                } else {
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.yrepeat * (texy - tsizy)) * 4.0f);
                }
                this.transform.scale((float)(tspr.xrepeat * texx) / 4.0f, 0.0f, (float)(tspr.yrepeat * texy) * 4.0f);
                break;
            }
            case 2: {
                if (yflip) {
                    yoff = -yoff;
                }
                if ((orientation & 0x40) == 0) {
                    if (tspr.z < Engine.globalposz) {
                        yflip = true;
                    } else if (yflip) {
                        yflip = !yflip;
                    }
                }
                float xspans = 4.0f;
                if (xflip ^ yflip) {
                    if (yflip) {
                        xspans = -xspans;
                    }
                } else if (xflip) {
                    xspans = -xspans;
                }
                this.transform.rotate(0.0f, 0.0f, 1.0f, (int)Gameutils.AngleToDegrees(tspr.ang + (xflip ? 512 : 1536) & 0x7FF));
                this.transform.rotate(1.0f, 0.0f, 0.0f, xflip ? -90.0f : 90.0f);
                if ((tsizx & 1) == 0) {
                    this.transform.translate((float)(tspr.xrepeat >> 1) / xspans, 0.0f, 0.0f);
                }
                this.transform.translate((float)(tspr.xrepeat * xoff) / 4.0f, 0.0f, (float)(-(tspr.yrepeat * yoff)) / 4.0f);
                this.transform.scale((float)(tspr.xrepeat * texx) / 4.0f, 0.0f, (float)(tspr.yrepeat * texy) / 4.0f);
            }
        }
        return this.transform.rotate(1.0f, 0.0f, 0.0f, 90.0f);
    }

    public boolean draw(SPRITE tspr) {
        GLTile tex;
        if (tspr.owner < 0 || !Gameutils.isValidTile(tspr.picnum) || !Gameutils.isValidSector(tspr.sectnum)) {
            return false;
        }
        ShaderManager manager = this.parent.manager;
        int picnum = tspr.picnum;
        byte shade = tspr.shade;
        int pal = tspr.pal & 0xFF;
        short orientation = tspr.cstat;
        short spritenum = tspr.owner;
        Tile pic = this.engine.getTile(picnum);
        if ((orientation & 0x30) != 48 && pic.getType() != Tile.AnimType.None) {
            picnum += this.engine.animateoffs(picnum, spritenum + 32768);
            pic = this.engine.getTile(picnum);
        }
        if (!pic.isLoaded()) {
            this.engine.loadtile(picnum);
        }
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (tsizx <= 0 || tsizy <= 0) {
            return false;
        }
        int method = 5;
        if ((orientation & 2) != 0) {
            method = (orientation & 0x200) == 0 ? 6 : 7;
        }
        if ((tex = this.parent.bind(picnum, pal, shade, 0, method)) == null) {
            return false;
        }
        if (tex.isHighTile()) {
            for (tsizy = 1; tsizy < tex.getHeight(); tsizy += tsizy) {
            }
            tsizy = (int)((float)tsizy / tex.getYScale());
        } else {
            tsizx = tex.getWidth();
            tsizy = tex.getHeight();
        }
        int vis = Engine.globalvisibility;
        if (Engine.sector[tspr.sectnum].visibility != 0) {
            vis = Pragmas.mulscale(Engine.globalvisibility, Engine.sector[tspr.sectnum].visibility + 16 & 0xFF, 4);
        }
        if (tex.getPixelFormat() == TileData.PixelFormat.Pal8) {
            ((IndexedShader)manager.getProgram()).setVisibility((int)((float)(-vis) / 64.0f));
        } else {
            this.parent.calcFog(pal, shade, vis);
        }
        boolean xflip = (orientation & 4) != 0;
        boolean yflip = (orientation & 8) != 0;
        switch (orientation >> 4 & 3) {
            case 1: {
                int dang;
                if ((orientation & 0x40) != 0 || (dang = (tspr.ang - this.engine.getangle(tspr.x - Engine.globalposx, tspr.y - Engine.globalposy) & 0x7FF) - 1024) <= 512 && dang >= -512) break;
                xflip = !xflip;
                break;
            }
            case 2: {
                if ((orientation & 0x40) != 0) break;
                if (tspr.z < Engine.globalposz) {
                    yflip = true;
                    break;
                }
                if (!yflip) break;
                boolean bl = yflip = !yflip;
            }
        }
        if ((method & 3) == 0) {
            BuildGdx.gl.glDisable(3042);
        } else {
            BuildGdx.gl.glEnable(3042);
        }
        if (xflip ^ yflip) {
            BuildGdx.gl.glFrontFace(2305);
        } else {
            BuildGdx.gl.glFrontFace(2304);
        }
        Gdx.gl.glDepthFunc(515);
        Gdx.gl.glDepthRangef(0.0f, 0.99999f);
        Matrix4 mat = this.getMatrix(tspr, tsizx, tsizy);
        float invscalex = 1.0f / this.cam.xscale;
        float invscaley = 1.0f / this.cam.yscale;
        mat.val[0] = mat.val[0] * invscalex;
        mat.val[4] = mat.val[4] * invscalex;
        mat.val[8] = mat.val[8] * invscalex;
        mat.val[12] = mat.val[12] * invscalex;
        mat.val[1] = mat.val[1] * invscalex;
        mat.val[5] = mat.val[5] * invscalex;
        mat.val[9] = mat.val[9] * invscalex;
        mat.val[13] = mat.val[13] * invscalex;
        mat.val[2] = mat.val[2] * invscaley;
        mat.val[6] = mat.val[6] * invscaley;
        mat.val[10] = mat.val[10] * invscaley;
        mat.val[14] = mat.val[14] * invscaley;
        manager.transform(mat);
        manager.frustum(null);
        this.parent.world.getQuad().render(manager.getProgram());
        BuildGdx.gl.glFrontFace(2304);
        return true;
    }

    public void end() {
        Gdx.gl.glDepthFunc(513);
        Gdx.gl.glDepthRangef(this.parent.defznear, this.parent.defzfar);
    }

    public class SpriteComparator
    implements Comparator<SPRITE> {
        @Override
        public int compare(SPRITE o1, SPRITE o2) {
            int len2;
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (o1.owner == o2.owner || o1.owner == -1 || o2.owner == -1) {
                return 0;
            }
            int len1 = this.getDist(o1);
            if (len1 != (len2 = this.getDist(o2))) {
                return len1 < len2 ? -1 : 1;
            }
            if ((o1.cstat & 2) != 0) {
                return -1;
            }
            if ((o2.cstat & 2) != 0) {
                return 1;
            }
            return o1.statnum <= o2.statnum ? -1 : 0;
        }

        public int getDist(SPRITE spr) {
            int dx1 = spr.x - Engine.globalposx;
            int dy1 = spr.y - Engine.globalposy;
            int dz1 = SpriteRenderer.this.spritesz[spr.owner] - Engine.globalposz >> 4;
            return dx1 * dx1 + dy1 * dy1 + dz1 * dz1;
        }
    }
}

