/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GdxRender.Tesselator;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.Timer;
import ru.m210projects.Build.Types.WALL;

public class WorldMesh {
    private final Tesselator tess;
    private final Mesh mesh;
    protected Engine engine;
    private int maxVertices;
    private int meshOffset;
    protected GLSurface lastSurf;
    private boolean validateMesh = false;
    private FloatBuffer meshBuffer;
    private final FloatArray vertices = new FloatArray();
    private final int[] floorhash = new int[Engine.MAXSECTORS];
    private final int[] ceilinghash = new int[Engine.MAXSECTORS];
    private final int[] wallhash = new int[Engine.MAXWALLS];
    private final GLSurface[] walls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] upper_walls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] lower_walls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] maskwalls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] upper_skies = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] lower_skies = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] floors = new GLSurface[Engine.MAXSECTORS];
    private final GLSurface[] ceilings = new GLSurface[Engine.MAXSECTORS];
    private final GLSurface quad;
    private final int[] zofslope = new int[2];
    private static final int CEILING1 = 0;
    private static final int CEILING2 = 1;
    private static final int FLOOR2 = 2;
    private static final int FLOOR1 = 3;
    private final Tesselator.Vertex[] pol = new Tesselator.Vertex[]{new Tesselator.Vertex(0, 0), new Tesselator.Vertex(1, 0), new Tesselator.Vertex(1, 1), new Tesselator.Vertex(0, 1)};
    private final ArrayList<Tesselator.Vertex> pointList = new ArrayList();
    protected final float scalexy = 512.0f;
    protected final float scalez = 8192.0f;
    private int lastLimit = 0;

    public WorldMesh(Engine engine) {
        this.engine = engine;
        this.tess = new Tesselator(this, VertexAttribute.Position(), VertexAttribute.ColorPacked(), VertexAttribute.TexCoords(0));
        Timer.start();
        FloatArray vertices = new FloatArray();
        this.lastSurf = null;
        this.maxVertices = 0;
        this.meshOffset = 0;
        this.quad = this.addQuad(vertices);
        for (short s = 0; s < Engine.numsectors; s = (short)(s + 1)) {
            int w;
            SECTOR sec = Engine.sector[s];
            if (sec.floorz == sec.ceilingz) continue;
            this.tess.setSector(s, true);
            if (this.tess.zoids.size() == 0) continue;
            this.addFloor(vertices, s);
            this.floorhash[s] = this.getFloorHash(s);
            this.addCeiling(vertices, s);
            this.ceilinghash[s] = this.getCeilingHash(s);
            for (w = sec.wallptr; w < sec.wallptr + sec.wallnum; ++w) {
                this.wallhash[w] = this.getWallHash(s, w);
                this.addMiddle(vertices, s, w);
                this.addUpper(vertices, s, w);
                this.addLower(vertices, s, w);
                this.addMaskedWall(vertices, s, w);
            }
            if (sec.isParallaxCeiling() || sec.isParallaxFloor()) {
                for (w = sec.wallptr; w < sec.wallptr + sec.wallnum; ++w) {
                    this.addParallaxCeiling(vertices, s, w);
                    this.addParallaxFloor(vertices, s, w);
                }
            }
            this.maxVertices += this.tess.getMaxVertices();
        }
        Timer.result("WorldMesh built in: ");
        this.mesh = new Mesh(false, this.maxVertices, 0, this.tess.attributes);
        int size = Math.min(this.maxVertices * this.tess.getVertexSize(), vertices.items.length);
        this.mesh.setVertices(vertices.items, 0, size);
        this.meshBuffer = this.mesh.getVerticesBuffer();
        this.lastLimit = this.meshBuffer.limit() * 4;
        this.validateMesh = false;
    }

    public ArrayList<Tesselator.Vertex> getPoints(Heinum heinum, int sectnum, int z) {
        SECTOR sec = Engine.sector[sectnum];
        WALL wal = Engine.wall[z];
        WALL wal2 = Engine.wall[wal.point2];
        short nextsector = wal.nextsector;
        switch (heinum) {
            case Max: 
            case MaxWall: {
                this.engine.getzsofslope((short)sectnum, wal.x, wal.y, this.zofslope);
                this.pol[0].set(wal, this.zofslope[0], 0.0f, 0.0f);
                this.pol[3].set(wal, this.zofslope[1], 0.0f, 1.0f);
                this.engine.getzsofslope((short)sectnum, wal2.x, wal2.y, this.zofslope);
                this.pol[2].set(wal2, this.zofslope[1], 1.0f, 1.0f);
                this.pol[1].set(wal2, this.zofslope[0], 1.0f, 0.0f);
                if (heinum != Heinum.Max) break;
                if (sec.isParallaxCeiling()) {
                    this.pol[1].z = -2.1474836E9f;
                    this.pol[0].z = -2.1474836E9f;
                }
                if (!sec.isParallaxFloor()) break;
                this.pol[2].z = 2.1474836E9f;
                this.pol[3].z = 2.1474836E9f;
                break;
            }
            case Lower: {
                int fz1 = this.engine.getflorzofslope((short)sectnum, wal.x, wal.y);
                int cz1 = this.engine.getflorzofslope(nextsector, wal.x, wal.y);
                int fz2 = this.engine.getflorzofslope((short)sectnum, wal2.x, wal2.y);
                int cz2 = this.engine.getflorzofslope(nextsector, wal2.x, wal2.y);
                if (fz1 < cz1 && fz2 < cz2) {
                    return null;
                }
                this.pol[0].set(wal, cz1, 0.0f, 0.0f);
                this.pol[3].set(wal, fz1, 0.0f, 1.0f);
                this.pol[2].set(wal2, fz2, 1.0f, 1.0f);
                this.pol[1].set(wal2, cz2, 1.0f, 0.0f);
                break;
            }
            case SkyLower: {
                int fz1 = this.engine.getflorzofslope((short)sectnum, wal.x, wal.y);
                this.pol[0].set(wal, fz1, 0.0f, 1.0f);
                this.pol[3].set(wal, fz1 + 0x8000000, 0.0f, 0.0f);
                fz1 = this.engine.getflorzofslope((short)sectnum, wal2.x, wal2.y);
                this.pol[2].set(wal2, fz1 + 0x8000000, 1.0f, 1.0f);
                this.pol[1].set(wal2, fz1, 1.0f, 0.0f);
                break;
            }
            case SkyUpper: {
                int cz1 = this.engine.getceilzofslope((short)sectnum, wal.x, wal.y);
                this.pol[3].set(wal, cz1, 0.0f, 0.0f);
                this.pol[0].set(wal, cz1 - 0x8000000, 0.0f, 1.0f);
                cz1 = this.engine.getceilzofslope((short)sectnum, wal2.x, wal2.y);
                this.pol[2].set(wal2, cz1, 1.0f, 1.0f);
                this.pol[1].set(wal2, cz1 - 0x8000000, 1.0f, 0.0f);
                break;
            }
            case Upper: {
                int fz1 = this.engine.getceilzofslope((short)sectnum, wal.x, wal.y);
                int cz1 = this.engine.getceilzofslope(nextsector, wal.x, wal.y);
                int fz2 = this.engine.getceilzofslope((short)sectnum, wal2.x, wal2.y);
                int cz2 = this.engine.getceilzofslope(nextsector, wal2.x, wal2.y);
                if (fz1 >= cz1 && fz2 >= cz2) {
                    return null;
                }
                this.pol[0].set(wal, fz1, 0.0f, 0.0f);
                this.pol[3].set(wal, cz1, 0.0f, 1.0f);
                this.pol[2].set(wal2, cz2, 1.0f, 1.0f);
                this.pol[1].set(wal2, fz2, 1.0f, 0.0f);
                break;
            }
            case Portal: {
                this.engine.getzsofslope(nextsector, wal.x, wal.y, this.zofslope);
                int fz1 = this.zofslope[1];
                int cz1 = this.zofslope[0];
                this.engine.getzsofslope(nextsector, wal2.x, wal2.y, this.zofslope);
                int fz2 = this.zofslope[1];
                int cz2 = this.zofslope[0];
                this.engine.getzsofslope((short)sectnum, wal.x, wal.y, this.zofslope);
                int fz3 = this.zofslope[1];
                int cz3 = this.zofslope[0];
                this.engine.getzsofslope((short)sectnum, wal2.x, wal2.y, this.zofslope);
                int fz4 = this.zofslope[1];
                int cz4 = this.zofslope[0];
                if (fz3 <= fz1 && fz4 <= fz2) {
                    fz1 = fz3;
                    fz2 = fz4;
                }
                if (cz3 >= cz1 && cz4 >= cz2) {
                    cz1 = cz3;
                    cz2 = cz4;
                }
                this.pol[0].set(wal, cz1, 0.0f, 0.0f);
                this.pol[3].set(wal, fz1, 0.0f, 1.0f);
                this.pol[2].set(wal2, fz2, 1.0f, 1.0f);
                this.pol[1].set(wal2, cz2, 1.0f, 0.0f);
            }
        }
        this.pointList.clear();
        if (this.pol[3].z == this.pol[0].z && this.pol[2].z == this.pol[1].z) {
            if (sec.isParallaxFloor() || sec.isParallaxCeiling()) {
                this.pointList.add(this.pol[0]);
                this.pointList.add(this.pol[1]);
                return this.pointList;
            }
            return null;
        }
        float dz0 = this.pol[3].z - this.pol[0].z;
        float dz1 = this.pol[2].z - this.pol[1].z;
        if (dz0 > 0.0f) {
            this.pointList.add(this.pol[0]);
            if (dz1 > 0.0f) {
                this.pointList.add(this.pol[1]);
                this.pointList.add(this.pol[2]);
                this.pointList.add(this.pol[3]);
                return this.pointList;
            }
            float f = dz0 / (dz0 - dz1);
            this.pol[1].x = (this.pol[1].x - this.pol[0].x) * f + this.pol[0].x;
            this.pol[1].y = (this.pol[1].y - this.pol[0].y) * f + this.pol[0].y;
            this.pol[1].z = (this.pol[1].z - this.pol[0].z) * f + this.pol[0].z;
            this.pol[1].u = (this.pol[1].u - this.pol[0].u) * f + this.pol[0].u;
            this.pol[1].v = (this.pol[1].v - this.pol[0].v) * f + this.pol[0].v;
            this.pointList.add(this.pol[1]);
            this.pointList.add(this.pol[3]);
            return this.pointList;
        }
        if (dz1 <= 0.0f) {
            return null;
        }
        float f = dz0 / (dz0 - dz1);
        this.pol[0].x = (this.pol[1].x - this.pol[0].x) * f + this.pol[0].x;
        this.pol[0].y = (this.pol[1].y - this.pol[0].y) * f + this.pol[0].y;
        this.pol[0].z = (this.pol[1].z - this.pol[0].z) * f + this.pol[0].z;
        this.pol[0].u = (this.pol[1].u - this.pol[0].u) * f + this.pol[0].u;
        this.pol[0].v = (this.pol[1].v - this.pol[0].v) * f + this.pol[0].v;
        this.pointList.add(this.pol[0]);
        this.pointList.add(this.pol[1]);
        this.pointList.add(this.pol[2]);
        return this.pointList;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    private GLSurface addParallaxFloor(FloatArray vertices, int sectnum, int wallnum) {
        WALL wal = Engine.wall[wallnum];
        SECTOR sec = Engine.sector[sectnum];
        boolean isParallaxFloor = sec.isParallaxFloor();
        if (!isParallaxFloor) {
            return this.setNull(this.lower_skies, wallnum);
        }
        short nextsector = wal.nextsector;
        boolean isParallaxNext = nextsector != -1 && Engine.sector[nextsector].isParallaxFloor();
        GLSurface surf = null;
        if (isParallaxFloor && (nextsector == -1 || !isParallaxNext)) {
            Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Sky.setHeinum(Heinum.SkyLower), wallnum, vertices);
            if (info == null) {
                return this.setNull(this.lower_skies, wallnum);
            }
            surf = this.getSurface(this.lower_skies, wallnum, info.getSize(), info.getLimit());
            if (surf != null) {
                surf.picnum = info.picnum;
                surf.ptr = info.obj;
                surf.type = Tesselator.Type.Floor;
                surf.vis_ptr = sectnum;
                surf.visflag = 0;
            }
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addParallaxCeiling(FloatArray vertices, int sectnum, int wallnum) {
        WALL wal = Engine.wall[wallnum];
        SECTOR sec = Engine.sector[sectnum];
        boolean isParallaxCeiling = sec.isParallaxCeiling();
        if (!isParallaxCeiling) {
            return this.setNull(this.upper_skies, wallnum);
        }
        short nextsector = wal.nextsector;
        boolean isParallaxNext = nextsector != -1 && Engine.sector[nextsector].isParallaxCeiling();
        GLSurface surf = null;
        if (isParallaxCeiling && (nextsector == -1 || !isParallaxNext)) {
            Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Sky.setHeinum(Heinum.SkyUpper), wallnum, vertices);
            if (info == null) {
                return this.setNull(this.upper_skies, wallnum);
            }
            surf = this.getSurface(this.upper_skies, wallnum, info.getSize(), info.getLimit());
            if (surf != null) {
                surf.picnum = info.picnum;
                surf.ptr = info.obj;
                surf.type = Tesselator.Type.Ceiling;
                surf.vis_ptr = sectnum;
                surf.visflag = 0;
            }
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addMiddle(FloatArray vertices, int sectnum, int wallnum) {
        GLSurface surf = null;
        short nextsector = Engine.wall[wallnum].nextsector;
        if (nextsector != -1) {
            return this.setNull(this.walls, wallnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.MaxWall), wallnum, vertices);
        if (info == null) {
            return this.setNull(this.walls, wallnum);
        }
        surf = this.getSurface(this.walls, wallnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Wall;
            surf.vis_ptr = sectnum;
            surf.visflag = 0;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addUpper(FloatArray vertices, int sectnum, int wallnum) {
        short nextsector = Engine.wall[wallnum].nextsector;
        if (nextsector == -1 || Engine.sector[nextsector].isParallaxCeiling() && Engine.sector[sectnum].isParallaxCeiling()) {
            return this.setNull(this.upper_walls, wallnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.Upper), wallnum, vertices);
        if (info == null) {
            return this.setNull(this.upper_walls, wallnum);
        }
        GLSurface surf = this.getSurface(this.upper_walls, wallnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Wall;
            surf.vis_ptr = sectnum;
            surf.visflag = 2;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addLower(FloatArray vertices, int sectnum, int wallnum) {
        short nextsector = Engine.wall[wallnum].nextsector;
        if (nextsector == -1 || Engine.sector[nextsector].isParallaxFloor() && Engine.sector[sectnum].isParallaxFloor()) {
            return this.setNull(this.lower_walls, wallnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.Lower), wallnum, vertices);
        if (info == null) {
            return this.setNull(this.lower_walls, wallnum);
        }
        GLSurface surf = this.getSurface(this.lower_walls, wallnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Wall;
            surf.vis_ptr = sectnum;
            surf.visflag = 1;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addMaskedWall(FloatArray vertices, int sectnum, int wallnum) {
        WALL wal = Engine.wall[wallnum];
        GLSurface surf = null;
        if ((wal.isMasked() || wal.isOneWay()) && wal.nextsector != -1) {
            Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.Portal), wallnum, vertices);
            if (info == null) {
                return this.setNull(this.maskwalls, wallnum);
            }
            surf = this.getSurface(this.maskwalls, wallnum, info.getSize(), info.getLimit());
            if (surf != null) {
                surf.picnum = info.picnum;
                surf.ptr = info.obj;
                surf.type = Tesselator.Type.Wall;
                surf.vis_ptr = sectnum;
                surf.visflag = 4;
            }
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addFloor(FloatArray vertices, int sectnum) {
        if (Engine.sector[sectnum].isParallaxFloor()) {
            return this.setNull(this.floors, sectnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Floor, sectnum, vertices);
        if (info == null) {
            return this.setNull(this.floors, sectnum);
        }
        GLSurface surf = this.getSurface(this.floors, sectnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Floor;
            surf.vis_ptr = sectnum;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addQuad(FloatArray vertices) {
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Quad, 0, vertices);
        GLSurface surf = new GLSurface(this.meshOffset);
        surf.count = info.getSize();
        surf.limit = info.getLimit();
        surf.type = Tesselator.Type.Quad;
        surf.primitiveType = 6;
        this.meshOffset += surf.limit;
        return surf;
    }

    private GLSurface addCeiling(FloatArray vertices, int sectnum) {
        if (Engine.sector[sectnum].isParallaxCeiling()) {
            return this.setNull(this.ceilings, sectnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Ceiling, sectnum, vertices);
        if (info == null) {
            return this.setNull(this.ceilings, sectnum);
        }
        GLSurface surf = this.getSurface(this.ceilings, sectnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Ceiling;
            surf.vis_ptr = sectnum;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private void updateVertices(int targetOffset, float[] source, int sourceOffset, int count) {
        if (this.lastLimit < targetOffset * 4) {
            System.err.println("Oh shit  " + this.lastLimit + " " + targetOffset * 4);
            this.checkValidate();
            try {
                this.mesh.bind(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastLimit = this.meshBuffer.limit() * 4;
        }
        this.mesh.updateVertices(targetOffset, source, sourceOffset, count);
    }

    public GLSurface getWall(int wallnum, int sectnum) {
        int hash = this.getWallHash(sectnum, wallnum);
        if (this.wallhash[wallnum] != hash) {
            this.wallhash[wallnum] = hash;
            this.tess.setSector(sectnum, false);
            this.vertices.clear();
            GLSurface surf = this.addMiddle(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addUpper(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addLower(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addMaskedWall(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addParallaxCeiling(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addParallaxFloor(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.checkValidate();
        }
        return this.walls[wallnum];
    }

    protected void checkValidate() {
        if (this.validateMesh) {
            FloatBuffer buffer = this.meshBuffer;
            int newLimit = (this.meshOffset + this.tess.getMaxVertices()) * this.tess.getVertexSize();
            if (newLimit > buffer.capacity()) {
                newLimit = buffer.capacity();
            }
            buffer.limit(newLimit);
            this.validateMesh = false;
        }
    }

    public GLSurface getUpper(int wallnum, int sectnum) {
        return this.upper_walls[wallnum];
    }

    public GLSurface getLower(int wallnum, int sectnum) {
        return this.lower_walls[wallnum];
    }

    public GLSurface getMaskedWall(int wallnum) {
        return this.maskwalls[wallnum];
    }

    public GLSurface getParallaxFloor(int wallnum) {
        return this.lower_skies[wallnum];
    }

    public GLSurface getParallaxCeiling(int wallnum) {
        return this.upper_skies[wallnum];
    }

    public GLSurface getQuad() {
        return this.quad;
    }

    public GLSurface getFloor(int sectnum) {
        int hash = this.getFloorHash(sectnum);
        GLSurface surf = this.floors[sectnum];
        if (this.floorhash[sectnum] != hash) {
            this.floorhash[sectnum] = hash;
            this.tess.setSector(sectnum, true);
            this.vertices.clear();
            surf = this.addFloor(this.vertices, sectnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.checkValidate();
        }
        return surf;
    }

    public GLSurface getCeiling(int sectnum) {
        int hash = this.getCeilingHash(sectnum);
        GLSurface surf = this.ceilings[sectnum];
        if (this.ceilinghash[sectnum] != hash) {
            this.ceilinghash[sectnum] = hash;
            this.tess.setSector(sectnum, true);
            this.vertices.clear();
            surf = this.addCeiling(this.vertices, sectnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.checkValidate();
        }
        return surf;
    }

    private int getCeilingHash(int sectnum) {
        int hash = 1;
        int prime = 31;
        SECTOR sec = Engine.sector[sectnum];
        int startwall = sec.wallptr;
        int endwall = sec.wallnum + startwall;
        for (int z = startwall; z < endwall; ++z) {
            WALL wal = Engine.wall[z];
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.x);
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.y);
        }
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.ceilingz);
        hash = 31 * hash + sec.ceilingstat;
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.ceilingheinum);
        hash = 31 * hash + sec.ceilingpicnum;
        hash = 31 * hash + sec.ceilingxpanning;
        hash = 31 * hash + sec.ceilingypanning;
        return hash;
    }

    private int getFloorHash(int sectnum) {
        int hash = 1;
        int prime = 31;
        SECTOR sec = Engine.sector[sectnum];
        int startwall = sec.wallptr;
        int endwall = sec.wallnum + startwall;
        for (int z = startwall; z < endwall; ++z) {
            WALL wal = Engine.wall[z];
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.x);
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.y);
        }
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.floorz);
        hash = 31 * hash + sec.floorstat;
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.floorheinum);
        hash = 31 * hash + sec.floorpicnum;
        hash = 31 * hash + sec.floorxpanning;
        hash = 31 * hash + sec.floorypanning;
        return hash;
    }

    private int getWallHash(int sectnum, int z) {
        SECTOR sec = Engine.sector[sectnum];
        WALL wal = Engine.wall[z];
        int hash = 1;
        int prime = 31;
        hash = 31 * hash + NumberUtils.floatToIntBits(wal.x);
        hash = 31 * hash + NumberUtils.floatToIntBits(wal.y);
        hash = 31 * hash + NumberUtils.floatToIntBits(Engine.wall[wal.point2].x);
        hash = 31 * hash + NumberUtils.floatToIntBits(Engine.wall[wal.point2].y);
        hash = 31 * hash + wal.cstat;
        hash = 31 * hash + wal.xpanning;
        hash = 31 * hash + wal.ypanning;
        hash = 31 * hash + wal.xrepeat;
        hash = 31 * hash + wal.yrepeat;
        hash = 31 * hash + wal.picnum;
        hash = 31 * hash + wal.overpicnum;
        if (wal.isSwapped() && wal.nextwall != -1) {
            WALL swal = Engine.wall[wal.nextwall];
            hash = 31 * hash + swal.cstat;
            hash = 31 * hash + swal.xpanning;
            hash = 31 * hash + swal.ypanning;
            hash = 31 * hash + swal.xrepeat;
            hash = 31 * hash + swal.yrepeat;
            hash = 31 * hash + swal.picnum;
        }
        if (((sec.ceilingstat | sec.floorstat) & 2) != 0) {
            hash = 31 * hash + NumberUtils.floatToIntBits(Engine.wall[sec.wallptr].x);
            hash = 31 * hash + NumberUtils.floatToIntBits(Engine.wall[sec.wallptr].y);
        }
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.floorz);
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.floorheinum);
        hash = 31 * hash + (sec.isSlopedFloor() ? 1 : 0);
        hash = 31 * hash + (sec.isParallaxFloor() ? 1 : 0);
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.ceilingz);
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.ceilingheinum);
        hash = 31 * hash + (sec.isSlopedCeiling() ? 1 : 0);
        hash = 31 * hash + (sec.isParallaxCeiling() ? 1 : 0);
        if (wal.nextsector != -1) {
            SECTOR nsec = Engine.sector[wal.nextsector];
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.floorz);
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.floorheinum);
            hash = 31 * hash + (nsec.isSlopedFloor() ? 1 : 0);
            hash = 31 * hash + (nsec.isParallaxFloor() ? 1 : 0);
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.ceilingz);
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.ceilingheinum);
            hash = 31 * hash + (nsec.isSlopedCeiling() ? 1 : 0);
            hash = 31 * hash + (nsec.isParallaxCeiling() ? 1 : 0);
            if (((nsec.ceilingstat | nsec.floorstat) & 2) != 0) {
                hash = 31 * hash + NumberUtils.floatToIntBits(Engine.wall[nsec.wallptr].x);
                hash = 31 * hash + NumberUtils.floatToIntBits(Engine.wall[nsec.wallptr].y);
            }
        }
        return hash;
    }

    private GLSurface setNull(GLSurface[] array, int num) {
        GLSurface src = array[num];
        if (src != null) {
            src.count = 0;
        }
        return null;
    }

    private GLSurface getSurface(GLSurface[] array, int num, int count, int limit) {
        if (array[num] == null) {
            if (count == 0) {
                return null;
            }
            GLSurface surf = new GLSurface(this.meshOffset);
            surf.count = count;
            surf.limit = limit;
            this.meshOffset += surf.limit;
            array[num] = surf;
            if (this.lastSurf != null) {
                this.lastSurf.next = surf;
            }
            this.lastSurf = surf;
            this.validateMesh = true;
            return surf;
        }
        if (this.mesh == null) {
            Console.Println("Error: Unexpected behavior in mesh initialization, perhaps the map is corrupt", Console.OSDTEXT_RED);
            this.meshOffset += limit;
            return null;
        }
        if (array[num].limit < count) {
            int shift = count - array[num].limit;
            this.shiftFrom(array[num].next, shift);
            this.meshOffset += shift;
            array[num].limit = count;
        }
        array[num].count = count;
        return array[num];
    }

    public void nextpage() {
        this.tess.setSector(-1, false);
        if (this.meshBuffer != null) {
            this.lastLimit = this.meshBuffer.limit() * 4;
        }
    }

    private void shiftFrom(GLSurface surf, int shift) {
        if (surf == null) {
            return;
        }
        int size = this.meshOffset;
        int newSize = size - surf.offset;
        float[] newItems = new float[newSize * this.tess.getVertexSize()];
        this.mesh.getVertices(surf.offset * this.tess.getVertexSize(), newItems);
        surf.offset += shift;
        this.validateMesh = true;
        this.updateVertices(surf.offset * this.tess.getVertexSize(), newItems, 0, newItems.length);
        surf = surf.next;
        while (surf != null) {
            surf.offset += shift;
            surf = surf.next;
        }
    }

    public Vector3[] getPositions(int offset, int count) {
        Vector3[] out = new Vector3[count];
        FloatBuffer buffer = this.meshBuffer;
        for (int i = 0; i < count; ++i) {
            int offs = (offset + i) * this.tess.getVertexSize();
            out[i] = new Vector3(buffer.get(offs++), buffer.get(offs++), buffer.get(offs++));
        }
        return out;
    }

    public boolean isInvalid() {
        return this.validateMesh;
    }

    public void dispose() {
        this.mesh.dispose();
        this.meshBuffer = null;
        this.validateMesh = true;
        System.gc();
    }

    public class GLSurface {
        public int offset;
        public int count;
        public int limit;
        public int visflag = 0;
        public int primitiveType = 4;
        public int picnum;
        private Object ptr;
        private Tesselator.Type type;
        private int vis_ptr;
        protected GLSurface next;

        public GLSurface(int offset) {
            this.offset = offset;
        }

        public int getVisibility() {
            return Engine.sector[this.vis_ptr].visibility;
        }

        public void render(ShaderProgram shader) {
            WorldMesh.this.mesh.render(shader, this.primitiveType, this.offset, this.count);
        }

        public int getMethod() {
            switch (this.type) {
                case Floor: {
                    return ((SECTOR)this.ptr).floorstat >> 7 & 3;
                }
                case Ceiling: {
                    return ((SECTOR)this.ptr).ceilingstat >> 7 & 3;
                }
                case Wall: {
                    int method = 0;
                    WALL wal = (WALL)this.ptr;
                    if (wal.isMasked() && this.visflag == 4) {
                        method = 1;
                        if (!wal.isOneWay() && wal.isTransparent()) {
                            method = !wal.isTransparent2() ? 2 : 3;
                        }
                    }
                    return method;
                }
            }
            return 0;
        }

        public short getPal() {
            switch (this.type) {
                case Floor: {
                    return ((SECTOR)this.ptr).floorpal;
                }
                case Ceiling: {
                    return ((SECTOR)this.ptr).ceilingpal;
                }
                case Wall: {
                    return ((WALL)this.ptr).pal;
                }
            }
            return 0;
        }

        public byte getShade() {
            switch (this.type) {
                case Floor: {
                    return ((SECTOR)this.ptr).floorshade;
                }
                case Ceiling: {
                    return ((SECTOR)this.ptr).ceilingshade;
                }
                case Wall: {
                    return ((WALL)this.ptr).shade;
                }
            }
            return 0;
        }
    }

    public static enum Heinum {
        MaxWall,
        Max,
        Lower,
        Upper,
        Portal,
        SkyLower,
        SkyUpper;

    }
}

