/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Builder;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Triangle;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;

public abstract class MD2ModelGL10
extends MDModel {
    private final ShortBuffer indices;
    private final FloatBuffer vertices;
    private final FloatBuffer uv;
    private final MD2Frame[] frames;
    private final MD2Triangle[] tris;

    protected abstract int bindSkin(int var1, int var2);

    public MD2ModelGL10(MD2Info md) {
        super(md);
        int j;
        int i;
        MD2Builder builder = new MD2Builder(md);
        this.frames = builder.frames;
        this.tris = builder.triangles;
        int numTriangles = builder.header.numTriangles;
        this.indices = BufferUtils.newShortBuffer(numTriangles * 3);
        for (i = 0; i < numTriangles; ++i) {
            for (j = 0; j < 3; ++j) {
                this.indices.put((short)(i * 3 + j));
            }
        }
        this.indices.flip();
        this.vertices = BufferUtils.newFloatBuffer(numTriangles * 3 * 3);
        this.uv = BufferUtils.newFloatBuffer(numTriangles * 3 * 2);
        for (i = 0; i < numTriangles; ++i) {
            for (j = 0; j < 3; ++j) {
                short idx = builder.triangles[i].texCoords[j];
                this.uv.put(builder.texCoords[idx][0]);
                this.uv.put(builder.texCoords[idx][1]);
            }
        }
        this.uv.flip();
    }

    @Override
    public boolean render(int pal, int pad1, int skinnum, int pad2, float pad3) {
        boolean isRendered = false;
        int texunits = this.bindSkin(pal, skinnum);
        if (texunits != -1) {
            MD2Frame cframe = this.frames[this.cframe];
            MD2Frame nframe = this.frames[this.nframe];
            this.vertices.clear();
            for (int i = 0; i < this.tris.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    short idx = this.tris[i].vertices[j];
                    float x = cframe.vertices[idx][0] * this.cScale.x + nframe.vertices[idx][0] * this.nScale.x;
                    float y = cframe.vertices[idx][1] * this.cScale.y + nframe.vertices[idx][1] * this.nScale.y;
                    float z = cframe.vertices[idx][2] * this.cScale.z + nframe.vertices[idx][2] * this.nScale.z;
                    this.vertices.put(x);
                    this.vertices.put(z);
                    this.vertices.put(y);
                }
            }
            this.vertices.flip();
            int l = 33984;
            do {
                BuildGdx.gl.glClientActiveTexture(l++);
                BuildGdx.gl.glEnableClientState(32888);
                BuildGdx.gl.glTexCoordPointer(2, 5126, 0, this.uv);
            } while (l <= texunits);
            BuildGdx.gl.glEnableClientState(32884);
            BuildGdx.gl.glVertexPointer(3, 5126, 0, this.vertices);
            BuildGdx.gl.glDrawElements(4, 0, 5123, this.indices);
            while (texunits > 33984) {
                BuildGdx.gl.glMatrixMode(5890);
                BuildGdx.gl.glLoadIdentity();
                BuildGdx.gl.glMatrixMode(5888);
                BuildGdx.gl.glTexEnvf(8960, 34163, 1.0f);
                BuildGdx.gl.glDisable(3553);
                BuildGdx.gl.glDisableClientState(32888);
                BuildGdx.gl.glClientActiveTexture(texunits - 1);
                BuildGdx.gl.glActiveTexture(--texunits);
            }
            BuildGdx.gl.glDisableClientState(32884);
            isRendered = true;
        }
        if (this.usesalpha) {
            BuildGdx.gl.glDisable(3008);
        }
        BuildGdx.gl.glDisable(2884);
        BuildGdx.gl.glLoadIdentity();
        return isRendered;
    }

    @Override
    public void loadSkins(int pal, int skinnum) {
        this.getSkin(pal, skinnum, 0);
    }

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Md2;
    }

    @Override
    public ShaderProgram getShader() {
        return null;
    }
}

