/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD3;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import java.util.HashMap;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Header;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Shader;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Surface;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Vertice;

public class MD3Builder {
    public MD3Header head;
    public MD3Frame[] frames;
    public HashMap<String, Matrix4>[] tags;
    public MD3Surface[] surfaces;

    public MD3Builder(MD3Info md) {
        Resource bb = BuildGdx.cache.open(md.getFilename(), 0);
        this.head = md.header;
        MD3Frame[] frames = this.loadFrames(this.head, bb);
        HashMap<String, Matrix4>[] tags = this.loadTags(this.head, bb);
        MD3Surface[] surfaces = this.loadSurfaces(this.head, bb);
        this.frames = frames;
        this.tags = tags;
        this.surfaces = surfaces;
        bb.close();
    }

    protected String readString(Resource bb, int len) {
        byte[] buf = new byte[len];
        bb.read(buf);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            return new String(buf, 0, i);
        }
        return new String(buf);
    }

    private MD3Frame[] loadFrames(MD3Header header, Resource bb) {
        bb.seek(header.offsetFrames, Resource.Whence.Set);
        MD3Frame[] out = new MD3Frame[header.numFrames];
        for (int i = 0; i < header.numFrames; ++i) {
            MD3Frame frame = new MD3Frame();
            frame.min = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
            frame.max = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
            frame.origin = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
            frame.radius = bb.readFloat();
            frame.name = this.readString(bb, 16);
            out[i] = frame;
        }
        return out;
    }

    private HashMap<String, Matrix4>[] loadTags(MD3Header header, Resource bb) {
        bb.seek(header.offsetTags, Resource.Whence.Set);
        HashMap[] out = new HashMap[header.numFrames];
        for (int k = 0; k < header.numFrames; ++k) {
            out[k] = new HashMap();
            for (int i = 0; i < header.numTags; ++i) {
                String tagName = this.readString(bb, 64);
                Vector3 pos = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Vector3 xAxis = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Vector3 yAxis = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Vector3 zAxis = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Matrix4 mat = new Matrix4();
                mat.set(xAxis, yAxis, zAxis, pos);
                out[k].put(tagName, mat);
            }
        }
        return out;
    }

    private MD3Surface[] loadSurfaces(MD3Header header, Resource bb) {
        int offsetSurfaces = header.offsetSurfaces;
        MD3Surface[] out = new MD3Surface[header.numSurfaces];
        for (int i = 0; i < header.numSurfaces; ++i) {
            bb.seek(offsetSurfaces, Resource.Whence.Set);
            MD3Surface surf = new MD3Surface();
            surf.id = bb.readInt();
            surf.nam = this.readString(bb, 64);
            surf.flags = bb.readInt();
            surf.numframes = bb.readInt();
            surf.numshaders = bb.readInt();
            surf.numverts = bb.readInt();
            surf.numtris = bb.readInt();
            surf.ofstris = bb.readInt();
            surf.ofsshaders = bb.readInt();
            surf.ofsuv = bb.readInt();
            surf.ofsxyzn = bb.readInt();
            surf.ofsend = bb.readInt();
            surf.tris = this.loadTriangles(surf, offsetSurfaces, bb);
            surf.shaders = this.loadShaders(surf, offsetSurfaces, bb);
            surf.uv = this.loadUVs(surf, offsetSurfaces, bb);
            surf.xyzn = this.loadVertices(surf, offsetSurfaces, bb);
            offsetSurfaces += surf.ofsend;
            out[i] = surf;
        }
        return out;
    }

    private int[][] loadTriangles(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofstris, Resource.Whence.Set);
        int[][] out = new int[surf.numtris][3];
        for (int i = 0; i < surf.numtris; ++i) {
            out[i][0] = bb.readInt();
            out[i][1] = bb.readInt();
            out[i][2] = bb.readInt();
        }
        return out;
    }

    private FloatBuffer loadUVs(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofsuv, Resource.Whence.Set);
        FloatBuffer out = BufferUtils.newFloatBuffer(2 * surf.numverts);
        for (int i = 0; i < surf.numverts; ++i) {
            out.put(bb.readFloat().floatValue());
            out.put(bb.readFloat().floatValue());
        }
        out.flip();
        return out;
    }

    private MD3Vertice[][] loadVertices(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofsxyzn, Resource.Whence.Set);
        MD3Vertice[][] out = new MD3Vertice[surf.numframes][surf.numverts];
        for (int i = 0; i < surf.numframes; ++i) {
            for (int j = 0; j < surf.numverts; ++j) {
                MD3Vertice xyzn = new MD3Vertice();
                xyzn.x = bb.readShort();
                xyzn.y = bb.readShort();
                xyzn.z = bb.readShort();
                xyzn.nlat = (short)(bb.readByte() & 0xFF);
                xyzn.nlng = (short)(bb.readByte() & 0xFF);
                out[i][j] = xyzn;
            }
        }
        return out;
    }

    private MD3Shader[] loadShaders(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofsshaders, Resource.Whence.Set);
        MD3Shader[] out = new MD3Shader[surf.numshaders];
        for (int i = 0; i < surf.numshaders; ++i) {
            MD3Shader shader = new MD3Shader();
            shader.name = this.readString(bb, 64);
            shader.index = bb.readInt();
            out[i] = shader;
        }
        return out;
    }
}

