/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD3;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.NumberUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Builder;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Surface;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Vertice;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;

public abstract class MD3ModelGL20
extends MDModel {
    private final Mesh mesh;
    private final MD3Surface[] surfaces;
    private final int numSurfaces;

    public MD3ModelGL20(MD3Info md) {
        super(md);
        MD3Builder builder = new MD3Builder(md);
        this.surfaces = builder.surfaces;
        this.numSurfaces = builder.head.numSurfaces;
        int maxtris = 0;
        int maxverts = 0;
        for (int i = 0; i < this.numSurfaces; ++i) {
            MD3Surface surf = this.surfaces[i];
            maxtris = Math.max(maxtris, surf.numtris);
            maxverts = Math.max(maxverts, surf.numverts);
        }
        this.mesh = new Mesh(false, maxverts * 6, maxtris * 3, VertexAttribute.Position(), VertexAttribute.ColorPacked(), VertexAttribute.TexCoords(0));
    }

    protected abstract int bindSkin(int var1, int var2, int var3);

    @Override
    public boolean render(int pal, int pad1, int skinnum, int pad2, float pad3) {
        float f = this.interpol;
        float g = 1.0f - f;
        boolean isRendered = false;
        for (int surfi = 0; surfi < this.numSurfaces; ++surfi) {
            int i;
            MD3Surface s = this.surfaces[surfi];
            int texunits = this.bindSkin(pal, skinnum, surfi);
            if (texunits == -1) break;
            FloatBuffer vertices = this.mesh.getVerticesBuffer();
            ShortBuffer indices = this.mesh.getIndicesBuffer();
            s.uv.rewind();
            vertices.clear();
            for (i = 0; i < s.numverts; ++i) {
                MD3Vertice v0 = s.xyzn[this.cframe][i];
                MD3Vertice v1 = s.xyzn[this.nframe][i];
                vertices.put((float)v0.x * g + (float)v1.x * f);
                vertices.put((float)v0.z * g + (float)v1.z * f);
                vertices.put((float)v0.y * g + (float)v1.y * f);
                vertices.put(NumberUtils.intToFloatColor(-1));
                vertices.put(s.uv.get());
                vertices.put(s.uv.get());
            }
            vertices.flip();
            indices.clear();
            for (i = s.numtris - 1; i >= 0; --i) {
                for (int j = 0; j < 3; ++j) {
                    indices.put((short)s.tris[i][j]);
                }
            }
            indices.flip();
            this.mesh.render(this.getShader(), 4);
            isRendered = true;
        }
        return isRendered;
    }

    @Override
    public void loadSkins(int pal, int skinnum) {
        for (int surfi = 0; surfi < this.numSurfaces; ++surfi) {
            this.getSkin(pal, skinnum, surfi);
        }
    }

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Md3;
    }
}

