/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.DefaultMapSettings;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public abstract class OrphoRenderer {
    protected final Engine engine;
    protected IOverheadMapSettings mapSettings;

    public OrphoRenderer(Engine engine) {
        this(engine, null);
    }

    public OrphoRenderer(Engine engine, IOverheadMapSettings mapSettings) {
        this.engine = engine;
        this.mapSettings = mapSettings != null ? mapSettings : new DefaultMapSettings();
    }

    public abstract void init();

    public abstract void uninit();

    public abstract void printext(TileFont var1, int var2, int var3, char[] var4, int var5, int var6, Renderer.Transparent var7, float var8);

    public abstract void printext(int var1, int var2, int var3, int var4, char[] var5, int var6, float var7);

    public abstract void drawline256(int var1, int var2, int var3, int var4, int var5);

    public abstract void rotatesprite(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    public abstract void nextpage();

    public abstract void drawmapview(int var1, int var2, int var3, int var4);

    protected int getclipmask(int a, int b, int c, int d) {
        int bA = a < 0 ? 1 : 0;
        int bB = b < 0 ? 1 : 0;
        int bC = c < 0 ? 1 : 0;
        int bD = d < 0 ? 1 : 0;
        d = bA * 8 + bB * 4 + bC * 2 + bD;
        return d << 4 ^ 0xF0 | d;
    }

    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        int k;
        int y1;
        int x1;
        int oy;
        int ox;
        WALL wal;
        int j;
        int endwall;
        int startwall;
        int i;
        int x2 = 0;
        int y2 = 0;
        int xvect = Engine.sintable[-cang & 0x7FF] * czoom;
        int yvect = Engine.sintable[1536 - cang & 0x7FF] * czoom;
        int xvect2 = Pragmas.mulscale(xvect, Engine.yxaspect, 16);
        int yvect2 = Pragmas.mulscale(yvect, Engine.yxaspect, 16);
        for (i = 0; i < Engine.numsectors; ++i) {
            if (!this.mapSettings.isFullMap() && (Engine.show2dsector[i >> 3] & 1 << (i & 7)) == 0 || !Gameutils.isValidSector(i)) continue;
            SECTOR sec = Engine.sector[i];
            if (!Gameutils.isValidWall(sec.wallptr) || sec.wallnum < 3) continue;
            startwall = sec.wallptr;
            endwall = sec.wallptr + sec.wallnum;
            if (startwall < 0 || endwall < 0) continue;
            for (j = startwall; j < endwall; ++j) {
                if (!Gameutils.isValidWall(j) || !Gameutils.isValidWall(Engine.wall[j].point2)) continue;
                wal = Engine.wall[j];
                if (!this.mapSettings.isShowRedWalls() || !Gameutils.isValidWall(wal.nextwall) || !Gameutils.isValidSector(wal.nextsector) || !this.mapSettings.isWallVisible(j, i)) continue;
                ox = this.mapSettings.getWallX(j) - cposx;
                oy = this.mapSettings.getWallY(j) - cposy;
                x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                ox = this.mapSettings.getWallX(wal.point2) - cposx;
                oy = this.mapSettings.getWallY(wal.point2) - cposy;
                x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                int col = this.mapSettings.getWallColor(j, i);
                if (col < 0) continue;
                this.drawline256(x1, y1, x2, y2, col);
            }
        }
        if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Lines)) {
            for (i = 0; i < Engine.numsectors; ++i) {
                if (!this.mapSettings.isFullMap() && (Engine.show2dsector[i >> 3] & 1 << (i & 7)) == 0) continue;
                j = Engine.headspritesect[i];
                while (j >= 0) {
                    SPRITE spr = Engine.sprite[j];
                    if ((spr.cstat & 0x8000) == 0 && spr.xrepeat != 0 && spr.yrepeat != 0 && this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Lines, j)) {
                        switch (spr.cstat & 0x30) {
                            case 0: {
                                if (!this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Lines) || (Engine.gotsector[i >> 3] & 1 << (i & 7)) <= 0 || czoom <= 96) break;
                                ox = this.mapSettings.getSpriteX(j) - cposx;
                                oy = this.mapSettings.getSpriteY(j) - cposy;
                                x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                int daang = spr.ang - cang & 0x7FF;
                                this.rotatesprite((x1 << 4) + (Engine.xdim << 15), (y1 << 4) + (Engine.ydim << 15), Pragmas.mulscale(czoom * spr.yrepeat, Engine.yxaspect, 16), daang, spr.picnum, spr.shade, spr.pal, (spr.cstat & 2) >> 1, Engine.windowx1, Engine.windowy1, Engine.windowx2, Engine.windowy2);
                                break;
                            }
                            case 16: {
                                Tile pic = this.engine.getTile(spr.picnum);
                                x1 = this.mapSettings.getSpriteX(j);
                                y1 = this.mapSettings.getSpriteY(j);
                                byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                                if ((spr.cstat & 4) > 0) {
                                    xoff = -xoff;
                                }
                                k = spr.ang;
                                int l = spr.xrepeat;
                                int dax = Engine.sintable[k & 0x7FF] * l;
                                int day = Engine.sintable[k + 1536 & 0x7FF] * l;
                                l = pic.getWidth();
                                k = (l >> 1) + xoff;
                                x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                                y2 = (y1 -= Pragmas.mulscale(day, k, 16)) + Pragmas.mulscale(day, l, 16);
                                ox = x1 - cposx;
                                oy = y1 - cposy;
                                x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                ox = x2 - cposx;
                                oy = y2 - cposy;
                                x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                int col = this.mapSettings.getSpriteColor(j);
                                if (col < 0) break;
                                this.drawline256(x1 + (Engine.xdim << 11), y1 + (Engine.ydim << 11), x2 + (Engine.xdim << 11), y2 + (Engine.ydim << 11), col);
                                break;
                            }
                            case 32: {
                                Tile pic = this.engine.getTile(spr.picnum);
                                byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                                byte yoff = (byte)(pic.getOffsetY() + spr.yoffset);
                                if ((spr.cstat & 4) > 0) {
                                    xoff = -xoff;
                                }
                                if ((spr.cstat & 8) > 0) {
                                    yoff = -yoff;
                                }
                                k = spr.ang;
                                short cosang = Engine.sintable[k + 512 & 0x7FF];
                                short sinang = Engine.sintable[k & 0x7FF];
                                int xspan = pic.getWidth();
                                short xrepeat = spr.xrepeat;
                                int yspan = pic.getHeight();
                                short yrepeat = spr.yrepeat;
                                int dax = ((xspan >> 1) + xoff) * xrepeat;
                                int day = ((yspan >> 1) + yoff) * yrepeat;
                                x1 = this.mapSettings.getSpriteX(j) + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                                y1 = this.mapSettings.getSpriteY(j) + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                                int l = xspan * xrepeat;
                                x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                                y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                                l = yspan * yrepeat;
                                k = -Pragmas.mulscale(cosang, l, 16);
                                int x3 = x2 + k;
                                int x4 = x1 + k;
                                k = -Pragmas.mulscale(sinang, l, 16);
                                int y3 = y2 + k;
                                int y4 = y1 + k;
                                ox = x1 - cposx;
                                oy = y1 - cposy;
                                x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                ox = x2 - cposx;
                                oy = y2 - cposy;
                                x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                ox = x3 - cposx;
                                oy = y3 - cposy;
                                x3 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y3 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                ox = x4 - cposx;
                                oy = y4 - cposy;
                                x4 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16);
                                y4 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16);
                                int col = this.mapSettings.getSpriteColor(j);
                                if (col < 0) break;
                                this.drawline256(x1 + (Engine.xdim << 11), y1 + (Engine.ydim << 11), x2 + (Engine.xdim << 11), y2 + (Engine.ydim << 11), col);
                                this.drawline256(x2 + (Engine.xdim << 11), y2 + (Engine.ydim << 11), x3 + (Engine.xdim << 11), y3 + (Engine.ydim << 11), col);
                                this.drawline256(x3 + (Engine.xdim << 11), y3 + (Engine.ydim << 11), x4 + (Engine.xdim << 11), y4 + (Engine.ydim << 11), col);
                                this.drawline256(x4 + (Engine.xdim << 11), y4 + (Engine.ydim << 11), x1 + (Engine.xdim << 11), y1 + (Engine.ydim << 11), col);
                            }
                        }
                    }
                    j = Engine.nextspritesect[j];
                }
            }
        }
        for (i = 0; i < Engine.numsectors; ++i) {
            if (!this.mapSettings.isFullMap() && (Engine.show2dsector[i >> 3] & 1 << (i & 7)) == 0 || !Gameutils.isValidSector(i)) continue;
            startwall = Engine.sector[i].wallptr;
            endwall = Engine.sector[i].wallptr + Engine.sector[i].wallnum;
            if (startwall < 0 || endwall < 0) continue;
            k = -1;
            for (j = startwall; j < endwall; ++j) {
                Tile pic;
                wal = Engine.wall[j];
                if (!Gameutils.isValidWall(j) || !Gameutils.isValidWall(Engine.wall[j].point2) || wal.nextwall >= 0 || !(pic = this.engine.getTile(wal.picnum)).hasSize()) continue;
                if (j == k) {
                    x1 = x2;
                    y1 = y2;
                } else {
                    ox = this.mapSettings.getWallX(j) - cposx;
                    oy = this.mapSettings.getWallY(j) - cposy;
                    x1 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y1 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                }
                k = wal.point2;
                if (Engine.wall[k] == null) continue;
                ox = this.mapSettings.getWallX(k) - cposx;
                oy = this.mapSettings.getWallY(k) - cposy;
                x2 = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                y2 = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                int col = this.mapSettings.getWallColor(j, i);
                if (col < 0) continue;
                this.drawline256(x1, y1, x2, y2, col);
            }
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            int spr = this.mapSettings.getPlayerSprite(i);
            if (spr != -1 && Gameutils.isValidSector(Engine.sprite[spr].sectnum)) {
                SPRITE pPlayer = Engine.sprite[spr];
                ox = this.mapSettings.getSpriteX(spr) - cposx;
                oy = this.mapSettings.getSpriteY(spr) - cposy;
                int dx = Pragmas.mulscale(ox, xvect, 16) - Pragmas.mulscale(oy, yvect, 16);
                int dy = Pragmas.mulscale(oy, xvect2, 16) + Pragmas.mulscale(ox, yvect2, 16);
                int dang = pPlayer.ang - cang & 0x7FF;
                int viewindex = this.mapSettings.getViewPlayer();
                if (i == viewindex && !this.mapSettings.isScrollMode()) {
                    dx = 0;
                    dy = viewindex ^ i;
                    dang = 0;
                }
                if (i == viewindex || this.mapSettings.isShowAllPlayers()) {
                    int picnum = this.mapSettings.getPlayerPicnum(i);
                    if (picnum == -1) {
                        x2 = 0;
                        y2 = -(this.mapSettings.getPlayerZoom(i, czoom) << 1);
                        int x3 = Pragmas.mulscale(x2, Engine.yxaspect, 16);
                        int y3 = Pragmas.mulscale(y2, Engine.yxaspect, 16);
                        int col = this.mapSettings.getSpriteColor(spr);
                        if (col >= 0) {
                            this.drawline256(dx - x2 + (Engine.xdim << 11), dy - y3 + (Engine.ydim << 11), dx + x2 + (Engine.xdim << 11), dy + y3 + (Engine.ydim << 11), col);
                            this.drawline256(dx - y2 + (Engine.xdim << 11), dy + x3 + (Engine.ydim << 11), dx + x2 + (Engine.xdim << 11), dy + y3 + (Engine.ydim << 11), col);
                            this.drawline256(dx + y2 + (Engine.xdim << 11), dy - x3 + (Engine.ydim << 11), dx + x2 + (Engine.xdim << 11), dy + y3 + (Engine.ydim << 11), col);
                        }
                    } else {
                        int nZoom = this.mapSettings.getPlayerZoom(i, czoom);
                        int sx = (dx << 4) + (Engine.xdim << 15);
                        int sy = (dy << 4) + (Engine.ydim << 15);
                        this.rotatesprite(sx, sy, nZoom, (short)dang, this.mapSettings.getPlayerPicnum(i), pPlayer.shade, pPlayer.pal, (pPlayer.cstat & 2) >> 1, Engine.windowx1, Engine.windowy1, Engine.windowx2, Engine.windowy2);
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }
}

