/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Polymost;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2ModelGL10;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3ModelGL10;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDSkinmap;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.ModelManager;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelGL10;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelSkin;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class PolymostModelManager
extends ModelManager {
    protected Polymost parent;

    public PolymostModelManager(Polymost parent) {
        this.parent = parent;
    }

    @Override
    public GLVoxel allocateVoxel(VoxelData vox, int voxmip, int flags) {
        return new VoxelGL10(vox, voxmip, flags, true){

            @Override
            public GLTile getSkin(int pal) {
                TileData.PixelFormat fmt = PolymostModelManager.this.parent.getTextureFormat();
                if (Engine.palookup[pal] == null || fmt == TileData.PixelFormat.Pal8) {
                    pal = 0;
                }
                if (this.texid[pal] == null) {
                    VoxelSkin dat = new VoxelSkin(fmt, this.skinData, pal);
                    GLTile dst = PolymostModelManager.this.parent.textureCache.newTile(dat, pal, false);
                    dst.unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
                    dst.unsafeSetAnisotropicFilter(1.0f, true);
                    this.texid[pal] = dst;
                }
                return this.texid[pal];
            }

            @Override
            public void setTextureParameters(GLTile tile, int pal, int shade, int visibility, float alpha) {
                if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
                    if (!PolymostModelManager.this.parent.getShader().isBinded()) {
                        PolymostModelManager.this.parent.getShader().begin();
                    }
                    PolymostModelManager.this.parent.getShader().setTextureParams(pal, shade);
                    PolymostModelManager.this.parent.getShader().setDrawLastIndex(true);
                    PolymostModelManager.this.parent.getShader().setTransparent(alpha);
                    PolymostModelManager.this.parent.getShader().setVisibility(visibility);
                }
            }
        };
    }

    @Override
    public GLModel allocateModel(ModelInfo modelInfo) {
        switch (modelInfo.getType()) {
            case Md3: {
                return new MD3ModelGL10((MD3Info)modelInfo){

                    @Override
                    protected GLTile loadTexture(String skinfile, int palnum) {
                        return PolymostModelManager.this.loadMDTexture(this, skinfile, palnum);
                    }

                    @Override
                    protected int bindSkin(int pal, int skinnum, int surfnum) {
                        return PolymostModelManager.this.bindMDSkin(this, pal, skinnum, surfnum);
                    }
                };
            }
            case Md2: {
                return new MD2ModelGL10((MD2Info)modelInfo){

                    @Override
                    protected int bindSkin(int pal, int skinnum) {
                        return PolymostModelManager.this.bindMDSkin(this, pal, skinnum, 0);
                    }

                    @Override
                    protected GLTile loadTexture(String skinfile, int palnum) {
                        return PolymostModelManager.this.loadMDTexture(this, skinfile, palnum);
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLTile loadMDTexture(MDModel m, String skinfile, int palnum) {
        GLTile texidx = this.findLoadedMultitexture(skinfile, palnum);
        if (texidx != null) {
            return texidx;
        }
        Resource res = BuildGdx.cache.open(skinfile, 0);
        if (res == null) {
            Console.Println("Skin " + skinfile + " not found.", Console.OSDTEXT_YELLOW);
            return null;
        }
        try {
            byte[] data = res.getBytes();
            Pixmap pix = new Pixmap(data, 0, data.length);
            texidx = this.parent.textureCache.newTile(new PixmapTileData(pix, true, 0), 0, true);
            if (palnum == 255 || palnum == 254) {
                texidx.setHighTile(new Hicreplctyp(palnum));
            }
            m.usesalpha = true;
        }
        catch (Exception e) {
            Console.Println("Couldn't load file: " + skinfile, Console.OSDTEXT_YELLOW);
            GLTile gLTile = null;
            return gLTile;
        }
        finally {
            res.close();
        }
        texidx.setupTextureWrap(Texture.TextureWrap.Repeat);
        return texidx;
    }

    protected int bindMDSkin(MDModel m, int pal, int skinnum, int surfnum) {
        int texunits = -1;
        GLTile texid = m.getSkin(pal, skinnum, surfnum);
        if (texid != null) {
            this.parent.bind(texid);
            texunits = 33984;
            if (Console.Geti("r_detailmapping") != 0 && (texid = m.getSkin(255, skinnum, surfnum)) != null) {
                if (!texid.isDetailTexture()) {
                    System.err.println("Wtf detail!");
                }
                BuildGdx.gl.glActiveTexture(++texunits);
                BuildGdx.gl.glEnable(3553);
                this.parent.bind(texid);
                this.parent.setupTextureDetail(texid);
                MDSkinmap sk = m.skinmap;
                while (sk != null) {
                    if (sk.palette == 255 && skinnum == sk.skinnum && surfnum == sk.surfnum) {
                        float f = sk.param;
                        BuildGdx.gl.glMatrixMode(5890);
                        BuildGdx.gl.glLoadIdentity();
                        BuildGdx.gl.glScalef(f, f, 1.0f);
                        BuildGdx.gl.glMatrixMode(5888);
                    }
                    sk = sk.next;
                }
            }
            if (Console.Geti("r_glowmapping") != 0 && (texid = m.getSkin(254, skinnum, surfnum)) != null) {
                if (!texid.isGlowTexture()) {
                    System.err.println("Wtf glow! " + surfnum);
                }
                BuildGdx.gl.glActiveTexture(++texunits);
                BuildGdx.gl.glEnable(3553);
                this.parent.bind(texid);
                this.parent.setupTextureGlow(texid);
            }
        }
        return texunits;
    }

    protected GLTile findLoadedMultitexture(String skinfile, int palnum) {
        if (palnum >= 252) {
            for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
                GLModel m = this.models[i];
                if (!(m instanceof MDModel)) continue;
                MDSkinmap sk = ((MDModel)m).skinmap;
                while (sk != null) {
                    if (sk.fn.equalsIgnoreCase(skinfile) && sk.texid != null) {
                        if (sk.palette != palnum) {
                            GLTile texidx = sk.texid.clone();
                            if (palnum == 255 || palnum == 254) {
                                texidx.setHighTile(new Hicreplctyp(palnum));
                                texidx.update(null, palnum, true);
                                return texidx;
                            }
                        }
                        return sk.texid;
                    }
                    sk = sk.next;
                }
            }
        }
        return null;
    }
}

