/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Software;

import java.nio.ByteBuffer;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.Software.A;
import ru.m210projects.Build.Render.Software.Ac;
import ru.m210projects.Build.Render.Software.PermFifo;
import ru.m210projects.Build.Render.Software.SoftwareOrpho;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public class Software
implements Renderer {
    public final int BITSOFPRECISION = 3;
    public static final int MAXVOXMIPS = 5;
    protected A a;
    protected Engine engine;
    protected DefScript defs;
    public int bytesperline;
    public int frameoffset;
    protected int guniqhudid;
    protected final int MAXPERMS = 512;
    protected PermFifo[] permfifo = new PermFifo[512];
    protected int permhead = 0;
    protected int permtail = 0;
    public short[] umost = new short[4096];
    public short[] dmost = new short[4096];
    public short[] uplc = new short[4096];
    public short[] dplc = new short[4096];
    public short[] startumost = new short[4096];
    public short[] startdmost = new short[4096];
    public int[] ylookup = new int[3073];
    public int[] lookups;
    public byte[][] bakframeplace = new byte[4][];
    public short[] bakxsiz = new short[4];
    public short[] bakysiz = new short[4];
    public int globaluclip;
    public int globaldclip;
    public int globalpisibility;
    public int globalhisibility;
    public int globalcisibility;
    public int globparaceilclip;
    public int globparaflorclip;
    protected short globalpicnum;
    protected short globalshiftval;
    public int globalorientation;
    public int globvis;
    public int globalyscale;
    public int globalxpanning;
    public int globalypanning;
    public int globalx1;
    public int globaly1;
    public int globalx2;
    public int globaly2;
    public int globalx;
    public int globaly;
    public int globalx3;
    public int globaly3;
    public int globalzd;
    public int globalzx;
    public int globalz;
    protected byte globalxshift;
    protected byte globalyshift;
    public byte[] globalbufplc;
    public int globalpalwritten;
    public int numscans;
    public int numhits;
    public int numbunches;
    protected final int MAXWALLSB = (Engine.MAXWALLS >> 2) + (Engine.MAXWALLS >> 3);
    protected final int MAXYSAVES = 4096 * Engine.MAXSPRITES >> 7;
    public int[] xb1 = new int[this.MAXWALLSB];
    public int[] yb1 = new int[this.MAXWALLSB];
    public int[] xb2 = new int[this.MAXWALLSB];
    public int[] yb2 = new int[this.MAXWALLSB];
    public int[] rx1 = new int[this.MAXWALLSB];
    public int[] ry1 = new int[this.MAXWALLSB];
    public int[] rx2 = new int[this.MAXWALLSB];
    public int[] ry2 = new int[this.MAXWALLSB];
    public int[] rxi = new int[8];
    public int[] ryi = new int[8];
    public int[] rzi = new int[8];
    public int[] rxi2 = new int[8];
    public int[] ryi2 = new int[8];
    public int[] rzi2 = new int[8];
    public int[] xsi = new int[8];
    public int[] ysi = new int[8];
    public int horizlookup2;
    public int horizycent;
    public short[] p2 = new short[this.MAXWALLSB];
    public short[] thesector = new short[this.MAXWALLSB];
    public short[] thewall = new short[this.MAXWALLSB];
    public short[] bunchfirst = new short[this.MAXWALLSB];
    public short[] bunchlast = new short[this.MAXWALLSB];
    public short[] radarang2 = new short[4096];
    public short[] uwall = new short[4096];
    public short[] dwall = new short[4096];
    public int[] swall = new int[4096];
    public int[] lwall = new int[4100];
    public int[] swplc = new int[4096];
    public int[] lplc = new int[4096];
    public int[] lastx = new int[3072];
    public int[] slopalookup = new int[16384];
    public int[] reciptable = new int[2048];
    public int xdimenrecip;
    public int[] smostwall = new int[this.MAXWALLSB];
    public int smostwallcnt = -1;
    public int smostcnt;
    public short[] smost = new short[this.MAXYSAVES];
    public int[] smoststart = new int[this.MAXWALLSB];
    public byte[] smostwalltype = new byte[this.MAXWALLSB];
    public int[] maskwall = new int[this.MAXWALLSB];
    public int maskwallcnt;
    private final int[] spritesx = new int[1024];
    private final int[] spritesy = new int[1025];
    private final int[] spritesz = new int[1024];
    private final SPRITE[] tspriteptr = new SPRITE[1025];
    public short[] sectorborder = new short[256];
    public short sectorbordercnt;
    public int mirrorsx1;
    public int mirrorsy1;
    public int mirrorsx2;
    public int mirrorsy2;
    public byte[] tempbuf = new byte[Engine.MAXWALLS];
    protected int oxyaspect;
    protected int oxdimen;
    protected int oviewingrange;
    private final int[] zofslope = new int[2];
    private final int MAXXSIZ = 256;
    private final int[] ggxinc = new int[257];
    private final int[] ggyinc = new int[257];
    protected int[] lowrecip = new int[1024];
    protected int nytooclose;
    protected int nytoofar;
    protected int[] distrecip = new int[65536];
    public boolean novoxmips = false;
    public boolean isInited = false;
    protected SoftwareOrpho ortho;
    private final int[] cz = new int[5];
    private final int[] fz = new int[5];
    private ByteBuffer indexbuffer;
    private ByteBuffer rgbbuffer;

    public Software(Engine engine, IOverheadMapSettings settings) {
        this.engine = engine;
        this.ortho = this.allocOrphoRenderer(settings);
    }

    @Override
    public void init() {
        if (Engine.xdim == 0 && Engine.ydim == 0) {
            return;
        }
        try {
            int i;
            if (BuildGdx.graphics.getFrameType() != BuildFrame.FrameType.Canvas) {
                BuildGdx.app.setFrame(BuildFrame.FrameType.Canvas);
            }
            this.bytesperline = Engine.xdim;
            int j = Engine.ydim * 4 * 4;
            this.lookups = new int[j << 1];
            this.horizlookup2 = j;
            this.horizycent = Engine.ydim * 4 >> 1;
            this.oviewingrange = -1;
            this.oxdimen = -1;
            this.oxyaspect = -1;
            this.globalpalwritten = 0;
            this.changepalette(Engine.curpalette.getBytes());
            j = 0;
            for (i = 0; i <= Engine.ydim; ++i) {
                this.ylookup[i] = j;
                j += this.bytesperline;
            }
            for (i = 0; i < 2048; ++i) {
                this.reciptable[i] = Pragmas.divscale(2048L, i + 2048, 30);
            }
            this.updateview();
            for (i = 1; i < 1024; ++i) {
                this.lowrecip[i] = 0xFFFFFF / i;
            }
            this.a = new Ac(Engine.xdim, Engine.ydim, this.reciptable);
            this.a.setvlinebpl(this.bytesperline);
            this.a.fixtransluscence(Engine.transluc);
            this.a.setpalookupaddress(Engine.palookup[this.globalpalwritten]);
            Console.Println("Software renderer is initialized", Console.OSDTEXT_GOLD);
            this.isInited = true;
        }
        catch (Throwable t) {
            this.isInited = false;
        }
    }

    protected A getA() {
        return this.a;
    }

    @Override
    public boolean isInited() {
        return this.isInited;
    }

    public void updateview() {
        int i;
        this.xdimenrecip = Pragmas.divscale(1L, Engine.xdimen, 32);
        for (i = 0; i < Engine.windowx1; ++i) {
            this.startumost[i] = 1;
            this.startdmost[i] = 0;
        }
        for (i = Engine.windowx1; i <= Engine.windowx2; ++i) {
            this.startumost[i] = (short)Engine.windowy1;
            this.startdmost[i] = (short)(Engine.windowy2 + 1);
        }
        for (i = Engine.windowx2 + 1; i < Engine.xdim; ++i) {
            this.startumost[i] = 1;
            this.startdmost[i] = 0;
        }
    }

    @Override
    public void setview(int x1, int y1, int x2, int y2) {
        this.updateview();
    }

    public void setviewtotile(int tilenume, int xsiz, int ysiz) {
        Tile pic = this.engine.getTile(tilenume);
        pic.setWidth(xsiz).setHeight(ysiz);
        this.bakxsiz[Engine.setviewcnt] = (short)xsiz;
        this.bakysiz[Engine.setviewcnt] = (short)ysiz;
        this.bakframeplace[Engine.setviewcnt] = this.a.getframeplace();
        this.a.setframeplace(pic.data);
        Engine.bakwindowx1[Engine.setviewcnt] = Engine.windowx1;
        Engine.bakwindowy1[Engine.setviewcnt] = Engine.windowy1;
        Engine.bakwindowx2[Engine.setviewcnt] = Engine.windowx2;
        Engine.bakwindowy2[Engine.setviewcnt] = Engine.windowy2;
        ++Engine.setviewcnt;
        this.engine.setview(0, 0, ysiz - 1, xsiz - 1);
        this.engine.setaspect(65536, 65536);
        int j = 0;
        for (int i = 0; i <= xsiz; ++i) {
            this.ylookup[i] = j;
            j += ysiz;
        }
        this.a.setvlinebpl(ysiz);
    }

    public void setviewback() {
        this.a.setframeplace(this.bakframeplace[Engine.setviewcnt]);
        int k = Engine.setviewcnt == 0 ? this.bakxsiz[0] : Math.max(this.bakxsiz[Engine.setviewcnt - 1], this.bakxsiz[Engine.setviewcnt]);
        int j = 0;
        for (int i = 0; i <= k; ++i) {
            this.ylookup[i] = j;
            j += this.bytesperline;
        }
        this.a.setvlinebpl(this.bytesperline);
    }

    @Override
    public void uninit() {
        this.isInited = false;
    }

    public void swapsprite(int k, int l, boolean z) {
        SPRITE stmp = this.tspriteptr[k];
        this.tspriteptr[k] = this.tspriteptr[l];
        this.tspriteptr[l] = stmp;
        int tmp = this.spritesx[k];
        this.spritesx[k] = this.spritesx[l];
        this.spritesx[l] = tmp;
        tmp = this.spritesy[k];
        this.spritesy[k] = this.spritesy[l];
        this.spritesy[l] = tmp;
        if (z) {
            tmp = this.spritesz[k];
            this.spritesz[k] = this.spritesz[l];
            this.spritesz[l] = tmp;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void drawmasks() {
        i = Engine.spritesortcnt - 1;
        while (i >= 0) {
            block25: {
                block26: {
                    this.tspriteptr[i] = Engine.tsprite[i];
                    if (this.tspriteptr[i].picnum < 0 || this.tspriteptr[i].picnum > Engine.MAXTILES) break block25;
                    xs = this.tspriteptr[i].x - Engine.globalposx;
                    ys = this.tspriteptr[i].y - Engine.globalposy;
                    yp = Pragmas.dmulscale(xs, Engine.cosviewingrangeglobalang, ys, Engine.sinviewingrangeglobalang, 6);
                    if (yp <= 1024) break block26;
                    xp = Pragmas.dmulscale(ys, Engine.cosglobalang, -xs, Engine.singlobalang, 6);
                    this.spritesx[i] = Pragmas.scale(xp + yp, Engine.xdimen << 7, yp);
                    ** GOTO lbl-1000
                }
                if ((this.tspriteptr[i].cstat & 48) == 0) {
                    if (i != --Engine.spritesortcnt) {
                        this.tspriteptr[i] = this.tspriteptr[Engine.spritesortcnt];
                        this.spritesx[i] = this.spritesx[Engine.spritesortcnt];
                        this.spritesy[i] = this.spritesy[Engine.spritesortcnt];
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.spritesy[i] = yp;
                }
            }
            --i;
        }
        gap = 1;
        while (gap < Engine.spritesortcnt) {
            gap = (gap << 1) + 1;
        }
        gap >>= 1;
        while (gap > 0) {
            for (i = 0; i < Engine.spritesortcnt - gap; ++i) {
                for (l = i; l >= 0 && this.spritesy[l] > this.spritesy[l + gap]; l -= gap) {
                    this.swapsprite(l, l + gap, false);
                }
            }
            gap >>= 1;
        }
        if (Engine.spritesortcnt > 0) {
            this.spritesy[Engine.spritesortcnt] = this.spritesy[Engine.spritesortcnt - 1] ^ 1;
        }
        ys = this.spritesy[0];
        i = 0;
        for (j = 1; j <= Engine.spritesortcnt; ++j) {
            if (this.spritesy[j] == ys) continue;
            ys = this.spritesy[j];
            if (j > i + 1) {
                for (k = i; k < j; ++k) {
                    this.spritesz[k] = this.tspriteptr[k].z;
                    if (this.tspriteptr[k].picnum < 0 || this.tspriteptr[k].picnum > Engine.MAXTILES || (this.tspriteptr[k].cstat & 48) == 32) continue;
                    pic = this.engine.getTile(this.tspriteptr[k].picnum);
                    yoff = (byte)(pic.getOffsetY() + this.tspriteptr[k].yoffset);
                    v0 = k;
                    this.spritesz[v0] = this.spritesz[v0] - (yoff * this.tspriteptr[k].yrepeat << 2);
                    yspan = pic.getHeight() * this.tspriteptr[k].yrepeat << 2;
                    if ((this.tspriteptr[k].cstat & 128) == 0) {
                        v1 = k;
                        this.spritesz[v1] = this.spritesz[v1] - (yspan >> 1);
                    }
                    if (Pragmas.klabs(this.spritesz[k] - Engine.globalposz) >= yspan >> 1) continue;
                    this.spritesz[k] = Engine.globalposz;
                }
                for (k = i + 1; k < j; ++k) {
                    for (l = i; l < k; ++l) {
                        if (Pragmas.klabs(this.spritesz[k] - Engine.globalposz) >= Pragmas.klabs(this.spritesz[l] - Engine.globalposz)) continue;
                        this.swapsprite(k, l, true);
                    }
                }
                for (k = i + 1; k < j; ++k) {
                    for (l = i; l < k; ++l) {
                        if (this.tspriteptr[k].statnum >= this.tspriteptr[l].statnum) continue;
                        this.swapsprite(k, l, false);
                    }
                }
            }
            i = j;
        }
        while (Engine.spritesortcnt > 0 && this.maskwallcnt > 0) {
            j = this.maskwall[this.maskwallcnt - 1];
            if (!this.spritewallfront(this.tspriteptr[Engine.spritesortcnt - 1], this.thewall[j])) {
                this.drawsprite(--Engine.spritesortcnt);
                continue;
            }
            k = -1;
            gap = 0;
            for (i = Engine.spritesortcnt - 2; i >= 0; --i) {
                if (this.xb1[j] > this.spritesx[i] >> 8 || this.spritesx[i] >> 8 > this.xb2[j] || this.spritewallfront(this.tspriteptr[i], this.thewall[j])) continue;
                this.drawsprite(i);
                this.tspriteptr[i] = null;
                k = i;
                ++gap;
            }
            if (k >= 0) {
                for (i = k; i < Engine.spritesortcnt; ++i) {
                    if (this.tspriteptr[i] == null || this.tspriteptr[i].owner < 0) continue;
                    if (i > k) {
                        this.tspriteptr[k] = this.tspriteptr[i];
                        this.spritesx[k] = this.spritesx[i];
                        this.spritesy[k] = this.spritesy[i];
                        this.tspriteptr[i] = null;
                    }
                    ++k;
                }
                Engine.spritesortcnt -= gap;
            }
            this.drawmaskwall(--this.maskwallcnt);
        }
        while (Engine.spritesortcnt != 0) {
            if (this.tspriteptr[--Engine.spritesortcnt] == null) continue;
            this.drawsprite(Engine.spritesortcnt);
        }
        while (this.maskwallcnt > 0) {
            this.drawmaskwall(--this.maskwallcnt);
        }
    }

    @Override
    public void drawrooms() {
        Engine.globalhoriz = Engine.globalhoriz * (float)Engine.xdimenscale / (float)Engine.viewingrange + (float)(Engine.ydimen >> 1);
        this.globaluclip = (0 - (int)Engine.globalhoriz) * Engine.xdimscale;
        this.globaldclip = (Engine.ydimen - (int)Engine.globalhoriz) * Engine.xdimscale;
        int i = Pragmas.mulscale(Engine.xdimenscale, Engine.viewingrangerecip, 16);
        this.globalpisibility = Pragmas.mulscale(Engine.parallaxvisibility, i, 16);
        Engine.globalvisibility = Pragmas.mulscale(Engine.visibility, i, 16);
        this.globalhisibility = Pragmas.mulscale(Engine.globalvisibility, Engine.xyaspect, 16);
        this.globalcisibility = Pragmas.mulscale(this.globalhisibility, 320L, 8);
        if (Engine.xyaspect != this.oxyaspect || Engine.xdimen != this.oxdimen || Engine.viewingrange != this.oviewingrange) {
            this.dosetaspect();
        }
        i = Engine.xdimen - 1;
        do {
            this.umost[i] = (short)(this.startumost[Engine.windowx1 + i] - Engine.windowy1);
            this.dmost[i] = (short)(this.startdmost[Engine.windowx1 + i] - Engine.windowy1);
        } while (--i != 0);
        this.umost[0] = (short)(this.startumost[Engine.windowx1] - Engine.windowy1);
        this.dmost[0] = (short)(this.startdmost[Engine.windowx1] - Engine.windowy1);
        this.frameoffset = Engine.windowy1 * this.bytesperline + Engine.windowx1;
        this.numhits = Engine.xdimen;
        this.numscans = 0;
        this.numbunches = 0;
        this.maskwallcnt = 0;
        this.smostwallcnt = 0;
        this.smostcnt = 0;
        Engine.spritesortcnt = 0;
        if (Engine.globalcursectnum >= Engine.MAXSECTORS) {
            Engine.globalcursectnum = (short)(Engine.globalcursectnum - Engine.MAXSECTORS);
        } else {
            i = Engine.globalcursectnum;
            if ((Engine.globalcursectnum = this.engine.updatesector(Engine.globalposx, Engine.globalposy, Engine.globalcursectnum)) < 0) {
                Engine.globalcursectnum = (short)i;
            }
        }
        this.globparaceilclip = 1;
        this.globparaflorclip = 1;
        this.engine.getzsofslope(Engine.globalcursectnum, Engine.globalposx, Engine.globalposy, this.zofslope);
        int cz = this.zofslope[0];
        int fz = this.zofslope[1];
        if (Engine.globalposz < cz) {
            this.globparaceilclip = 0;
        }
        if (Engine.globalposz > fz) {
            this.globparaflorclip = 0;
        }
        this.scansector(Engine.globalcursectnum);
        if (Engine.inpreparemirror) {
            Engine.inpreparemirror = false;
            this.mirrorsx1 = Engine.xdimen - 1;
            this.mirrorsx2 = 0;
            for (i = this.numscans - 1; i >= 0; --i) {
                if (Engine.wall[this.thewall[i]].nextsector < 0) continue;
                if (this.xb1[i] < this.mirrorsx1) {
                    this.mirrorsx1 = this.xb1[i];
                }
                if (this.xb2[i] <= this.mirrorsx2) continue;
                this.mirrorsx2 = this.xb2[i];
            }
            for (i = 0; i < this.mirrorsx1; ++i) {
                if (this.umost[i] > this.dmost[i]) continue;
                this.umost[i] = 1;
                this.dmost[i] = 0;
                --this.numhits;
            }
            for (i = this.mirrorsx2 + 1; i < Engine.xdimen; ++i) {
                if (this.umost[i] > this.dmost[i]) continue;
                this.umost[i] = 1;
                this.dmost[i] = 0;
                --this.numhits;
            }
            this.drawalls(0);
            --this.numbunches;
            this.mirrorsy1 = Math.min(this.umost[this.mirrorsx1], this.umost[this.mirrorsx2]);
            this.mirrorsy2 = Math.max(this.dmost[this.mirrorsx1], this.dmost[this.mirrorsx2]);
            if (this.numbunches < 0) {
                return;
            }
            this.bunchfirst[0] = this.bunchfirst[this.numbunches];
            this.bunchlast[0] = this.bunchlast[this.numbunches];
        }
        while (this.numbunches > 0 && this.numhits > 0) {
            int j;
            Arrays.fill(this.tempbuf, 0, this.numbunches + 3, (byte)0);
            this.tempbuf[0] = 1;
            int closest = 0;
            for (i = 1; i < this.numbunches; ++i) {
                j = this.bunchfront(i, closest);
                if (j < 0) continue;
                this.tempbuf[i] = 1;
                if (j != 0) continue;
                this.tempbuf[closest] = 1;
                closest = i;
            }
            for (i = 0; i < this.numbunches; ++i) {
                if (this.tempbuf[i] != 0 || (j = this.bunchfront(i, closest)) < 0) continue;
                this.tempbuf[i] = 1;
                if (j != 0) continue;
                this.tempbuf[closest] = 1;
                closest = i;
                i = 0;
            }
            this.drawalls(closest);
            if (Engine.automapping != 0) {
                short z = this.bunchfirst[closest];
                while (z >= 0) {
                    int n = this.thewall[z] >> 3;
                    Engine.show2dwall[n] = (byte)(Engine.show2dwall[n] | Engine.pow2char[this.thewall[z] & 7]);
                    z = this.p2[z];
                }
            }
            --this.numbunches;
            this.bunchfirst[closest] = this.bunchfirst[this.numbunches];
            this.bunchlast[closest] = this.bunchlast[this.numbunches];
        }
    }

    @Override
    public void completemirror() {
        if (Engine.inpreparemirror) {
            Engine.inpreparemirror = false;
            return;
        }
        if (this.mirrorsx1 > 0) {
            --this.mirrorsx1;
        }
        if (this.mirrorsx2 < Engine.windowx2 - Engine.windowx1 - 1) {
            ++this.mirrorsx2;
        }
        if (this.mirrorsx2 < this.mirrorsx1) {
            return;
        }
        int p = this.ylookup[Engine.windowy1 + this.mirrorsy1] + Engine.windowx1 + this.mirrorsx1;
        int i = Engine.windowx2 - Engine.windowx1 - this.mirrorsx2 - this.mirrorsx1;
        this.mirrorsx2 -= this.mirrorsx1;
        byte[] frameplace = this.a.getframeplace();
        for (int dy = this.mirrorsy2 - this.mirrorsy1; dy >= 0; --dy) {
            if (this.mirrorsx2 + 1 + p + 1 >= frameplace.length) {
                return;
            }
            System.arraycopy(frameplace, p + 1, this.tempbuf, 0, this.mirrorsx2 + 1);
            this.tempbuf[this.mirrorsx2] = this.tempbuf[this.mirrorsx2 - 1];
            this.copybufreverse(this.tempbuf, this.mirrorsx2, frameplace, p + i, this.mirrorsx2 + 1);
            p += this.ylookup[1];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawalls(int bunch) {
        int z = this.bunchfirst[bunch];
        short sectnum = this.thesector[z];
        SECTOR sec = Engine.sector[sectnum];
        int andwstat1 = 255;
        int andwstat2 = 255;
        while (z >= 0) {
            andwstat1 &= this.wallmost(this.uplc, z, sectnum, 0);
            andwstat2 &= this.wallmost(this.dplc, z, sectnum, 1);
            z = this.p2[z];
        }
        if ((andwstat1 & 3) != 3) {
            if ((sec.ceilingstat & 3) == 2) {
                this.grouscan(this.xb1[this.bunchfirst[bunch]], this.xb2[this.bunchlast[bunch]], sectnum, 0);
            } else if ((sec.ceilingstat & 1) == 0) {
                this.ceilscan(this.xb1[this.bunchfirst[bunch]], this.xb2[this.bunchlast[bunch]], sectnum);
            } else {
                this.parascan(this.xb1[this.bunchfirst[bunch]], this.xb2[this.bunchlast[bunch]], 0, bunch);
            }
        }
        if ((andwstat2 & 0xC) != 12) {
            if ((sec.floorstat & 3) == 2) {
                this.grouscan(this.xb1[this.bunchfirst[bunch]], this.xb2[this.bunchlast[bunch]], sectnum, 1);
            } else if ((sec.floorstat & 1) == 0) {
                this.florscan(this.xb1[this.bunchfirst[bunch]], this.xb2[this.bunchlast[bunch]], sectnum);
            } else {
                this.parascan(this.xb1[this.bunchfirst[bunch]], this.xb2[this.bunchlast[bunch]], 1, bunch);
            }
        }
        z = this.bunchfirst[bunch];
        while (true) {
            block67: {
                boolean gotswall;
                SECTOR nextsec;
                short nextsectnum;
                WALL wal;
                short wallnum;
                int x;
                int x2;
                int x1;
                block68: {
                    int startsmostcnt;
                    int startsmostwallcnt;
                    block72: {
                        int i;
                        block74: {
                            block73: {
                                block69: {
                                    int i2;
                                    block71: {
                                        block70: {
                                            block66: {
                                                if (z < 0) {
                                                    return;
                                                }
                                                x1 = this.xb1[z];
                                                x2 = this.xb2[z];
                                                if (this.umost[x2] < this.dmost[x2]) break block66;
                                                for (x = x1; x < x2 && this.umost[x] >= this.dmost[x]; ++x) {
                                                }
                                                if (x < x2) break block66;
                                                this.smostwall[this.smostwallcnt] = z;
                                                this.smostwalltype[this.smostwallcnt] = 0;
                                                ++this.smostwallcnt;
                                                break block67;
                                            }
                                            wallnum = this.thewall[z];
                                            wal = Engine.wall[wallnum];
                                            nextsectnum = wal.nextsector;
                                            nextsec = null;
                                            gotswall = false;
                                            startsmostwallcnt = this.smostwallcnt;
                                            startsmostcnt = this.smostcnt;
                                            if (nextsectnum < 0) break block68;
                                            nextsec = Engine.sector[nextsectnum];
                                            this.engine.getzsofslope(sectnum, wal.x, wal.y, this.zofslope);
                                            this.cz[0] = this.zofslope[0];
                                            this.fz[0] = this.zofslope[1];
                                            this.engine.getzsofslope(sectnum, Engine.wall[wal.point2].x, Engine.wall[wal.point2].y, this.zofslope);
                                            this.cz[1] = this.zofslope[0];
                                            this.fz[1] = this.zofslope[1];
                                            this.engine.getzsofslope(nextsectnum, wal.x, wal.y, this.zofslope);
                                            this.cz[2] = this.zofslope[0];
                                            this.fz[2] = this.zofslope[1];
                                            this.engine.getzsofslope(nextsectnum, Engine.wall[wal.point2].x, Engine.wall[wal.point2].y, this.zofslope);
                                            this.cz[3] = this.zofslope[0];
                                            this.fz[3] = this.zofslope[1];
                                            this.engine.getzsofslope(nextsectnum, Engine.globalposx, Engine.globalposy, this.zofslope);
                                            this.cz[4] = this.zofslope[0];
                                            this.fz[4] = this.zofslope[1];
                                            if ((wal.cstat & 0x30) == 16) {
                                                this.maskwall[this.maskwallcnt++] = z;
                                            }
                                            if ((sec.ceilingstat & 1) != 0 && (nextsec.ceilingstat & 1) != 0) break block69;
                                            if (this.cz[2] > this.cz[0] || this.cz[3] > this.cz[1]) break block70;
                                            if (this.globparaceilclip != 0) {
                                                for (x = x1; x <= x2; ++x) {
                                                    if (this.uplc[x] <= this.umost[x] || this.umost[x] > this.dmost[x]) continue;
                                                    this.umost[x] = this.uplc[x];
                                                    if (this.umost[x] <= this.dmost[x]) continue;
                                                    --this.numhits;
                                                }
                                            }
                                            break block71;
                                        }
                                        this.wallmost(this.dwall, z, nextsectnum, 0);
                                        if (this.cz[2] > this.fz[0] || this.cz[3] > this.fz[1]) {
                                            for (int i3 = x1; i3 <= x2; ++i3) {
                                                if (this.dwall[i3] <= this.dplc[i3]) continue;
                                                this.dwall[i3] = this.dplc[i3];
                                            }
                                        }
                                        this.globalorientation = wal.cstat;
                                        this.globalpicnum = wal.picnum;
                                        if (this.globalpicnum >= Engine.MAXTILES) {
                                            this.globalpicnum = 0;
                                        }
                                        this.globalxpanning = wal.xpanning & 0xFF;
                                        this.globalypanning = wal.ypanning & 0xFF;
                                        this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
                                        Tile pic = this.engine.getTile(this.globalpicnum);
                                        if (Engine.pow2long[this.globalshiftval] != pic.getHeight()) {
                                            this.globalshiftval = (short)(this.globalshiftval + 1);
                                        }
                                        this.globalshiftval = (short)(32 - this.globalshiftval);
                                        if (pic.getType() != Tile.AnimType.None) {
                                            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, (short)wallnum + 16384));
                                        }
                                        Engine.globalshade = wal.shade;
                                        this.globvis = Engine.globalvisibility;
                                        if (sec.visibility != 0) {
                                            this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                                        }
                                        if (Engine.palookup[Engine.globalpal = (int)wal.pal] == null) {
                                            Engine.globalpal = 0;
                                        }
                                        this.globalyscale = wal.yrepeat << this.globalshiftval - 19;
                                        this.globalzd = (this.globalorientation & 4) == 0 ? (Engine.globalposz - nextsec.ceilingz) * this.globalyscale << 8 : (Engine.globalposz - sec.ceilingz) * this.globalyscale << 8;
                                        this.globalzd += this.globalypanning << 24;
                                        if ((this.globalorientation & 0x100) != 0) {
                                            this.globalyscale = -this.globalyscale;
                                            this.globalzd = -this.globalzd;
                                        }
                                        if (!gotswall) {
                                            gotswall = true;
                                            this.prepwall(z, wal);
                                        }
                                        this.wallscan(x1, x2, this.uplc, this.dwall, this.swall, this.lwall);
                                        if (this.cz[2] >= this.cz[0] && this.cz[3] >= this.cz[1]) {
                                            for (x = x1; x <= x2; ++x) {
                                                if (this.dwall[x] <= this.umost[x] || this.umost[x] > this.dmost[x]) continue;
                                                this.umost[x] = this.dwall[x];
                                                if (this.umost[x] <= this.dmost[x]) continue;
                                                --this.numhits;
                                            }
                                        } else {
                                            for (x = x1; x <= x2; ++x) {
                                                int i4;
                                                if (this.umost[x] > this.dmost[x] || (i4 = Math.max(this.uplc[x], this.dwall[x])) <= this.umost[x]) continue;
                                                this.umost[x] = (short)i4;
                                                if (this.umost[x] <= this.dmost[x]) continue;
                                                --this.numhits;
                                            }
                                        }
                                    }
                                    if ((this.cz[2] < this.cz[0] || this.cz[3] < this.cz[1] || Engine.globalposz < this.cz[4]) && this.smostcnt + (i2 = x2 - x1 + 1) < this.MAXYSAVES) {
                                        this.smoststart[this.smostwallcnt] = this.smostcnt;
                                        this.smostwall[this.smostwallcnt] = z;
                                        this.smostwalltype[this.smostwallcnt] = 1;
                                        ++this.smostwallcnt;
                                        System.arraycopy(this.umost, x1, this.smost, this.smostcnt, i2);
                                        this.smostcnt += i2;
                                    }
                                }
                                if ((sec.floorstat & 1) != 0 && (nextsec.floorstat & 1) != 0) break block72;
                                if (this.fz[2] < this.fz[0] || this.fz[3] < this.fz[1]) break block73;
                                if (this.globparaflorclip != 0) {
                                    for (x = x1; x <= x2; ++x) {
                                        if (this.dplc[x] >= this.dmost[x] || this.umost[x] > this.dmost[x]) continue;
                                        this.dmost[x] = this.dplc[x];
                                        if (this.umost[x] <= this.dmost[x]) continue;
                                        --this.numhits;
                                    }
                                }
                                break block74;
                            }
                            this.wallmost(this.uwall, z, nextsectnum, 1);
                            if (this.fz[2] < this.cz[0] || this.fz[3] < this.cz[1]) {
                                for (int i5 = x1; i5 <= x2; ++i5) {
                                    if (this.uwall[i5] >= this.uplc[i5]) continue;
                                    this.uwall[i5] = this.uplc[i5];
                                }
                            }
                            if ((wal.cstat & 2) > 0) {
                                wallnum = wal.nextwall;
                                wal = Engine.wall[wallnum];
                                this.globalorientation = wal.cstat;
                                this.globalpicnum = wal.picnum;
                                if (this.globalpicnum >= Engine.MAXTILES) {
                                    this.globalpicnum = 0;
                                }
                                this.globalxpanning = wal.xpanning & 0xFF;
                                this.globalypanning = wal.ypanning & 0xFF;
                                if (this.engine.getTile(this.globalpicnum).getType() != Tile.AnimType.None) {
                                    this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, wallnum + 16384));
                                }
                                Engine.globalshade = wal.shade;
                                Engine.globalpal = wal.pal;
                                wallnum = this.thewall[z];
                                wal = Engine.wall[wallnum];
                            } else {
                                this.globalorientation = wal.cstat;
                                this.globalpicnum = wal.picnum;
                                if (this.globalpicnum >= Engine.MAXTILES) {
                                    this.globalpicnum = 0;
                                }
                                this.globalxpanning = wal.xpanning & 0xFF;
                                this.globalypanning = wal.ypanning & 0xFF;
                                if (this.engine.getTile(this.globalpicnum).getType() != Tile.AnimType.None) {
                                    this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, wallnum + 16384));
                                }
                                Engine.globalshade = wal.shade;
                                Engine.globalpal = wal.pal;
                            }
                            if (Engine.palookup[Engine.globalpal] == null) {
                                Engine.globalpal = 0;
                            }
                            this.globvis = Engine.globalvisibility;
                            if (sec.visibility != 0) {
                                this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                            }
                            this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
                            if (Engine.pow2long[this.globalshiftval] != this.engine.getTile(this.globalpicnum).getHeight()) {
                                this.globalshiftval = (short)(this.globalshiftval + 1);
                            }
                            this.globalshiftval = (short)(32 - this.globalshiftval);
                            this.globalyscale = wal.yrepeat << this.globalshiftval - 19;
                            this.globalzd = (this.globalorientation & 4) == 0 ? (Engine.globalposz - nextsec.floorz) * this.globalyscale << 8 : (Engine.globalposz - sec.ceilingz) * this.globalyscale << 8;
                            this.globalzd += this.globalypanning << 24;
                            if ((this.globalorientation & 0x100) != 0) {
                                this.globalyscale = -this.globalyscale;
                                this.globalzd = -this.globalzd;
                            }
                            if (!gotswall) {
                                gotswall = true;
                                this.prepwall(z, wal);
                            }
                            this.wallscan(x1, x2, this.uwall, this.dplc, this.swall, this.lwall);
                            if (this.fz[2] <= this.fz[0] && this.fz[3] <= this.fz[1]) {
                                for (x = x1; x <= x2; ++x) {
                                    if (this.uwall[x] >= this.dmost[x] || this.umost[x] > this.dmost[x]) continue;
                                    this.dmost[x] = this.uwall[x];
                                    if (this.umost[x] <= this.dmost[x]) continue;
                                    --this.numhits;
                                }
                            } else {
                                for (x = x1; x <= x2; ++x) {
                                    int i6;
                                    if (this.umost[x] > this.dmost[x] || (i6 = Math.min(this.dplc[x], this.uwall[x])) >= this.dmost[x]) continue;
                                    this.dmost[x] = (short)i6;
                                    if (this.umost[x] <= this.dmost[x]) continue;
                                    --this.numhits;
                                }
                            }
                        }
                        if ((this.fz[2] > this.fz[0] || this.fz[3] > this.fz[1] || Engine.globalposz > this.fz[4]) && this.smostcnt + (i = x2 - x1 + 1) < this.MAXYSAVES) {
                            this.smoststart[this.smostwallcnt] = this.smostcnt;
                            this.smostwall[this.smostwallcnt] = z;
                            this.smostwalltype[this.smostwallcnt] = 2;
                            ++this.smostwallcnt;
                            System.arraycopy(this.dmost, x1, this.smost, this.smostcnt, i);
                            this.smostcnt += i;
                        }
                    }
                    if (this.numhits < 0) {
                        return;
                    }
                    if ((wal.cstat & 0x20) == 0 && (Engine.gotsector[nextsectnum >> 3] & Engine.pow2char[nextsectnum & 7]) == 0) {
                        if (this.umost[x2] < this.dmost[x2]) {
                            this.scansector(nextsectnum);
                        } else {
                            for (x = x1; x < x2; ++x) {
                                if (this.umost[x] >= this.dmost[x]) continue;
                                this.scansector(nextsectnum);
                                break;
                            }
                            if (x == x2) {
                                this.smostwallcnt = startsmostwallcnt;
                                this.smostcnt = startsmostcnt;
                                this.smostwall[this.smostwallcnt] = z;
                                this.smostwalltype[this.smostwallcnt] = 0;
                                ++this.smostwallcnt;
                            }
                        }
                    }
                }
                if (nextsectnum < 0 || (wal.cstat & 0x20) != 0) {
                    this.globalorientation = wal.cstat;
                    this.globalpicnum = nextsectnum < 0 ? wal.picnum : wal.overpicnum;
                    if (this.globalpicnum >= Engine.MAXTILES) {
                        this.globalpicnum = 0;
                    }
                    this.globalxpanning = wal.xpanning & 0xFF;
                    this.globalypanning = wal.ypanning & 0xFF;
                    Tile pic = this.engine.getTile(this.globalpicnum);
                    if (pic.getType() != Tile.AnimType.None) {
                        this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, wallnum + 16384));
                        pic = this.engine.getTile(this.globalpicnum);
                    }
                    Engine.globalshade = wal.shade;
                    this.globvis = Engine.globalvisibility;
                    if (sec.visibility != 0) {
                        this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                    }
                    if (Engine.palookup[Engine.globalpal = (int)wal.pal] == null) {
                        Engine.globalpal = 0;
                    }
                    this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
                    if (Engine.pow2long[this.globalshiftval] != pic.getHeight()) {
                        this.globalshiftval = (short)(this.globalshiftval + 1);
                    }
                    this.globalshiftval = (short)(32 - this.globalshiftval);
                    this.globalyscale = wal.yrepeat << this.globalshiftval - 19;
                    this.globalzd = nextsectnum >= 0 ? ((this.globalorientation & 4) == 0 ? Engine.globalposz - nextsec.ceilingz : Engine.globalposz - sec.ceilingz) : ((this.globalorientation & 4) == 0 ? Engine.globalposz - sec.ceilingz : Engine.globalposz - sec.floorz);
                    this.globalzd = (this.globalzd * this.globalyscale << 8) + (this.globalypanning << 24);
                    if ((this.globalorientation & 0x100) != 0) {
                        this.globalyscale = -this.globalyscale;
                        this.globalzd = -this.globalzd;
                    }
                    if (!gotswall) {
                        gotswall = true;
                        this.prepwall(z, wal);
                    }
                    this.wallscan(x1, x2, this.uplc, this.dplc, this.swall, this.lwall);
                    for (x = x1; x <= x2; ++x) {
                        if (this.umost[x] > this.dmost[x]) continue;
                        this.umost[x] = 1;
                        this.dmost[x] = 0;
                        --this.numhits;
                    }
                    this.smostwall[this.smostwallcnt] = z;
                    this.smostwalltype[this.smostwallcnt] = 0;
                    ++this.smostwallcnt;
                }
            }
            z = this.p2[z];
        }
    }

    private void drawsprite(int snum) {
        SPRITE tspr = this.tspriteptr[snum];
        int xb = this.spritesx[snum];
        int yp = this.spritesy[snum];
        if (tspr == null || tspr.owner < 0 || tspr.picnum < 0 || tspr.picnum >= Engine.MAXTILES || tspr.sectnum < 0) {
            return;
        }
        int tilenum = tspr.picnum;
        VoxelInfo vtilenum = null;
        short spritenum = tspr.owner;
        short cstat = tspr.cstat;
        Tile pic = this.engine.getTile(tilenum);
        if (pic.getType() != Tile.AnimType.None) {
            tilenum += this.engine.animateoffs(tilenum, spritenum + 32768);
            pic = this.engine.getTile(tilenum);
        }
        if (!pic.hasSize() || spritenum < 0) {
            return;
        }
        if (tspr.xrepeat <= 0 || tspr.yrepeat <= 0) {
            return;
        }
        if (BuildSettings.useVoxels.get().booleanValue()) {
            Tile2model entry;
            Tile2model tile2model = entry = this.defs != null ? this.defs.mdInfo.getParams(tilenum) : null;
            if (entry != null && entry.voxel != null && (Engine.sprite[tspr.owner].cstat & 0x30) != 32) {
                vtilenum = entry.voxel;
                cstat = (short)(cstat | 0x30);
            }
        }
        short sectnum = tspr.sectnum;
        SECTOR sec = Engine.sector[sectnum];
        Engine.globalpal = tspr.pal;
        if (Engine.palookup[Engine.globalpal] == null) {
            Engine.globalpal = 0;
        }
        Engine.globalshade = tspr.shade;
        if ((cstat & 2) != 0) {
            if ((cstat & 0x200) != 0) {
                this.a.settransreverse();
            } else {
                this.a.settransnormal();
            }
        }
        short xoff = (short)(pic.getOffsetX() + tspr.xoffset);
        short yoff = (short)(pic.getOffsetY() + tspr.yoffset);
        switch (cstat >> 4 & 3) {
            case 0: {
                int x;
                int linum;
                long linuminc;
                int rx;
                if (yp <= 1024) {
                    return;
                }
                long siz = Pragmas.divscale(Engine.xdimenscale, yp, 19);
                int xv = Pragmas.mulscale(tspr.xrepeat << 16, Engine.xyaspect, 16);
                int xspan = pic.getWidth();
                int yspan = pic.getHeight();
                int xsiz = Pragmas.mulscale(siz, xv * xspan, 30);
                int ysiz = Pragmas.mulscale(siz, tspr.yrepeat * yspan, 14);
                if (xspan >> 11 >= xsiz || yspan >= ysiz >> 1) {
                    return;
                }
                int x1 = xb - (xsiz >> 1);
                if ((xspan & 1) != 0) {
                    x1 += Pragmas.mulscale(siz, xv, 31);
                }
                int i = Pragmas.mulscale(siz, xv * xoff, 30);
                x1 = (cstat & 4) == 0 ? (x1 -= i) : (x1 += i);
                int y1 = Pragmas.mulscale(tspr.z - Engine.globalposz, siz, 16);
                y1 -= Pragmas.mulscale(siz, tspr.yrepeat * yoff, 14);
                y1 += ((int)Engine.globalhoriz << 8) - ysiz;
                if ((cstat & 0x80) != 0) {
                    y1 += ysiz >> 1;
                    if ((yspan & 1) != 0) {
                        y1 += Pragmas.mulscale(siz, tspr.yrepeat, 15);
                    }
                }
                int x2 = x1 + xsiz - 1;
                int y2 = y1 + ysiz - 1;
                if ((y1 | 0xFF) >= (y2 | 0xFF)) {
                    return;
                }
                int lx = (x1 >> 8) + 1;
                if (lx < 0) {
                    lx = 0;
                }
                if ((rx = x2 >> 8) >= Engine.xdimen) {
                    rx = Engine.xdimen - 1;
                }
                if (lx > rx) {
                    return;
                }
                long yinc = Pragmas.divscale(yspan, ysiz, 32);
                long startum = 0L;
                if ((sec.ceilingstat & 3) == 0) {
                    startum = (long)Engine.globalhoriz + (long)Pragmas.mulscale(siz, sec.ceilingz - Engine.globalposz, 24) - 1L;
                }
                long startdm = Integer.MAX_VALUE;
                if ((sec.floorstat & 3) == 0) {
                    startdm = (long)Engine.globalhoriz + (long)Pragmas.mulscale(siz, sec.floorz - Engine.globalposz, 24) + 1L;
                }
                if ((long)(y1 >> 8) > startum) {
                    startum = y1 >> 8;
                }
                if ((long)(y2 >> 8) < startdm) {
                    startdm = y2 >> 8;
                }
                if (startum < -32768L) {
                    startum = -32768L;
                }
                if (startdm > 32767L) {
                    startdm = 32767L;
                }
                if (startum >= startdm) {
                    return;
                }
                if ((cstat & 4) == 0) {
                    linuminc = Pragmas.divscale(xspan, xsiz, 24);
                    linum = Pragmas.mulscale((lx << 8) - x1, linuminc, 8);
                } else {
                    linuminc = -Pragmas.divscale(xspan, xsiz, 24);
                    linum = Pragmas.mulscale((lx << 8) - x2, linuminc, 8);
                }
                if ((cstat & 8) > 0) {
                    yinc = -yinc;
                    i = y1;
                    y1 = y2;
                    y2 = i;
                }
                for (x = lx; x <= rx; ++x) {
                    this.uwall[x] = (short)Math.max(this.startumost[x + Engine.windowx1] - Engine.windowy1, (short)startum);
                    this.dwall[x] = (short)Math.min(this.startdmost[x + Engine.windowx1] - Engine.windowy1, (short)startdm);
                }
                int daclip = 0;
                block27: for (i = this.smostwallcnt - 1; i >= 0; --i) {
                    int j;
                    if ((this.smostwalltype[i] & daclip) != 0 || this.xb1[j = this.smostwall[i]] > rx || this.xb2[j] < lx || yp <= this.yb1[j] && yp <= this.yb2[j] || this.spritewallfront(tspr, this.thewall[j]) && (yp <= this.yb1[j] || yp <= this.yb2[j])) continue;
                    int dalx2 = Math.max(this.xb1[j], lx);
                    int darx2 = Math.min(this.xb2[j], rx);
                    switch (this.smostwalltype[i]) {
                        case 0: {
                            int k;
                            if (dalx2 > darx2) continue block27;
                            if (dalx2 == lx && darx2 == rx) {
                                return;
                            }
                            for (k = dalx2; k <= darx2; ++k) {
                                this.dwall[k] = 0;
                            }
                            continue block27;
                        }
                        case 1: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] <= this.uwall[x]) continue;
                                this.uwall[x] = this.smost[k + x];
                            }
                            if (dalx2 != lx || darx2 != rx) continue block27;
                            daclip |= 1;
                            continue block27;
                        }
                        case 2: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] >= this.dwall[x]) continue;
                                this.dwall[x] = this.smost[k + x];
                            }
                            if (dalx2 != lx || darx2 != rx) continue block27;
                            daclip |= 2;
                        }
                    }
                }
                if (this.uwall[rx] >= this.dwall[rx]) {
                    for (x = lx; x < rx && this.uwall[x] >= this.dwall[x]; ++x) {
                    }
                    if (x == rx) {
                        return;
                    }
                }
                int z2 = tspr.z - (yoff * tspr.yrepeat << 2);
                if ((cstat & 0x80) != 0) {
                    z2 += yspan * tspr.yrepeat << 1;
                    if ((yspan & 1) != 0) {
                        z2 += tspr.yrepeat << 1;
                    }
                }
                int z1 = z2 - (yspan * tspr.yrepeat << 2);
                this.globalorientation = 0;
                this.globalpicnum = (short)tilenum;
                if (this.globalpicnum >= Engine.MAXTILES) {
                    this.globalpicnum = 0;
                }
                this.globalxpanning = 0;
                this.globalypanning = 0;
                this.globvis = Engine.globalvisibility;
                if (sec.visibility != 0) {
                    this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                }
                this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
                if (Engine.pow2long[this.globalshiftval] != pic.getHeight()) {
                    this.globalshiftval = (short)(this.globalshiftval + 1);
                }
                this.globalshiftval = (short)(32 - this.globalshiftval);
                this.globalyscale = Pragmas.divscale(512L, tspr.yrepeat, this.globalshiftval - 19);
                this.globalzd = (Engine.globalposz - z1) * this.globalyscale << 8;
                if ((cstat & 8) > 0) {
                    this.globalyscale = -this.globalyscale;
                    this.globalzd = (Engine.globalposz - z2) * this.globalyscale << 8;
                }
                this.qinterpolatedown16(this.lwall, lx, rx - lx + 1, linum, linuminc);
                Arrays.fill(this.swall, lx, rx + 1, Pragmas.mulscale(yp, Engine.xdimscale, 19));
                if ((cstat & 2) == 0) {
                    this.maskwallscan(lx, rx, this.uwall, this.dwall, this.swall, this.lwall);
                    break;
                }
                this.transmaskwallscan(lx, rx);
                break;
            }
            case 1: {
                int x;
                if ((cstat & 4) > 0) {
                    xoff = -xoff;
                }
                if ((cstat & 8) > 0) {
                    yoff = -yoff;
                }
                int xspan = pic.getWidth();
                int yspan = pic.getHeight();
                int xv = tspr.xrepeat * Engine.sintable[tspr.ang + 2560 + 1536 & 0x7FF];
                int yv = tspr.xrepeat * Engine.sintable[tspr.ang + 2048 + 1536 & 0x7FF];
                int i = (xspan >> 1) + xoff;
                int x1 = tspr.x - Engine.globalposx - Pragmas.mulscale(xv, i, 16);
                int x2 = x1 + Pragmas.mulscale(xv, xspan, 16);
                int y1 = tspr.y - Engine.globalposy - Pragmas.mulscale(yv, i, 16);
                int y2 = y1 + Pragmas.mulscale(yv, xspan, 16);
                int yp1 = Pragmas.dmulscale(x1, Engine.cosviewingrangeglobalang, y1, Engine.sinviewingrangeglobalang, 6);
                int yp2 = Pragmas.dmulscale(x2, Engine.cosviewingrangeglobalang, y2, Engine.sinviewingrangeglobalang, 6);
                if (yp1 <= 0 && yp2 <= 0) {
                    return;
                }
                int xp1 = Pragmas.dmulscale(y1, Engine.cosglobalang, -x1, Engine.singlobalang, 6);
                int xp2 = Pragmas.dmulscale(y2, Engine.cosglobalang, -x2, Engine.singlobalang, 6);
                x1 += Engine.globalposx;
                y1 += Engine.globalposy;
                x2 += Engine.globalposx;
                y2 += Engine.globalposy;
                int swapped = 0;
                if (Pragmas.dmulscale(xp1, yp2, -xp2, yp1, 32) >= 0) {
                    if ((cstat & 0x40) != 0) {
                        return;
                    }
                    i = xp1;
                    xp1 = xp2;
                    xp2 = i;
                    i = yp1;
                    yp1 = yp2;
                    yp2 = i;
                    i = x1;
                    x1 = x2;
                    x2 = i;
                    i = y1;
                    y1 = y2;
                    y2 = i;
                    swapped = 1;
                }
                if (xp1 >= -yp1) {
                    if (xp1 > yp1) {
                        return;
                    }
                    if (yp1 == 0) {
                        return;
                    }
                    this.xb1[this.MAXWALLSB - 1] = Engine.halfxdimen + Pragmas.scale(xp1, Engine.halfxdimen, yp1);
                    if (xp1 >= 0) {
                        int n = this.MAXWALLSB - 1;
                        this.xb1[n] = this.xb1[n] + 1;
                    }
                    if (this.xb1[this.MAXWALLSB - 1] >= Engine.xdimen) {
                        this.xb1[this.MAXWALLSB - 1] = Engine.xdimen - 1;
                    }
                    this.yb1[this.MAXWALLSB - 1] = yp1;
                } else {
                    if (xp2 < -yp2) {
                        return;
                    }
                    this.xb1[this.MAXWALLSB - 1] = 0;
                    i = yp1 - yp2 + xp1 - xp2;
                    if (i == 0) {
                        return;
                    }
                    this.yb1[this.MAXWALLSB - 1] = yp1 + Pragmas.scale(yp2 - yp1, xp1 + yp1, i);
                }
                if (xp2 <= yp2) {
                    if (xp2 < -yp2) {
                        return;
                    }
                    if (yp2 == 0) {
                        return;
                    }
                    this.xb2[this.MAXWALLSB - 1] = Engine.halfxdimen + Pragmas.scale(xp2, Engine.halfxdimen, yp2) - 1;
                    if (xp2 >= 0) {
                        int n = this.MAXWALLSB - 1;
                        this.xb2[n] = this.xb2[n] + 1;
                    }
                    if (this.xb2[this.MAXWALLSB - 1] >= Engine.xdimen) {
                        this.xb2[this.MAXWALLSB - 1] = Engine.xdimen - 1;
                    }
                    this.yb2[this.MAXWALLSB - 1] = yp2;
                } else {
                    if (xp1 > yp1) {
                        return;
                    }
                    this.xb2[this.MAXWALLSB - 1] = Engine.xdimen - 1;
                    i = xp2 - xp1 + yp1 - yp2;
                    if (i == 0) {
                        return;
                    }
                    this.yb2[this.MAXWALLSB - 1] = yp1 + Pragmas.scale(yp2 - yp1, yp1 - xp1, i);
                }
                if (this.yb1[this.MAXWALLSB - 1] < 256 || this.yb2[this.MAXWALLSB - 1] < 256 || this.xb1[this.MAXWALLSB - 1] > this.xb2[this.MAXWALLSB - 1]) {
                    return;
                }
                int topinc = -Pragmas.mulscale(yp1, xspan, 10);
                int top = (Pragmas.mulscale(xp1, Engine.xdimen, 10) - Pragmas.mulscale(this.xb1[this.MAXWALLSB - 1] - Engine.halfxdimen, yp1, 9)) * xspan >> 3;
                int botinc = yp2 - yp1 >> 8;
                int bot = Pragmas.mulscale(xp1 - xp2, Engine.xdimen, 11) + Pragmas.mulscale(this.xb1[this.MAXWALLSB - 1] - Engine.halfxdimen, botinc, 2);
                int j = this.xb2[this.MAXWALLSB - 1] + 3;
                int z = Pragmas.mulscale(top, this.krecipasm(bot), 20);
                this.lwall[this.xb1[this.MAXWALLSB - 1]] = z >> 8;
                for (x = this.xb1[this.MAXWALLSB - 1] + 4; x <= j; x += 4) {
                    int zz = z;
                    z = Pragmas.mulscale(top += topinc, this.krecipasm(bot += botinc), 20);
                    this.lwall[x] = z >> 8;
                    i = z + zz >> 1;
                    this.lwall[x - 2] = i >> 8;
                    this.lwall[x - 3] = i + zz >> 9;
                    this.lwall[x - 1] = i + z >> 9;
                }
                if (this.lwall[this.xb1[this.MAXWALLSB - 1]] < 0) {
                    this.lwall[this.xb1[this.MAXWALLSB - 1]] = 0;
                }
                if (this.lwall[this.xb2[this.MAXWALLSB - 1]] >= xspan) {
                    this.lwall[this.xb2[this.MAXWALLSB - 1]] = xspan - 1;
                }
                if ((swapped ^ ((cstat & 4) > 0 ? 1 : 0)) > 0) {
                    j = xspan - 1;
                    for (x = this.xb1[this.MAXWALLSB - 1]; x <= this.xb2[this.MAXWALLSB - 1]; ++x) {
                        this.lwall[x] = j - this.lwall[x];
                    }
                }
                this.rx1[this.MAXWALLSB - 1] = xp1;
                this.ry1[this.MAXWALLSB - 1] = yp1;
                this.rx2[this.MAXWALLSB - 1] = xp2;
                this.ry2[this.MAXWALLSB - 1] = yp2;
                int hplc = Pragmas.divscale(Engine.xdimenscale, this.yb1[this.MAXWALLSB - 1], 19);
                long hinc = Pragmas.divscale(Engine.xdimenscale, this.yb2[this.MAXWALLSB - 1], 19);
                hinc = (hinc - (long)hplc) / (long)(this.xb2[this.MAXWALLSB - 1] - this.xb1[this.MAXWALLSB - 1] + 1);
                int z2 = tspr.z - (yoff * tspr.yrepeat << 2);
                if ((cstat & 0x80) != 0) {
                    z2 += yspan * tspr.yrepeat << 1;
                    if ((yspan & 1) != 0) {
                        z2 += tspr.yrepeat << 1;
                    }
                }
                int z1 = z2 - (yspan * tspr.yrepeat << 2);
                this.globalorientation = 0;
                this.globalpicnum = (short)tilenum;
                if (this.globalpicnum >= Engine.MAXTILES) {
                    this.globalpicnum = 0;
                }
                this.globalxpanning = 0;
                this.globalypanning = 0;
                this.globvis = Engine.globalvisibility;
                if (sec.visibility != 0) {
                    this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                }
                this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
                if (Engine.pow2long[this.globalshiftval] != pic.getHeight()) {
                    this.globalshiftval = (short)(this.globalshiftval + 1);
                }
                this.globalshiftval = (short)(32 - this.globalshiftval);
                this.globalyscale = Pragmas.divscale(512L, tspr.yrepeat, this.globalshiftval - 19);
                this.globalzd = (Engine.globalposz - z1) * this.globalyscale << 8;
                if ((cstat & 8) > 0) {
                    this.globalyscale = -this.globalyscale;
                    this.globalzd = (Engine.globalposz - z2) * this.globalyscale << 8;
                }
                if ((sec.ceilingstat & 1) == 0 && z1 < sec.ceilingz) {
                    z1 = sec.ceilingz;
                }
                if ((sec.floorstat & 1) == 0 && z2 > sec.floorz) {
                    z2 = sec.floorz;
                }
                this.owallmost(this.uwall, this.MAXWALLSB - 1, z1 - Engine.globalposz);
                this.owallmost(this.dwall, this.MAXWALLSB - 1, z2 - Engine.globalposz);
                for (i = this.xb1[this.MAXWALLSB - 1]; i <= this.xb2[this.MAXWALLSB - 1]; ++i) {
                    this.swall[i] = this.krecipasm(hplc) << 2;
                    hplc = (int)((long)hplc + hinc);
                }
                block35: for (i = this.smostwallcnt - 1; i >= 0; --i) {
                    j = this.smostwall[i];
                    if (this.xb1[j] > this.xb2[this.MAXWALLSB - 1] || this.xb2[j] < this.xb1[this.MAXWALLSB - 1]) continue;
                    int dalx2 = this.xb1[j];
                    int darx2 = this.xb2[j];
                    if (Math.max(this.yb1[this.MAXWALLSB - 1], this.yb2[this.MAXWALLSB - 1]) <= Math.min(this.yb1[j], this.yb2[j])) continue;
                    if (Math.min(this.yb1[this.MAXWALLSB - 1], this.yb2[this.MAXWALLSB - 1]) > Math.max(this.yb1[j], this.yb2[j])) {
                        x = Integer.MIN_VALUE;
                    } else {
                        x = this.thewall[j];
                        xp1 = Engine.wall[x].x;
                        yp1 = Engine.wall[x].y;
                        x = Engine.wall[x].point2;
                        xp2 = Engine.wall[x].x;
                        yp2 = Engine.wall[x].y;
                        z1 = (xp2 - xp1) * (y1 - yp1) - (yp2 - yp1) * (x1 - xp1);
                        z2 = (xp2 - xp1) * (y2 - yp1) - (yp2 - yp1) * (x2 - xp1);
                        if ((z1 ^ z2) >= 0) {
                            x = z1 + z2;
                        } else {
                            z1 = (x2 - x1) * (yp1 - y1) - (y2 - y1) * (xp1 - x1);
                            z2 = (x2 - x1) * (yp2 - y1) - (y2 - y1) * (xp2 - x1);
                            if ((z1 ^ z2) >= 0) {
                                x = -(z1 + z2);
                            } else if ((xp2 - xp1) * (tspr.y - yp1) == (tspr.x - xp1) * (yp2 - yp1)) {
                                x = Engine.wall[this.thewall[j]].nextsector == tspr.sectnum ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                            } else {
                                int y;
                                x = xp1 - Engine.globalposx + Pragmas.scale(xp2 - xp1, z1, z1 - z2);
                                yp1 = Pragmas.dmulscale(x, Engine.cosglobalang, y = yp1 - Engine.globalposy + Pragmas.scale(yp2 - yp1, z1, z1 - z2), Engine.singlobalang, 14);
                                if (yp1 > 0) {
                                    xp1 = Pragmas.dmulscale(y, Engine.cosglobalang, -x, Engine.singlobalang, 14);
                                    x = Engine.halfxdimen + Pragmas.scale(xp1, Engine.halfxdimen, yp1);
                                    if (xp1 >= 0) {
                                        ++x;
                                    }
                                    if (z1 < 0) {
                                        if (dalx2 < x) {
                                            dalx2 = x;
                                        }
                                    } else if (darx2 > x) {
                                        darx2 = x;
                                    }
                                    x = -2147483647;
                                } else {
                                    x = Integer.MAX_VALUE;
                                }
                            }
                        }
                    }
                    if (x >= 0) continue;
                    if (dalx2 < this.xb1[this.MAXWALLSB - 1]) {
                        dalx2 = this.xb1[this.MAXWALLSB - 1];
                    }
                    if (darx2 > this.xb2[this.MAXWALLSB - 1]) {
                        darx2 = this.xb2[this.MAXWALLSB - 1];
                    }
                    switch (this.smostwalltype[i]) {
                        case 0: {
                            int k;
                            if (dalx2 > darx2) continue block35;
                            if (dalx2 == this.xb1[this.MAXWALLSB - 1] && darx2 == this.xb2[this.MAXWALLSB - 1]) {
                                return;
                            }
                            for (k = dalx2; k <= darx2; ++k) {
                                this.dwall[k] = 0;
                            }
                            continue block35;
                        }
                        case 1: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] <= this.uwall[x]) continue;
                                this.uwall[x] = this.smost[k + x];
                            }
                            continue block35;
                        }
                        case 2: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] >= this.dwall[x]) continue;
                                this.dwall[x] = this.smost[k + x];
                            }
                            continue block35;
                        }
                    }
                }
                if ((cstat & 2) == 0) {
                    this.maskwallscan(this.xb1[this.MAXWALLSB - 1], this.xb2[this.MAXWALLSB - 1], this.uwall, this.dwall, this.swall, this.lwall);
                    break;
                }
                this.transmaskwallscan(this.xb1[this.MAXWALLSB - 1], this.xb2[this.MAXWALLSB - 1]);
                break;
            }
            case 2: {
                int x;
                int y;
                long yinc;
                int dax1;
                int dax2;
                long t;
                int zsgn;
                int zz;
                int z2;
                int z1;
                int z;
                if ((cstat & 0x40) != 0 && Engine.globalposz > tspr.z == ((cstat & 8) == 0)) {
                    return;
                }
                if ((cstat & 4) > 0) {
                    xoff = -xoff;
                }
                if ((cstat & 8) > 0) {
                    yoff = -yoff;
                }
                int xspan = pic.getWidth();
                int yspan = pic.getHeight();
                int dax = tspr.x - Engine.globalposx;
                int day = tspr.y - Engine.globalposy;
                this.rzi[0] = Pragmas.dmulscale(Engine.cosglobalang, dax, Engine.singlobalang, day, 10);
                this.rxi[0] = Pragmas.dmulscale(Engine.cosglobalang, day, -Engine.singlobalang, dax, 10);
                int i = tspr.ang + 2048 - (int)Engine.globalang & 0x7FF;
                short cosang = Engine.sintable[i + 512 & 0x7FF];
                short sinang = Engine.sintable[i];
                dax = ((xspan >> 1) + xoff) * tspr.xrepeat;
                day = ((yspan >> 1) + yoff) * tspr.yrepeat;
                this.rzi[0] = this.rzi[0] + Pragmas.dmulscale(sinang, dax, cosang, day, 12);
                this.rxi[0] = this.rxi[0] + Pragmas.dmulscale(sinang, day, -cosang, dax, 12);
                dax = xspan * tspr.xrepeat;
                day = yspan * tspr.yrepeat;
                this.rzi[1] = this.rzi[0] - Pragmas.mulscale(sinang, dax, 12);
                this.rxi[1] = this.rxi[0] + Pragmas.mulscale(cosang, dax, 12);
                dax = -Pragmas.mulscale(cosang, day, 12);
                day = -Pragmas.mulscale(sinang, day, 12);
                this.rzi[2] = this.rzi[1] + dax;
                this.rxi[2] = this.rxi[1] + day;
                this.rzi[3] = this.rzi[0] + dax;
                this.rxi[3] = this.rxi[0] + day;
                this.ryi[0] = Pragmas.scale(tspr.z - Engine.globalposz, Engine.yxaspect, 81920L);
                if (this.ryi[0] == 0) {
                    return;
                }
                this.ryi[2] = this.ryi[3] = this.ryi[0];
                this.ryi[1] = this.ryi[3];
                if ((cstat & 4) == 0) {
                    z = 0;
                    z1 = 1;
                    z2 = 3;
                } else {
                    z = 1;
                    z1 = 0;
                    z2 = 2;
                }
                dax = this.rzi[z1] - this.rzi[z];
                day = this.rxi[z1] - this.rxi[z];
                int bot = Pragmas.dmulscale(dax, dax, day, day, 8);
                if (Pragmas.klabs(dax) >> 13 >= bot || Pragmas.klabs(day) >> 13 >= bot) {
                    return;
                }
                this.globalx1 = Pragmas.divscale(dax, bot, 18);
                this.globalx2 = Pragmas.divscale(day, bot, 18);
                dax = this.rzi[z2] - this.rzi[z];
                day = this.rxi[z2] - this.rxi[z];
                bot = Pragmas.dmulscale(dax, dax, day, day, 8);
                if (Pragmas.klabs(dax) >> 13 >= bot || Pragmas.klabs(day) >> 13 >= bot) {
                    return;
                }
                this.globaly1 = Pragmas.divscale(dax, bot, 18);
                this.globaly2 = Pragmas.divscale(day, bot, 18);
                this.globalxpanning = this.rxi[z] << 12;
                this.globalypanning = this.rzi[z] << 12;
                this.globalzd = this.ryi[z] << 12;
                this.rzi[0] = Pragmas.mulscale(this.rzi[0], Engine.viewingrange, 16);
                this.rzi[1] = Pragmas.mulscale(this.rzi[1], Engine.viewingrange, 16);
                this.rzi[2] = Pragmas.mulscale(this.rzi[2], Engine.viewingrange, 16);
                this.rzi[3] = Pragmas.mulscale(this.rzi[3], Engine.viewingrange, 16);
                if (this.ryi[0] < 0) {
                    i = this.rxi[1];
                    this.rxi[1] = this.rxi[3];
                    this.rxi[3] = i;
                    i = this.rzi[1];
                    this.rzi[1] = this.rzi[3];
                    this.rzi[3] = i;
                }
                int npoints = 4;
                int npoints2 = 0;
                int zzsgn = this.rxi[0] + this.rzi[0];
                for (z = 0; z < npoints; ++z) {
                    zz = z + 1;
                    if (zz == npoints) {
                        zz = 0;
                    }
                    zsgn = zzsgn;
                    zzsgn = this.rxi[zz] + this.rzi[zz];
                    if (zsgn >= 0) {
                        this.rxi2[npoints2] = this.rxi[z];
                        this.ryi2[npoints2] = this.ryi[z];
                        this.rzi2[npoints2] = this.rzi[z];
                        ++npoints2;
                    }
                    if ((zsgn ^ zzsgn) >= 0) continue;
                    t = Pragmas.divscale(zsgn, zsgn - zzsgn, 30);
                    this.rxi2[npoints2] = this.rxi[z] + Pragmas.mulscale(t, this.rxi[zz] - this.rxi[z], 30);
                    this.ryi2[npoints2] = this.ryi[z] + Pragmas.mulscale(t, this.ryi[zz] - this.ryi[z], 30);
                    this.rzi2[npoints2] = this.rzi[z] + Pragmas.mulscale(t, this.rzi[zz] - this.rzi[z], 30);
                    ++npoints2;
                }
                if (npoints2 <= 2) {
                    return;
                }
                npoints = 0;
                zzsgn = this.rxi2[0] - this.rzi2[0];
                for (z = 0; z < npoints2; ++z) {
                    zz = z + 1;
                    if (zz == npoints2) {
                        zz = 0;
                    }
                    zsgn = zzsgn;
                    zzsgn = this.rxi2[zz] - this.rzi2[zz];
                    if (zsgn <= 0) {
                        this.rxi[npoints] = this.rxi2[z];
                        this.ryi[npoints] = this.ryi2[z];
                        this.rzi[npoints] = this.rzi2[z];
                        ++npoints;
                    }
                    if ((zsgn ^ zzsgn) >= 0) continue;
                    t = Pragmas.divscale(zsgn, zsgn - zzsgn, 30);
                    this.rxi[npoints] = this.rxi2[z] + Pragmas.mulscale(t, this.rxi2[zz] - this.rxi2[z], 30);
                    this.ryi[npoints] = this.ryi2[z] + Pragmas.mulscale(t, this.ryi2[zz] - this.ryi2[z], 30);
                    this.rzi[npoints] = this.rzi2[z] + Pragmas.mulscale(t, this.rzi2[zz] - this.rzi2[z], 30);
                    ++npoints;
                }
                if (npoints <= 2) {
                    return;
                }
                npoints2 = 0;
                zzsgn = this.ryi[0] * Engine.halfxdimen + this.rzi[0] * ((int)Engine.globalhoriz - 0);
                for (z = 0; z < npoints; ++z) {
                    zz = z + 1;
                    if (zz == npoints) {
                        zz = 0;
                    }
                    zsgn = zzsgn;
                    zzsgn = this.ryi[zz] * Engine.halfxdimen + this.rzi[zz] * (int)Engine.globalhoriz;
                    if (zsgn >= 0) {
                        this.rxi2[npoints2] = this.rxi[z];
                        this.ryi2[npoints2] = this.ryi[z];
                        this.rzi2[npoints2] = this.rzi[z];
                        ++npoints2;
                    }
                    if ((zsgn ^ zzsgn) >= 0) continue;
                    t = Pragmas.divscale(zsgn, zsgn - zzsgn, 30);
                    this.rxi2[npoints2] = this.rxi[z] + Pragmas.mulscale(t, this.rxi[zz] - this.rxi[z], 30);
                    this.ryi2[npoints2] = this.ryi[z] + Pragmas.mulscale(t, this.ryi[zz] - this.ryi[z], 30);
                    this.rzi2[npoints2] = this.rzi[z] + Pragmas.mulscale(t, this.rzi[zz] - this.rzi[z], 30);
                    ++npoints2;
                }
                if (npoints2 <= 2) {
                    return;
                }
                npoints = 0;
                zzsgn = this.ryi2[0] * Engine.halfxdimen + this.rzi2[0] * ((int)Engine.globalhoriz - Engine.ydimen);
                for (z = 0; z < npoints2; ++z) {
                    zz = z + 1;
                    if (zz == npoints2) {
                        zz = 0;
                    }
                    zsgn = zzsgn;
                    zzsgn = this.ryi2[zz] * Engine.halfxdimen + this.rzi2[zz] * ((int)Engine.globalhoriz - Engine.ydimen);
                    if (zsgn <= 0) {
                        this.rxi[npoints] = this.rxi2[z];
                        this.ryi[npoints] = this.ryi2[z];
                        this.rzi[npoints] = this.rzi2[z];
                        ++npoints;
                    }
                    if ((zsgn ^ zzsgn) >= 0) continue;
                    t = Pragmas.divscale(zsgn, zsgn - zzsgn, 30);
                    this.rxi[npoints] = this.rxi2[z] + Pragmas.mulscale(t, this.rxi2[zz] - this.rxi2[z], 30);
                    this.ryi[npoints] = this.ryi2[z] + Pragmas.mulscale(t, this.ryi2[zz] - this.ryi2[z], 30);
                    this.rzi[npoints] = this.rzi2[z] + Pragmas.mulscale(t, this.rzi2[zz] - this.rzi2[z], 30);
                    ++npoints;
                }
                if (npoints <= 2) {
                    return;
                }
                int lpoint = -1;
                long lmax = Integer.MAX_VALUE;
                int rpoint = -1;
                long rmax = Integer.MIN_VALUE;
                for (z = 0; z < npoints; ++z) {
                    if (this.rzi[z] == 0) continue;
                    this.xsi[z] = Pragmas.scale(this.rxi[z], Engine.xdimen << 15, this.rzi[z]) + (Engine.xdimen << 15);
                    this.ysi[z] = Pragmas.scale(this.ryi[z], Engine.xdimen << 15, this.rzi[z]) + ((int)Engine.globalhoriz << 16);
                    if (this.xsi[z] < 0) {
                        this.xsi[z] = 0;
                    }
                    if (this.xsi[z] > Engine.xdimen << 16) {
                        this.xsi[z] = Engine.xdimen << 16;
                    }
                    if (this.ysi[z] < 0) {
                        this.ysi[z] = 0;
                    }
                    if (this.ysi[z] > Engine.ydimen << 16) {
                        this.ysi[z] = Engine.ydimen << 16;
                    }
                    if ((long)this.xsi[z] < lmax) {
                        lmax = this.xsi[z];
                        lpoint = z;
                    }
                    if ((long)this.xsi[z] <= rmax) continue;
                    rmax = this.xsi[z];
                    rpoint = z;
                }
                z = lpoint;
                while (z != rpoint) {
                    zz = z + 1;
                    if (zz == npoints) {
                        zz = 0;
                    }
                    if ((dax2 = this.xsi[zz] + 65535 >> 16) > (dax1 = this.xsi[z] + 65535 >> 16)) {
                        yinc = Pragmas.divscale(this.ysi[zz] - this.ysi[z], this.xsi[zz] - this.xsi[z], 16);
                        y = this.ysi[z] + Pragmas.mulscale((dax1 << 16) - this.xsi[z], yinc, 16);
                        this.qinterpolatedown16short(this.uwall, dax1, dax2 - dax1, y, yinc);
                    }
                    z = zz;
                }
                while (z != lpoint) {
                    zz = z + 1;
                    if (zz == npoints) {
                        zz = 0;
                    }
                    if ((dax2 = this.xsi[z] + 65535 >> 16) > (dax1 = this.xsi[zz] + 65535 >> 16)) {
                        yinc = Pragmas.divscale(this.ysi[zz] - this.ysi[z], this.xsi[zz] - this.xsi[z], 16);
                        y = this.ysi[zz] + Pragmas.mulscale((dax1 << 16) - this.xsi[zz], yinc, 16);
                        this.qinterpolatedown16short(this.dwall, dax1, dax2 - dax1, y, yinc);
                    }
                    z = zz;
                }
                int lx = (int)(lmax + 65535L >> 16);
                int rx = (int)(rmax + 65535L >> 16);
                for (x = lx; x <= rx; ++x) {
                    this.uwall[x] = (short)Math.max(this.uwall[x], this.startumost[x + Engine.windowx1] - Engine.windowy1);
                    this.dwall[x] = (short)Math.min(this.dwall[x], this.startdmost[x + Engine.windowx1] - Engine.windowy1);
                }
                block47: for (i = this.smostwallcnt - 1; i >= 0; --i) {
                    int j = this.smostwall[i];
                    if (this.xb1[j] > rx || this.xb2[j] < lx || yp <= this.yb1[j] && yp <= this.yb2[j]) continue;
                    x = this.thewall[j];
                    int xp1 = Engine.wall[x].x;
                    int yp1 = Engine.wall[x].y;
                    x = Engine.wall[x].point2;
                    int xp2 = Engine.wall[x].x;
                    int yp2 = Engine.wall[x].y;
                    x = (xp2 - xp1) * (tspr.y - yp1) - (tspr.x - xp1) * (yp2 - yp1);
                    if (yp > this.yb1[j] && yp > this.yb2[j]) {
                        x = -1;
                    }
                    if (x >= 0 && (x != 0 || Engine.wall[this.thewall[j]].nextsector != tspr.sectnum)) continue;
                    int dalx2 = Math.max(this.xb1[j], lx);
                    int darx2 = Math.min(this.xb2[j], rx);
                    switch (this.smostwalltype[i]) {
                        case 0: {
                            if (dalx2 > darx2) continue block47;
                            if (dalx2 == lx && darx2 == rx) {
                                return;
                            }
                            for (x = dalx2; x <= darx2; ++x) {
                                this.dwall[x] = 0;
                            }
                            continue block47;
                        }
                        case 1: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] <= this.uwall[x]) continue;
                                this.uwall[x] = this.smost[k + x];
                            }
                            continue block47;
                        }
                        case 2: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] >= this.dwall[x]) continue;
                                this.dwall[x] = this.smost[k + x];
                            }
                            continue block47;
                        }
                    }
                }
                this.globalorientation = cstat;
                this.globalpicnum = (short)tilenum;
                if (this.globalpicnum >= Engine.MAXTILES) {
                    this.globalpicnum = 0;
                }
                if (pic.data == null) {
                    this.engine.loadtile(this.globalpicnum);
                }
                this.engine.setgotpic(this.globalpicnum);
                this.globalbufplc = pic.data;
                this.globvis = Pragmas.mulscale(this.globalhisibility, Engine.viewingrange, 16);
                if (sec.visibility != 0) {
                    this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                }
                x = Engine.picsiz[this.globalpicnum];
                y = x >> 4 & 0xF;
                if (Engine.pow2long[x &= 0xF] != xspan) {
                    this.globalx1 = Pragmas.mulscale(this.globalx1, xspan, ++x);
                    this.globalx2 = Pragmas.mulscale(this.globalx2, xspan, x);
                }
                dax = this.globalxpanning;
                day = this.globalypanning;
                this.globalxpanning = -Pragmas.dmulscale(this.globalx1, day, this.globalx2, dax, 6);
                this.globalypanning = -Pragmas.dmulscale(this.globaly1, day, this.globaly2, dax, 6);
                this.globalx2 = Pragmas.mulscale(this.globalx2, Engine.viewingrange, 16);
                this.globaly2 = Pragmas.mulscale(this.globaly2, Engine.viewingrange, 16);
                this.globalzd = Pragmas.mulscale(this.globalzd, Engine.viewingrangerecip, 16);
                this.globalx1 = (this.globalx1 - this.globalx2) * Engine.halfxdimen;
                this.globaly1 = (this.globaly1 - this.globaly2) * Engine.halfxdimen;
                if ((cstat & 2) == 0) {
                    this.a.msethlineshift(x, y);
                } else {
                    this.a.tsethlineshift(x, y);
                }
                this.ceilspritescan(lx, rx - 1);
                break;
            }
            case 3: {
                Spriteext sprext;
                int i;
                int x;
                xoff = tspr.xoffset;
                yoff = tspr.yoffset;
                if ((cstat & 8) > 0) {
                    yoff = -yoff;
                }
                int lx = 0;
                int rx = Engine.xdim - 1;
                for (x = lx; x <= rx; ++x) {
                    this.lwall[x] = this.startumost[x + Engine.windowx1] - Engine.windowy1;
                    this.swall[x] = this.startdmost[x + Engine.windowx1] - Engine.windowy1;
                }
                block52: for (i = this.smostwallcnt - 1; i >= 0; --i) {
                    int j = this.smostwall[i];
                    if (this.xb1[j] > rx || this.xb2[j] < lx || yp <= this.yb1[j] && yp <= this.yb2[j] || this.spritewallfront(tspr, this.thewall[j]) && (yp <= this.yb1[j] || yp <= this.yb2[j])) continue;
                    int dalx2 = Math.max(this.xb1[j], lx);
                    int darx2 = Math.min(this.xb2[j], rx);
                    switch (this.smostwalltype[i]) {
                        case 0: {
                            if (dalx2 > darx2) continue block52;
                            if (dalx2 == lx && darx2 == rx) {
                                return;
                            }
                            for (x = dalx2; x <= darx2; ++x) {
                                this.swall[x] = 0;
                            }
                            continue block52;
                        }
                        case 1: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] <= this.lwall[x]) continue;
                                this.lwall[x] = this.smost[k + x];
                            }
                            continue block52;
                        }
                        case 2: {
                            int k = this.smoststart[i] - this.xb1[j];
                            for (x = dalx2; x <= darx2; ++x) {
                                if (this.smost[k + x] >= this.swall[x]) continue;
                                this.swall[x] = this.smost[k + x];
                            }
                            continue block52;
                        }
                    }
                }
                if (this.lwall[rx] >= this.swall[rx]) {
                    for (x = lx; x < rx && this.lwall[x] >= this.swall[x]; ++x) {
                    }
                    if (x == rx) {
                        return;
                    }
                }
                if (vtilenum == null) break;
                long nyrepeat = vtilenum.getScale() == 65536.0f ? (long)(tspr.yrepeat << 16) : (long)((float)tspr.yrepeat * vtilenum.getScale());
                int xv = (int)((float)(tspr.xrepeat * Engine.sintable[tspr.ang + 2560 + 1536 & 0x7FF]) * (vtilenum.getScale() / 65536.0f));
                int yv = (int)((float)(tspr.xrepeat * Engine.sintable[tspr.ang + 2048 + 1536 & 0x7FF]) * (vtilenum.getScale() / 65536.0f));
                tspr.x = (int)((float)tspr.x - (float)Pragmas.mulscale(xoff, xv, 16) / 1.25f);
                tspr.y = (int)((float)tspr.y - (float)Pragmas.mulscale(xoff, yv, 16) / 1.25f);
                tspr.z -= Pragmas.mulscale(yoff, nyrepeat, 14);
                if ((cstat & 0x80) == 0) {
                    tspr.z -= Pragmas.mulscale(vtilenum.getData().zpiv[0], nyrepeat, 22);
                }
                if ((cstat & 8) != 0 && (cstat & 0x10) != 0) {
                    tspr.z += Pragmas.mulscale(pic.getHeight() / 2 - vtilenum.getData().zpiv[0], nyrepeat, 36);
                }
                this.globvis = Engine.globalvisibility;
                this.globalorientation = cstat;
                if (sec.visibility != 0) {
                    this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
                }
                i = tspr.ang + 1536;
                if (vtilenum.isRotating()) {
                    i -= 5 * Engine.totalclock & 0x7FF;
                }
                if ((sprext = this.defs.mapInfo.getSpriteInfo(tspr.owner)) != null) {
                    i += sprext.angoff;
                }
                float f = 1.0f;
                if ((Engine.sprite[tspr.owner].cstat & 0x30) == 16 || (Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
                    f *= 1.25f;
                }
                this.voxdraw(tspr, i, (int)((float)tspr.xrepeat * f), tspr.yrepeat, vtilenum, this.lwall, this.swall);
            }
        }
        if (Engine.automapping == 1) {
            int n = spritenum >> 3;
            Engine.show2dsprite[n] = (byte)(Engine.show2dsprite[n] | Engine.pow2char[spritenum & 7]);
        }
    }

    protected void kloadvoxel(int voxindex) {
    }

    private void voxdraw(SPRITE daspr, int dasprang, int daxscale, int dayscale, VoxelInfo daindex, int[] daumost, int[] dadmost) {
        int i;
        int k;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int yinc = 0;
        int xs = 0;
        int ys = 0;
        int xi = 0;
        int yi = 0;
        int dasprx = daspr.x;
        int daspry = daspr.y;
        int dasprz = daspr.z;
        byte dashade = daspr.shade;
        short dapal = daspr.pal;
        SECTOR sec = Engine.sector[daspr.sectnum];
        int cosang = Engine.sintable[(int)(Engine.globalang + 512.0f) & 0x7FF];
        int sinang = Engine.sintable[(int)Engine.globalang & 0x7FF];
        int sprcosang = Engine.sintable[dasprang + 512 & 0x7FF];
        int sprsinang = Engine.sintable[dasprang & 0x7FF];
        int mip = Pragmas.klabs(Pragmas.dmulscale(dasprx - Engine.globalposx, cosang, daspry - Engine.globalposy, sinang, 6));
        int j = this.engine.getpalookup(Pragmas.mulscale(this.globvis, mip, 21), dashade) << 8;
        int trans = 0;
        if ((this.globalorientation & 2) != 0) {
            trans = (this.globalorientation & 0x200) != 0 ? 2 : 1;
        }
        this.a.setupdrawslab(this.ylookup[1], Engine.palookup[dapal], j, trans);
        if (!this.novoxmips) {
            j = 0x140000;
            j *= Math.min(daxscale, dayscale);
            j >>= 6;
            for (k = 0; k < 5; ++k) {
                if (mip < j) {
                    mip = k;
                    break;
                }
                j <<= 1;
            }
            if (k >= 5) {
                mip = 4;
            }
        } else {
            mip = 0;
        }
        VoxelData davox = daindex.getData();
        int scale = (int)daindex.getScale();
        if (davox == null) {
            return;
        }
        if (davox.data[mip] == null && mip > 0) {
            mip = 0;
        }
        if (scale == 65536) {
            daxscale <<= mip + 8;
            dayscale <<= mip + 8;
        } else {
            daxscale = Pragmas.mulscale(daxscale << mip, scale, 8);
            dayscale = Pragmas.mulscale(dayscale << mip, scale, 8);
        }
        int odayscale = dayscale;
        daxscale = Pragmas.mulscale(daxscale, Engine.xyaspect, 16);
        daxscale = Pragmas.scale(daxscale, Engine.xdimenscale, Engine.xdimen << 8);
        dayscale = Pragmas.scale(dayscale, Pragmas.mulscale(Engine.xdimenscale, Engine.viewingrangerecip, 16), Engine.xdimen << 8);
        if (daxscale == 0 || dayscale == 0) {
            return;
        }
        int daxscalerecip = 0x40000000 / daxscale;
        int dayscalerecip = 0x40000000 / dayscale;
        int daxsiz = davox.xsiz[mip];
        int daysiz = davox.ysiz[mip];
        int daxpivot = davox.xpiv[mip];
        int daypivot = davox.ypiv[mip];
        int dazpivot = davox.zpiv[mip];
        int x = Pragmas.mulscale(Engine.globalposx - dasprx, daxscalerecip, 16);
        int y = Pragmas.mulscale(Engine.globalposy - daspry, daxscalerecip, 16);
        int backx = Pragmas.dmulscale(x, sprcosang, y, sprsinang, 10) + daxpivot >> 8;
        int backy = Pragmas.dmulscale(y, sprcosang, x, -sprsinang, 10) + daypivot >> 8;
        int cbackx = Math.min(Math.max(backx, 0), daxsiz - 1);
        int cbacky = Math.min(Math.max(backy, 0), daysiz - 1);
        sprcosang = Pragmas.mulscale(daxscale, sprcosang, 14);
        sprsinang = Pragmas.mulscale(daxscale, sprsinang, 14);
        x = dasprx - Engine.globalposx - Pragmas.dmulscale(daxpivot, sprcosang, daypivot, -sprsinang, 18);
        y = daspry - Engine.globalposy - Pragmas.dmulscale(daypivot, sprcosang, daxpivot, sprsinang, 18);
        cosang = Pragmas.mulscale(cosang, dayscalerecip, 16);
        sinang = Pragmas.mulscale(sinang, dayscalerecip, 16);
        int gxstart = y * cosang - x * sinang;
        int gystart = x * cosang + y * sinang;
        int gxinc = Pragmas.dmulscale(sprsinang, cosang, sprcosang, -sinang, 10);
        int gyinc = Pragmas.dmulscale(sprcosang, cosang, sprsinang, sinang, 10);
        x = 0;
        y = 0;
        j = Math.max(daxsiz, daysiz);
        for (i = 0; i <= j; ++i) {
            this.ggxinc[i] = x;
            x += gxinc;
            this.ggyinc[i] = y;
            y += gyinc;
        }
        if (Pragmas.klabs(Engine.globalposz - dasprz) >> 10 >= Pragmas.klabs(odayscale)) {
            return;
        }
        int syoff = Pragmas.divscale(Engine.globalposz - dasprz, odayscale, 21) + (dazpivot << 7);
        int yoff = Pragmas.klabs(gxinc) + Pragmas.klabs(gyinc) >> 1;
        boolean xflip = (this.globalorientation & 4) != 0;
        boolean yflip = (this.globalorientation & 8) != 0;
        int dazsiz = davox.zsiz[mip];
        int dm = Pragmas.divscale(sec.floorz - Engine.globalposz, odayscale, 21);
        int um = Pragmas.divscale(sec.ceilingz - Engine.globalposz, odayscale, 21);
        for (int cnt = 0; cnt < 8; ++cnt) {
            int dagyinc;
            int dagxinc;
            switch (cnt) {
                case 0: {
                    xs = 0;
                    ys = 0;
                    xi = 1;
                    yi = 1;
                    break;
                }
                case 1: {
                    xs = daxsiz - 1;
                    ys = 0;
                    xi = -1;
                    yi = 1;
                    break;
                }
                case 2: {
                    xs = 0;
                    ys = daysiz - 1;
                    xi = 1;
                    yi = -1;
                    break;
                }
                case 3: {
                    xs = daxsiz - 1;
                    ys = daysiz - 1;
                    xi = -1;
                    yi = -1;
                    break;
                }
                case 4: {
                    xs = 0;
                    ys = cbacky;
                    xi = 1;
                    yi = 2;
                    break;
                }
                case 5: {
                    xs = daxsiz - 1;
                    ys = cbacky;
                    xi = -1;
                    yi = 2;
                    break;
                }
                case 6: {
                    xs = cbackx;
                    ys = 0;
                    xi = 2;
                    yi = 1;
                    break;
                }
                case 7: {
                    xs = cbackx;
                    ys = daysiz - 1;
                    xi = 2;
                    yi = -1;
                }
            }
            int xe = cbackx;
            int ye = cbacky;
            if (cnt < 4) {
                if (xi < 0 && xe >= xs || xi > 0 && xe <= xs || yi < 0 && ye >= ys || yi > 0 && ye <= ys) {
                    continue;
                }
            } else {
                if (xi < 0 && xe > xs || xi > 0 && xe < xs || yi < 0 && ye > ys || yi > 0 && ye < ys) continue;
                xe += xi;
                ye += yi;
            }
            i = Pragmas.ksgn(ys - backy) + Pragmas.ksgn(xs - backx) * 3 + 4;
            switch (i) {
                case 6: 
                case 7: {
                    x1 = 0;
                    y1 = 0;
                    break;
                }
                case 5: 
                case 8: {
                    x1 = gxinc;
                    y1 = gyinc;
                    break;
                }
                case 0: 
                case 3: {
                    x1 = gyinc;
                    y1 = -gxinc;
                    break;
                }
                case 1: 
                case 2: {
                    x1 = gxinc + gyinc;
                    y1 = gyinc - gxinc;
                }
            }
            switch (i) {
                case 2: 
                case 5: {
                    x2 = 0;
                    y2 = 0;
                    break;
                }
                case 0: 
                case 1: {
                    x2 = gxinc;
                    y2 = gyinc;
                    break;
                }
                case 7: 
                case 8: {
                    x2 = gyinc;
                    y2 = -gxinc;
                    break;
                }
                case 3: 
                case 6: {
                    x2 = gxinc + gyinc;
                    y2 = gyinc - gxinc;
                }
            }
            short oand = (short)(Engine.pow2char[(xs < backx ? 1 : 0) + 0] + Engine.pow2char[(ys < backy ? 1 : 0) + 2]);
            if (xflip) {
                oand = (short)(oand ^ 3);
            }
            short oand16 = (short)(oand + 16);
            short oand32 = (short)(oand + 32);
            if (yflip) {
                oand16 = (short)(oand + 32);
                oand32 = (short)(oand + 16);
            }
            if (yi > 0) {
                dagxinc = gxinc;
                dagyinc = Pragmas.mulscale(gyinc, Engine.viewingrangerecip, 16);
            } else {
                dagxinc = -gxinc;
                dagyinc = -Pragmas.mulscale(gyinc, Engine.viewingrangerecip, 16);
            }
            int nxoff = Pragmas.mulscale(x2 - x1, Engine.viewingrangerecip, 16);
            x1 = Pragmas.mulscale(x1, Engine.viewingrangerecip, 16);
            int ggxstart = gxstart + this.ggyinc[ys];
            int ggystart = gystart - this.ggxinc[ys];
            for (x = xs; x != xe; x += xi) {
                int xptr = xflip ? daxsiz - 1 - x : x;
                int slabxoffs = davox.slabxoffs[mip][xptr];
                short[] shortptr = davox.xyoffs[mip][xptr];
                int nx = Pragmas.mulscale(ggxstart + this.ggxinc[x], Engine.viewingrangerecip, 16) + x1;
                int ny = ggystart + this.ggyinc[x];
                y = ys;
                while (y != ye) {
                    block64: {
                        int rx;
                        int voxend;
                        int voxptr;
                        if (ny <= this.nytooclose || ny >= this.nytoofar || (voxptr = slabxoffs + shortptr[y]) == (voxend = slabxoffs + shortptr[y + 1]) || ny + y1 < 0 || ny + y2 < 0) break block64;
                        int lx = Pragmas.mulscale(nx >> 3, this.distrecip[ny + y1 >> 14], 32) + Engine.halfxdimen;
                        if (lx < 0) {
                            lx = 0;
                        }
                        if ((rx = Pragmas.mulscale(nx + nxoff >> 3, this.distrecip[ny + y2 >> 14], 32) + Engine.halfxdimen) > Engine.xdimen) {
                            rx = Engine.xdimen;
                        }
                        if (rx <= lx) break block64;
                        rx -= lx;
                        int l1 = this.distrecip[ny - yoff >> 14];
                        int l2 = this.distrecip[ny + yoff >> 14];
                        int umz = 0;
                        if ((sec.ceilingstat & 3) == 0) {
                            umz = Pragmas.mulscale(um < 0 ? (long)l1 : (long)l2, um, 32) + (int)Engine.globalhoriz;
                        }
                        int dmz = Integer.MAX_VALUE;
                        if ((sec.floorstat & 3) == 0) {
                            dmz = Pragmas.mulscale(dm < 0 ? (long)l2 : (long)l1, dm, 32) + (int)Engine.globalhoriz;
                        }
                        while (voxptr < voxend) {
                            int zleng;
                            block67: {
                                int yplc;
                                int z1;
                                int z2;
                                block69: {
                                    block65: {
                                        block68: {
                                            block66: {
                                                zleng = davox.data[mip][voxptr + 1] & 0xFF;
                                                j = yflip ? (dazsiz - (davox.data[mip][voxptr] & 0xFF) - zleng << 15) - syoff : ((davox.data[mip][voxptr] & 0xFF) << 15) - syoff;
                                                if (j >= 0) break block65;
                                                k = j + (zleng << 15);
                                                if (k >= 0) break block66;
                                                if ((davox.data[mip][voxptr + 2] & oand32) == 0) break block67;
                                                z2 = Pragmas.mulscale(l2, k, 32) + (int)Engine.globalhoriz;
                                                break block68;
                                            }
                                            if ((davox.data[mip][voxptr + 2] & oand) == 0) break block67;
                                            z2 = Pragmas.mulscale(l1, k, 32) + (int)Engine.globalhoriz;
                                        }
                                        z1 = Pragmas.mulscale(l1, j, 32) + (int)Engine.globalhoriz;
                                        break block69;
                                    }
                                    if ((davox.data[mip][voxptr + 2] & oand16) == 0) break block67;
                                    z1 = Pragmas.mulscale(l2, j, 32) + (int)Engine.globalhoriz;
                                    z2 = Pragmas.mulscale(l1, j + (zleng << 15), 32) + (int)Engine.globalhoriz;
                                }
                                int umost = Math.max(daumost[lx], umz);
                                int dmost = Math.min(dadmost[lx], dmz);
                                if (zleng == 1) {
                                    yplc = 0;
                                    yinc = 0;
                                    if (z1 < umost) {
                                        z1 = umost;
                                    }
                                } else {
                                    if (z2 - z1 >= 1024) {
                                        yinc = Pragmas.divscale(zleng, z2 - z1, 16);
                                    } else if (z2 > z1) {
                                        yinc = this.lowrecip[z2 - z1] * zleng >> 8;
                                    }
                                    if (z1 < umost) {
                                        yplc = yinc * (umost - z1);
                                        z1 = umost;
                                    } else {
                                        yplc = 0;
                                    }
                                    if (yflip) {
                                        yinc = -yinc;
                                        yplc = (zleng << 16) - yplc + yinc;
                                    }
                                }
                                if (z2 > dmost) {
                                    z2 = dmost;
                                }
                                if ((z2 -= z1) > 0) {
                                    this.a.drawslab(rx, yplc, z2, yinc, davox.data[mip], voxptr + 3, this.ylookup[z1] + lx + this.frameoffset);
                                }
                            }
                            voxptr += zleng + 3;
                        }
                    }
                    y += yi;
                    nx += dagyinc;
                    ny -= dagxinc;
                }
            }
        }
    }

    private void drawmaskwall(int damaskwallcnt) {
        int x;
        int z = this.maskwall[damaskwallcnt];
        WALL wal = Engine.wall[this.thewall[z]];
        short sectnum = this.thesector[z];
        SECTOR sec = Engine.sector[sectnum];
        SECTOR nsec = Engine.sector[wal.nextsector];
        int z1 = Math.max(nsec.ceilingz, sec.ceilingz);
        int z2 = Math.min(nsec.floorz, sec.floorz);
        this.wallmost(this.uwall, z, sectnum, 0);
        this.wallmost(this.uplc, z, wal.nextsector, 0);
        for (x = this.xb1[z]; x <= this.xb2[z]; ++x) {
            if (this.uplc[x] <= this.uwall[x]) continue;
            this.uwall[x] = this.uplc[x];
        }
        this.wallmost(this.dwall, z, sectnum, 1);
        this.wallmost(this.dplc, z, wal.nextsector, 1);
        for (x = this.xb1[z]; x <= this.xb2[z]; ++x) {
            if (this.dplc[x] >= this.dwall[x]) continue;
            this.dwall[x] = this.dplc[x];
        }
        this.prepwall(z, wal);
        this.globalorientation = wal.cstat;
        this.globalpicnum = wal.overpicnum;
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        this.globalxpanning = wal.xpanning & 0xFF;
        this.globalypanning = wal.ypanning & 0xFF;
        Tile pic = this.engine.getTile(this.globalpicnum);
        if (pic.getType() != Tile.AnimType.None) {
            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, this.thewall[z] + 16384));
            pic = this.engine.getTile(this.globalpicnum);
        }
        Engine.globalshade = wal.shade;
        this.globvis = Engine.globalvisibility;
        if (sec.visibility != 0) {
            this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
        }
        Engine.globalpal = wal.pal;
        this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
        if (Engine.pow2long[this.globalshiftval] != pic.getHeight()) {
            this.globalshiftval = (short)(this.globalshiftval + 1);
        }
        this.globalshiftval = (short)(32 - this.globalshiftval);
        this.globalyscale = wal.yrepeat << this.globalshiftval - 19;
        this.globalzd = (this.globalorientation & 4) == 0 ? (Engine.globalposz - z1) * this.globalyscale << 8 : (Engine.globalposz - z2) * this.globalyscale << 8;
        this.globalzd += this.globalypanning << 24;
        if ((this.globalorientation & 0x100) != 0) {
            this.globalyscale = -this.globalyscale;
            this.globalzd = -this.globalzd;
        }
        block7: for (int i = this.smostwallcnt - 1; i >= 0; --i) {
            int j = this.smostwall[i];
            if (this.xb1[j] > this.xb2[z] || this.xb2[j] < this.xb1[z] || this.wallfront(j, z) != 0) continue;
            int lx = Math.max(this.xb1[j], this.xb1[z]);
            int rx = Math.min(this.xb2[j], this.xb2[z]);
            switch (this.smostwalltype[i]) {
                case 0: {
                    if (lx > rx) continue block7;
                    if (lx == this.xb1[z] && rx == this.xb2[z]) {
                        return;
                    }
                    for (x = lx; x <= rx; ++x) {
                        this.dwall[x] = 0;
                    }
                    continue block7;
                }
                case 1: {
                    int k = this.smoststart[i] - this.xb1[j];
                    for (x = lx; x <= rx; ++x) {
                        if (this.smost[k + x] <= this.uwall[x]) continue;
                        this.uwall[x] = this.smost[k + x];
                    }
                    continue block7;
                }
                case 2: {
                    int k = this.smoststart[i] - this.xb1[j];
                    for (x = lx; x <= rx; ++x) {
                        if (this.smost[k + x] >= this.dwall[x]) continue;
                        this.dwall[x] = this.smost[k + x];
                    }
                    continue block7;
                }
            }
        }
        if ((this.globalorientation & 0x80) == 0) {
            this.maskwallscan(this.xb1[z], this.xb2[z], this.uwall, this.dwall, this.swall, this.lwall);
        } else {
            if ((this.globalorientation & 0x80) != 0) {
                if ((this.globalorientation & 0x200) != 0) {
                    this.a.settransreverse();
                } else {
                    this.a.settransnormal();
                }
            }
            this.transmaskwallscan(this.xb1[z], this.xb2[z]);
        }
    }

    private void transmaskwallscan(int x1, int x2) {
        int x;
        this.engine.setgotpic(this.globalpicnum);
        Tile pic = this.engine.getTile(this.globalpicnum);
        if (!pic.hasSize()) {
            return;
        }
        if (pic.data == null) {
            this.engine.loadtile(this.globalpicnum);
        }
        this.a.setuptvlineasm(this.globalshiftval);
        for (x = x1; this.startumost[x + Engine.windowx1] > this.startdmost[x + Engine.windowx1] && x <= x2; ++x) {
        }
        while (x <= x2) {
            this.transmaskvline(x);
            ++x;
        }
    }

    private void transmaskvline(int x) {
        if (x < 0 || x >= Engine.xdimen) {
            return;
        }
        int y1v = Math.max(this.uwall[x], this.startumost[x + Engine.windowx1] - Engine.windowy1);
        int y2v = Math.min(this.dwall[x], this.startdmost[x + Engine.windowx1] - Engine.windowy1);
        if (--y2v < y1v) {
            return;
        }
        int vinc = this.swall[x] * this.globalyscale;
        int vplc = this.globalzd + vinc * (y1v - (int)Engine.globalhoriz + 1);
        int i = this.lwall[x] + this.globalxpanning;
        Tile pic = this.engine.getTile(this.globalpicnum);
        if (i >= pic.getWidth()) {
            i %= pic.getWidth();
        }
        byte[] bufplc = pic.data;
        int bufoffs = i * pic.getHeight();
        int p = this.ylookup[y1v] + x + this.frameoffset;
        this.a.tvlineasm1(vinc, Engine.palookup[Engine.globalpal], this.engine.getpalookup(Pragmas.mulscale(this.swall[x], this.globvis, 16), Engine.globalshade) << 8, y2v - y1v, vplc, bufplc, bufoffs, p);
    }

    private void prepwall(int z, WALL wal) {
        int l = 0;
        int ol = 0;
        int walxrepeat = wal.xrepeat << 3;
        int i = this.xb1[z] - Engine.halfxdimen;
        int topinc = -(this.ry1[z] >> 2);
        int botinc = this.ry2[z] - this.ry1[z] >> 8;
        int top = Pragmas.mulscale(this.rx1[z], Engine.xdimen, 5) + Pragmas.mulscale(topinc, i, 2);
        int bot = Pragmas.mulscale(this.rx1[z] - this.rx2[z], Engine.xdimen, 11) + Pragmas.mulscale(botinc, i, 2);
        int splc = Pragmas.mulscale(this.ry1[z], Engine.xdimscale, 19);
        int sinc = Pragmas.mulscale(this.ry2[z] - this.ry1[z], Engine.xdimscale, 16);
        int x = this.xb1[z];
        if (bot != 0) {
            l = Pragmas.divscale(top, bot, 12);
            this.swall[x] = Pragmas.mulscale(l, sinc, 21) + splc;
            this.lwall[x] = (l *= walxrepeat) >> 18;
        }
        while (x + 4 <= this.xb2[z]) {
            top += topinc;
            if ((bot += botinc) != 0) {
                ol = l;
                l = Pragmas.divscale(top, bot, 12);
                this.swall[x + 4] = Pragmas.mulscale(l, sinc, 21) + splc;
                this.lwall[x + 4] = (l *= walxrepeat) >> 18;
            }
            i = ol + l >> 1;
            this.lwall[x + 2] = i >> 18;
            this.lwall[x + 1] = ol + i >> 19;
            this.lwall[x + 3] = l + i >> 19;
            this.swall[x + 2] = this.swall[x] + this.swall[x + 4] >> 1;
            this.swall[x + 1] = this.swall[x] + this.swall[x + 2] >> 1;
            this.swall[x + 3] = this.swall[x + 4] + this.swall[x + 2] >> 1;
            x += 4;
        }
        if (x + 2 <= this.xb2[z]) {
            top += topinc >> 1;
            if ((bot += botinc >> 1) != 0) {
                ol = l;
                l = Pragmas.divscale(top, bot, 12);
                this.swall[x + 2] = Pragmas.mulscale(l, sinc, 21) + splc;
                this.lwall[x + 2] = (l *= walxrepeat) >> 18;
            }
            this.lwall[x + 1] = l + ol >> 19;
            this.swall[x + 1] = this.swall[x] + this.swall[x + 2] >> 1;
            x += 2;
        }
        if (x + 1 <= this.xb2[z] && (bot += botinc >> 2) != 0) {
            l = Pragmas.divscale(top + (topinc >> 2), bot, 12);
            this.swall[x + 1] = Pragmas.mulscale(l, sinc, 21) + splc;
            this.lwall[x + 1] = Pragmas.mulscale(l, walxrepeat, 18);
        }
        if (this.lwall[this.xb1[z]] < 0) {
            this.lwall[this.xb1[z]] = 0;
        }
        if (this.lwall[this.xb2[z]] >= walxrepeat && walxrepeat != 0) {
            this.lwall[this.xb2[z]] = walxrepeat - 1;
        }
        if ((wal.cstat & 8) != 0) {
            --walxrepeat;
            for (x = this.xb1[z]; x <= this.xb2[z]; ++x) {
                this.lwall[x] = walxrepeat - this.lwall[x];
            }
        }
    }

    private void maskwallscan(int x1, int x2, short[] uwal, short[] dwal, int[] swal, int[] lwal) {
        int bufplce;
        boolean ynice;
        boolean xnice;
        Tile pic = this.engine.getTile(this.globalpicnum);
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        this.engine.setgotpic(this.globalpicnum);
        if (!pic.hasSize()) {
            return;
        }
        if (uwal[x1] > Engine.ydimen && uwal[x2] > Engine.ydimen) {
            return;
        }
        if (dwal[x1] < 0 && dwal[x2] < 0) {
            return;
        }
        if (pic.data == null) {
            this.engine.loadtile(this.globalpicnum);
        }
        int startx = x1;
        boolean bl = xnice = Engine.pow2long[Engine.picsiz[this.globalpicnum] & 0xF] == tsizx;
        if (xnice) {
            --tsizx;
        }
        boolean bl2 = ynice = Engine.pow2long[Engine.picsiz[this.globalpicnum] >> 4] == tsizy;
        if (ynice) {
            tsizy = Engine.picsiz[this.globalpicnum] >> 4;
        }
        this.a.setupmvlineasm(this.globalshiftval);
        for (int x = startx; x <= x2 && (bufplce = lwal[x] + this.globalxpanning) >= 0; ++x) {
            int y1ve = Math.max(uwal[x], this.startumost[x + Engine.windowx1] - Engine.windowy1);
            int y2ve = Math.min(dwal[x], this.startdmost[x + Engine.windowx1] - Engine.windowy1);
            if (y2ve <= y1ve) continue;
            int shade = this.engine.getpalookup(Pragmas.mulscale(swal[x], this.globvis, 16), Engine.globalshade) << 8;
            if (bufplce >= tsizx) {
                bufplce = !xnice ? (bufplce %= tsizx) : (bufplce &= tsizx);
            }
            bufplce = !ynice ? (bufplce *= tsizy) : (bufplce <<= tsizy);
            int vince = swal[x] * this.globalyscale;
            int vplce = this.globalzd + vince * (y1ve - (int)Engine.globalhoriz + 1);
            int cnt = y2ve - y1ve - 1;
            this.a.mvlineasm1(vince, Engine.palookup[Engine.globalpal], shade, cnt, vplce, pic.data, bufplce, x + this.frameoffset + this.ylookup[y1ve]);
        }
    }

    private void wallscan(int x1, int x2, short[] uwal, short[] dwal, int[] swal, int[] lwal) {
        boolean ynice;
        boolean xnice;
        int fpalookup = 0;
        Tile pic = this.engine.getTile(this.globalpicnum);
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        this.engine.setgotpic(this.globalpicnum);
        if (!pic.hasSize()) {
            return;
        }
        if (x1 >= uwal.length || x2 >= uwal.length || uwal[x1] > Engine.ydimen && uwal[x2] > Engine.ydimen) {
            return;
        }
        if (x1 >= dwal.length || x2 >= dwal.length || dwal[x1] < 0 && dwal[x2] < 0) {
            return;
        }
        if (pic.data == null) {
            this.engine.loadtile(this.globalpicnum);
        }
        boolean bl = xnice = Engine.pow2long[Engine.picsiz[this.globalpicnum] & 0xF] == tsizx;
        if (xnice) {
            --tsizx;
        }
        boolean bl2 = ynice = Engine.pow2long[Engine.picsiz[this.globalpicnum] >> 4] == tsizy;
        if (ynice) {
            tsizy = Engine.picsiz[this.globalpicnum] >> 4;
        }
        fpalookup = Engine.globalpal;
        this.a.setupvlineasm(this.globalshiftval);
        for (int x = x1; x <= x2; ++x) {
            int y1ve = Math.max(uwal[x], this.umost[x]);
            int y2ve = Math.min(dwal[x], this.dmost[x]);
            if (y2ve <= y1ve) continue;
            int shade = this.engine.getpalookup(Pragmas.mulscale(swal[x], this.globvis, 16), Engine.globalshade) << 8;
            int bufplce = lwal[x] + this.globalxpanning;
            if (bufplce >= tsizx) {
                bufplce = !xnice ? (bufplce %= tsizx) : (bufplce &= tsizx);
            }
            bufplce = !ynice ? (bufplce *= tsizy) : (bufplce <<= tsizy);
            int vince = swal[x] * this.globalyscale;
            int vplce = this.globalzd + vince * (y1ve - (int)Engine.globalhoriz + 1);
            this.a.vlineasm1(vince, Engine.palookup[fpalookup], shade, y2ve - y1ve - 1, vplce, pic.data, bufplce, x + this.frameoffset + this.ylookup[y1ve]);
        }
    }

    private void florscan(int x1, int x2, int sectnum) {
        int y1;
        int i;
        SECTOR sec = Engine.sector[sectnum];
        if (sec.floorpal != this.globalpalwritten) {
            this.globalpalwritten = sec.floorpal;
            this.a.setpalookupaddress(Engine.palookup[this.globalpalwritten]);
        }
        this.globalzd = Engine.globalposz - sec.floorz;
        if (this.globalzd > 0) {
            return;
        }
        this.globalpicnum = sec.floorpicnum;
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        this.engine.setgotpic(this.globalpicnum);
        Tile pic = this.engine.getTile(this.globalpicnum);
        if (!pic.hasSize()) {
            return;
        }
        if (pic.getType() != Tile.AnimType.None) {
            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, sectnum));
            pic = this.engine.getTile(this.globalpicnum);
        }
        if (pic.data == null) {
            this.engine.loadtile(this.globalpicnum);
        }
        this.globalbufplc = pic.data;
        Engine.globalshade = sec.floorshade;
        this.globvis = this.globalcisibility;
        if (sec.visibility != 0) {
            this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
        }
        this.globalorientation = sec.floorstat;
        if ((this.globalorientation & 0x40) == 0) {
            this.globalx1 = Engine.singlobalang;
            this.globalx2 = Engine.singlobalang;
            this.globaly1 = Engine.cosglobalang;
            this.globaly2 = Engine.cosglobalang;
            this.globalxpanning = Engine.globalposx << 20;
            this.globalypanning = -(Engine.globalposy << 20);
        } else {
            int j = sec.wallptr;
            int ox = Engine.wall[Engine.wall[j].point2].x - Engine.wall[j].x;
            int oy = Engine.wall[Engine.wall[j].point2].y - Engine.wall[j].y;
            i = this.engine.ksqrt(ox * ox + oy * oy);
            i = i == 0 ? 1024 : 0x100000 / i;
            this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, Engine.singlobalang, -oy, Engine.cosglobalang, 10), i, 10);
            this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, Engine.cosglobalang, oy, Engine.singlobalang, 10), i, 10);
            this.globalx2 = -this.globalx1;
            this.globaly2 = -this.globaly1;
            ox = Engine.wall[j].x - Engine.globalposx << 6;
            oy = Engine.wall[j].y - Engine.globalposy << 6;
            i = Pragmas.dmulscale(oy, Engine.cosglobalang, -ox, Engine.singlobalang, 14);
            j = Pragmas.dmulscale(ox, Engine.cosglobalang, oy, Engine.singlobalang, 14);
            ox = i;
            oy = j;
            this.globalxpanning = this.globalx1 * ox - this.globaly1 * oy;
            this.globalypanning = this.globaly2 * ox + this.globalx2 * oy;
        }
        this.globalx2 = Pragmas.mulscale(this.globalx2, Engine.viewingrangerecip, 16);
        this.globaly1 = Pragmas.mulscale(this.globaly1, Engine.viewingrangerecip, 16);
        this.globalxshift = (byte)(8 - (Engine.picsiz[this.globalpicnum] & 0xF));
        this.globalyshift = (byte)(8 - (Engine.picsiz[this.globalpicnum] >> 4));
        if ((this.globalorientation & 8) != 0) {
            this.globalxshift = (byte)(this.globalxshift + 1);
            this.globalyshift = (byte)(this.globalyshift + 1);
        }
        if ((this.globalorientation & 4) > 0) {
            i = this.globalxpanning;
            this.globalxpanning = this.globalypanning;
            this.globalypanning = i;
            i = this.globalx2;
            this.globalx2 = -this.globaly1;
            this.globaly1 = -i;
            i = this.globalx1;
            this.globalx1 = this.globaly2;
            this.globaly2 = i;
        }
        if ((this.globalorientation & 0x10) > 0) {
            this.globalx1 = -this.globalx1;
            this.globaly1 = -this.globaly1;
            this.globalxpanning = -this.globalxpanning;
        }
        if ((this.globalorientation & 0x20) > 0) {
            this.globalx2 = -this.globalx2;
            this.globaly2 = -this.globaly2;
            this.globalypanning = -this.globalypanning;
        }
        this.globalx1 <<= this.globalxshift;
        this.globaly1 <<= this.globalxshift;
        this.globalx2 <<= this.globalyshift;
        this.globaly2 <<= this.globalyshift;
        this.globalxpanning <<= this.globalxshift;
        this.globalypanning <<= this.globalyshift;
        this.globalxpanning += sec.floorxpanning << 24;
        this.globalypanning += sec.floorypanning << 24;
        this.globaly1 = (-this.globalx1 - this.globaly1) * Engine.halfxdimen;
        this.globalx2 = (this.globalx2 - this.globaly2) * Engine.halfxdimen;
        this.a.sethlinesizes(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4, this.globalbufplc);
        this.globalx2 += this.globaly2 * (x1 - 1);
        this.globaly1 += this.globalx1 * (x1 - 1);
        this.globalx1 = Pragmas.mulscale(this.globalx1, this.globalzd, 16);
        this.globalx2 = Pragmas.mulscale(this.globalx2, this.globalzd, 16);
        this.globaly1 = Pragmas.mulscale(this.globaly1, this.globalzd, 16);
        this.globaly2 = Pragmas.mulscale(this.globaly2, this.globalzd, 16);
        this.globvis = Pragmas.klabs(Pragmas.mulscale(this.globvis, this.globalzd, 10));
        if ((this.globalorientation & 0x180) == 0) {
            int y12;
            int y2 = y12 = Math.max(this.dplc[x1], this.umost[x1]);
            for (int x = x1; x <= x2; ++x) {
                short bwall;
                int twall = Math.max(this.dplc[x], this.umost[x]) - 1;
                if (twall < (bwall = this.dmost[x]) - 1) {
                    if (twall >= y2) {
                        while (y12 < y2 - 1) {
                            this.hline(x - 1, ++y12);
                        }
                        y12 = twall;
                    } else {
                        while (y12 < twall) {
                            this.hline(x - 1, ++y12);
                        }
                        while (y12 > twall) {
                            this.lastx[y12--] = x;
                        }
                    }
                    while (y2 > bwall) {
                        this.hline(x - 1, --y2);
                    }
                    while (y2 < bwall) {
                        this.lastx[y2++] = x;
                    }
                } else {
                    while (y12 < y2 - 1) {
                        this.hline(x - 1, ++y12);
                    }
                    if (x == x2) {
                        this.globalx2 += this.globaly2;
                        this.globaly1 += this.globalx1;
                        break;
                    }
                    y2 = y12 = Math.max(this.dplc[x + 1], this.umost[x + 1]);
                }
                this.globalx2 += this.globaly2;
                this.globaly1 += this.globalx1;
            }
            while (y12 < y2 - 1) {
                this.hline(x2, ++y12);
            }
            return;
        }
        switch (this.globalorientation & 0x180) {
            case 128: {
                this.a.msethlineshift(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4);
                break;
            }
            case 256: {
                this.a.settransnormal();
                this.a.tsethlineshift(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4);
                break;
            }
            case 384: {
                this.a.settransreverse();
                this.a.tsethlineshift(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4);
            }
        }
        int y2 = y1 = Math.max(this.dplc[x1], this.umost[x1]);
        for (int x = x1; x <= x2; ++x) {
            short bwall;
            int twall = Math.max(this.dplc[x], this.umost[x]) - 1;
            if (twall < (bwall = this.dmost[x]) - 1) {
                if (twall >= y2) {
                    while (y1 < y2 - 1) {
                        this.slowhline(x - 1, ++y1);
                    }
                    y1 = twall;
                } else {
                    while (y1 < twall) {
                        this.slowhline(x - 1, ++y1);
                    }
                    while (y1 > twall) {
                        this.lastx[y1--] = x;
                    }
                }
                while (y2 > bwall) {
                    this.slowhline(x - 1, --y2);
                }
                while (y2 < bwall) {
                    this.lastx[y2++] = x;
                }
            } else {
                while (y1 < y2 - 1) {
                    this.slowhline(x - 1, ++y1);
                }
                if (x == x2) {
                    this.globalx2 += this.globaly2;
                    this.globaly1 += this.globalx1;
                    break;
                }
                y2 = y1 = Math.max(this.dplc[x + 1], this.umost[x + 1]);
            }
            this.globalx2 += this.globaly2;
            this.globaly1 += this.globalx1;
        }
        while (y1 < y2 - 1) {
            this.slowhline(x2, ++y1);
        }
    }

    private void parascan(int dax1, int dax2, int dastat, int bunch) {
        int m;
        short l;
        int n;
        int j;
        Tile pic;
        short[] botptr;
        short[] topptr;
        short sectnum = this.thesector[this.bunchfirst[bunch]];
        SECTOR sec = Engine.sector[sectnum];
        int globalhorizbak = (int)Engine.globalhoriz;
        if (Engine.parallaxyscale != 65536) {
            Engine.globalhoriz = Pragmas.mulscale((int)Engine.globalhoriz - (Engine.ydimen >> 1), Engine.parallaxyscale, 16) + (Engine.ydimen >> 1);
        }
        this.globvis = this.globalpisibility;
        if (sec.visibility != 0) {
            this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
        }
        if (dastat == 0) {
            Engine.globalpal = sec.ceilingpal;
            this.globalpicnum = sec.ceilingpicnum;
            Engine.globalshade = sec.ceilingshade;
            this.globalxpanning = sec.ceilingxpanning;
            this.globalypanning = sec.ceilingypanning;
            topptr = this.umost;
            botptr = this.uplc;
        } else {
            Engine.globalpal = sec.floorpal;
            this.globalpicnum = sec.floorpicnum;
            Engine.globalshade = sec.floorshade;
            this.globalxpanning = sec.floorxpanning;
            this.globalypanning = sec.floorypanning;
            topptr = this.dplc;
            botptr = this.dmost;
        }
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        if ((pic = this.engine.getTile(this.globalpicnum)).getType() != Tile.AnimType.None) {
            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, sectnum));
            pic = this.engine.getTile(this.globalpicnum);
        }
        this.globalshiftval = (short)(Engine.picsiz[this.globalpicnum] >> 4);
        if (Engine.pow2long[this.globalshiftval] != pic.getHeight()) {
            this.globalshiftval = (short)(this.globalshiftval + 1);
        }
        this.globalshiftval = (short)(32 - this.globalshiftval);
        this.globalzd = ((pic.getHeight() >> 1) + Engine.parallaxyoffs << this.globalshiftval) + (this.globalypanning << 24);
        this.globalyscale = 8 << this.globalshiftval - 19;
        int k = 11 - (Engine.picsiz[this.globalpicnum] & 0xF) - Engine.pskybits;
        int x = -1;
        short z = this.bunchfirst[bunch];
        while (z >= 0) {
            short wallnum = this.thewall[z];
            short nextsectnum = Engine.wall[wallnum].nextsector;
            j = 0;
            if (nextsectnum != -1) {
                j = dastat == 0 ? Engine.sector[nextsectnum].ceilingstat : Engine.sector[nextsectnum].floorstat;
            }
            if (nextsectnum < 0 || (Engine.wall[wallnum].cstat & 0x20) != 0 || (j & 1) == 0) {
                if (x == -1) {
                    x = this.xb1[z];
                }
                if (Engine.parallaxtype == 0) {
                    n = Pragmas.mulscale(this.xdimenrecip, Engine.viewingrange, 16);
                    for (j = this.xb1[z]; j <= this.xb2[z]; ++j) {
                        this.lplc[j] = (Pragmas.mulscale(j - Engine.halfxdimen, n, 23) + (int)Engine.globalang & 0x7FF) >> k;
                    }
                } else {
                    for (j = this.xb1[z]; j <= this.xb2[z]; ++j) {
                        this.lplc[j] = (this.radarang2[j] + (int)Engine.globalang & 0x7FF) >> k;
                    }
                }
                if (Engine.parallaxtype == 2) {
                    n = Pragmas.mulscale(Engine.xdimscale, Engine.viewingrange, 16);
                    for (j = this.xb1[z]; j <= this.xb2[z]; ++j) {
                        this.swplc[j] = Pragmas.mulscale(Engine.sintable[this.radarang2[j] + 512 & 0x7FF], n, 14);
                    }
                } else {
                    Arrays.fill(this.swplc, this.xb1[z], this.xb2[z] + 1, Pragmas.mulscale(Engine.xdimscale, Engine.viewingrange, 16));
                }
            } else if (x >= 0) {
                l = this.globalpicnum;
                m = Engine.picsiz[this.globalpicnum] & 0xF;
                this.globalpicnum = (short)(l + Engine.pskyoff[this.lplc[x] >> m]);
                if ((this.lplc[x] ^ this.lplc[this.xb1[z] - 1]) >> m == 0) {
                    this.wallscan(x, this.xb1[z] - 1, topptr, botptr, this.swplc, this.lplc);
                } else {
                    j = x;
                    while (x < this.xb1[z]) {
                        n = l + Engine.pskyoff[this.lplc[x] >> m];
                        if (n != this.globalpicnum) {
                            this.wallscan(j, x - 1, topptr, botptr, this.swplc, this.lplc);
                            j = x;
                            this.globalpicnum = (short)n;
                        }
                        ++x;
                    }
                    if (j < x) {
                        this.wallscan(j, x - 1, topptr, botptr, this.swplc, this.lplc);
                    }
                }
                this.globalpicnum = l;
                x = -1;
            }
            z = this.p2[z];
        }
        if (x >= 0) {
            l = this.globalpicnum;
            m = Engine.picsiz[this.globalpicnum] & 0xF;
            this.globalpicnum = (short)(l + Engine.pskyoff[this.lplc[x] >> m]);
            if ((this.lplc[x] ^ this.lplc[this.xb2[this.bunchlast[bunch]]]) >> m == 0) {
                this.wallscan(x, this.xb2[this.bunchlast[bunch]], topptr, botptr, this.swplc, this.lplc);
            } else {
                j = x;
                while (x <= this.xb2[this.bunchlast[bunch]]) {
                    n = l + Engine.pskyoff[this.lplc[x] >> m];
                    if (n != this.globalpicnum) {
                        this.wallscan(j, x - 1, topptr, botptr, this.swplc, this.lplc);
                        j = x;
                        this.globalpicnum = (short)n;
                    }
                    ++x;
                }
                if (j <= x) {
                    this.wallscan(j, x, topptr, botptr, this.swplc, this.lplc);
                }
            }
            this.globalpicnum = l;
        }
        Engine.globalhoriz = globalhorizbak;
    }

    private void ceilspritescan(int x1, int x2) {
        int y1;
        int y2 = y1 = this.uwall[x1];
        for (int x = x1; x <= x2; ++x) {
            int twall = this.uwall[x] - 1;
            short bwall = this.dwall[x];
            if (twall < bwall - 1) {
                if (twall >= y2) {
                    while (y1 < y2 - 1) {
                        this.ceilspritehline(x - 1, ++y1);
                    }
                    y1 = twall;
                } else {
                    while (y1 < twall) {
                        this.ceilspritehline(x - 1, ++y1);
                    }
                    while (y1 > twall) {
                        this.lastx[y1--] = x;
                    }
                }
                while (y2 > bwall) {
                    this.ceilspritehline(x - 1, --y2);
                }
                while (y2 < bwall) {
                    this.lastx[y2++] = x;
                }
                continue;
            }
            while (y1 < y2 - 1) {
                this.ceilspritehline(x - 1, ++y1);
            }
            if (x == x2) break;
            y2 = y1 = this.uwall[x + 1];
        }
        while (y1 < y2 - 1) {
            this.ceilspritehline(x2, ++y1);
        }
    }

    private void ceilspritehline(int x2, int y) {
        int x1 = this.lastx[y];
        if (x2 < x1) {
            return;
        }
        if (y - (int)Engine.globalhoriz + this.horizycent < 0 || y - (int)Engine.globalhoriz + this.horizycent >= this.lookups.length) {
            Console.Println("Crash catcher:");
            Console.Println("y = " + y);
            Console.Println("globalhoriz = " + Engine.globalhoriz);
            Console.Println("horizycent = " + this.horizycent);
            Console.Println("globalzd = " + this.globalzd);
        }
        int v = Pragmas.mulscale(this.globalzd, this.lookups[y - (int)Engine.globalhoriz + this.horizycent], 20);
        int bx = Pragmas.mulscale(this.globalx2 * x1 + this.globalx1, v, 14) + this.globalxpanning;
        int by = Pragmas.mulscale(this.globaly2 * x1 + this.globaly1, v, 14) + this.globalypanning;
        this.a.sethlineincs(Pragmas.mulscale(this.globalx2, v, 14), Pragmas.mulscale(this.globaly2, v, 14));
        this.a.setuphline(Engine.palookup[Engine.globalpal], this.engine.getpalookup(Pragmas.mulscale(Pragmas.klabs(v), this.globvis, 28), Engine.globalshade) << 8);
        if ((this.globalorientation & 2) == 0) {
            this.a.mhline(this.globalbufplc, bx, x2 - x1 << 16, 0, by, this.ylookup[y] + x1 + this.frameoffset);
        } else {
            this.a.thline(this.globalbufplc, bx, x2 - x1 << 16, 0, by, this.ylookup[y] + x1 + this.frameoffset);
        }
    }

    private void grouscan(int dax1, int dax2, short sectnum, int dastat) {
        int x;
        int daz;
        short daslope;
        SECTOR sec = Engine.sector[sectnum];
        if (dastat == 0) {
            if (Engine.globalposz <= this.engine.getceilzofslope(sectnum, Engine.globalposx, Engine.globalposy)) {
                return;
            }
            this.globalorientation = sec.ceilingstat;
            this.globalpicnum = sec.ceilingpicnum;
            Engine.globalshade = sec.ceilingshade;
            Engine.globalpal = sec.ceilingpal;
            daslope = sec.ceilingheinum;
            daz = sec.ceilingz;
        } else {
            if (Engine.globalposz >= this.engine.getflorzofslope(sectnum, Engine.globalposx, Engine.globalposy)) {
                return;
            }
            this.globalorientation = sec.floorstat;
            this.globalpicnum = sec.floorpicnum;
            Engine.globalshade = sec.floorshade;
            Engine.globalpal = sec.floorpal;
            daslope = sec.floorheinum;
            daz = sec.floorz;
        }
        Tile pic = this.engine.getTile(this.globalpicnum);
        if (pic.getType() != Tile.AnimType.None) {
            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, sectnum));
            pic = this.engine.getTile(this.globalpicnum);
        }
        this.engine.setgotpic(this.globalpicnum);
        if (!pic.hasSize()) {
            return;
        }
        if (pic.data == null) {
            this.engine.loadtile(this.globalpicnum);
        }
        WALL wal = Engine.wall[sec.wallptr];
        int wx = Engine.wall[wal.point2].x - wal.x;
        int wy = Engine.wall[wal.point2].y - wal.y;
        int dasqr = this.krecipasm(this.engine.ksqrt(wx * wx + wy * wy));
        int i = Pragmas.mulscale(daslope, dasqr, 21);
        wx *= i;
        wy *= i;
        this.globalx = -Pragmas.mulscale(Engine.singlobalang, this.xdimenrecip, 19);
        this.globaly = Pragmas.mulscale(Engine.cosglobalang, this.xdimenrecip, 19);
        this.globalx1 = Engine.globalposx << 8;
        this.globaly1 = -(Engine.globalposy << 8);
        i = (dax1 - Engine.halfxdimen) * this.xdimenrecip;
        this.globalx2 = Pragmas.mulscale(Engine.cosglobalang << 4, Engine.viewingrangerecip, 16) - Pragmas.mulscale(Engine.singlobalang, i, 27);
        this.globaly2 = Pragmas.mulscale(Engine.singlobalang << 4, Engine.viewingrangerecip, 16) + Pragmas.mulscale(Engine.cosglobalang, i, 27);
        this.globalzd = Engine.xdimscale << 9;
        this.globalzx = -Pragmas.dmulscale(wx, this.globaly2, -wy, this.globalx2, 17) + Pragmas.mulscale(1 - (int)Engine.globalhoriz, this.globalzd, 10);
        this.globalz = -Pragmas.dmulscale(wx, this.globaly, -wy, this.globalx, 25);
        if ((this.globalorientation & 0x40) != 0) {
            int dx = Pragmas.mulscale(Engine.wall[wal.point2].x - wal.x, dasqr, 14);
            int dy = Pragmas.mulscale(Engine.wall[wal.point2].y - wal.y, dasqr, 14);
            i = this.engine.ksqrt(daslope * daslope + 0x1000000);
            x = this.globalx;
            int y = this.globaly;
            this.globalx = Pragmas.dmulscale(x, dx, y, dy, 16);
            this.globaly = Pragmas.mulscale(Pragmas.dmulscale(-y, dx, x, dy, 16), i, 12);
            x = wal.x - Engine.globalposx << 8;
            y = wal.y - Engine.globalposy << 8;
            this.globalx1 = Pragmas.dmulscale(-x, dx, -y, dy, 16);
            this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(-y, dx, x, dy, 16), i, 12);
            x = this.globalx2;
            y = this.globaly2;
            this.globalx2 = Pragmas.dmulscale(x, dx, y, dy, 16);
            this.globaly2 = Pragmas.mulscale(Pragmas.dmulscale(-y, dx, x, dy, 16), i, 12);
        }
        if ((this.globalorientation & 4) != 0) {
            i = this.globalx;
            this.globalx = -this.globaly;
            this.globaly = -i;
            i = this.globalx1;
            this.globalx1 = this.globaly1;
            this.globaly1 = i;
            i = this.globalx2;
            this.globalx2 = -this.globaly2;
            this.globaly2 = -i;
        }
        if ((this.globalorientation & 0x10) != 0) {
            this.globalx1 = -this.globalx1;
            this.globalx2 = -this.globalx2;
            this.globalx = -this.globalx;
        }
        if ((this.globalorientation & 0x20) != 0) {
            this.globaly1 = -this.globaly1;
            this.globaly2 = -this.globaly2;
            this.globaly = -this.globaly;
        }
        daz = Pragmas.dmulscale(wx, Engine.globalposy - wal.y, -wy, Engine.globalposx - wal.x, 9) + (daz - Engine.globalposz << 8);
        this.globalx2 = Pragmas.mulscale(this.globalx2, daz, 20);
        this.globalx = Pragmas.mulscale(this.globalx, daz, 28);
        this.globaly2 = Pragmas.mulscale(this.globaly2, -daz, 20);
        this.globaly = Pragmas.mulscale(this.globaly, -daz, 28);
        i = 8 - (Engine.picsiz[this.globalpicnum] & 0xF);
        int j = 8 - (Engine.picsiz[this.globalpicnum] >> 4);
        if ((this.globalorientation & 8) != 0) {
            ++i;
            ++j;
        }
        this.globalx1 <<= i + 12;
        this.globalx2 <<= i;
        this.globalx <<= i;
        this.globaly1 <<= j + 12;
        this.globaly2 <<= j;
        this.globaly <<= j;
        if (dastat == 0) {
            this.globalx1 += sec.ceilingxpanning << 24;
            this.globaly1 += sec.ceilingypanning << 24;
        } else {
            this.globalx1 += sec.floorxpanning << 24;
            this.globaly1 += sec.floorypanning << 24;
        }
        this.globvis = Engine.globalvisibility;
        if (sec.visibility != 0) {
            this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
        }
        this.globvis = Pragmas.mulscale(this.globvis, daz, 13);
        this.globvis = Pragmas.mulscale(this.globvis, Engine.xdimscale, 16);
        j = Engine.globalpal;
        this.a.setupslopevlin((Engine.picsiz[this.globalpicnum] & 0xF) + (Engine.picsiz[this.globalpicnum] >> 4 << 8), pic.data, -this.ylookup[1], -(this.globalzd >> 13));
        int l = this.globalzd >> 16;
        int shinc = Pragmas.mulscale(this.globalz, Engine.xdimenscale, 16);
        int shoffs = shinc > 0 ? 131072 : 16380 - Engine.ydimen << 15;
        int y1 = dastat == 0 ? this.umost[dax1] : Math.max(this.umost[dax1], this.dplc[dax1]);
        int m1 = Pragmas.mulscale(y1, this.globalzd, 16) + (this.globalzx >> 6);
        m1 = this.globalzd > 0 ? (m1 += this.globalzd >> 16) : (m1 -= this.globalzd >> 16);
        int m2 = m1 + l;
        int mptr1 = y1 + (shoffs >> 15);
        int mptr2 = mptr1 + 1;
        for (x = dax1; x <= dax2; ++x) {
            int y2;
            if (dastat == 0) {
                y1 = this.umost[x];
                y2 = Math.min(this.dmost[x], this.uplc[x]) - 1;
            } else {
                y1 = Math.max(this.umost[x], this.dplc[x]);
                y2 = this.dmost[x] - 1;
            }
            if (y1 <= y2) {
                int nptr1 = y1 + (shoffs >> 15);
                int nptr2 = y2 + (shoffs >> 15);
                while (nptr1 <= mptr1) {
                    this.slopalookup[mptr1--] = this.engine.getpalookup(Pragmas.mulscale(this.krecipasm(m1), this.globvis, 24), Engine.globalshade) << 8;
                    m1 -= l;
                }
                while (nptr2 >= mptr2) {
                    this.slopalookup[mptr2++] = this.engine.getpalookup(Pragmas.mulscale(this.krecipasm(m2), this.globvis, 24), Engine.globalshade) << 8;
                    m2 += l;
                }
                this.globalx3 = this.globalx2 >> 10;
                this.globaly3 = this.globaly2 >> 10;
                this.a.slopevlin(this.ylookup[y2] + x + this.frameoffset, Engine.palookup[j], nptr2, y2 - y1 + 1, this.globalx1, this.globaly1, this.globalx3, this.globaly3, this.slopalookup, Pragmas.mulscale(y2, this.globalzd, 16) + (this.globalzx >> 6));
            }
            this.globalx2 += this.globalx;
            this.globaly2 += this.globaly;
            this.globalzx += this.globalz;
            shoffs += shinc;
        }
    }

    private void ceilscan(int x1, int x2, int sectnum) {
        int y1;
        int i;
        SECTOR sec = Engine.sector[sectnum];
        if (sec.ceilingpal != this.globalpalwritten) {
            this.globalpalwritten = sec.ceilingpal;
            this.a.setpalookupaddress(Engine.palookup[this.globalpalwritten]);
        }
        this.globalzd = sec.ceilingz - Engine.globalposz;
        if (this.globalzd > 0) {
            return;
        }
        this.globalpicnum = sec.ceilingpicnum;
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        Tile pic = this.engine.getTile(this.globalpicnum);
        this.engine.setgotpic(this.globalpicnum);
        if (!pic.hasSize()) {
            return;
        }
        if (pic.getType() != Tile.AnimType.None) {
            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, sectnum));
            pic = this.engine.getTile(this.globalpicnum);
        }
        if (pic.data == null) {
            this.engine.loadtile(this.globalpicnum);
        }
        this.globalbufplc = pic.data;
        Engine.globalshade = sec.ceilingshade;
        this.globvis = this.globalcisibility;
        if (sec.visibility != 0) {
            this.globvis = Pragmas.mulscale(this.globvis, sec.visibility + 16 & 0xFF, 4);
        }
        this.globalorientation = sec.ceilingstat;
        if ((this.globalorientation & 0x40) == 0) {
            this.globalx1 = Engine.singlobalang;
            this.globalx2 = Engine.singlobalang;
            this.globaly1 = Engine.cosglobalang;
            this.globaly2 = Engine.cosglobalang;
            this.globalxpanning = Engine.globalposx << 20;
            this.globalypanning = -(Engine.globalposy << 20);
        } else {
            int j = sec.wallptr;
            int ox = Engine.wall[Engine.wall[j].point2].x - Engine.wall[j].x;
            int oy = Engine.wall[Engine.wall[j].point2].y - Engine.wall[j].y;
            i = this.engine.ksqrt(ox * ox + oy * oy);
            i = i == 0 ? 1024 : 0x100000 / i;
            this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, Engine.singlobalang, -oy, Engine.cosglobalang, 10), i, 10);
            this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, Engine.cosglobalang, oy, Engine.singlobalang, 10), i, 10);
            this.globalx2 = -this.globalx1;
            this.globaly2 = -this.globaly1;
            ox = Engine.wall[j].x - Engine.globalposx << 6;
            oy = Engine.wall[j].y - Engine.globalposy << 6;
            i = Pragmas.dmulscale(oy, Engine.cosglobalang, -ox, Engine.singlobalang, 14);
            j = Pragmas.dmulscale(ox, Engine.cosglobalang, oy, Engine.singlobalang, 14);
            ox = i;
            oy = j;
            this.globalxpanning = this.globalx1 * ox - this.globaly1 * oy;
            this.globalypanning = this.globaly2 * ox + this.globalx2 * oy;
        }
        this.globalx2 = Pragmas.mulscale(this.globalx2, Engine.viewingrangerecip, 16);
        this.globaly1 = Pragmas.mulscale(this.globaly1, Engine.viewingrangerecip, 16);
        this.globalxshift = (byte)(8 - (Engine.picsiz[this.globalpicnum] & 0xF));
        this.globalyshift = (byte)(8 - (Engine.picsiz[this.globalpicnum] >> 4));
        if ((this.globalorientation & 8) != 0) {
            this.globalxshift = (byte)(this.globalxshift + 1);
            this.globalyshift = (byte)(this.globalyshift + 1);
        }
        if ((this.globalorientation & 4) > 0) {
            i = this.globalxpanning;
            this.globalxpanning = this.globalypanning;
            this.globalypanning = i;
            i = this.globalx2;
            this.globalx2 = -this.globaly1;
            this.globaly1 = -i;
            i = this.globalx1;
            this.globalx1 = this.globaly2;
            this.globaly2 = i;
        }
        if ((this.globalorientation & 0x10) > 0) {
            this.globalx1 = -this.globalx1;
            this.globaly1 = -this.globaly1;
            this.globalxpanning = -this.globalxpanning;
        }
        if ((this.globalorientation & 0x20) > 0) {
            this.globalx2 = -this.globalx2;
            this.globaly2 = -this.globaly2;
            this.globalypanning = -this.globalypanning;
        }
        this.globalx1 <<= this.globalxshift;
        this.globaly1 <<= this.globalxshift;
        this.globalx2 <<= this.globalyshift;
        this.globaly2 <<= this.globalyshift;
        this.globalxpanning <<= this.globalxshift;
        this.globalypanning <<= this.globalyshift;
        this.globalxpanning += sec.ceilingxpanning << 24;
        this.globalypanning += sec.ceilingypanning << 24;
        this.globaly1 = (-this.globalx1 - this.globaly1) * Engine.halfxdimen;
        this.globalx2 = (this.globalx2 - this.globaly2) * Engine.halfxdimen;
        this.a.sethlinesizes(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4, this.globalbufplc);
        this.globalx2 += this.globaly2 * (x1 - 1);
        this.globaly1 += this.globalx1 * (x1 - 1);
        this.globalx1 = Pragmas.mulscale(this.globalx1, this.globalzd, 16);
        this.globalx2 = Pragmas.mulscale(this.globalx2, this.globalzd, 16);
        this.globaly1 = Pragmas.mulscale(this.globaly1, this.globalzd, 16);
        this.globaly2 = Pragmas.mulscale(this.globaly2, this.globalzd, 16);
        this.globvis = Pragmas.klabs(Pragmas.mulscale(this.globvis, this.globalzd, 10));
        if ((this.globalorientation & 0x180) == 0) {
            int y12;
            int y2 = y12 = this.umost[x1];
            for (int x = x1; x <= x2; ++x) {
                int twall = this.umost[x] - 1;
                int bwall = Math.min(this.uplc[x], this.dmost[x]);
                if (twall < bwall - 1) {
                    if (twall >= y2) {
                        while (y12 < y2 - 1) {
                            this.hline(x - 1, ++y12);
                        }
                        y12 = twall;
                    } else {
                        while (y12 < twall) {
                            this.hline(x - 1, ++y12);
                        }
                        while (y12 > twall) {
                            this.lastx[y12--] = x;
                        }
                    }
                    while (y2 > bwall) {
                        this.hline(x - 1, --y2);
                    }
                    while (y2 < bwall) {
                        this.lastx[y2++] = x;
                    }
                } else {
                    while (y12 < y2 - 1) {
                        this.hline(x - 1, ++y12);
                    }
                    if (x == x2) {
                        this.globalx2 += this.globaly2;
                        this.globaly1 += this.globalx1;
                        break;
                    }
                    y2 = y12 = this.umost[x + 1];
                }
                this.globalx2 += this.globaly2;
                this.globaly1 += this.globalx1;
            }
            while (y12 < y2 - 1) {
                this.hline(x2, ++y12);
            }
            return;
        }
        int forswitch = this.globalorientation & 0x180;
        switch (forswitch) {
            case 128: {
                this.a.msethlineshift(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4);
                break;
            }
            case 256: {
                this.a.settransnormal();
                this.a.tsethlineshift(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4);
                break;
            }
            case 384: {
                this.a.settransreverse();
                this.a.tsethlineshift(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4);
            }
        }
        int y2 = y1 = this.umost[x1];
        for (int x = x1; x <= x2; ++x) {
            int twall = this.umost[x] - 1;
            int bwall = Math.min(this.uplc[x], this.dmost[x]);
            if (twall < bwall - 1) {
                if (twall >= y2) {
                    while (y1 < y2 - 1) {
                        this.slowhline(x - 1, ++y1);
                    }
                    y1 = twall;
                } else {
                    while (y1 < twall) {
                        this.slowhline(x - 1, ++y1);
                    }
                    while (y1 > twall) {
                        this.lastx[y1--] = x;
                    }
                }
                while (y2 > bwall) {
                    this.slowhline(x - 1, --y2);
                }
                while (y2 < bwall) {
                    this.lastx[y2++] = x;
                }
            } else {
                while (y1 < y2 - 1) {
                    this.slowhline(x - 1, ++y1);
                }
                if (x == x2) {
                    this.globalx2 += this.globaly2;
                    this.globaly1 += this.globalx1;
                    break;
                }
                y2 = y1 = this.umost[x + 1];
            }
            this.globalx2 += this.globaly2;
            this.globaly1 += this.globalx1;
        }
        while (y1 < y2 - 1) {
            this.slowhline(x2, ++y1);
        }
    }

    @Override
    public void clearview(int dacol) {
        this.a.clearframe((byte)dacol);
    }

    @Override
    public void nextpage() {
        byte[] src = this.a.getframeplace();
        byte[] dst = (byte[])BuildGdx.graphics.extra(BuildGraphics.Option.SWGetFrame, new Object[0]);
        int len = src.length;
        if (dst.length < src.length) {
            len = dst.length;
        }
        System.arraycopy(src, 0, dst, 0, len);
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.ortho.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2);
    }

    protected void qinterpolatedown16short(short[] bufptr, int offset, int num, long val, long add) {
        int len = num + offset;
        if (offset < 0 || len == 0 || len >= bufptr.length) {
            return;
        }
        for (int i = offset; i < len; ++i) {
            bufptr[i] = (short)(val >> 16);
            val += add;
        }
    }

    protected void qinterpolatedown16(int[] bufptr, int offset, int num, long val, long add) {
        int len = num + offset;
        if (offset < 0 || len == 0 || len >= bufptr.length) {
            return;
        }
        for (int i = offset; i < len; ++i) {
            bufptr[i] = (int)(val >> 16);
            val += add;
        }
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.ortho.drawmapview(dax, day, zoome, ang);
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        this.ortho.drawoverheadmap(cposx, cposy, czoom, cang);
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
        this.ortho.printext(font, xpos, ypos, text, col, shade, bit, scale);
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        this.ortho.printext(xpos, ypos, col, backcol, text, fontsize, scale);
    }

    @Override
    public ByteBuffer getFrame(TileData.PixelFormat format, int xsiz, int ysiz) {
        if (ysiz < 0) {
            ysiz *= -1;
        }
        byte[] frameplace = this.a.getframeplace();
        if (format == TileData.PixelFormat.Pal8) {
            if (this.indexbuffer != null) {
                this.indexbuffer.clear();
            }
            if (this.indexbuffer == null || this.indexbuffer.capacity() < xsiz * ysiz) {
                this.indexbuffer = ByteBuffer.allocateDirect(xsiz * ysiz);
            }
            this.indexbuffer.put(frameplace);
            this.indexbuffer.rewind();
            return this.indexbuffer;
        }
        if (format == TileData.PixelFormat.Rgb) {
            if (this.rgbbuffer != null) {
                this.rgbbuffer.clear();
            }
            if (this.rgbbuffer == null || this.rgbbuffer.capacity() < xsiz * ysiz * 3) {
                this.rgbbuffer = ByteBuffer.allocateDirect(xsiz * ysiz * 3);
            }
            for (int i = 0; i < xsiz * ysiz; ++i) {
                int dacol = frameplace[i] & 0xFF;
                this.rgbbuffer.put((byte)Engine.curpalette.getRed(dacol));
                this.rgbbuffer.put((byte)Engine.curpalette.getGreen(dacol));
                this.rgbbuffer.put((byte)Engine.curpalette.getBlue(dacol));
            }
            this.rgbbuffer.rewind();
            return this.rgbbuffer;
        }
        return null;
    }

    @Override
    public byte[] screencapture(int newwidth, int newheight) {
        byte[] capture = new byte[newwidth * newheight];
        int xf = Pragmas.divscale(Engine.xdim, newwidth, 16);
        int yf = Pragmas.divscale(Engine.ydim, newheight, 16);
        byte[] frameplace = this.a.getframeplace();
        for (int fy = 0; fy < newheight; ++fy) {
            int base = Pragmas.mulscale(fy, yf, 16) * Engine.xdim;
            for (int fx = 0; fx < newwidth; ++fx) {
                capture[newheight * fx + fy] = frameplace[base + Pragmas.mulscale(fx, xf, 16)];
            }
        }
        return capture;
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int c) {
        this.ortho.drawline256(x1, y1, x2, y2, c);
    }

    public void dosetaspect() {
        int i;
        int j;
        if (Engine.xyaspect != this.oxyaspect) {
            this.oxyaspect = Engine.xyaspect;
            j = Engine.xyaspect * 320;
            this.lookups[this.horizlookup2 + this.horizycent - 1] = Pragmas.divscale(131072L, j, 26);
            for (i = Engine.ydim * 4 - 1; i >= 0; --i) {
                if (i == this.horizycent - 1) continue;
                this.lookups[i] = Pragmas.divscale(1L, i - (this.horizycent - 1), 28);
                this.lookups[this.horizlookup2 + i] = Pragmas.divscale(Pragmas.klabs(this.lookups[i]), j, 14);
            }
        }
        if (Engine.xdimen != this.oxdimen || Engine.viewingrange != this.oviewingrange) {
            this.oxdimen = Engine.xdimen;
            this.oviewingrange = Engine.viewingrange;
            int xinc = Pragmas.mulscale(Engine.viewingrange * 320, this.xdimenrecip, 32);
            int x = 0x2800000 - Pragmas.mulscale(xinc, Engine.xdimen, 1);
            for (i = 0; i < Engine.xdimen; ++i) {
                j = x & 0xFFFF;
                int k = x >> 16;
                x += xinc;
                if (k < 0 || k >= Engine.radarang.length - 1) break;
                if (j != 0) {
                    j = Pragmas.mulscale(Engine.radarang[k + 1] - Engine.radarang[k], j, 16);
                }
                this.radarang2[i] = (short)(Engine.radarang[k] + j >> 6);
            }
            for (i = 1; i < 65536; ++i) {
                this.distrecip[i] = Pragmas.divscale(Engine.xdimen, i, 20);
            }
            this.nytooclose = Engine.xdimen * 2100;
            this.nytoofar = 0x3FF00000;
        }
    }

    @Override
    public void settiltang(int tilt) {
    }

    @Override
    public void changepalette(byte[] palette) {
        BuildGdx.graphics.extra(BuildGraphics.Option.SWChangePalette, new Object[]{palette});
    }

    private void scansector(short sectnum) {
        int xp2 = 0;
        int yp2 = 0;
        if (sectnum < 0) {
            return;
        }
        if (Engine.automapping != 0) {
            int n = sectnum >> 3;
            Engine.show2dsector[n] = (byte)(Engine.show2dsector[n] | Engine.pow2char[sectnum & 7]);
        }
        this.sectorborder[0] = sectnum;
        this.sectorbordercnt = 1;
        do {
            this.sectorbordercnt = (short)(this.sectorbordercnt - 1);
            sectnum = this.sectorborder[this.sectorbordercnt];
            int z = Engine.headspritesect[sectnum];
            while (z >= 0) {
                SPRITE spr = Engine.sprite[z];
                if (((spr.cstat & 0x8000) == 0 || Engine.showinvisibility) && spr.xrepeat > 0 && spr.yrepeat > 0 && Engine.spritesortcnt < 1024) {
                    int xs = spr.x - Engine.globalposx;
                    int ys = spr.y - Engine.globalposy;
                    if ((spr.cstat & 0x30) != 0 || xs * Engine.cosglobalang + ys * Engine.singlobalang > 0) {
                        if (Engine.tsprite[Engine.spritesortcnt] == null) {
                            Engine.tsprite[Engine.spritesortcnt] = new SPRITE();
                        }
                        Engine.tsprite[Engine.spritesortcnt].set(Engine.sprite[z]);
                        Engine.tsprite[++Engine.spritesortcnt].owner = (short)z;
                    }
                }
                z = Engine.nextspritesect[z];
            }
            int n = sectnum >> 3;
            Engine.gotsector[n] = (byte)(Engine.gotsector[n] | Engine.pow2char[sectnum & 7]);
            int bunchfrst = this.numbunches;
            int numscansbefore = this.numscans;
            if (Engine.sector[sectnum] == null) continue;
            int startwall = Engine.sector[sectnum].wallptr;
            int endwall = startwall + Engine.sector[sectnum].wallnum;
            int scanfirst = this.numscans;
            if (startwall < 0 || endwall < 0) continue;
            for (z = startwall; z < endwall; ++z) {
                block22: {
                    int yp1;
                    int xp1;
                    block26: {
                        int templong;
                        block25: {
                            block24: {
                                block23: {
                                    WALL wal = Engine.wall[z];
                                    if (wal == null || wal.point2 < 0 || wal.point2 >= Engine.MAXWALLS) continue;
                                    short nextsectnum = wal.nextsector;
                                    WALL wal2 = Engine.wall[wal.point2];
                                    if (wal2 == null) continue;
                                    int x1 = wal.x - Engine.globalposx;
                                    int y1 = wal.y - Engine.globalposy;
                                    int x2 = wal2.x - Engine.globalposx;
                                    int y2 = wal2.y - Engine.globalposy;
                                    if (nextsectnum >= 0 && (wal.cstat & 0x20) == 0 && this.sectorbordercnt < this.sectorborder.length && (Engine.gotsector[nextsectnum >> 3] & Engine.pow2char[nextsectnum & 7]) == 0 && Software.toUnsignedLong(templong = x1 * y2 - x2 * y1) + 262144L < 524288L && Pragmas.mulscale(templong, templong, 5) <= (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) {
                                        short s = this.sectorbordercnt;
                                        this.sectorbordercnt = (short)(s + 1);
                                        this.sectorborder[s] = nextsectnum;
                                    }
                                    if (z == startwall || Engine.wall[z - 1].point2 != z) {
                                        xp1 = Pragmas.dmulscale(y1, Engine.cosglobalang, -x1, Engine.singlobalang, 6);
                                        yp1 = Pragmas.dmulscale(x1, Engine.cosviewingrangeglobalang, y1, Engine.sinviewingrangeglobalang, 6);
                                    } else {
                                        xp1 = xp2;
                                        yp1 = yp2;
                                    }
                                    xp2 = Pragmas.dmulscale(y2, Engine.cosglobalang, -x2, Engine.singlobalang, 6);
                                    yp2 = Pragmas.dmulscale(x2, Engine.cosviewingrangeglobalang, y2, Engine.sinviewingrangeglobalang, 6);
                                    if (yp1 < 256 && yp2 < 256 || Pragmas.dmulscale(xp1, yp2, -xp2, yp1, 32) >= 0 || this.numscans >= this.MAXWALLSB - 1) break block22;
                                    if (xp1 < -yp1) break block23;
                                    if (xp1 > yp1 || yp1 == 0) break block22;
                                    this.xb1[this.numscans] = Engine.halfxdimen + Pragmas.scale(xp1, Engine.halfxdimen, yp1);
                                    if (xp1 >= 0) {
                                        int n2 = this.numscans;
                                        this.xb1[n2] = this.xb1[n2] + 1;
                                    }
                                    if (this.xb1[this.numscans] >= Engine.xdimen) {
                                        this.xb1[this.numscans] = Engine.xdimen - 1;
                                    }
                                    this.yb1[this.numscans] = yp1;
                                    break block24;
                                }
                                if (xp2 < -yp2) break block22;
                                this.xb1[this.numscans] = 0;
                                templong = yp1 - yp2 + xp1 - xp2;
                                if (templong == 0) break block22;
                                this.yb1[this.numscans] = yp1 + Pragmas.scale(yp2 - yp1, xp1 + yp1, templong);
                            }
                            if (this.yb1[this.numscans] < 256) break block22;
                            if (xp2 > yp2) break block25;
                            if (xp2 < -yp2 || yp2 == 0) break block22;
                            this.xb2[this.numscans] = Engine.halfxdimen + Pragmas.scale(xp2, Engine.halfxdimen, yp2) - 1;
                            if (xp2 >= 0) {
                                int n3 = this.numscans;
                                this.xb2[n3] = this.xb2[n3] + 1;
                            }
                            if (this.xb2[this.numscans] >= Engine.xdimen) {
                                this.xb2[this.numscans] = Engine.xdimen - 1;
                            }
                            this.yb2[this.numscans] = yp2;
                            break block26;
                        }
                        if (xp1 > yp1) break block22;
                        this.xb2[this.numscans] = Engine.xdimen - 1;
                        templong = xp2 - xp1 + yp1 - yp2;
                        if (templong == 0) break block22;
                        this.yb2[this.numscans] = yp1 + Pragmas.scale(yp2 - yp1, yp1 - xp1, templong);
                    }
                    if (this.yb2[this.numscans] >= 256 && this.xb1[this.numscans] <= this.xb2[this.numscans]) {
                        this.thesector[this.numscans] = sectnum;
                        this.thewall[this.numscans] = (short)z;
                        this.rx1[this.numscans] = xp1;
                        this.ry1[this.numscans] = yp1;
                        this.rx2[this.numscans] = xp2;
                        this.ry2[this.numscans] = yp2;
                        this.p2[this.numscans] = (short)(this.numscans + 1);
                        ++this.numscans;
                    }
                }
                if (Engine.wall[z].point2 >= z || scanfirst >= this.numscans) continue;
                this.p2[this.numscans - 1] = (short)scanfirst;
                scanfirst = this.numscans;
            }
            for (z = numscansbefore; z < this.numscans; ++z) {
                if (z >= this.MAXWALLSB || this.p2[z] >= this.MAXWALLSB || Engine.wall[this.thewall[z]].point2 == this.thewall[this.p2[z]] && this.xb2[z] < this.xb1[this.p2[z]]) continue;
                this.bunchfirst[this.numbunches++] = this.p2[z];
                this.p2[z] = -1;
            }
            for (z = bunchfrst; z < this.numbunches; ++z) {
                if (this.p2[z] >= this.MAXWALLSB) continue;
                short zz = this.bunchfirst[z];
                while (this.p2[zz] >= 0) {
                    zz = this.p2[zz];
                }
                this.bunchlast[z] = zz;
            }
        } while (this.sectorbordercnt > 0);
    }

    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    private boolean spritewallfront(SPRITE s, int w) {
        if (s == null) {
            return false;
        }
        WALL wal = Engine.wall[w];
        int x1 = wal.x;
        int y1 = wal.y;
        wal = Engine.wall[wal.point2];
        return Pragmas.dmulscale(wal.x - x1, s.y - y1, -(s.x - x1), wal.y - y1, 32) >= 0;
    }

    private int bunchfront(int b1, int b2) {
        short b1f = this.bunchfirst[b1];
        int x1b1 = this.xb1[b1f];
        int x2b2 = this.xb2[this.bunchlast[b2]] + 1;
        if (x1b1 >= x2b2) {
            return -1;
        }
        short b2f = this.bunchfirst[b2];
        int x1b2 = this.xb1[b2f];
        int x2b1 = this.xb2[this.bunchlast[b1]] + 1;
        if (x1b2 >= x2b1) {
            return -1;
        }
        if (x1b1 >= x1b2) {
            short i = b2f;
            while (this.xb2[i] <= x1b1 && this.p2[i] != -1) {
                i = this.p2[i];
            }
            return this.wallfront(b1f, i);
        }
        short i = b1f;
        while (this.xb2[i] <= x1b2 && this.p2[i] != -1) {
            i = this.p2[i];
        }
        return this.wallfront(i, b2f);
    }

    private int wallfront(int l1, int l2) {
        WALL wal = Engine.wall[this.thewall[l1]];
        int x11 = wal.x;
        int y11 = wal.y;
        wal = Engine.wall[wal.point2];
        int x21 = wal.x;
        int y21 = wal.y;
        wal = Engine.wall[this.thewall[l2]];
        int x12 = wal.x;
        int y12 = wal.y;
        wal = Engine.wall[wal.point2];
        int x22 = wal.x;
        int y22 = wal.y;
        int dx = x21 - x11;
        int dy = y21 - y11;
        int t1 = Pragmas.dmulscale(x12 - x11, dy, -dx, y12 - y11, 2);
        int t2 = Pragmas.dmulscale(x22 - x11, dy, -dx, y22 - y11, 2);
        if (t1 == 0 && (t1 = t2) == 0) {
            return -1;
        }
        if (t2 == 0) {
            t2 = t1;
        }
        if ((t1 ^ t2) >= 0) {
            t2 = Pragmas.dmulscale(Engine.globalposx - x11, dy, -dx, Engine.globalposy - y11, 2);
            return (t2 ^ t1) >= 0 ? 1 : 0;
        }
        dx = x22 - x12;
        dy = y22 - y12;
        t1 = Pragmas.dmulscale(x11 - x12, dy, -dx, y11 - y12, 2);
        t2 = Pragmas.dmulscale(x21 - x12, dy, -dx, y21 - y12, 2);
        if (t1 == 0 && (t1 = t2) == 0) {
            return -1;
        }
        if (t2 == 0) {
            t2 = t1;
        }
        if ((t1 ^ t2) >= 0) {
            t2 = Pragmas.dmulscale(Engine.globalposx - x12, dy, -dx, Engine.globalposy - y12, 2);
            return (t2 ^ t1) < 0 ? 1 : 0;
        }
        return -2;
    }

    private int owallmost(short[] mostbuf, int w, int z) {
        int i;
        int xcross;
        int inty;
        long t;
        int s1 = Pragmas.mulscale(this.globaluclip, this.yb1[w], 20);
        int s2 = Pragmas.mulscale(this.globaluclip, this.yb2[w], 20);
        int s3 = Pragmas.mulscale(this.globaldclip, this.yb1[w], 20);
        int s4 = Pragmas.mulscale(this.globaldclip, this.yb2[w], 20);
        int bad = ((z <<= 7) < s1 ? 1 : 0) + ((z < s2 ? 1 : 0) << 1) + ((z > s3 ? 1 : 0) << 2) + ((z > s4 ? 1 : 0) << 3);
        int ix1 = this.xb1[w];
        int iy1 = this.yb1[w];
        int ix2 = this.xb2[w];
        int iy2 = this.yb2[w];
        if (ix1 < 0 || iy1 < 0 || ix2 < 0 || iy2 < 0) {
            return bad;
        }
        if ((bad & 3) == 3) {
            for (int i2 = ix1; i2 <= ix2; ++i2) {
                mostbuf[i2] = 0;
            }
            return bad;
        }
        if ((bad & 0xC) == 12) {
            for (int i3 = ix1; i3 <= ix2; ++i3) {
                mostbuf[i3] = (short)Engine.ydimen;
            }
            return bad;
        }
        if ((bad & 3) != 0) {
            t = Pragmas.divscale(z - s1, s2 - s1, 30);
            inty = this.yb1[w] + Pragmas.mulscale(this.yb2[w] - this.yb1[w], t, 30);
            xcross = this.xb1[w] + Pragmas.scale(Pragmas.mulscale(this.yb2[w], t, 30), this.xb2[w] - this.xb1[w], inty);
            if ((bad & 3) == 2) {
                if (this.xb1[w] <= xcross) {
                    iy2 = inty;
                    ix2 = xcross;
                }
                for (i = xcross + 1; i <= this.xb2[w]; ++i) {
                    if (i < 0 || i >= mostbuf.length) {
                        return bad;
                    }
                    mostbuf[i] = 0;
                }
            } else {
                if (xcross <= this.xb2[w]) {
                    iy1 = inty;
                    ix1 = xcross;
                }
                for (i = this.xb1[w]; i <= xcross; ++i) {
                    if (i < 0 || i >= mostbuf.length) {
                        return bad;
                    }
                    mostbuf[i] = 0;
                }
            }
        }
        if ((bad & 0xC) != 0) {
            t = Pragmas.divscale(z - s3, s4 - s3, 30);
            inty = this.yb1[w] + Pragmas.mulscale(this.yb2[w] - this.yb1[w], t, 30);
            xcross = this.xb1[w] + Pragmas.scale(Pragmas.mulscale(this.yb2[w], t, 30), this.xb2[w] - this.xb1[w], inty);
            if ((bad & 0xC) == 8) {
                if (this.xb1[w] <= xcross) {
                    iy2 = inty;
                    ix2 = xcross;
                }
                for (i = xcross + 1; i <= this.xb2[w]; ++i) {
                    if (i < 0 || i >= mostbuf.length) {
                        return bad;
                    }
                    mostbuf[i] = (short)Engine.ydimen;
                }
            } else {
                if (xcross <= this.xb2[w]) {
                    iy1 = inty;
                    ix1 = xcross;
                }
                for (i = this.xb1[w]; i <= xcross; ++i) {
                    if (i < 0 || i >= mostbuf.length) {
                        return bad;
                    }
                    mostbuf[i] = (short)Engine.ydimen;
                }
            }
        }
        int y = Pragmas.scale(z, Engine.xdimenscale, iy1) << 4;
        long yinc = ((Pragmas.scale(z, Engine.xdimenscale, iy2) << 4) - y) / (ix2 - ix1 + 1);
        this.qinterpolatedown16short(mostbuf, ix1, ix2 - ix1 + 1, y + ((int)Engine.globalhoriz << 16), yinc);
        if (ix1 < 0 || ix1 < mostbuf.length && mostbuf[ix1] < 0) {
            if (ix1 < 0) {
                ix1 = 0;
            }
            mostbuf[ix1] = 0;
        }
        if (ix1 >= mostbuf.length || mostbuf[ix1] > Engine.ydimen) {
            if (ix1 >= mostbuf.length) {
                ix1 = mostbuf.length - 1;
            }
            mostbuf[ix1] = (short)Engine.ydimen;
        }
        if (ix2 < 0 || ix2 < mostbuf.length && mostbuf[ix2] < 0) {
            if (ix2 < 0) {
                ix2 = 0;
            }
            mostbuf[ix2] = 0;
        }
        if (ix2 >= mostbuf.length || mostbuf[ix2] > Engine.ydimen) {
            if (ix2 >= mostbuf.length) {
                ix2 = mostbuf.length - 1;
            }
            mostbuf[ix2] = (short)Engine.ydimen;
        }
        return bad;
    }

    private int wallmost(short[] mostbuf, int w, short sectnum, int dastat) {
        int xcross;
        int intz;
        int inty;
        int z2;
        int z1;
        long t;
        int yv;
        int xv;
        int i;
        int z;
        if (dastat == 0) {
            z = Engine.sector[sectnum].ceilingz - Engine.globalposz;
            if ((Engine.sector[sectnum].ceilingstat & 2) == 0) {
                return this.owallmost(mostbuf, w, z);
            }
        } else {
            z = Engine.sector[sectnum].floorz - Engine.globalposz;
            if ((Engine.sector[sectnum].floorstat & 2) == 0) {
                return this.owallmost(mostbuf, w, z);
            }
        }
        if ((i = this.thewall[w]) == Engine.sector[sectnum].wallptr) {
            return this.owallmost(mostbuf, w, z);
        }
        int x1 = Engine.wall[i].x;
        int x2 = Engine.wall[Engine.wall[i].point2].x - x1;
        int y1 = Engine.wall[i].y;
        int y2 = Engine.wall[Engine.wall[i].point2].y - y1;
        short fw = Engine.sector[sectnum].wallptr;
        i = Engine.wall[fw].point2;
        int dx = Engine.wall[i].x - Engine.wall[fw].x;
        int dy = Engine.wall[i].y - Engine.wall[fw].y;
        int dasqr = this.krecipasm(this.engine.ksqrt(dx * dx + dy * dy));
        if (this.xb1[w] == 0) {
            xv = Engine.cosglobalang + Engine.sinviewingrangeglobalang;
            yv = Engine.singlobalang - Engine.cosviewingrangeglobalang;
        } else {
            xv = x1 - Engine.globalposx;
            yv = y1 - Engine.globalposy;
        }
        i = xv * (y1 - Engine.globalposy) - yv * (x1 - Engine.globalposx);
        int j = yv * x2 - xv * y2;
        if (Pragmas.klabs(j) > Pragmas.klabs(i >> 3)) {
            i = Pragmas.divscale(i, j, 28);
        }
        if (dastat == 0) {
            t = Pragmas.mulscale(Engine.sector[sectnum].ceilingheinum, dasqr, 15);
            z1 = Engine.sector[sectnum].ceilingz;
        } else {
            t = Pragmas.mulscale(Engine.sector[sectnum].floorheinum, dasqr, 15);
            z1 = Engine.sector[sectnum].floorz;
        }
        z1 = Pragmas.dmulscale((long)dx * t, Pragmas.mulscale(y2, i, 20) + (y1 - Engine.wall[fw].y << 8), (long)(-dy) * t, Pragmas.mulscale(x2, i, 20) + (x1 - Engine.wall[fw].x << 8), 24) + (z1 - Engine.globalposz << 7);
        if (this.xb2[w] == Engine.xdimen - 1) {
            xv = Engine.cosglobalang - Engine.sinviewingrangeglobalang;
            yv = Engine.singlobalang + Engine.cosviewingrangeglobalang;
        } else {
            xv = x2 + x1 - Engine.globalposx;
            yv = y2 + y1 - Engine.globalposy;
        }
        i = xv * (y1 - Engine.globalposy) - yv * (x1 - Engine.globalposx);
        j = yv * x2 - xv * y2;
        if (Pragmas.klabs(j) > Pragmas.klabs(i >> 3)) {
            i = Pragmas.divscale(i, j, 28);
        }
        if (dastat == 0) {
            t = Pragmas.mulscale(Engine.sector[sectnum].ceilingheinum, dasqr, 15);
            z2 = Engine.sector[sectnum].ceilingz;
        } else {
            t = Pragmas.mulscale(Engine.sector[sectnum].floorheinum, dasqr, 15);
            z2 = Engine.sector[sectnum].floorz;
        }
        z2 = Pragmas.dmulscale((long)dx * t, Pragmas.mulscale(y2, i, 20) + (y1 - Engine.wall[fw].y << 8), (long)(-dy) * t, Pragmas.mulscale(x2, i, 20) + (x1 - Engine.wall[fw].x << 8), 24) + (z2 - Engine.globalposz << 7);
        int s1 = Pragmas.mulscale(this.globaluclip, this.yb1[w], 20);
        int s2 = Pragmas.mulscale(this.globaluclip, this.yb2[w], 20);
        int s3 = Pragmas.mulscale(this.globaldclip, this.yb1[w], 20);
        int s4 = Pragmas.mulscale(this.globaldclip, this.yb2[w], 20);
        int bad = (z1 < s1 ? 1 : 0) + ((z2 < s2 ? 1 : 0) << 1) + ((z1 > s3 ? 1 : 0) << 2) + ((z2 > s4 ? 1 : 0) << 3);
        int ix1 = this.xb1[w];
        int ix2 = this.xb2[w];
        int iy1 = this.yb1[w];
        int iy2 = this.yb2[w];
        int oz1 = z1;
        int oz2 = z2;
        if ((bad & 3) == 3) {
            for (i = ix1; i <= ix2; ++i) {
                mostbuf[i] = 0;
            }
            return bad;
        }
        if ((bad & 0xC) == 12) {
            for (i = ix1; i <= ix2; ++i) {
                mostbuf[i] = (short)Engine.ydimen;
            }
            return bad;
        }
        if ((bad & 3) != 0) {
            t = Pragmas.divscale(oz1 - s1, s2 - s1 + oz1 - oz2, 30);
            inty = this.yb1[w] + Pragmas.mulscale(this.yb2[w] - this.yb1[w], t, 30);
            intz = oz1 + Pragmas.mulscale(oz2 - oz1, t, 30);
            xcross = this.xb1[w] + Pragmas.scale(Pragmas.mulscale(this.yb2[w], t, 30), this.xb2[w] - this.xb1[w], inty);
            if ((bad & 3) == 2) {
                if (this.xb1[w] <= xcross) {
                    z2 = intz;
                    iy2 = inty;
                    ix2 = xcross;
                }
                for (i = xcross + 1; i <= this.xb2[w]; ++i) {
                    mostbuf[i] = 0;
                }
            } else {
                if (xcross <= this.xb2[w]) {
                    z1 = intz;
                    iy1 = inty;
                    ix1 = xcross;
                }
                for (i = this.xb1[w]; i <= xcross; ++i) {
                    mostbuf[i] = 0;
                }
            }
        }
        if ((bad & 0xC) != 0) {
            t = Pragmas.divscale(oz1 - s3, s4 - s3 + oz1 - oz2, 30);
            inty = this.yb1[w] + Pragmas.mulscale(this.yb2[w] - this.yb1[w], t, 30);
            intz = oz1 + Pragmas.mulscale(oz2 - oz1, t, 30);
            xcross = this.xb1[w] + Pragmas.scale(Pragmas.mulscale(this.yb2[w], t, 30), this.xb2[w] - this.xb1[w], inty);
            if ((bad & 0xC) == 8) {
                if (this.xb1[w] <= xcross) {
                    z2 = intz;
                    iy2 = inty;
                    ix2 = xcross;
                }
                for (i = xcross + 1; i <= this.xb2[w]; ++i) {
                    mostbuf[i] = (short)Engine.ydimen;
                }
            } else {
                if (xcross <= this.xb2[w]) {
                    z1 = intz;
                    iy1 = inty;
                    ix1 = xcross;
                }
                for (i = this.xb1[w]; i <= xcross; ++i) {
                    mostbuf[i] = (short)Engine.ydimen;
                }
            }
        }
        int y = Pragmas.scale(z1, Engine.xdimenscale, iy1) << 4;
        int yinc = ((Pragmas.scale(z2, Engine.xdimenscale, iy2) << 4) - y) / (ix2 - ix1 + 1);
        this.qinterpolatedown16short(mostbuf, ix1, ix2 - ix1 + 1, y + ((int)Engine.globalhoriz << 16), yinc);
        if (mostbuf[ix1] < 0) {
            mostbuf[ix1] = 0;
        }
        if (mostbuf[ix1] > Engine.ydimen) {
            mostbuf[ix1] = (short)Engine.ydimen;
        }
        if (mostbuf[ix2] < 0) {
            mostbuf[ix2] = 0;
        }
        if (mostbuf[ix2] > Engine.ydimen) {
            mostbuf[ix2] = (short)Engine.ydimen;
        }
        return bad;
    }

    public int krecipasm(int i) {
        i = Float.floatToIntBits(i);
        return this.reciptable[i >> 12 & 0x7FF] >> (i - 1065353216 >> 23 & 0x1F) ^ i >> 31;
    }

    private void hline(int xr, int yp) {
        int xl = this.lastx[yp];
        if (xl > xr) {
            return;
        }
        int r = this.lookups[this.horizlookup2 + yp - (int)Engine.globalhoriz + this.horizycent];
        this.a.sethlineincs(this.globalx1 * r, this.globaly2 * r);
        int shade = this.engine.getpalookup(Pragmas.mulscale(r, this.globvis, 16), Engine.globalshade) << 8;
        this.a.hlineasm4(xr - xl, 0, shade, this.globalx2 * r + this.globalypanning, this.globaly1 * r + this.globalxpanning, this.ylookup[yp] + xr + this.frameoffset);
    }

    private void slowhline(int xr, int yp) {
        int xl = this.lastx[yp];
        if (xl > xr) {
            return;
        }
        int r = this.lookups[this.horizlookup2 + yp - (int)Engine.globalhoriz + this.horizycent];
        int xinc = this.globalx1 * r;
        int yinc = this.globaly2 * r;
        this.a.sethlineincs(this.globalx1 * r, this.globaly2 * r);
        this.a.setuphline(Engine.palookup[this.globalpalwritten], this.engine.getpalookup(Pragmas.mulscale(r, this.globvis, 16), Engine.globalshade) << 8);
        if ((this.globalorientation & 0x100) == 0) {
            this.a.mhline(this.globalbufplc, this.globaly1 * r + this.globalxpanning - xinc * (xr - xl), xr - xl << 16, 0, this.globalx2 * r + this.globalypanning - yinc * (xr - xl), this.ylookup[yp] + xl + this.frameoffset);
            return;
        }
        this.a.thline(this.globalbufplc, this.globaly1 * r + this.globalxpanning - xinc * (xr - xl), xr - xl << 16, 0, this.globalx2 * r + this.globalypanning - yinc * (xr - xl), this.ylookup[yp] + xl + this.frameoffset);
    }

    protected SoftwareOrpho allocOrphoRenderer(IOverheadMapSettings settings) {
        return new SoftwareOrpho(this, settings);
    }

    private void copybufreverse(byte[] s, int sptr, byte[] d, int dptr, int c) {
        while (c-- > 0) {
            d[dptr++] = s[sptr--];
        }
    }

    @Override
    public Renderer.RenderType getType() {
        return Renderer.RenderType.Software;
    }

    @Override
    public TileData.PixelFormat getTexFormat() {
        return TileData.PixelFormat.Pal8;
    }

    @Override
    public void setDefs(DefScript defs) {
        this.defs = defs;
    }

    @Override
    public void invalidatetile(int tilenume, int pal, int how) {
    }
}

