/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class DummyTileData
extends TileData {
    public final ByteBuffer data;
    public final int width;
    public final int height;
    public final TileData.PixelFormat fmt;
    public int format;
    public int internalformat;

    public DummyTileData(TileData.PixelFormat fmt, int width, int height) {
        this.width = width;
        this.height = height;
        this.fmt = fmt;
        this.data = ByteBuffer.allocateDirect(width * height * fmt.getLength()).order(ByteOrder.LITTLE_ENDIAN);
        switch (fmt) {
            case Rgba: {
                this.format = 6408;
                this.internalformat = 6408;
                break;
            }
            case Rgb: {
                this.format = 6407;
                this.internalformat = 6407;
                break;
            }
            case Pal8: {
                this.format = 6409;
                this.internalformat = 6409;
                break;
            }
            case Bitmap: {
                this.format = 6406;
                this.internalformat = 6406;
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getPixels() {
        this.data.rewind();
        return this.data;
    }

    @Override
    public int getGLType() {
        return 5121;
    }

    @Override
    public int getGLInternalFormat() {
        return this.internalformat;
    }

    @Override
    public int getGLFormat() {
        return this.format;
    }

    @Override
    public TileData.PixelFormat getPixelFormat() {
        return this.fmt;
    }

    @Override
    public boolean hasAlpha() {
        return true;
    }

    @Override
    public boolean isClamped() {
        return false;
    }

    @Override
    public boolean isHighTile() {
        return false;
    }
}

