/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.GLFilter;

public class GLTileArray {
    private final GLTile[] array;

    public GLTileArray(int size) {
        this.array = new GLTile[size];
    }

    public GLTile get(int picnum, int palnum, boolean clamped, int surfnum) {
        GLTile pth = this.array[picnum];
        while (pth != null && pth.palnum <= palnum) {
            if (pth.getPixelFormat() == TileData.PixelFormat.Pal8 ? pth.isClamped() == clamped : pth.palnum == palnum && pth.isClamped() == clamped && pth.skyface == surfnum) {
                return pth;
            }
            pth = pth.next;
        }
        return null;
    }

    public GLTile get(int picnum) {
        return this.array[picnum];
    }

    public void add(GLTile newNode, int dapicnum) {
        int p = newNode.compareTo(this.array[dapicnum]);
        if (p <= 0) {
            newNode.next = this.array[dapicnum];
            this.array[dapicnum] = newNode;
        } else {
            GLTile prev = null;
            GLTile pth = this.array[dapicnum];
            do {
                if (newNode.compareTo(pth) < 0) {
                    newNode.next = pth;
                    if (prev != null) {
                        prev.next = newNode;
                    }
                    return;
                }
                prev = pth;
            } while ((pth = pth.next) != null);
            prev.next = newNode;
        }
    }

    public void dispose(int tilenum) {
        GLTile pth = this.array[tilenum];
        while (pth != null) {
            GLTile next = pth.next;
            pth.delete();
            pth = next;
        }
        this.array[tilenum] = null;
    }

    public void setFilter(int tilenum, GLFilter filter, int anisotropy) {
        GLTile pth = this.array[tilenum];
        while (pth != null) {
            GLTile next = pth.next;
            pth.bind();
            pth.setupTextureFilter(filter, anisotropy);
            if (!filter.retro) {
                pth.setInvalidated(true);
            }
            pth = next;
        }
    }

    public void invalidate(int tilenum) {
        GLTile pth = this.array[tilenum];
        while (pth != null) {
            GLTile next = pth.next;
            if (pth.hicr == null && pth.getPixelFormat() != TileData.PixelFormat.Pal8) {
                pth.setInvalidated(true);
            }
            pth = next;
        }
    }
}

