/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.GLTileArray;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.Tile;

public class TextureManager {
    protected final Engine engine;
    protected final GLTileArray cache;
    protected TextureHDInfo info;
    private GLTile bindedTile;
    protected GLTile palette;
    protected GLTile[] palookups;
    protected int texunits = 0;
    protected final ExpandTexture expand;

    public TextureManager(Engine engine, ExpandTexture opt) {
        this.engine = engine;
        this.cache = new GLTileArray(Engine.MAXTILES);
        this.palookups = new GLTile[256];
        this.expand = opt;
    }

    public void setTextureInfo(TextureHDInfo info) {
        this.info = info;
    }

    public GLTile get(TileData.PixelFormat fmt, int dapicnum, int dapalnum, int skybox, int method) {
        Hicreplctyp si;
        boolean clamping = this.clampingMode(method);
        boolean alpha = this.alphaMode(method);
        Hicreplctyp hicreplctyp = si = GLSettings.useHighTile.get() != false && this.info != null ? this.info.findTexture(dapicnum, dapalnum, skybox) : null;
        if (si == null && (skybox != 0 || dapalnum >= 252)) {
            return null;
        }
        GLTile tile = this.cache.get(dapicnum, dapalnum, clamping, skybox);
        if (si != null && tile != null && tile.hicr == null && si.skybox == null) {
            this.cache.dispose(dapicnum);
            tile = null;
        }
        boolean useMipMaps = GLSettings.textureFilter.get().mipmaps;
        if (tile != null) {
            if (tile.isInvalidated()) {
                tile.setInvalidated(false);
                TileData data = this.loadPic(fmt, si, dapicnum, dapalnum, clamping, alpha, skybox);
                tile.update(data, fmt == TileData.PixelFormat.Pal8 ? 0 : dapalnum, useMipMaps);
            }
        } else {
            if (si != null && dapalnum != 0 && this.info.findTexture(dapicnum, 0, skybox) == si && (tile = this.cache.get(dapicnum, 0, clamping, skybox)) != null) {
                return tile;
            }
            TileData data = this.loadPic(fmt, si, dapicnum, dapalnum, clamping, alpha, skybox);
            if (data == null) {
                return null;
            }
            tile = this.allocTile(data, si, dapicnum, fmt == TileData.PixelFormat.Pal8 ? 0 : dapalnum, skybox, alpha, useMipMaps);
        }
        if (dapalnum >= 252) {
            this.activateEffect();
        }
        return tile;
    }

    public TileData.PixelFormat getFmt(int dapicnum) {
        GLTile tile = this.cache.get(dapicnum);
        if (tile != null) {
            return tile.getPixelFormat();
        }
        return null;
    }

    public boolean bind(GLTile tile) {
        if (this.bindedTile == tile) {
            return false;
        }
        tile.bind();
        return true;
    }

    public void unbind() {
        if (this.bindedTile != null) {
            this.bindedTile.unbind();
        }
        this.bindedTile = null;
    }

    public void precache(TileData.PixelFormat fmt, int dapicnum, int dapalnum, int method) {
        this.get(fmt, dapicnum, dapalnum, 0, method);
    }

    public int getTextureUnits() {
        return this.texunits;
    }

    protected TileData loadPic(TileData.PixelFormat fmt, Hicreplctyp hicr, int dapicnum, int dapalnum, boolean clamping, boolean alpha, int skybox) {
        block4: {
            String fn;
            byte[] data;
            if (hicr != null && (data = BuildGdx.cache.getBytes(fn = this.checkResource(hicr, dapicnum, skybox), 0)) != null) {
                try {
                    return new PixmapTileData(new Pixmap(data, 0, data.length), clamping, this.expand.get());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (skybox == 0) break block4;
                    return null;
                }
            }
        }
        if (fmt == TileData.PixelFormat.Pal8) {
            return new IndexedTileData(this.engine.getTile(dapicnum), clamping, alpha, this.expand.get());
        }
        return new RGBTileData(this.engine.getTile(dapicnum), dapalnum, clamping, alpha, this.expand.get());
    }

    protected String checkResource(Hicreplctyp hicr, int dapic, int facen) {
        if (hicr == null) {
            return null;
        }
        String fn = null;
        if (facen > 0) {
            if (hicr.skybox == null || facen > 6 || hicr.skybox.face[facen - 1] == null) {
                return null;
            }
            fn = hicr.skybox.face[facen - 1];
        } else {
            fn = hicr.filename;
        }
        if (!BuildGdx.cache.contains(fn, 0)) {
            Console.Println("Hightile[" + dapic + "]: File \"" + fn + "\" not found");
            if (facen > 0) {
                hicr.skybox.ignore = 1;
            } else {
                hicr.ignore = 1;
            }
            return null;
        }
        return fn;
    }

    public GLTile newTile(TileData pic, int palnum, boolean useMipMaps) {
        return new GLTile(pic, palnum, useMipMaps){

            @Override
            public void bind() {
                super.bind();
                TextureManager.this.bindedTile = this;
            }

            @Override
            public void unbind() {
                super.unbind();
                TextureManager.this.bindedTile = null;
            }

            @Override
            public void bind(int unit) {
                BuildGdx.gl.glBindTexture(this.glTarget, this.glHandle);
            }
        };
    }

    public GLTile newTile(TileData.PixelFormat fmt, int width, int height) {
        return new GLTile(fmt, width, height){

            @Override
            public void bind() {
                super.bind();
                TextureManager.this.bindedTile = this;
            }

            @Override
            public void bind(int unit) {
                BuildGdx.gl.glBindTexture(this.glTarget, this.glHandle);
            }

            @Override
            public void unbind() {
                super.unbind();
                TextureManager.this.bindedTile = null;
            }
        };
    }

    protected GLTile allocTile(TileData data, Hicreplctyp si, int dapicnum, int dapalnum, int skybox, boolean alpha, boolean useMipMaps) {
        GLTile tile = this.newTile(data, data.isHighTile() ? si.palnum : dapalnum, useMipMaps);
        if (data.isHighTile()) {
            tile.setHighTile(si);
            tile.setHasAlpha(alpha);
            tile.setSkyboxFace(skybox);
            if (skybox > 0) {
                tile.scalex = (float)tile.getWidth() / 64.0f;
                tile.scaley = (float)tile.getHeight() / 64.0f;
            } else {
                Tile pic = this.engine.getTile(dapicnum);
                if (data instanceof PixmapTileData) {
                    tile.width = ((PixmapTileData)data).getTileWidth();
                    tile.height = ((PixmapTileData)data).getTileHeight();
                }
                int width = tile.getWidth();
                int height = tile.getHeight();
                tile.scalex = (float)width / (float)pic.getWidth();
                tile.scaley = (float)height / (float)pic.getHeight();
            }
        }
        data.dispose();
        this.cache.add(tile, dapicnum);
        return tile;
    }

    public void setFilter(GLFilter filter) {
        int anisotropy = GLSettings.textureAnisotropy.get();
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.cache.setFilter(i, filter, anisotropy);
        }
    }

    public void invalidate(int dapicnum, int dapalnum, boolean clamped) {
        GLTile tile = this.cache.get(dapicnum, dapalnum, clamped, 0);
        if (tile == null) {
            return;
        }
        if (!tile.isHighTile()) {
            tile.setInvalidated(true);
        }
    }

    public void invalidateall() {
        for (int j = Engine.MAXTILES - 1; j >= 0; --j) {
            this.cache.invalidate(j);
        }
    }

    public boolean clampingMode(int dameth) {
        return (dameth & 4) >> 2 == 1;
    }

    public boolean alphaMode(int dameth) {
        return (dameth & 0x100) == 0;
    }

    public void uninit() {
        Console.Println("TextureCache uninited!", Console.OSDTEXT_RED);
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.cache.dispose(i);
        }
        Engine.pTextfont.uninit();
        Engine.pSmallTextfont.uninit();
    }

    public GLTile getLastBinded() {
        return this.bindedTile;
    }

    public void activateEffect() {
        if (GLInfo.multisample == 0) {
            return;
        }
        BuildGdx.gl.glActiveTexture(33984 + ++this.texunits);
        BuildGdx.gl.glEnable(3553);
    }

    public void deactivateEffects() {
        if (GLInfo.multisample == 0) {
            return;
        }
        while (this.texunits >= 0) {
            BuildGdx.gl.glActiveTexture(33984 + this.texunits);
            BuildGdx.gl.glMatrixMode(5890);
            BuildGdx.gl.glLoadIdentity();
            BuildGdx.gl.glMatrixMode(5888);
            if (this.texunits > 0) {
                BuildGdx.gl.glTexEnvf(8960, 34163, 1.0f);
                BuildGdx.gl.glDisable(3553);
            }
            --this.texunits;
        }
        this.texunits = 0;
    }

    public GLTile getPalette() {
        return this.palette;
    }

    public GLTile getPalookup(int pal) {
        if (this.palookups[pal] == null || this.palookups[pal].isInvalidated()) {
            if (Engine.palookup[pal] == null) {
                return this.palookups[0];
            }
            LookupData dat = new LookupData(Engine.palookup[pal]);
            if (this.palookups[pal] != null) {
                this.palookups[pal].setInvalidated(false);
                this.palookups[pal].update(dat, 0, false);
            } else {
                this.palookups[pal] = this.newTile(dat, 0, false);
            }
            this.palookups[pal].unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
        }
        return this.palookups[pal];
    }

    public void disposePalette() {
        this.palette.dispose();
        this.palette = null;
        for (int i = 0; i < 256; ++i) {
            if (this.palookups[i] == null) continue;
            this.palookups[i].dispose();
            this.palookups[i] = null;
        }
    }

    public void changePalette(byte[] pal) {
        PaletteData dat = new PaletteData(pal);
        if (this.palette != null) {
            this.palette.update(dat, 0, false);
        } else {
            this.palette = this.newTile(dat, 0, false);
        }
        this.palette.unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
    }

    public void invalidatepalookup(int pal) {
        if (this.palookups[pal] != null) {
            this.palookups[pal].setInvalidated(true);
        }
    }

    public static enum ExpandTexture {
        Horizontal(1),
        Vertical(2),
        Both(3);

        private final byte bit;

        private ExpandTexture(int bit) {
            this.bit = (byte)bit;
        }

        public byte get() {
            return this.bit;
        }
    }

    private class LookupData
    extends ShaderData {
        public LookupData(byte[] data) {
            super(data, 256, 64, 1);
        }

        @Override
        public int getGLFormat() {
            return 6409;
        }
    }

    private class PaletteData
    extends ShaderData {
        public PaletteData(byte[] data) {
            super(data, 256, 1, 3);
        }

        @Override
        public TileData.PixelFormat getPixelFormat() {
            return TileData.PixelFormat.Pal8;
        }
    }

    private abstract class ShaderData
    extends DummyTileData {
        public ShaderData(byte[] buf, int w, int h, int bytes) {
            super(bytes != 1 ? TileData.PixelFormat.Rgb : TileData.PixelFormat.Pal8, w, h);
            this.data.clear();
            this.data.put(buf, 0, buf.length);
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }
    }
}

