/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import com.badlogic.gdx.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class VideoMode {
    public static final int MAXVALIDMODES = 256;
    public static String[] strvmodes;
    public static List<VideoMode> validmodes;
    public Graphics.DisplayMode mode;
    public int xdim;
    public int ydim;
    public byte bpp;

    public VideoMode(Graphics.DisplayMode mode) {
        this.mode = mode;
        this.xdim = mode.width;
        this.ydim = mode.height;
        this.bpp = (byte)mode.bitsPerPixel;
    }

    public static void initVideoModes(Graphics.DisplayMode[] modes, Graphics.DisplayMode DesktopDisplayMode) {
        VideoMode mode;
        int i;
        if (strvmodes != null) {
            return;
        }
        for (i = 0; i < modes.length; ++i) {
            mode = new VideoMode(modes[i]);
            boolean exist = false;
            for (VideoMode savedmode : validmodes) {
                if (savedmode.xdim != mode.xdim || savedmode.ydim != mode.ydim) continue;
                exist = true;
                break;
            }
            if (exist || mode.xdim > 4096 || mode.ydim > 3072) continue;
            validmodes.add(mode);
        }
        if (validmodes.size() == 0) {
            validmodes.add(new VideoMode(DesktopDisplayMode));
        }
        Collections.sort(validmodes, new Comparator<VideoMode>(){

            @Override
            public int compare(VideoMode lhs, VideoMode rhs) {
                return lhs.ydim > rhs.ydim ? -1 : (lhs.ydim > rhs.ydim ? 1 : 0);
            }
        });
        Collections.sort(validmodes, new Comparator<VideoMode>(){

            @Override
            public int compare(VideoMode lhs, VideoMode rhs) {
                return lhs.xdim > rhs.xdim ? -1 : (lhs.xdim > rhs.xdim ? 1 : 0);
            }
        });
        Collections.reverse(validmodes);
        strvmodes = new String[validmodes.size()];
        for (i = 0; i < validmodes.size(); ++i) {
            mode = validmodes.get(i);
            VideoMode.strvmodes[i] = mode.xdim == DesktopDisplayMode.width && mode.ydim == DesktopDisplayMode.height ? "* " + mode.xdim + " x " + mode.ydim : mode.xdim + " x " + mode.ydim;
        }
    }

    public static Graphics.DisplayMode getmode(int xdim, int ydim) {
        int j = 0;
        for (int i = 0; i < validmodes.size(); ++i) {
            if (VideoMode.validmodes.get((int)i).xdim != xdim || VideoMode.validmodes.get((int)i).ydim != ydim) continue;
            j = i;
            break;
        }
        return VideoMode.validmodes.get((int)j).mode;
    }

    public static boolean setFullscreen(int xdim, int ydim, boolean fullscreen) {
        if (!fullscreen) {
            return false;
        }
        return VideoMode.getmodeindex(xdim, ydim) != -1;
    }

    public static Graphics.DisplayMode getmode(int index) {
        if (index >= 0 && index < validmodes.size()) {
            return VideoMode.validmodes.get((int)index).mode;
        }
        return null;
    }

    public static int getmodeindex(int xdim, int ydim) {
        int j = -1;
        for (int i = 0; i < validmodes.size(); ++i) {
            if (VideoMode.validmodes.get((int)i).xdim != xdim || VideoMode.validmodes.get((int)i).ydim != ydim) continue;
            j = i;
            break;
        }
        return j;
    }

    static {
        validmodes = new ArrayList<VideoMode>();
    }
}

