/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.Types.Palette;

public class TextureHDInfo {
    private final Palette[] tinting = new Palette[256];
    private final Hicreplctyp[] cache = new Hicreplctyp[Engine.MAXTILES];

    public TextureHDInfo() {
        for (int i = 0; i < 256; ++i) {
            this.tinting[i] = new Palette(255, 255, 255, 0);
        }
    }

    public TextureHDInfo(TextureHDInfo src) {
        int i;
        for (i = 0; i < 256; ++i) {
            this.tinting[i] = new Palette(src.tinting[i]);
        }
        for (i = 0; i < Engine.MAXTILES; ++i) {
            if (src.cache[i] == null) continue;
            Hicreplctyp hr = src.cache[i];
            while (hr != null) {
                this.add(new Hicreplctyp(hr), i);
                hr = hr.next;
            }
        }
    }

    public void setPaletteTint(int palnum, int r, int g, int b, int effect) {
        if (palnum >= 256) {
            return;
        }
        this.tinting[palnum].update(r, g, b, effect & 3);
    }

    public Palette getTints(int palnum) {
        return this.tinting[palnum];
    }

    private Hicreplctyp get(int picnum, int palnum) {
        Hicreplctyp hr = this.cache[picnum];
        while (hr != null) {
            if (hr.palnum == palnum) {
                return hr;
            }
            hr = hr.next;
        }
        return null;
    }

    private void add(Hicreplctyp tex, int picnum) {
        tex.next = this.cache[picnum];
        this.cache[picnum] = tex;
    }

    public Hicreplctyp remove(int picnum, int palnum) {
        if (this.cache[picnum] != null && this.cache[picnum].palnum == palnum) {
            Hicreplctyp tmp = this.cache[picnum];
            this.cache[picnum] = this.cache[picnum].next;
            return tmp;
        }
        Hicreplctyp hr = this.cache[picnum];
        while (hr != null) {
            Hicreplctyp tmp = hr.next;
            if (tmp.palnum == palnum) {
                hr.next = tmp.next;
                return tmp;
            }
            hr = hr.next;
        }
        return null;
    }

    public boolean isHighTile(int picnum) {
        return this.cache[picnum] != null;
    }

    public boolean addTexture(int picnum, int palnum, String filen, float alphacut, float xscale, float yscale, float specpower, float specfactor, int flags) {
        if (filen == null || picnum >= Engine.MAXTILES || palnum >= 256) {
            return false;
        }
        Hicreplctyp hr = this.get(picnum, palnum);
        if (hr == null) {
            hr = new Hicreplctyp(palnum);
            this.add(hr, picnum);
        }
        hr.filename = filen;
        hr.ignore = 0;
        hr.alphacut = Math.min(alphacut, 1.0f);
        hr.xscale = xscale;
        hr.yscale = yscale;
        hr.specpower = specpower;
        hr.specfactor = specfactor;
        hr.flags = flags;
        return true;
    }

    public boolean addSkybox(int picnum, int palnum, String[] faces) {
        if (picnum >= Engine.MAXTILES || palnum >= 256) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (faces[i] != null) continue;
            return false;
        }
        Hicreplctyp hr = this.get(picnum, palnum);
        if (hr == null) {
            hr = new Hicreplctyp(palnum, true);
            this.add(hr, picnum);
        }
        System.arraycopy(faces, 0, hr.skybox.face, 0, 6);
        hr.skybox.ignore = 0;
        return true;
    }

    public Hicreplctyp findTexture(int picnum, int palnum, int skybox) {
        if (picnum >= Engine.MAXTILES) {
            return null;
        }
        while (true) {
            Hicreplctyp hr;
            if ((hr = this.get(picnum, palnum)) != null && (skybox != 0 ? hr.skybox != null && hr.skybox.ignore == 0 : hr.ignore == 0)) {
                return hr;
            }
            if (palnum == 0 || palnum >= 252) break;
            palnum = 0;
        }
        return null;
    }
}

