/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Types.WALL;

public class SECTOR {
    public static final int sizeof = 40;
    private static final ByteBuffer buffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
    public short wallptr;
    public short wallnum;
    public int ceilingz;
    public int floorz;
    public short ceilingstat;
    public short floorstat;
    public short ceilingpicnum;
    public short ceilingheinum;
    public byte ceilingshade;
    public short ceilingpal;
    public short ceilingxpanning;
    public short ceilingypanning;
    public short floorpicnum;
    public short floorheinum;
    public byte floorshade;
    public short floorpal;
    public short floorxpanning;
    public short floorypanning;
    public short visibility;
    public short filler;
    public short lotag;
    public short hitag;
    public short extra;
    private static SectorIterator it;

    public SECTOR() {
    }

    public SECTOR(byte[] data) {
        this.buildSector(new DataResource(data));
    }

    public SECTOR(Resource data) {
        this.buildSector(data);
    }

    public boolean isParallaxCeiling() {
        return (this.ceilingstat & 1) != 0;
    }

    public boolean isSlopedCeiling() {
        return (this.ceilingstat & 2) != 0;
    }

    public boolean isTexSwapedCeiling() {
        return (this.ceilingstat & 4) != 0;
    }

    public boolean isTexSmooshedCeiling() {
        return (this.ceilingstat & 8) != 0;
    }

    public boolean isTexXFlippedCeiling() {
        return (this.ceilingstat & 0x10) != 0;
    }

    public boolean isTexYFlippedCeiling() {
        return (this.ceilingstat & 0x20) != 0;
    }

    public boolean isRelativeTexCeiling() {
        return (this.ceilingstat & 0x40) != 0;
    }

    public boolean isMaskedTexCeiling() {
        return (this.ceilingstat & 0x80) != 0;
    }

    public boolean isTransparentCeiling() {
        return (this.ceilingstat & 0x100) != 0;
    }

    public boolean isTransparent2Ceiling() {
        return (this.ceilingstat & 0x180) != 0;
    }

    public boolean isParallaxFloor() {
        return (this.floorstat & 1) != 0;
    }

    public boolean isSlopedFloor() {
        return (this.floorstat & 2) != 0;
    }

    public boolean isTexSwapedFloor() {
        return (this.floorstat & 4) != 0;
    }

    public boolean isTexSmooshedFloor() {
        return (this.floorstat & 8) != 0;
    }

    public boolean isTexXFlippedFloor() {
        return (this.floorstat & 0x10) != 0;
    }

    public boolean isTexYFlippedFloor() {
        return (this.floorstat & 0x20) != 0;
    }

    public boolean isRelativeTexFloor() {
        return (this.floorstat & 0x40) != 0;
    }

    public boolean isMaskedTexFloor() {
        return (this.floorstat & 0x80) != 0;
    }

    public boolean isTransparentFloor() {
        return (this.floorstat & 0x100) != 0;
    }

    public boolean isTransparent2Floor() {
        return (this.floorstat & 0x180) != 0;
    }

    public void buildSector(Resource bb) {
        this.wallptr = bb.readShort();
        if (this.wallptr < 0 || this.wallptr >= Engine.MAXWALLS) {
            this.wallptr = 0;
        }
        this.wallnum = bb.readShort();
        this.ceilingz = bb.readInt();
        this.floorz = bb.readInt();
        this.ceilingstat = bb.readShort();
        this.floorstat = bb.readShort();
        this.ceilingpicnum = bb.readShort();
        if (!Gameutils.isValidTile(this.ceilingpicnum)) {
            this.ceilingpicnum = 0;
        }
        this.ceilingheinum = bb.readShort();
        this.ceilingshade = bb.readByte();
        this.ceilingpal = (short)(bb.readByte() & 0xFF);
        this.ceilingxpanning = (short)(bb.readByte() & 0xFF);
        this.ceilingypanning = (short)(bb.readByte() & 0xFF);
        this.floorpicnum = bb.readShort();
        if (!Gameutils.isValidTile(this.floorpicnum)) {
            this.floorpicnum = 0;
        }
        this.floorheinum = bb.readShort();
        this.floorshade = bb.readByte();
        this.floorpal = (short)(bb.readByte() & 0xFF);
        this.floorxpanning = (short)(bb.readByte() & 0xFF);
        this.floorypanning = (short)(bb.readByte() & 0xFF);
        this.visibility = (short)(bb.readByte() & 0xFF);
        this.filler = bb.readByte().byteValue();
        this.lotag = bb.readShort();
        this.hitag = bb.readShort();
        this.extra = bb.readShort();
    }

    public void set(SECTOR src) {
        this.wallptr = src.wallptr;
        this.wallnum = src.wallnum;
        this.ceilingz = src.ceilingz;
        this.floorz = src.floorz;
        this.ceilingstat = src.ceilingstat;
        this.floorstat = src.floorstat;
        this.ceilingpicnum = src.ceilingpicnum;
        this.ceilingheinum = src.ceilingheinum;
        this.ceilingshade = src.ceilingshade;
        this.ceilingpal = src.ceilingpal;
        this.ceilingxpanning = src.ceilingxpanning;
        this.ceilingypanning = src.ceilingypanning;
        this.floorpicnum = src.floorpicnum;
        this.floorheinum = src.floorheinum;
        this.floorshade = src.floorshade;
        this.floorpal = src.floorpal;
        this.floorxpanning = src.floorxpanning;
        this.floorypanning = src.floorypanning;
        this.visibility = src.visibility;
        this.filler = src.filler;
        this.lotag = src.lotag;
        this.hitag = src.hitag;
        this.extra = src.extra;
    }

    public byte[] getBytes() {
        buffer.clear();
        buffer.putShort(this.wallptr);
        buffer.putShort(this.wallnum);
        buffer.putInt(this.ceilingz);
        buffer.putInt(this.floorz);
        buffer.putShort(this.ceilingstat);
        buffer.putShort(this.floorstat);
        buffer.putShort(this.ceilingpicnum);
        buffer.putShort(this.ceilingheinum);
        buffer.put(this.ceilingshade);
        buffer.put((byte)this.ceilingpal);
        buffer.put((byte)this.ceilingxpanning);
        buffer.put((byte)this.ceilingypanning);
        buffer.putShort(this.floorpicnum);
        buffer.putShort(this.floorheinum);
        buffer.put(this.floorshade);
        buffer.put((byte)this.floorpal);
        buffer.put((byte)this.floorxpanning);
        buffer.put((byte)this.floorypanning);
        buffer.put((byte)this.visibility);
        buffer.put((byte)this.filler);
        buffer.putShort(this.lotag);
        buffer.putShort(this.hitag);
        buffer.putShort(this.extra);
        return buffer.array();
    }

    public String toString() {
        String out = "wallptr " + this.wallptr + " \r\n";
        out = out + "wallnum " + this.wallnum + " \r\n";
        out = out + "ceilingz " + this.ceilingz + " \r\n";
        out = out + "floorz " + this.floorz + " \r\n";
        out = out + "ceilingstat " + this.ceilingstat + " \r\n";
        out = out + "floorstat " + this.floorstat + " \r\n";
        out = out + "ceilingpicnum " + this.ceilingpicnum + " \r\n";
        out = out + "ceilingheinum " + this.ceilingheinum + " \r\n";
        out = out + "ceilingshade " + this.ceilingshade + " \r\n";
        out = out + "ceilingpal " + this.ceilingpal + " \r\n";
        out = out + "ceilingxpanning " + this.ceilingxpanning + " \r\n";
        out = out + "ceilingypanning " + this.ceilingypanning + " \r\n";
        out = out + "floorpicnum " + this.floorpicnum + " \r\n";
        out = out + "floorheinum " + this.floorheinum + " \r\n";
        out = out + "floorshade " + this.floorshade + " \r\n";
        out = out + "floorpal " + this.floorpal + " \r\n";
        out = out + "floorxpanning " + this.floorxpanning + " \r\n";
        out = out + "floorypanning " + this.floorypanning + " \r\n";
        out = out + "visibility " + this.visibility + " \r\n";
        out = out + "filler " + this.filler + " \r\n";
        out = out + "lotag " + this.lotag + " \r\n";
        out = out + "hitag " + this.hitag + " \r\n";
        out = out + "extra " + this.extra + " \r\n";
        return out;
    }

    public SectorIterator iterator() {
        if (it == null) {
            it = new SectorIterator();
        }
        return it.init(this.wallptr, this.wallnum);
    }

    public static final class SectorIterator
    implements Iterator<WALL> {
        private short i;
        private short startwall;
        private short endwall;

        @Override
        public boolean hasNext() {
            return this.startwall < this.endwall;
        }

        @Override
        public WALL next() {
            return Engine.wall[this.nexti()];
        }

        public short nexti() {
            short s = this.startwall;
            this.startwall = (short)(s + 1);
            this.i = s;
            return s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int getIndex() {
            return this.i;
        }

        protected SectorIterator init(short wallptr, short wallnum) {
            this.startwall = wallptr;
            this.endwall = (short)(wallnum + this.startwall);
            return this;
        }
    }
}

