/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import java.util.HashSet;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class TileFont {
    public static final HashSet<TileFont> managedFont = new HashSet();
    public GLTile atlas;
    public Object ptr;
    public FontType type;
    public int charsizx;
    public int charsizy;
    public int cols;
    public int rows;
    public int sizx = -1;
    public int sizy = -1;

    public TileFont(FontType type, Object ptr, int charsizx, int charsizy, int cols, int rows) {
        this.ptr = ptr;
        this.type = type;
        this.charsizx = charsizx;
        this.charsizy = charsizy;
        this.cols = cols;
        this.rows = rows;
        this.sizx = charsizx * cols;
        this.sizy = charsizy * rows;
        managedFont.add(this);
    }

    public GLTile getGL(TextureManager textureCache, TileData.PixelFormat fmt, int col) {
        GLTile tile = textureCache.get(fmt, (Integer)this.ptr, col, 0, 0);
        if (tile != null) {
            textureCache.bind(tile);
            return tile;
        }
        return null;
    }

    public void uninit() {
        if (this.atlas != null) {
            this.atlas.delete();
            this.atlas = null;
        }
    }

    public void dispose() {
        this.uninit();
        managedFont.remove(this);
    }

    public static enum FontType {
        Tilemap,
        Bitmap;

    }

    public static abstract class TileFontData
    extends DummyTileData {
        public TileFontData(int width, int height) {
            super(TileData.PixelFormat.Rgba, width, height);
            this.buildAtlas(this.data);
        }

        public abstract ByteBuffer buildAtlas(ByteBuffer var1);
    }
}

