/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio;

import com.badlogic.gdx.backends.lwjgl.audio.OggInputStream;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import ru.m210projects.Build.Audio.Music;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Audio.SoundData;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Audio.SourceCallback;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Loader.WAVLoader;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.desktop.audio.ALAudio;
import ru.m210projects.Build.desktop.audio.ALMusicDrv;
import ru.m210projects.Build.desktop.audio.ALSource;

public class ALSoundDrv
implements Sound {
    protected DriverCallback driverCallback;
    protected boolean noDevice = true;
    private static final FloatBuffer NULLVECTOR = BufferUtils.newFloatBuffer(3);
    private static final FloatBuffer orientation = BufferUtils.newFloatBuffer(6);
    private final float[] deforientation = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    protected Sound.SystemType system;
    protected IntBuffer buffers;
    protected SourceManager sourceManager;
    private float soundVolume = 0.5f;
    private final String name;
    protected List<Source> loopedSource = new ArrayList<Source>();
    private boolean alReverbEnable = false;
    private float alReverbDelay = 0.0f;
    private int alCurrentSoftResampler;
    private ALMusicDrv mus;
    private ALAudio al;

    public ALSoundDrv(ALAudio al) {
        this(al, "OpenAL");
    }

    public ALSoundDrv(ALAudio al, String name) {
        this.al = al;
        this.mus = new ALMusicDrv(this);
        this.name = name;
    }

    public ALSoundDrv(DriverCallback driverCallback, String name) {
        this.driverCallback = driverCallback;
        this.name = name;
    }

    public ALAudio getALAudio() {
        if (this.driverCallback != null) {
            this.al = this.InitRegisteredDriver();
            this.mus = new ALMusicDrv(this);
        }
        return this.al;
    }

    private ALAudio InitRegisteredDriver() {
        if (this.driverCallback != null) {
            try {
                this.al = this.driverCallback.InitDriver();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Console.Println("Unable to initialize OpenAL! - " + e.getLocalizedMessage(), Console.OSDTEXT_RED);
            }
            this.driverCallback = null;
        }
        return this.al;
    }

    @Override
    public synchronized boolean init(Sound.SystemType system, int maxChannels, int softResampler) {
        if (this.getALAudio() == null) {
            this.noDevice = true;
            return false;
        }
        if (maxChannels < 1) {
            maxChannels = 1;
        }
        this.al.alDistanceModel(0);
        orientation.put(this.deforientation).flip();
        this.sourceManager = new SourceManager(maxChannels);
        this.buffers = BufferUtils.newIntBuffer(maxChannels);
        this.al.alGenBuffers(this.buffers);
        this.resetListener();
        this.system = system;
        Console.Println(this.al.getName() + " initialized", Console.OSDTEXT_GOLD);
        Console.Println("\twith max voices: " + this.sourceManager.getSourcesNum(), Console.OSDTEXT_GOLD);
        Console.Println("\tOpenAL version: " + this.al.getVersion(), Console.OSDTEXT_GOLD);
        this.noDevice = false;
        if (this.al.alIsEFXSupport()) {
            Console.Println("ALC_EXT_EFX enabled.");
        } else {
            Console.Println("ALC_EXT_EFX not supported!");
        }
        if (this.al.alIsSoftResamplerSupport()) {
            Console.Println("AL_SOFT_Source_Resampler enabled. Using resampler: " + this.al.alGetSoftResamplerName(softResampler));
            this.setSoftResampler(softResampler);
        } else {
            Console.Println("AL_SOFT_Source_Resampler not supported!");
        }
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL init error " + error, Console.OSDTEXT_RED);
        }
        this.getDigitalMusic().init();
        if (error != 0) {
            Console.Println("OpenAL digital music init error " + error, Console.OSDTEXT_RED);
        }
        this.loopedSource.clear();
        return true;
    }

    @Override
    public boolean isInited() {
        return !this.noDevice;
    }

    @Override
    public void dispose() {
        this.uninit();
        if (this.al != null) {
            this.al.dispose();
        }
    }

    @Override
    public String getName() {
        if (this.noDevice) {
            return this.name;
        }
        return "OpenAL" + this.al.getVersion();
    }

    @Override
    public void setListener(int x, int y, int z, int ang) {
        if (this.noDevice) {
            return;
        }
        if (this.system != Sound.SystemType.Mono) {
            this.al.alListener3f(4100, x, y, z);
            double angle = (double)(ang * 2) * Math.PI / 2048.0;
            orientation.put(0, (float)Math.cos(angle));
            orientation.put(1, 0.0f);
            orientation.put(2, (float)Math.sin(angle));
            orientation.rewind();
            this.al.alListener(4111, orientation);
        } else {
            this.al.alListener(4100, NULLVECTOR);
        }
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error setListener " + error, Console.OSDTEXT_RED);
        }
    }

    @Override
    public void resetListener() {
        if (this.noDevice) {
            return;
        }
        orientation.put(this.deforientation).flip();
        this.al.alListener(4111, orientation);
        this.al.alListener(4102, NULLVECTOR);
        this.al.alListener(4100, NULLVECTOR);
    }

    @Override
    public float getVolume() {
        return this.soundVolume;
    }

    @Override
    public void setVolume(float vol) {
        this.soundVolume = Math.min(Math.max(vol, 0.0f), 1.0f);
    }

    @Override
    public Source newSound(ByteBuffer data, int rate, int bits, int channels, int priority) {
        if (this.noDevice || data == null) {
            return null;
        }
        Source source = this.sourceManager.obtainSource(priority);
        if (source == null) {
            return null;
        }
        if (this.loopedSource.size() > 0 && source.loopInfo.looped) {
            this.loopedSource.remove(source);
        }
        source.loopInfo.clear();
        int sourceId = source.sourceId;
        this.al.alSourcei(sourceId, 4103, 0);
        this.al.setSourceReverb(sourceId, this.alReverbEnable, this.alReverbDelay);
        this.al.setSourceSoftResampler(sourceId, this.alCurrentSoftResampler);
        source.setVolume(0.0f);
        int format = this.toALFormat(channels, bits);
        if (format == -1) {
            Console.Println("OpenAL Error wrong bits: " + bits, Console.OSDTEXT_RED);
            source.dispose();
            return null;
        }
        source.format = format;
        source.rate = rate;
        source.data = data;
        int bufferID = this.buffers.get(source.bufferId);
        this.al.alBufferData(bufferID, format, data, rate);
        this.al.alSourcei(sourceId, 4105, bufferID);
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error newSound " + error, Console.OSDTEXT_RED);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoundData decodeSound(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data[0] == 82 && data[1] == 73 && data[2] == 70 && data[3] == 70) {
            try {
                return new WAVLoader(data);
            }
            catch (Exception exception) {
            }
        } else if (data[0] == 79 && data[1] == 103 && data[2] == 103) {
            SoundData soundData;
            OggInputStream input = null;
            try {
                int length;
                input = new OggInputStream(new ByteArrayInputStream(data, 0, data.length));
                ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[2048];
                while (!input.atEnd() && (length = input.read(buffer)) != -1) {
                    output.write(buffer, 0, length);
                }
                SoundData ogg = new SoundData();
                ogg.channels = input.getChannels();
                ogg.rate = input.getSampleRate();
                ogg.bits = 16;
                ogg.data = ByteBuffer.allocateDirect(output.size()).order(ByteOrder.LITTLE_ENDIAN);
                ogg.data.put(output.toByteArray());
                ogg.data.rewind();
                soundData = ogg;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(input);
                throw throwable;
            }
            StreamUtils.closeQuietly(input);
            return soundData;
        }
        return null;
    }

    @Override
    public void stopAllSounds() {
        if (this.noDevice) {
            return;
        }
        this.sourceManager.stopAllSounds();
        this.loopedSource.clear();
    }

    @Override
    public float getReverb() {
        return this.alReverbDelay;
    }

    @Override
    public void setReverb(boolean enable, float delay) {
        if (this.noDevice) {
            return;
        }
        this.alReverbEnable = enable;
        this.alReverbDelay = enable ? Gameutils.BClipRange(delay, 0.0f, 10.0f) : 0.0f;
        for (Source s : this.sourceManager) {
            if (s.flags == 1) continue;
            this.al.setSourceReverb(s.sourceId, this.alReverbEnable, this.alReverbDelay);
        }
    }

    @Override
    public String getSoftResamplerName(int num) {
        if (this.noDevice) {
            return "Not supported";
        }
        return this.al.alGetSoftResamplerName(num);
    }

    @Override
    public int getCurrentSoftResampler() {
        return this.alCurrentSoftResampler;
    }

    @Override
    public int getNumResamplers() {
        if (this.noDevice) {
            return 1;
        }
        return this.al.alGetNumResamplers();
    }

    @Override
    public void setSoftResampler(int num) {
        if (this.noDevice) {
            return;
        }
        this.alCurrentSoftResampler = num;
        for (Source s : this.sourceManager) {
            this.al.setSourceSoftResampler(s.sourceId, this.alCurrentSoftResampler);
        }
    }

    protected int toALFormat(int channels, int bits) {
        boolean stereo = channels > 1;
        switch (bits) {
            case 16: {
                if (stereo) {
                    return 4355;
                }
                return 4353;
            }
            case 8: {
                if (stereo) {
                    return 4354;
                }
                return 4352;
            }
        }
        return -1;
    }

    public void printSources(SourceManager sourceManager) {
        for (Source obj : sourceManager) {
            System.out.println("#" + obj.sourceId + " isFree: " + obj.free + " pri: " + obj.priority + " vol: " + String.format("%.2f", Float.valueOf(obj.getVolume())).replace(',', '.') + " pitch: " + String.format("%.2f", Float.valueOf(obj.getPitch())).replace(',', '.') + " flags: " + obj.flags);
        }
        System.out.println();
    }

    @Override
    public void update() {
        if (this.noDevice) {
            return;
        }
        this.mus.update();
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error " + error, Console.OSDTEXT_RED);
        }
        if (this.loopedSource.size() > 0) {
            Iterator<Source> i = this.loopedSource.iterator();
            while (i.hasNext()) {
                Source s = i.next();
                if (s.isPlaying() || !s.loopInfo.looped) continue;
                int bufferID = this.al.alSourceUnqueueBuffers(s.sourceId);
                this.al.alBufferData(bufferID, s.loopInfo.format, s.loopInfo.getData(), s.loopInfo.sampleRate);
                this.al.alSourceQueueBuffers(s.sourceId, bufferID);
                this.al.alSourcei(s.sourceId, 4103, 1);
                this.al.alSourcePlay(s.sourceId);
                i.remove();
            }
        }
        this.sourceManager.update();
    }

    @Override
    public Music getDigitalMusic() {
        return this.mus;
    }

    @Override
    public boolean isAvailable(int priority) {
        if (this.noDevice) {
            return false;
        }
        return ((Source)this.sourceManager.element()).priority < priority || !((Source)this.sourceManager.element()).isPlaying();
    }

    @Override
    public void uninit() {
        if (this.noDevice) {
            return;
        }
        this.sourceManager.dispose();
        this.al.alDeleteBuffers(this.buffers);
        this.mus.dispose();
        this.sourceManager = null;
        this.buffers = null;
        this.noDevice = true;
        this.loopedSource.clear();
    }

    public static interface DriverCallback {
        public ALAudio InitDriver() throws Throwable;
    }

    protected class SourceManager
    extends PriorityQueue<Source> {
        private static final long serialVersionUID = 1L;
        private final Source[] allSources;

        public SourceManager(int maxSources) {
            this.allSources = new Source[maxSources];
            this.clear();
            for (int i = 0; i < maxSources; ++i) {
                int sourceId = ALSoundDrv.this.al.alGenSources();
                if (ALSoundDrv.this.al.alGetError() != 0) break;
                this.allSources[i] = new ALSource(ALSoundDrv.this, i, sourceId);
                ALSoundDrv.this.al.alSourcef(sourceId, 4106, 0.0f);
                ALSoundDrv.this.al.alSourcef(sourceId, 4099, 1.0f);
                ALSoundDrv.this.al.alSourcei(sourceId, 514, 0);
                ALSoundDrv.this.al.alSource(sourceId, 4102, NULLVECTOR);
                ALSoundDrv.this.al.alSourcei(sourceId, 4103, 0);
                this.add(this.allSources[i]);
            }
        }

        public int getSourcesNum() {
            return this.size();
        }

        public void freeSource(Source source) {
            if (this.remove(source)) {
                if (source.callback != null) {
                    SourceCallback<Object> callback = source.callback;
                    source.callback = null;
                    callback.run(source.channel);
                }
                source.free = true;
                source.priority = 0;
                source.flags = 0;
                source.loopInfo.clear();
                source.format = 0;
                source.rate = 0;
                source.data = null;
                this.add(source);
            }
        }

        protected void update() {
            for (int i = 0; i < this.allSources.length; ++i) {
                if (this.allSources[i] == null || this.allSources[i].free || this.allSources[i].isActive() || this.allSources[i].flags == 1) continue;
                this.freeSource(this.allSources[i]);
            }
        }

        protected Source obtainSource(int priority) {
            if (!(this.size() <= 0 || ((Source)this.element()).priority >= priority && ((Source)this.element()).isPlaying())) {
                Source source = (Source)this.remove();
                int sourceId = source.sourceId;
                source.priority = priority;
                source.free = false;
                if (source.callback != null) {
                    SourceCallback<Object> callback = source.callback;
                    source.callback = null;
                    callback.run(source.channel);
                }
                ALSoundDrv.this.al.alSourceStop(sourceId);
                ALSoundDrv.this.al.alSourcei(sourceId, 4105, 0);
                ALSoundDrv.this.al.alSourcef(sourceId, 4106, 0.0f);
                ALSoundDrv.this.al.alSourcef(sourceId, 4099, 1.0f);
                ALSoundDrv.this.al.alSource3f(sourceId, 4100, 0.0f, 0.0f, 0.0f);
                ALSoundDrv.this.al.alSourcei(sourceId, 514, 0);
                ALSoundDrv.this.al.alSourcei(sourceId, 4103, 0);
                this.add(source);
                return source;
            }
            return null;
        }

        public int stopSound(Source source) {
            if (source.flags == 1) {
                return -1;
            }
            ALSoundDrv.this.al.alSourceStop(source.sourceId);
            ALSoundDrv.this.al.alSourcei(source.sourceId, 4105, 0);
            this.freeSource(source);
            return source.sourceId;
        }

        public void stopAllSounds() {
            for (Source source : this.allSources) {
                if (source == null) break;
                this.stopSound(source);
            }
        }

        public void dispose() {
            int n = this.allSources.length;
            for (int i = 0; i < n && this.allSources[i] != null; ++i) {
                this.allSources[i].dispose();
                ALSoundDrv.this.al.alDeleteSources(this.allSources[i].sourceId);
                this.allSources[i].sourceId = -1;
                this.allSources[i].bufferId = -1;
                this.allSources[i] = null;
            }
        }
    }
}

