/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import ru.m210projects.Build.desktop.audio.ALAudio;
import ru.m210projects.Build.desktop.audio.nopenal.AL;
import ru.m210projects.Build.desktop.audio.nopenal.AL10;
import ru.m210projects.Build.desktop.audio.nopenal.AL11;
import ru.m210projects.Build.desktop.audio.nopenal.ALC10;
import ru.m210projects.Build.desktop.audio.nopenal.ALCdevice;
import ru.m210projects.Build.desktop.audio.nopenal.EXTEfx;
import ru.m210projects.Build.desktop.audio.nopenal.EXTThreadLocalContext;
import ru.m210projects.Build.desktop.audio.nopenal.SOFTSourceResampler;

public class GdxAL
implements ALAudio {
    private String name;
    private String version;
    private boolean alResamplerSupport;
    private int alNumResamplers;
    private String[] alResamplerNames;
    private boolean alEfxSupport;
    private int alEffectSlot = -1;
    private int alEffect = -1;

    public GdxAL() throws Throwable {
        if (!this.init()) {
            throw new Throwable();
        }
    }

    public boolean init() {
        try {
            AL.create();
            ALCdevice device = AL.getDevice();
            this.name = ALC10.alcGetString(device, 4101);
            this.version = AL10.alGetString(45058);
            boolean makeCurrentFailed = EXTThreadLocalContext.alcSetThreadContext(AL.getContext());
            if (!makeCurrentFailed) {
                return false;
            }
            this.alResamplerSupport = AL10.alIsExtensionPresent("AL_SOFT_source_resampler");
            if (this.alResamplerSupport) {
                this.alNumResamplers = AL10.alGetInteger(4624);
                this.alResamplerNames = new String[this.alNumResamplers];
                for (int i = 0; i < this.alNumResamplers; ++i) {
                    this.alResamplerNames[i] = SOFTSourceResampler.alGetStringiSOFT(4627, i);
                }
            }
            if (this.alEfxSupport = ALC10.alcIsExtensionPresent(device, "ALC_EXT_EFX")) {
                this.alEffectSlot = EXTEfx.alGenAuxiliaryEffectSlots();
                this.alEffect = EXTEfx.alGenEffects();
                EXTEfx.alEffecti(this.alEffect, 32769, 2);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int alGetError() {
        return AL10.alGetError();
    }

    @Override
    public int alGetSourcei(int source, int param) {
        return AL10.alGetSourcei(source, param);
    }

    @Override
    public void alSourcei(int source, int param, int value) {
        AL10.alSourcei(source, param, value);
    }

    @Override
    public void alSourcef(int source, int param, float value) {
        AL10.alSourcef(source, param, value);
    }

    @Override
    public void alSource3i(int source, int paramName, int value1, int value2, int value3) {
        AL11.alSource3i(source, paramName, value1, value2, value3);
    }

    @Override
    public void alSource3f(int source, int param, float v1, float v2, float v3) {
        AL10.alSource3f(source, param, v1, v2, v3);
    }

    @Override
    public void alSourceQueueBuffers(int sourceName, int bufferName) {
        AL10.alSourceQueueBuffers(sourceName, bufferName);
    }

    @Override
    public void alSourcePlay(int source) {
        AL10.alSourcePlay(source);
    }

    @Override
    public void alSourcePause(int source) {
        AL10.alSourcePause(source);
    }

    @Override
    public void alSourceStop(int source) {
        AL10.alSourceStop(source);
    }

    @Override
    public void setSourceReverb(int sourceId, boolean enable, float delay) {
        if (!this.alIsEFXSupport()) {
            return;
        }
        if (enable) {
            EXTEfx.alEffectf(this.alEffect, 3, 0.0f);
            EXTEfx.alEffectf(this.alEffect, 5, delay);
            EXTEfx.alEffectf(this.alEffect, 4, 0.0f);
            EXTEfx.alEffectf(this.alEffect, 6, 0.012f);
            EXTEfx.alAuxiliaryEffectSloti(this.alEffectSlot, 1, this.alEffect);
            this.alSource3i(sourceId, 131078, this.alEffectSlot, 0, 0);
        } else {
            EXTEfx.alAuxiliaryEffectSloti(this.alEffectSlot, 1, 0);
            this.alSource3i(sourceId, 131078, 0, 0, 0);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void dispose() {
        if (this.alIsEFXSupport()) {
            EXTEfx.alDeleteEffects(this.alEffect);
            EXTEfx.alDeleteAuxiliaryEffectSlots(this.alEffectSlot);
        }
        AL.destroy();
        while (AL.isCreated()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int alGenBuffers() {
        return AL10.alGenBuffers();
    }

    @Override
    public void alDistanceModel(int modelName) {
        AL10.alDistanceModel(modelName);
    }

    @Override
    public boolean alIsEFXSupport() {
        return this.alEfxSupport && this.alEffect != -1;
    }

    @Override
    public boolean alIsSoftResamplerSupport() {
        return this.alResamplerSupport && this.alNumResamplers > 0;
    }

    @Override
    public String alGetSoftResamplerName(int num) {
        return this.alResamplerNames[num];
    }

    @Override
    public void setSourceSoftResampler(int sourceId, int value) {
        if (!this.alIsSoftResamplerSupport() || value < 0 || value > this.alNumResamplers) {
            return;
        }
        this.alSourcei(sourceId, 4626, value);
    }

    @Override
    public void alDeleteBuffers(IntBuffer bufferNames) {
        AL10.alDeleteBuffers(bufferNames);
    }

    @Override
    public void alGenBuffers(IntBuffer bufferNames) {
        AL10.alGenBuffers(bufferNames);
    }

    @Override
    public float alGetSourcef(int source, int param) {
        return AL10.alGetSourcef(source, param);
    }

    @Override
    public int alSourceUnqueueBuffers(int sourceName) {
        return AL10.alSourceUnqueueBuffers(sourceName);
    }

    @Override
    public void alBufferData(int bufferName, int format, ByteBuffer data, int frequency) {
        AL10.alBufferData(bufferName, format, data, frequency);
    }

    @Override
    public void alListener(int paramName, FloatBuffer value) {
        AL10.alListenerfv(paramName, value);
    }

    @Override
    public void alListener3f(int paramName, float v1, float v2, float v3) {
        AL10.alListener3f(paramName, v1, v2, v3);
    }

    @Override
    public int alGenSources() {
        return AL10.alGenSources();
    }

    @Override
    public void alSource(int source, int param, FloatBuffer values) {
        AL10.alSourcefv(source, param, values);
    }

    @Override
    public void alDeleteSources(int sourceId) {
        AL10.alDeleteSources(sourceId);
    }

    @Override
    public int alGetNumResamplers() {
        return this.alNumResamplers;
    }

    @Override
    public void alGetSourcefv(int source, int param, FloatBuffer values) {
        AL10.alGetSourcefv(source, param, values);
    }

    @Override
    public float alGetListenerf(int paramName) {
        return AL10.alGetListenerf(paramName);
    }

    @Override
    public int alGetListeneri(int paramName) {
        return AL10.alGetListeneri(paramName);
    }

    @Override
    public void alGetListenerfv(int param, FloatBuffer values) {
        AL10.alGetListenerfv(param, values);
    }
}

