/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio;

import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.desktop.audio.ALAudio;
import ru.m210projects.Build.desktop.audio.ALSoundDrv;

abstract class OpenALMusic {
    private static final int bufferSize = 40960;
    private static final int bytesPerSample = 2;
    private static final byte[] tempBytes = new byte[40960];
    private static final ByteBuffer tempBuffer = BufferUtils.newByteBuffer(40960);
    private final ALSoundDrv.SourceManager sourceManager;
    private Source source = null;
    private int format;
    private int sampleRate;
    private boolean isLooping;
    private boolean isPlaying;
    private float renderedSeconds;
    private float secondsPerBuffer;
    protected byte[] data;
    private float musicVolume;
    private final IntBuffer musicBuffers;
    private final ALSoundDrv drv;
    private final ALAudio al;

    public OpenALMusic(ALSoundDrv drv, IntBuffer ALbuffers, byte[] data) {
        this.drv = drv;
        this.al = drv.getALAudio();
        this.sourceManager = drv.sourceManager;
        this.data = data;
        this.musicBuffers = ALbuffers;
    }

    protected void setup(int channels, int sampleRate) {
        this.format = channels > 1 ? 4355 : 4353;
        this.sampleRate = sampleRate;
        this.secondsPerBuffer = 20480.0f / (float)channels / (float)sampleRate;
    }

    public void play() {
        if (this.source == null) {
            int bufferID;
            this.source = this.sourceManager.obtainSource(Integer.MAX_VALUE);
            if (this.source == null) {
                return;
            }
            this.al.alSourcei(this.source.sourceId, 4103, 0);
            this.setVolume(this.musicVolume);
            this.source.flags |= 1;
            for (int i = 0; i < this.musicBuffers.capacity() && this.fill(bufferID = this.musicBuffers.get(i)); ++i) {
                this.renderedSeconds = 0.0f;
                this.al.alSourceQueueBuffers(this.source.sourceId, bufferID);
            }
            if (this.al.alGetError() != 0) {
                this.stop();
                return;
            }
        }
        this.al.alSourcePlay(this.source.sourceId);
        this.isPlaying = true;
    }

    public void stop() {
        if (this.source == null) {
            return;
        }
        this.reset();
        this.source.flags &= 0xFFFFFFFE;
        if (this.drv.isInited()) {
            this.sourceManager.stopSound(this.source);
        } else if (this.source.flags != 1) {
            this.sourceManager.freeSource(this.source);
        }
        this.source = null;
        this.renderedSeconds = 0.0f;
        this.isPlaying = false;
    }

    public void pause() {
        if (this.source != null && this.drv.isInited()) {
            this.al.alSourcePause(this.source.sourceId);
        }
        this.isPlaying = false;
    }

    public boolean isPlaying() {
        if (this.source == null) {
            return false;
        }
        return this.isPlaying;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setVolume(float volume) {
        this.musicVolume = volume;
        if (this.source != null && this.drv.isInited()) {
            this.al.alSourcef(this.source.sourceId, 4106, volume);
        }
    }

    public float getVolume() {
        return this.musicVolume;
    }

    public float getPosition() {
        if (this.source == null || !this.drv.isInited()) {
            return 0.0f;
        }
        return this.renderedSeconds + this.al.alGetSourcef(this.source.sourceId, 4132);
    }

    public int getChannels() {
        return this.format == 4355 ? 2 : 1;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public void update() {
        int bufferID;
        if (this.source == null || !this.drv.isInited()) {
            return;
        }
        boolean end = false;
        int buffers = this.al.alGetSourcei(this.source.sourceId, 4118);
        while (buffers-- > 0 && (bufferID = this.al.alSourceUnqueueBuffers(this.source.sourceId)) != 40963) {
            this.renderedSeconds += this.secondsPerBuffer;
            if (end) continue;
            if (this.fill(bufferID)) {
                this.al.alSourceQueueBuffers(this.source.sourceId, bufferID);
                continue;
            }
            end = true;
        }
        if (end && this.al.alGetSourcei(this.source.sourceId, 4117) == 0) {
            this.stop();
        }
        if (this.isPlaying && this.al.alGetSourcei(this.source.sourceId, 4112) != 4114) {
            this.al.alSourcePlay(this.source.sourceId);
        }
    }

    private boolean fill(int bufferID) {
        tempBuffer.clear();
        int length = this.read(tempBytes);
        if (length <= 0) {
            if (this.isLooping) {
                this.reset();
                this.renderedSeconds = 0.0f;
                length = this.read(tempBytes);
                if (length <= 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        tempBuffer.put(tempBytes, 0, length).flip();
        this.al.alBufferData(bufferID, this.format, tempBuffer, this.sampleRate);
        return true;
    }

    public abstract int read(byte[] var1);

    public abstract void reset();
}

