/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio.midi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.Music;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.desktop.audio.midi.MidiMusicSource;
import ru.m210projects.Build.desktop.audio.midi.MidiReceiver;
import ru.m210projects.Build.desktop.audio.midi.MidiSequencer;

public class MidiMusicModule
implements Music {
    protected MidiSequencer sequencer;
    private String name = "Midi Music Module";
    private boolean inited;
    private int nDevice;
    private static List<MidiDevice> devices;
    private MidiDevice device;
    private Soundbank soundbank;

    public MidiMusicModule(int nDevice, File soundbank) {
        try {
            devices = MidiMusicModule.getDevices();
            this.nDevice = nDevice;
            this.soundbank = soundbank != null ? MidiSystem.getSoundbank(soundbank) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<MidiDevice> getDevices() {
        if (devices != null) {
            return devices;
        }
        devices = new ArrayList<MidiDevice>();
        MidiDevice.Info[] dInfos = MidiSystem.getMidiDeviceInfo();
        try {
            for (MidiDevice.Info dInfo : dInfos) {
                MidiDevice dev = MidiSystem.getMidiDevice(dInfo);
                if (dev.getMaxReceivers() == 0) continue;
                devices.add(dev);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return devices;
    }

    @Override
    public MusicSource newMusic(byte[] data) {
        try {
            return new MidiMusicSource(this.sequencer, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MusicSource newMusic(String name) {
        Resource res = BuildGdx.cache.open(name, 0);
        if (res == null) {
            return null;
        }
        byte[] data = res.getBytes();
        res.close();
        return this.newMusic(data);
    }

    @Override
    public boolean init() {
        try {
            this.sequencer = new MidiSequencer();
            if (this.device != null) {
                this.device.close();
            }
            this.inited = false;
            if (devices == null) {
                return false;
            }
            if (this.soundbank != null) {
                Console.Println("Soundbank initializing...");
                Synthesizer softsynth = MidiSystem.getSynthesizer();
                this.device = softsynth;
                this.device.open();
                softsynth.loadAllInstruments(this.soundbank);
            } else {
                this.device = devices.get(this.nDevice);
                this.device.open();
            }
            this.name = this.device.getDeviceInfo().getName();
            this.sequencer.setReceiver(new MidiReceiver(this.device.getReceiver()));
            Console.Println(this.getName() + " initialized", Console.OSDTEXT_GOLD);
            this.inited = true;
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.name = "initialization failed";
            return false;
        }
    }

    @Override
    public void setVolume(float volume) {
        this.sequencer.setVolume(volume);
    }

    @Override
    public String getName() {
        if (this.soundbank != null) {
            return this.soundbank.getName();
        }
        return this.name;
    }

    @Override
    public boolean isInited() {
        return this.inited;
    }

    @Override
    public void dispose() {
        if (this.sequencer != null) {
            this.sequencer.dispose();
        }
        if (this.device != null) {
            this.device.close();
        }
    }

    @Override
    public void update() {
    }
}

