/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio.midi;

import java.io.ByteArrayInputStream;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.desktop.audio.midi.MidiSequencer;

public class MidiMusicSource
extends MusicSource {
    private final MidiSequencer sequencer;
    protected Sequence data;

    public MidiMusicSource(MidiSequencer sequencer, byte[] buf) throws Exception {
        if (sequencer == null || !sequencer.isOpen()) {
            throw new Exception("Sequencer not ready!");
        }
        this.sequencer = sequencer;
        this.data = MidiSystem.getSequence(new ByteArrayInputStream(buf));
    }

    private void setLooping(boolean looping) {
        this.sequencer.setLooping(looping);
    }

    @Override
    public void play(boolean looping) {
        this.setLooping(looping);
        this.sequencer.play(this, 0L);
    }

    public void play(long start, long end) {
        this.setLooping(true);
        this.sequencer.play(this, start, start, end);
    }

    @Override
    public void stop() {
        this.sequencer.stop();
    }

    @Override
    public void pause() {
        this.stop();
    }

    @Override
    public void resume() {
        this.sequencer.resume();
    }

    @Override
    public void dispose() {
        this.stop();
        this.data = null;
    }

    @Override
    public boolean isLooping() {
        return this.sequencer.isLooping();
    }

    @Override
    public boolean isPlaying() {
        return this.sequencer.isPlaying(this);
    }

    @Override
    public void update() {
    }
}

