/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio.nopenal;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.sun.jna.Native;
import java.io.File;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import ru.m210projects.Build.desktop.audio.nopenal.ALC10;
import ru.m210projects.Build.desktop.audio.nopenal.ALCcontext;
import ru.m210projects.Build.desktop.audio.nopenal.ALCdevice;
import ru.m210projects.Build.desktop.audio.nopenal.SharedLibraryAL;

public final class AL {
    static ALCdevice device;
    static ALCcontext context;
    private static boolean created;
    private static SharedLibraryAL alnative;

    private AL() {
    }

    private static void nCreate(String oalPath) throws LWJGLException {
        if (alnative != null) {
            return;
        }
        try {
            alnative = Native.load(oalPath, SharedLibraryAL.class);
        }
        catch (Throwable t) {
            throw new LWJGLException(t.getMessage());
        }
    }

    public static boolean isCreated() {
        return created;
    }

    public static void create(String deviceArguments, int contextFrequency, int contextRefresh, boolean contextSynchronized) throws Exception {
        AL.create(deviceArguments, contextFrequency, contextRefresh, contextSynchronized, true);
    }

    public static void create(String deviceArguments, int contextFrequency, int contextRefresh, boolean contextSynchronized, boolean openDevice) throws Exception {
        if (created) {
            throw new IllegalStateException("Only one OpenAL context may be instantiated at any one time.");
        }
        SharedLibraryLoader loader = new SharedLibraryLoader();
        File library = null;
        try {
            if (SharedLibraryLoader.isWindows) {
                library = loader.extractFile(SharedLibraryLoader.is64Bit ? "nOpenAL.dll" : "nOpenAL32.dll", null);
            } else if (SharedLibraryLoader.isMac) {
                library = loader.extractFile("nopenal.dylib", null);
            } else if (SharedLibraryLoader.isLinux) {
                library = loader.extractFile("nlibopenal.so", null);
            }
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Unable to extract OAL natives.", ex);
        }
        try {
            AL.nCreate(library.getAbsolutePath());
            created = true;
            AL.init(deviceArguments, contextFrequency, contextRefresh, contextSynchronized, openDevice);
        }
        catch (Exception e) {
            System.err.println("Failed to load " + library.getName() + ": " + e.getMessage());
        }
        if (!created) {
            throw new Exception("Could not locate OpenAL library.");
        }
    }

    private static void init(String deviceArguments, int contextFrequency, int contextRefresh, boolean contextSynchronized, boolean openDevice) throws LWJGLException {
        try {
            if (openDevice) {
                device = ALC10.alcOpenDevice(deviceArguments);
                if (device == null) {
                    throw new LWJGLException("Could not open ALC device");
                }
                context = contextFrequency == -1 ? ALC10.alcCreateContext(device, (IntBuffer)null) : ALC10.alcCreateContext(device, ALCcontext.createAttributeList(contextFrequency, contextRefresh, contextSynchronized ? 1 : 0));
                ALC10.alcMakeContextCurrent(context);
            }
        }
        catch (LWJGLException e) {
            AL.destroy();
            throw e;
        }
    }

    public static void create() throws Exception {
        AL.create(null, 44100, 60, false);
    }

    public static void destroy() {
        if (context != null) {
            ALC10.alcMakeContextCurrent(null);
            ALC10.alcDestroyContext(context);
            context = null;
        }
        if (device != null) {
            ALC10.alcCloseDevice(device);
            device = null;
        }
        created = false;
    }

    public static ALCcontext getContext() {
        return context;
    }

    public static ALCdevice getDevice() {
        return device;
    }

    protected static SharedLibraryAL getNative() {
        return alnative;
    }
}

