/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Menus;

import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuAudio;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Menus.DukeTitle;
import ru.m210projects.Duke3D.Sounds;

public class SoundMenu
extends MenuAudio {
    private final MenuAudio.AudioListener listener = new MenuAudio.AudioAdapter(){

        @Override
        public void PreDrvChange(BuildAudio.Driver drv) {
            Sounds.StopAllSounds();
        }

        @Override
        public void PostDrvChange() {
            if (Main.game.isCurrentScreen(Main.gGameScreen) || Main.game.isCurrentScreen(Main.gDemoScreen) || Main.game.isCurrentScreen(Main.gMenuScreen)) {
                Sounds.sndStopMusic();
                if (!Main.game.isCurrentScreen(Main.gGameScreen)) {
                    Sounds.sndPlayMusic(Globals.currentGame.getCON().env_music_fn[0]);
                } else {
                    Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.ud.volume_number][Globals.ud.level_number]);
                }
            }
        }

        @Override
        public void SoundVolumeChange() {
            Sounds.CommentaryVolume(Sounds.pCommentary, Main.cfg.soundVolume);
        }

        @Override
        public void SoundOff() {
            Sounds.StopAllSounds();
        }
    };

    public SoundMenu(Main app) {
        super(app, 20, 30, 280, 10, 10, app.getFont(1));
        this.setListener(this.listener);
        this.sSoundDrv.listFont = app.getFont(0);
        this.sMusicDrv.listFont = app.getFont(0);
        this.sResampler.listFont = app.getFont(0);
        this.mApplyChanges.font = app.getFont(2);
        this.mApplyChanges.y += 10;
    }

    @Override
    public MenuTitle getTitle(BuildGame app, String text) {
        return new DukeTitle(text);
    }

    @Override
    public boolean SoundRestart(int voices, int resampler) {
        return Sounds.sndRestart(voices, resampler);
    }

    @Override
    public boolean MusicRestart() {
        return Sounds.midRestart();
    }
}

