/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Gamedef;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.Screen;
import ru.m210projects.Duke3D.Sector;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;

public class Player {
    public static final byte[] waterpal = new byte[768];
    public static final byte[] slimepal = new byte[768];
    public static final byte[] titlepal = new byte[768];
    public static final byte[] drealms = new byte[768];
    public static final byte[] endingpal = new byte[768];
    public static final int[][] fdmatrix = new int[][]{{128, -1, -1, -1, 128, -1, -1, -1, 128, -1, 128, -1, -1}, {1024, 1024, 1024, 1024, 2560, 128, 2560, 2560, 1024, 2560, 2560, 2560, -1}, {512, 512, 512, 512, 2560, 128, 2560, 2560, 1024, 2560, 2560, 2560, -1}, {512, 512, 512, 512, 2560, 128, 2560, 2560, 1024, 2560, 2560, 2560, -1}, {2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, -1}, {512, 512, 512, 512, 2048, 512, 2560, 2560, 512, 2560, 2560, 2560, -1}, {128, 128, 128, 128, 2560, 128, 2560, 2560, 128, 128, 128, 128, -1}, {1536, 1536, 1536, 1536, 2560, 1536, 1536, 1536, 1536, 1536, 1536, 1536, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {128, 128, 128, 128, 2560, 128, 2560, 2560, 128, 128, 128, 128, -1}, {2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, -1}, {128, 128, 128, 128, 2560, 128, 2560, 2560, 128, 128, 128, 128, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    public static int[] goalx = new int[16];
    public static int[] goaly = new int[16];
    public static int[] goalz = new int[16];
    public static int[] goalsect = new int[16];
    public static int[] goalwall = new int[16];
    public static int[] goalsprite = new int[16];
    public static int[] goalplayer = new int[16];
    public static int[] clipmovecount = new int[16];
    public static short[] searchsect = new short[Engine.MAXSECTORS];
    public static short[] searchparent = new short[Engine.MAXSECTORS];
    public static byte[] dashow2dsector = new byte[Engine.MAXSECTORS + 7 >> 3];

    public static void InitPlayers() {
        Globals.ps[Mmulti.myconnectindex].reset();
        Globals.ps[Mmulti.myconnectindex].palette = Engine.palette;
        Globals.ps[Mmulti.myconnectindex].aim_mode = Main.cfg.gMouseAim ? 1 : 0;
        Globals.ps[Mmulti.myconnectindex].auto_aim = Main.cfg.gAutoAim ? 1 : 0;
        for (int i = 1; i < 16; ++i) {
            Globals.ps[i].copy(Globals.ps[Mmulti.myconnectindex]);
        }
        Main.game.net.getnames();
    }

    public static void checkavailinven(PlayerStruct p) {
        p.inven_icon = p.firstaid_amount > 0 ? 1 : (p.steroids_amount > 0 ? 2 : (p.holoduke_amount > 0 ? 3 : (p.jetpack_amount > 0 ? 4 : (p.heat_amount > 0 ? 5 : (p.scuba_amount > 0 ? 6 : (p.boot_amount > 0 ? 7 : 0))))));
    }

    public static void checkavailweapon(PlayerStruct p) {
        int i;
        int weap;
        if (p.wantweaponfire >= 0) {
            weap = p.wantweaponfire;
            p.wantweaponfire = (short)-1;
            if (weap == p.curr_weapon || weap >= 13) {
                return;
            }
            if (p.gotweapon[weap] && p.ammo_amount[weap] > 0) {
                Weapons.addweapon(p, weap);
                return;
            }
        }
        if (p.gotweapon[weap = p.curr_weapon] && p.ammo_amount[weap] > 0) {
            return;
        }
        short snum = Engine.sprite[p.i].yvel;
        for (i = 0; i < 10; ++i) {
            weap = Globals.ud.wchoice[snum][i];
            weap = weap == 0 ? 9 : --weap;
            if (weap == 0 || p.gotweapon[weap] && p.ammo_amount[weap] > 0) break;
        }
        if (i == 10) {
            weap = 0;
        }
        p.last_weapon = p.curr_weapon;
        p.random_club_frame = 0;
        p.curr_weapon = (short)weap;
        p.kickback_pic = 0;
        if (p.holster_weapon == 1) {
            p.holster_weapon = 0;
            p.weapon_pos = (short)10;
        } else {
            p.weapon_pos = (short)-1;
        }
    }

    public static boolean inventory(SPRITE s) {
        switch (s.picnum) {
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 1348: {
                return true;
            }
        }
        return false;
    }

    public static void setpal(PlayerStruct p) {
        if (p.heat_on != 0) {
            p.palette = slimepal;
        } else {
            switch (Engine.sector[p.cursectnum].ceilingpicnum) {
                case 200: 
                case 201: 
                case 202: {
                    p.palette = slimepal;
                    break;
                }
                default: {
                    p.palette = Engine.sector[p.cursectnum].lotag == 2 ? waterpal : Engine.palette;
                }
            }
        }
        Screen.changepalette = 1;
    }

    public static void incur_damage(PlayerStruct p) {
        int damage = 0;
        int shield_damage = 0;
        Engine.sprite[p.i].extra = (short)(Engine.sprite[p.i].extra - (p.extra_extra8 >> 8));
        damage = Engine.sprite[p.i].extra - p.last_extra;
        if (damage < 0) {
            p.extra_extra8 = 0;
            if (p.shield_amount > 0) {
                shield_damage = damage * (20 + Main.engine.krand() % 30) / 100;
                damage -= shield_damage;
                p.shield_amount = (short)(p.shield_amount + shield_damage);
                if (p.shield_amount < 0) {
                    damage += p.shield_amount;
                    p.shield_amount = 0;
                }
            }
            Engine.sprite[p.i].extra = (short)(p.last_extra + damage);
        }
    }

    public static void quickkill(PlayerStruct p) {
        p.pals[0] = 48;
        p.pals[1] = 48;
        p.pals[2] = 48;
        p.pals_time = 48;
        Engine.sprite[p.i].extra = 0;
        Engine.sprite[p.i].cstat = (short)(Engine.sprite[p.i].cstat | 0x8000);
        if (!Globals.ud.god) {
            Spawn.guts(Engine.sprite[p.i], 2286, 8, Mmulti.myconnectindex);
        }
    }

    public static void forceplayerangle(PlayerStruct p) {
        int n = 128 - (Main.engine.krand() & 0xFF);
        p.horiz += 64.0f;
        p.return_to_center = (short)9;
        p.look_ang = (short)(n >> 1);
        p.rotscrnang = (short)(n >> 1);
    }

    public static int hits(int i) {
        int zoff = 0;
        SPRITE spr = Engine.sprite[i];
        if (spr.picnum == 1405) {
            zoff = 10240;
        }
        Main.engine.hitscan(spr.x, spr.y, spr.z - zoff, spr.sectnum, Engine.sintable[spr.ang + 512 & 0x7FF], Engine.sintable[spr.ang & 0x7FF], 0, Engine.pHitInfo, 0x1000040);
        return Gameutils.FindDistance2D(Engine.pHitInfo.hitx - spr.x, Engine.pHitInfo.hity - spr.y);
    }

    public static int hitasprite(int i) {
        int zoff = 0;
        if (Actors.badguy(Engine.sprite[i])) {
            zoff = 10752;
        } else if (Engine.sprite[i].picnum == 1405) {
            zoff = 9984;
        }
        Main.engine.hitscan(Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z - zoff, Engine.sprite[i].sectnum, Engine.sintable[Engine.sprite[i].ang + 512 & 0x7FF], Engine.sintable[Engine.sprite[i].ang & 0x7FF], 0, Engine.pHitInfo, 0x1000040);
        if (Engine.pHitInfo.hitwall >= 0 && (Engine.wall[Engine.pHitInfo.hitwall].cstat & 0x10) != 0 && Actors.badguy(Engine.sprite[i])) {
            return 0x40000000;
        }
        return Gameutils.FindDistance2D(Engine.pHitInfo.hitx - Engine.sprite[i].x, Engine.pHitInfo.hity - Engine.sprite[i].y);
    }

    public static int hitawall(PlayerStruct p) {
        if (Main.IsOriginalDemo()) {
            Main.engine.hitscan(p.posx, p.posy, p.posz, p.cursectnum, Engine.sintable[(int)p.ang + 512 & 0x7FF], Engine.sintable[(int)p.ang & 0x7FF], 0, Engine.pHitInfo, 65537);
        } else {
            Main.engine.hitscan(p.posx, p.posy, p.posz, p.cursectnum, (int)ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)), (int)ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)), 0, Engine.pHitInfo, 65537);
        }
        return Gameutils.FindDistance2D(Engine.pHitInfo.hitx - p.posx, Engine.pHitInfo.hity - p.posy);
    }

    public static boolean doincrements(PlayerStruct p) {
        short snum = Engine.sprite[p.i].yvel;
        ++p.player_par;
        if (p.invdisptime > 0) {
            --p.invdisptime;
        }
        if (p.tipincs > 0) {
            p.tipincs = (short)(p.tipincs - 1);
        }
        if (p.last_pissed_time > 0) {
            --p.last_pissed_time;
            if (p.last_pissed_time == 5694) {
                Sounds.spritesound(79, p.i);
                if (snum == Globals.screenpeek || Globals.ud.coop == 1) {
                    Sounds.spritesound(218, p.i);
                }
            }
            if (p.last_pissed_time == 5668) {
                p.holster_weapon = 0;
                p.weapon_pos = (short)10;
            }
        }
        if (p.crack_time > 0) {
            --p.crack_time;
            if (p.crack_time == 0) {
                p.knuckle_incs = 1;
                p.crack_time = 777;
            }
        }
        if (p.steroids_amount > 0 && p.steroids_amount < 400) {
            p.steroids_amount = (short)(p.steroids_amount - 1);
            if (p.steroids_amount == 0) {
                Player.checkavailinven(p);
            }
            if ((p.steroids_amount & 7) == 0 && (snum == Globals.screenpeek || Globals.ud.coop == 1)) {
                Sounds.spritesound(39, p.i);
            }
        }
        if (p.heat_on != 0 && p.heat_amount > 0) {
            p.heat_amount = (short)(p.heat_amount - 1);
            if (p.heat_amount == 0) {
                p.heat_on = 0;
                Player.checkavailinven(p);
                Sounds.spritesound(213, p.i);
                Player.setpal(p);
            }
        }
        if (p.holoduke_on >= 0) {
            p.holoduke_amount = (short)(p.holoduke_amount - 1);
            if (p.holoduke_amount <= 0) {
                Sounds.spritesound(70, p.i);
                p.holoduke_on = (short)-1;
                Player.checkavailinven(p);
            }
        }
        if (p.jetpack_on != 0 && p.jetpack_amount > 0) {
            p.jetpack_amount = (short)(p.jetpack_amount - 1);
            if (p.jetpack_amount <= 0) {
                p.jetpack_on = 0;
                Player.checkavailinven(p);
                Sounds.spritesound(51, p.i);
                Sounds.stopsound(50, p.i);
                Sounds.stopsound(49, p.i);
            }
        }
        if (p.quick_kick > 0 && Engine.sprite[p.i].pal != 1) {
            p.quick_kick = (short)(p.quick_kick - 1);
            if (p.quick_kick == 8) {
                Weapons.shoot(p.i, 2521);
            }
        }
        if (p.access_incs != 0 && Engine.sprite[p.i].pal != 1) {
            p.access_incs = (short)(p.access_incs + 1);
            if (Engine.sprite[p.i].extra <= 0) {
                p.access_incs = (short)12;
            }
            if (p.access_incs == 12) {
                if (p.access_spritenum >= 0) {
                    Sector.checkhitswitch(snum, p.access_spritenum, 1);
                    switch (Engine.sprite[p.access_spritenum].pal) {
                        case 0: {
                            p.got_access = (short)(p.got_access & 0xFFFE);
                            break;
                        }
                        case 21: {
                            p.got_access = (short)(p.got_access & 0xFFFD);
                            break;
                        }
                        case 23: {
                            p.got_access = (short)(p.got_access & 0xFFFB);
                        }
                    }
                    p.access_spritenum = (short)-1;
                } else {
                    Sector.checkhitswitch(snum, p.access_wallnum, 0);
                    switch (Engine.wall[p.access_wallnum].pal) {
                        case 0: {
                            p.got_access = (short)(p.got_access & 0xFFFE);
                            break;
                        }
                        case 21: {
                            p.got_access = (short)(p.got_access & 0xFFFD);
                            break;
                        }
                        case 23: {
                            p.got_access = (short)(p.got_access & 0xFFFB);
                        }
                    }
                }
            }
            if (p.access_incs > 20) {
                p.access_incs = 0;
                p.weapon_pos = (short)10;
                p.kickback_pic = 0;
            }
        }
        if (p.scuba_on == 0 && p.cursectnum != -1 && Engine.sector[p.cursectnum].lotag == 2) {
            if (p.scuba_amount > 0) {
                p.scuba_on = 1;
                p.inven_icon = 6;
                View.FTA(76, p);
            } else if (p.airleft > 0) {
                p.airleft = (short)(p.airleft - 1);
            } else {
                p.extra_extra8 = (short)(p.extra_extra8 + 32);
                if (p.last_extra < Globals.currentGame.getCON().max_player_health >> 1 && (p.last_extra & 3) == 0) {
                    Sounds.spritesound(211, p.i);
                }
            }
        } else if (p.scuba_amount > 0 && p.scuba_on != 0) {
            p.scuba_amount = (short)(p.scuba_amount - 1);
            if (p.scuba_amount == 0) {
                p.scuba_on = 0;
                Player.checkavailinven(p);
            }
        }
        if (p.knuckle_incs != 0) {
            p.knuckle_incs = (short)(p.knuckle_incs + 1);
            if (p.knuckle_incs == 10) {
                if (Engine.totalclock > 1024 && (snum == Globals.screenpeek || Globals.ud.coop == 1)) {
                    if ((Main.engine.rand() & 1) != 0) {
                        Sounds.spritesound(33, p.i);
                    } else {
                        Sounds.spritesound(208, p.i);
                    }
                }
                Sounds.spritesound(215, p.i);
            } else if (p.knuckle_incs == 22 || (Globals.sync[snum].bits & 4) != 0) {
                p.knuckle_incs = 0;
            }
            return true;
        }
        return false;
    }

    public static void processinput(int snum) {
        int i;
        int k;
        int j;
        PlayerStruct p = Globals.ps[snum];
        short pi = p.i;
        SPRITE s = Engine.sprite[pi];
        int sb_snum = p.cheat_phase <= 0 ? Globals.sync[snum].bits : 0;
        short psect = p.cursectnum;
        if (psect == -1) {
            if (s.extra > 0 && !Globals.ud.clipping) {
                Player.quickkill(p);
                Sounds.spritesound(69, pi);
            }
            psect = 0;
        }
        if (!ru.m210projects.Build.Gameutils.isValidSector(s.sectnum) || !ru.m210projects.Build.Gameutils.isValidSector(psect)) {
            return;
        }
        short psectlotag = Engine.sector[psect].lotag;
        p.spritebridge = 0;
        boolean shrunk = s.yrepeat < 32;
        Main.engine.getzrange(p.posx, p.posy, p.posz, psect, 163, 65537);
        int cz = Engine.zr_ceilz;
        int hz = Engine.zr_ceilhit;
        int fz = Engine.zr_florz;
        int lz = Engine.zr_florhit;
        p.truefz = j = Main.engine.getflorzofslope(psect, p.posx, p.posy);
        p.truecz = Main.engine.getceilzofslope(psect, p.posx, p.posy);
        long truefdist = Pragmas.klabs(p.posz - j);
        if ((lz & 0xE000) == 16384 && psectlotag == 1 && truefdist > 13824L) {
            psectlotag = 0;
        }
        Globals.hittype[pi].floorz = fz;
        Globals.hittype[pi].ceilingz = cz;
        p.ohoriz = p.horiz;
        p.ohorizoff = p.horizoff;
        if (p.aim_mode == 0 && p.on_ground && psectlotag != 2 && (Engine.sector[psect].floorstat & 2) != 0) {
            int y;
            int x;
            if (Main.IsOriginalDemo()) {
                x = p.posx + (Engine.sintable[(int)p.ang + 512 & 0x7FF] >> 5);
                y = p.posy + (Engine.sintable[(int)p.ang & 0x7FF] >> 5);
            } else {
                x = (int)((double)p.posx + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 32.0);
                y = (int)((double)p.posy + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 32.0);
            }
            short tempsect = Main.engine.updatesector(x, y, psect);
            if (tempsect >= 0) {
                k = Main.engine.getflorzofslope(psect, x, y);
                if (psect == tempsect) {
                    p.horizoff = (short)(p.horizoff + Pragmas.mulscale(j - k, 160L, 16));
                } else if (Pragmas.klabs(Main.engine.getflorzofslope(tempsect, x, y) - k) <= 1024) {
                    p.horizoff = (short)(p.horizoff + Pragmas.mulscale(j - k, 160L, 16));
                }
            }
        }
        if (p.horizoff > 0) {
            p.horizoff = (short)(p.horizoff - ((p.horizoff >> 3) + 1));
        } else if (p.horizoff < 0) {
            PlayerStruct playerStruct = p;
            playerStruct.horizoff = (short)(playerStruct.horizoff + ((-p.horizoff >> 3) + 1));
        }
        if (hz >= 0 && (hz & 0xE000) == 49152 && Engine.sprite[hz &= 0x1FFF].statnum == 1 && Engine.sprite[hz].extra >= 0) {
            hz = 0;
            cz = p.truecz;
        }
        if (lz >= 0 && (lz & 0xE000) == 49152) {
            j = lz & 0x1FFF;
            if ((Engine.sprite[j].cstat & 0x21) == 33) {
                psectlotag = 0;
                p.footprintcount = 0;
                p.spritebridge = 1;
            } else if (Actors.badguy(Engine.sprite[j]) && Engine.sprite[j].xrepeat > 24 && Pragmas.klabs(s.z - Engine.sprite[j].z) < 21504) {
                j = Main.engine.getangle(Engine.sprite[j].x - p.posx, Engine.sprite[j].y - p.posy);
                p.posxv -= Engine.sintable[j + 512 & 0x7FF] << 4;
                p.posyv -= Engine.sintable[j & 0x7FF] << 4;
            }
        }
        if (s.extra > 0) {
            Player.incur_damage(p);
        } else {
            s.extra = 0;
            p.shield_amount = 0;
        }
        p.last_extra = s.extra;
        p.loogcnt = p.loogcnt > 0 ? --p.loogcnt : 0;
        if (p.fist_incs != 0) {
            p.fist_incs = (short)(p.fist_incs + 1);
            if (p.fist_incs == 28) {
                if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
                    Globals.ud.rec.close();
                }
                Sounds.sound(14);
                p.pals[0] = 64;
                p.pals[1] = 64;
                p.pals[2] = 64;
                p.pals_time = 48;
            }
            if (p.fist_incs > 42) {
                if (p.buttonpalette != 0 && Globals.ud.from_bonus == 0) {
                    Globals.ud.from_bonus = Globals.ud.level_number + 1;
                    if (Globals.ud.secretlevel > 0 && Globals.ud.secretlevel < 12) {
                        Globals.ud.level_number = Globals.ud.secretlevel - 1;
                    }
                } else if (Globals.ud.from_bonus != 0) {
                    Globals.ud.level_number = Globals.ud.from_bonus;
                    Globals.ud.from_bonus = 0;
                } else {
                    Globals.ud.level_number = Globals.ud.level_number == Globals.ud.secretlevel && Globals.ud.from_bonus > 0 ? Globals.ud.from_bonus : ++Globals.ud.level_number;
                }
                Premap.LeaveMap();
                p.fist_incs = 0;
                return;
            }
        }
        if (p.timebeforeexit > 1 && p.last_extra > 0) {
            p.timebeforeexit = (short)(p.timebeforeexit - 1);
            if (p.timebeforeexit == 130) {
                BuildGdx.audio.getSound().stopAllSounds();
                Sounds.clearsoundlocks();
                if (p.customexitsound >= 0) {
                    Sounds.sound(p.customexitsound);
                    View.FTA(102, p);
                }
            } else if (p.timebeforeexit == 1) {
                Premap.LeaveMap();
                if (Globals.ud.from_bonus != 0) {
                    Globals.ud.level_number = Globals.ud.from_bonus;
                    Globals.ud.from_bonus = 0;
                } else {
                    ++Globals.ud.level_number;
                }
                return;
            }
        }
        if (p.pals_time > 0) {
            --p.pals_time;
        }
        if (s.extra <= 0) {
            if (p.dead_flag == 0) {
                if (s.pal != 1) {
                    p.pals[0] = 63;
                    p.pals[1] = 0;
                    p.pals[2] = 0;
                    p.pals_time = 63;
                    p.posz -= 4096;
                    s.z -= 4096;
                }
                if (Globals.ud.recstat == 1 && Globals.ud.multimode < 2 && Globals.ud.rec != null) {
                    Globals.ud.rec.close();
                }
                if (s.pal != 1) {
                    p.dead_flag = (short)(512 - ((Main.engine.krand() & 1) << 10) + (Main.engine.krand() & 0xFF) - 512 & 0x7FF);
                }
                p.jetpack_on = 0;
                p.holoduke_on = (short)-1;
                Sounds.stopsound(50, p.i);
                if (p.scream_voice != null) {
                    p.scream_voice.dispose();
                    p.scream_voice = null;
                }
                if (s.pal != 1 && (s.cstat & 0x8000) == 0) {
                    s.cstat = 0;
                }
                if (Globals.ud.multimode > 1 && (s.pal != 1 || (s.cstat & 0x8000) != 0)) {
                    if (p.frag_ps != snum && p.frag_ps < Globals.ps.length) {
                        Globals.ps[p.frag_ps].frag = (short)(Globals.ps[p.frag_ps].frag + 1);
                        short[] sArray = Globals.frags[p.frag_ps];
                        int n = snum;
                        sArray[n] = (short)(sArray[n] + 1);
                        if (snum == Globals.screenpeek) {
                            if (Globals.ud.user_name[p.frag_ps] != null && !Globals.ud.user_name[p.frag_ps].isEmpty()) {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[115], 0, "KILLED BY ", Globals.ud.user_name[p.frag_ps]);
                            } else {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[115], 0, "KILLED BY PLAYER ", 1 + p.frag_ps);
                            }
                            View.FTA(115, p);
                        } else {
                            if (Globals.ud.user_name[snum] != null && !Globals.ud.user_name[snum].isEmpty()) {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[116], 0, "KILLED ", Globals.ud.user_name[snum]);
                            } else {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[116], 0, "KILLED PLAYER ", 1 + snum);
                            }
                            View.FTA(116, Globals.ps[p.frag_ps]);
                        }
                    } else {
                        p.fraggedself = (short)(p.fraggedself + 1);
                    }
                    p.frag_ps = (short)snum;
                }
            }
            if (psectlotag == 2) {
                if (p.on_warping_sector == 0) {
                    if (Pragmas.klabs(p.posz - fz) > 4864) {
                        p.posz += 348;
                    }
                } else {
                    s.z -= 512;
                    s.zvel = (short)-348;
                }
                Main.engine.clipmove(p.posx, p.posy, p.posz, p.cursectnum, 0L, 0L, 164, 1024, 1024, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    p.posx = Engine.clipmove_x;
                    p.posy = Engine.clipmove_y;
                    p.posz = Engine.clipmove_z;
                    p.cursectnum = Engine.clipmove_sectnum;
                }
            }
            p.oposx = p.posx;
            p.oposy = p.posy;
            p.oposz = p.posz;
            p.oang = p.ang;
            p.opyoff = p.pyoff;
            p.horiz = 100.0f;
            p.horizoff = 0;
            short sect = Main.engine.updatesector(p.posx, p.posy, p.cursectnum);
            if (sect != -1) {
                p.cursectnum = sect;
            }
            Main.engine.pushmove(p.posx, p.posy, p.posz, p.cursectnum, 128, 1024, 5120, 65537);
            if (Engine.pushmove_sectnum != -1) {
                p.posx = Engine.pushmove_x;
                p.posy = Engine.pushmove_y;
                p.posz = Engine.pushmove_z;
                p.cursectnum = Engine.pushmove_sectnum;
            }
            if (fz > cz + 4096 && s.pal != 1) {
                p.rotscrnang = (short)(p.dead_flag + (fz + p.posz >> 7) & 0x7FF);
            }
            p.on_warping_sector = 0;
            return;
        }
        if (p.transporter_hold > 0) {
            p.transporter_hold = (short)(p.transporter_hold - 1);
            if (p.transporter_hold == 0 && p.on_warping_sector != 0) {
                p.transporter_hold = (short)2;
            }
        }
        if (p.transporter_hold < 0) {
            p.transporter_hold = (short)(p.transporter_hold + 1);
        }
        boolean SHOOTINCODE = false;
        if (p.newowner >= 0) {
            i = p.newowner;
            Globals.hittype[p.i].tempang = (int)p.ang;
            p.posx = Engine.sprite[i].x;
            p.posy = Engine.sprite[i].y;
            p.posz = Engine.sprite[i].z;
            p.ang = Engine.sprite[i].ang;
            s.xvel = 0;
            p.posyv = 0;
            p.posxv = 0;
            p.look_ang = 0;
            p.rotscrnang = 0;
            Player.doincrements(p);
            if (p.curr_weapon == 10) {
                SHOOTINCODE = true;
            } else {
                return;
            }
        }
        if (!SHOOTINCODE) {
            int doubvel = 4;
            if (p.rotscrnang > 0) {
                p.rotscrnang = (short)(p.rotscrnang - ((p.rotscrnang >> 1) + 1));
            } else if (p.rotscrnang < 0) {
                PlayerStruct playerStruct = p;
                playerStruct.rotscrnang = (short)(playerStruct.rotscrnang + ((-p.rotscrnang >> 1) + 1));
            }
            p.look_ang = (short)(p.look_ang - (p.look_ang >> 2));
            if ((sb_snum & 0x40) != 0) {
                p.look_ang = (short)(p.look_ang - 152);
                p.rotscrnang = (short)(p.rotscrnang + 24);
            }
            if ((sb_snum & 0x80) != 0) {
                p.look_ang = (short)(p.look_ang + 152);
                p.rotscrnang = (short)(p.rotscrnang - 24);
            }
            if (p.on_crane < 0) {
                j = Pragmas.ksgn((int)Globals.sync[snum].avel);
                p.weapon_sway = s.xvel < 32 || !p.on_ground || p.bobcounter == 1024 ? ((p.weapon_sway & 0x7FF) > 1120 ? (p.weapon_sway -= 96) : ((p.weapon_sway & 0x7FF) < 928 ? (p.weapon_sway += 96) : 1024)) : p.bobcounter;
                s.xvel = (short)Main.engine.ksqrt((p.posx - p.bobposx) * (p.posx - p.bobposx) + (p.posy - p.bobposy) * (p.posy - p.bobposy));
                if (p.on_ground) {
                    p.bobcounter += Engine.sprite[p.i].xvel >> 1;
                }
                if (!(Globals.ud.clipping || Engine.sector[p.cursectnum].floorpicnum != 560 && p.cursectnum >= 0 && p.cursectnum < Engine.MAXSECTORS)) {
                    p.posx = p.oposx;
                    p.posy = p.oposy;
                } else {
                    p.oposx = p.posx;
                    p.oposy = p.posy;
                }
                p.bobposx = p.posx;
                p.bobposy = p.posy;
                p.oposz = p.posz;
                p.opyoff = p.pyoff;
                p.oang = p.ang;
                if (p.one_eighty_count < 0) {
                    p.one_eighty_count = (short)(p.one_eighty_count + 128);
                    p.ang += 128.0f;
                }
                i = 40;
                if (psectlotag == 2) {
                    p.jumping_counter = 0;
                    p.pycount = (short)(p.pycount + 32);
                    p.pycount = (short)(p.pycount & 0x7FF);
                    p.pyoff = Engine.sintable[p.pycount] >> 7;
                    if (Globals.Sound[48].num == 0) {
                        Sounds.spritesound(48, pi);
                    }
                    if ((sb_snum & 1) != 0) {
                        if (p.poszv > 0) {
                            p.poszv = 0;
                        }
                        p.poszv -= 348;
                        if (p.poszv < -1536) {
                            p.poszv = -1536;
                        }
                    } else if ((sb_snum & 2) != 0) {
                        if (p.poszv < 0) {
                            p.poszv = 0;
                        }
                        p.poszv += 348;
                        if (p.poszv > 1536) {
                            p.poszv = 1536;
                        }
                    } else {
                        if (p.poszv < 0) {
                            p.poszv += 256;
                            if (p.poszv > 0) {
                                p.poszv = 0;
                            }
                        }
                        if (p.poszv > 0) {
                            p.poszv -= 256;
                            if (p.poszv < 0) {
                                p.poszv = 0;
                            }
                        }
                    }
                    if (p.poszv > 2048) {
                        p.poszv >>= 1;
                    }
                    p.posz += p.poszv;
                    if (p.posz > fz - 3840) {
                        p.posz += fz - 3840 - p.posz >> 1;
                    }
                    if (p.posz < cz + 1024) {
                        p.posz = cz + 1024;
                        p.poszv = 0;
                    }
                    if (p.scuba_on != 0 && (Main.engine.krand() & 0xFF) < 8) {
                        j = Spawn.spawn(pi, 661);
                        if (Main.IsOriginalDemo()) {
                            Engine.sprite[j].x += Engine.sintable[(int)p.ang + 512 + 64 - (Globals.global_random & 0x80) & 0x7FF] >> 6;
                            Engine.sprite[j].y += Engine.sintable[(int)p.ang + 64 - (Globals.global_random & 0x80) & 0x7FF] >> 6;
                        } else {
                            Engine.sprite[j].x = (int)((double)Engine.sprite[j].x + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang + 64.0f - (float)(Globals.global_random & 0x80)) / 64.0f));
                            Engine.sprite[j].y = (int)((double)Engine.sprite[j].y + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang + 64.0f - (float)(Globals.global_random & 0x80)) / 64.0f));
                        }
                        Engine.sprite[j].xrepeat = (short)3;
                        Engine.sprite[j].yrepeat = (short)2;
                        Engine.sprite[j].z = p.posz + 2048;
                    }
                } else if (p.jetpack_on != 0) {
                    p.on_ground = false;
                    p.jumping_counter = 0;
                    p.hard_landing = 0;
                    p.falling_counter = 0;
                    p.pycount = (short)(p.pycount + 32);
                    p.pycount = (short)(p.pycount & 0x7FF);
                    p.pyoff = Engine.sintable[p.pycount] >> 7;
                    if (p.jetpack_on < 11) {
                        ++p.jetpack_on;
                        p.posz -= p.jetpack_on << 7;
                    } else if (p.jetpack_on == 11 && Globals.Sound[50].num < 1) {
                        Sounds.spritesound(50, pi);
                    }
                    j = shrunk ? 512 : 2048;
                    if ((sb_snum & 1) != 0) {
                        p.posz -= j;
                        p.crack_time = 777;
                    }
                    if ((sb_snum & 2) != 0) {
                        p.posz += j;
                        p.crack_time = 777;
                    }
                    k = !shrunk && (psectlotag == 0 || psectlotag == 2) ? 32 : 16;
                    if (psectlotag != 2 && p.scuba_on == 1) {
                        p.scuba_on = 0;
                    }
                    if (p.posz > fz - (k << 8)) {
                        p.posz += fz - (k << 8) - p.posz >> 1;
                    }
                    if (p.posz < Globals.hittype[pi].ceilingz + 4608) {
                        p.posz = Globals.hittype[pi].ceilingz + 4608;
                    }
                } else if (psectlotag != 2) {
                    if (p.airleft != 390) {
                        p.airleft = (short)390;
                    }
                    if (p.scuba_on == 1) {
                        p.scuba_on = 0;
                    }
                    if (psectlotag == 1 && p.spritebridge == 0) {
                        if (!shrunk) {
                            i = 34;
                            p.pycount = (short)(p.pycount + 32);
                            p.pycount = (short)(p.pycount & 0x7FF);
                            p.pyoff = Engine.sintable[p.pycount] >> 6;
                        } else {
                            i = 12;
                        }
                        if (!shrunk && truefdist <= 9728L && p.on_ground) {
                            if (p.dummyplayersprite == -1) {
                                p.dummyplayersprite = (short)Spawn.spawn(pi, 1420);
                            }
                            p.footprintcount = (short)6;
                            p.footprintpal = Engine.sector[p.cursectnum].floorpicnum == 200 ? (short)8 : (short)0;
                            p.footprintshade = 0;
                        }
                    } else if (p.footprintcount > 0 && p.on_ground && (Engine.sector[p.cursectnum].floorstat & 2) != 2) {
                        j = Engine.headspritesect[psect];
                        while (j >= 0 && (Engine.sprite[j].picnum != 550 && Engine.sprite[j].picnum != 672 && Engine.sprite[j].picnum != 673 && Engine.sprite[j].picnum != 674 || Pragmas.klabs(Engine.sprite[j].x - p.posx) >= 384 || Pragmas.klabs(Engine.sprite[j].y - p.posy) >= 384)) {
                            j = Engine.nextspritesect[j];
                        }
                        if (j < 0) {
                            p.footprintcount = (short)(p.footprintcount - 1);
                            if (Engine.sector[p.cursectnum].lotag == 0 && Engine.sector[p.cursectnum].hitag == 0) {
                                switch (Main.engine.krand() & 3) {
                                    case 0: {
                                        j = Spawn.spawn(pi, 550);
                                        break;
                                    }
                                    case 1: {
                                        j = Spawn.spawn(pi, 672);
                                        break;
                                    }
                                    case 2: {
                                        j = Spawn.spawn(pi, 673);
                                        break;
                                    }
                                    default: {
                                        j = Spawn.spawn(pi, 674);
                                    }
                                }
                                Engine.sprite[j].pal = p.footprintpal;
                                Engine.sprite[j].shade = (byte)p.footprintshade;
                            }
                        }
                    }
                    if (p.posz < fz - (i << 8)) {
                        if ((sb_snum & 3) == 0 && p.on_ground && (Engine.sector[psect].floorstat & 2) != 0 && p.posz >= fz - (i << 8) - 4096) {
                            p.posz = fz - (i << 8);
                        } else {
                            p.on_ground = false;
                            p.poszv += Globals.currentGame.getCON().gc + 80;
                            if (p.poszv >= 6144) {
                                p.poszv = 6144;
                            }
                            if (p.poszv > 2400 && p.falling_counter < 255) {
                                p.falling_counter = (short)(p.falling_counter + 1);
                                if (p.falling_counter == 38) {
                                    p.scream_voice = Sounds.spritesound(245, pi);
                                }
                            }
                            if (p.posz + p.poszv >= fz - (i << 8) && Engine.sector[p.cursectnum].lotag != 1) {
                                if (p.falling_counter > 62) {
                                    Player.quickkill(p);
                                } else if (p.falling_counter > 9) {
                                    j = p.falling_counter;
                                    s.extra = (short)(s.extra - (j - (Main.engine.krand() & 3)));
                                    if (s.extra <= 0) {
                                        Sounds.spritesound(69, pi);
                                        p.pals[0] = 63;
                                        p.pals[1] = 0;
                                        p.pals[2] = 0;
                                        p.pals_time = 63;
                                    } else {
                                        Sounds.spritesound(42, pi);
                                        Sounds.spritesound(200, pi);
                                    }
                                    p.pals[0] = 16;
                                    p.pals[1] = 0;
                                    p.pals[2] = 0;
                                    p.pals_time = 32;
                                } else if (p.poszv > 2048) {
                                    Sounds.spritesound(42, pi);
                                }
                            }
                        }
                    } else {
                        p.falling_counter = 0;
                        if (p.scream_voice != null) {
                            p.scream_voice.dispose();
                            p.scream_voice = null;
                        }
                        if (psectlotag != 1 && psectlotag != 2 && !p.on_ground && p.poszv > 3072) {
                            p.hard_landing = (short)(p.poszv >> 10);
                        }
                        p.on_ground = true;
                        if (i == 40) {
                            k = fz - (i << 8) - p.posz >> 1;
                            if (Pragmas.klabs(k) < 256) {
                                k = 0;
                            }
                            p.posz += k;
                            p.poszv -= 768;
                            if (p.poszv < 0) {
                                p.poszv = 0;
                            }
                        } else if (p.jumping_counter == 0) {
                            p.posz += fz - (i << 7) - p.posz >> 1;
                            if (p.on_warping_sector == 0 && p.posz > fz - 4096) {
                                p.posz = fz - 4096;
                                p.poszv >>= 1;
                            }
                        }
                        p.on_warping_sector = 0;
                        if ((sb_snum & 2) != 0) {
                            p.posz += 2816;
                            p.crack_time = 777;
                        }
                        if ((sb_snum & 1) == 0 && p.jumping_toggle == 1) {
                            p.jumping_toggle = 0;
                        } else if ((sb_snum & 1) != 0 && p.jumping_toggle == 0 && p.jumping_counter == 0 && fz - cz > 14336) {
                            p.jumping_counter = 1;
                            p.jumping_toggle = 1;
                        }
                        if (p.jumping_counter != 0 && (sb_snum & 1) == 0) {
                            p.jumping_toggle = 0;
                        }
                    }
                    if (p.jumping_counter != 0) {
                        p.crouch_toggle = 0;
                        if ((sb_snum & 1) == 0 && p.jumping_toggle == 1) {
                            p.jumping_toggle = 0;
                        }
                        if (p.jumping_counter < 1280) {
                            if (psectlotag == 1 && p.jumping_counter > 768) {
                                p.jumping_counter = 0;
                                p.poszv = -512;
                            } else {
                                p.poszv -= Engine.sintable[1920 + p.jumping_counter & 0x7FF] / 12;
                                p.jumping_counter = (short)(p.jumping_counter + 180);
                                p.on_ground = false;
                            }
                        } else {
                            p.jumping_counter = 0;
                            p.poszv = 0;
                        }
                    }
                    p.posz += p.poszv;
                    if (p.posz < cz + 1024) {
                        p.jumping_counter = 0;
                        if (p.poszv < 0) {
                            p.posyv = 0;
                            p.posxv = 0;
                        }
                        p.poszv = 128;
                        p.posz = cz + 1024;
                    }
                }
                if (p.fist_incs != 0 || p.transporter_hold > 2 || p.hard_landing != 0 || p.access_incs > 0 || p.knee_incs > 0 || p.curr_weapon == 8 && p.kickback_pic > 1 && p.kickback_pic < 4) {
                    doubvel = 0;
                    p.posxv = 0;
                    p.posyv = 0;
                } else if (Globals.sync[snum].avel != 0.0f) {
                    if (Main.IsOriginalDemo()) {
                        int tempang = (int)Globals.sync[snum].avel << 1;
                        p.angvel = psectlotag == 2 ? (float)((tempang - (tempang >> 3)) * Pragmas.ksgn(doubvel)) : (float)(tempang * Pragmas.ksgn(doubvel));
                        p.ang += p.angvel;
                        p.ang = (int)p.ang & 0x7FF;
                    } else {
                        float tempang = Globals.sync[snum].avel * 2.0f;
                        p.angvel = psectlotag == 2 ? (tempang - tempang / 8.0f) * (float)Gameutils.sgn(doubvel) : tempang * (float)Gameutils.sgn(doubvel);
                        p.ang += p.angvel;
                        p.ang = ru.m210projects.Build.Gameutils.BClampAngle(p.ang);
                    }
                    p.crack_time = 777;
                }
                if (p.spritebridge == 0 && ru.m210projects.Build.Gameutils.isValidSector(s.sectnum)) {
                    j = Engine.sector[s.sectnum].floorpicnum;
                    if (j == 4240 || Engine.sector[s.sectnum].ceilingpicnum == 4240) {
                        if (p.boot_amount > 0) {
                            p.boot_amount = (short)(p.boot_amount - 1);
                            p.inven_icon = 7;
                            if (p.boot_amount <= 0) {
                                Player.checkavailinven(p);
                            }
                        } else {
                            if (Globals.Sound[211].num < 1) {
                                Sounds.spritesound(211, pi);
                            }
                            p.pals[0] = 0;
                            p.pals[1] = 8;
                            p.pals[2] = 0;
                            p.pals_time = 32;
                            s.extra = (short)(s.extra - 1);
                        }
                    }
                    k = 0;
                    if (p.on_ground && truefdist <= 13824L) {
                        switch (j) {
                            case 859: {
                                if (!Gameutils.rnd(32)) break;
                                if (p.boot_amount > 0) {
                                    k = 1;
                                    break;
                                }
                                if (Globals.Sound[211].num < 1) {
                                    Sounds.spritesound(211, pi);
                                }
                                p.pals[0] = 64;
                                p.pals[1] = 64;
                                p.pals[2] = 64;
                                p.pals_time = 32;
                                s.extra = (short)(s.extra - (1 + (Main.engine.krand() & 3)));
                                if (Globals.Sound[21].num >= 1) break;
                                Sounds.spritesound(21, pi);
                                break;
                            }
                            case 200: {
                                if (!Gameutils.rnd(16)) break;
                                if (p.boot_amount > 0) {
                                    k = 1;
                                    break;
                                }
                                if (Globals.Sound[211].num < 1) {
                                    Sounds.spritesound(211, pi);
                                }
                                p.pals[0] = 0;
                                p.pals[1] = 8;
                                p.pals[2] = 0;
                                p.pals_time = 32;
                                s.extra = (short)(s.extra - (1 + (Main.engine.krand() & 3)));
                                break;
                            }
                            case 1082: {
                                if (!Gameutils.rnd(32)) break;
                                if (p.boot_amount > 0) {
                                    k = 1;
                                    break;
                                }
                                if (Globals.Sound[211].num < 1) {
                                    Sounds.spritesound(211, pi);
                                }
                                p.pals[0] = 8;
                                p.pals[1] = 0;
                                p.pals[2] = 0;
                                p.pals_time = 32;
                                s.extra = (short)(s.extra - (1 + (Main.engine.krand() & 3)));
                            }
                        }
                    }
                    if (k != 0) {
                        View.FTA(75, p);
                        p.boot_amount = (short)(p.boot_amount - 2);
                        if (p.boot_amount <= 0) {
                            Player.checkavailinven(p);
                        }
                    }
                }
                if (p.posxv != 0 || p.posyv != 0 || Globals.sync[snum].fvel != 0 || Globals.sync[snum].svel != 0) {
                    p.crack_time = 777;
                    k = Engine.sintable[p.bobcounter & 0x7FF] >> 12;
                    if (truefdist < 11776L) {
                        if (k == 1 || k == 3) {
                            if (p.spritebridge == 0 && p.walking_snd_toggle == 0 && p.on_ground) {
                                switch (psectlotag) {
                                    case 0: {
                                        j = lz >= 0 && (lz & 0xE000) == 49152 ? (int)Engine.sprite[lz & 0x1FFF].picnum : (int)Engine.sector[psect].floorpicnum;
                                        switch (j) {
                                            case 342: 
                                            case 343: {
                                                Sounds.spritesound(43, pi);
                                                p.walking_snd_toggle = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case 1: {
                                        if ((Main.engine.krand() & 1) == 0) {
                                            Sounds.spritesound(40, pi);
                                        }
                                        p.walking_snd_toggle = 1;
                                    }
                                }
                            }
                        } else if (p.walking_snd_toggle > 0) {
                            p.walking_snd_toggle = (short)(p.walking_snd_toggle - 1);
                        }
                    }
                    if (p.jetpack_on == 0 && p.steroids_amount > 0 && p.steroids_amount < 400) {
                        doubvel <<= 1;
                    }
                    p.posxv += Globals.sync[snum].fvel * doubvel << 6;
                    p.posyv += Globals.sync[snum].svel * doubvel << 6;
                    if (p.curr_weapon == 0 && p.kickback_pic > 10 && p.on_ground || p.on_ground && (sb_snum & 2) != 0) {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction - 8192, 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction - 8192, 16);
                    } else if (psectlotag == 2) {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction - 5120, 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction - 5120, 16);
                    } else {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction, 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction, 16);
                    }
                    if (Math.abs(p.posxv) < 2048 && Math.abs(p.posyv) < 2048) {
                        p.posyv = 0;
                        p.posxv = 0;
                    }
                    if (shrunk) {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                    }
                }
            }
            i = psectlotag == 1 || p.spritebridge == 1 ? 1024 : 5120;
            k = Engine.sector[p.cursectnum].lotag == 2 ? 0 : 1;
            if (Globals.ud.clipping) {
                j = 0;
                p.posx += p.posxv >> 14;
                p.posy += p.posyv >> 14;
                short sect = Main.engine.updatesector(p.posx, p.posy, p.cursectnum);
                if (sect != -1) {
                    p.cursectnum = sect;
                }
                Main.engine.changespritesect(pi, p.cursectnum);
            } else {
                j = Main.engine.clipmove(p.posx, p.posy, p.posz, p.cursectnum, p.posxv, p.posyv, 164, 1024, i, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    p.posx = Engine.clipmove_x;
                    p.posy = Engine.clipmove_y;
                    p.posz = Engine.clipmove_z;
                    p.cursectnum = Engine.clipmove_sectnum;
                }
            }
            if (p.jetpack_on == 0 && psectlotag != 2 && psectlotag != 1 && shrunk) {
                p.posz += 8192;
            }
            if (j != 0) {
                Sector.checkplayerhurt(p, j);
            }
            if (p.jetpack_on == 0) {
                if (s.xvel > 16) {
                    if (psectlotag != 1 && psectlotag != 2 && p.on_ground) {
                        p.pycount = (short)(p.pycount + 52);
                        p.pycount = (short)(p.pycount & 0x7FF);
                        p.pyoff = Pragmas.klabs(s.xvel * Engine.sintable[p.pycount]) / 1596;
                    }
                } else if (psectlotag != 2 && psectlotag != 1) {
                    p.pyoff = 0;
                }
            }
            Main.engine.setsprite(pi, p.posx, p.posy, p.posz + 9728);
            if (psectlotag < 3) {
                psect = s.sectnum;
                if (!Globals.ud.clipping && ru.m210projects.Build.Gameutils.isValidSector(psect) && Engine.sector[psect].lotag == 31 && Engine.sprite[Engine.sector[psect].hitag].xvel != 0 && Globals.hittype[Engine.sector[psect].hitag].temp_data[0] == 0) {
                    Player.quickkill(p);
                    return;
                }
            }
            if (truefdist < 9728L && p.on_ground && psectlotag != 1 && !shrunk && Engine.sector[p.cursectnum].lotag == 1 && Globals.Sound[40].num == 0) {
                Sounds.spritesound(40, pi);
            }
            if (p.cursectnum != s.sectnum && ru.m210projects.Build.Gameutils.isValidSector(p.cursectnum)) {
                Main.engine.changespritesect(pi, p.cursectnum);
            }
            if (!Globals.ud.clipping) {
                int n = j = Main.engine.pushmove(p.posx, p.posy, p.posz, p.cursectnum, 164, 1024, 1024, 65537) < 0 && Gamedef.furthestangle(pi, 8) < 512 ? 1 : 0;
                if (Engine.pushmove_sectnum != -1) {
                    p.posx = Engine.pushmove_x;
                    p.posy = Engine.pushmove_y;
                    p.posz = Engine.pushmove_z;
                    p.cursectnum = Engine.pushmove_sectnum;
                }
            } else {
                j = 0;
            }
            if (!Globals.ud.clipping) {
                if (Pragmas.klabs(Globals.hittype[pi].floorz - Globals.hittype[pi].ceilingz) < 12288 || j != 0) {
                    if (ru.m210projects.Build.Gameutils.isValidSector(s.sectnum) && (Engine.sector[s.sectnum].lotag & 0x8000) == 0 && (Sector.isanunderoperator(Engine.sector[s.sectnum].lotag) || Sector.isanearoperator(Engine.sector[s.sectnum].lotag))) {
                        Sector.activatebysector(s.sectnum, pi);
                    }
                    if (j != 0) {
                        Player.quickkill(p);
                        return;
                    }
                } else if (Pragmas.klabs(fz - cz) < 8192 && Sector.isanunderoperator(Engine.sector[psect].lotag)) {
                    Sector.activatebysector(psect, pi);
                }
            }
            if ((sb_snum & 0x40000) != 0 || p.hard_landing != 0) {
                p.return_to_center = (short)9;
            }
            if ((sb_snum & 0x2000) != 0) {
                p.return_to_center = (short)9;
                if ((sb_snum & 0x20) != 0) {
                    p.horiz += 12.0f;
                }
                p.horiz += 12.0f;
            } else if ((sb_snum & 0x4000) != 0) {
                p.return_to_center = (short)9;
                if ((sb_snum & 0x20) != 0) {
                    p.horiz -= 12.0f;
                }
                p.horiz -= 12.0f;
            } else if ((sb_snum & 8) != 0) {
                if ((sb_snum & 0x20) != 0) {
                    p.horiz += 6.0f;
                }
                p.horiz += 6.0f;
            } else if ((sb_snum & 0x10) != 0) {
                if ((sb_snum & 0x20) != 0) {
                    p.horiz -= 6.0f;
                }
                p.horiz -= 6.0f;
            }
            if (p.return_to_center > 0 && (sb_snum & 0x2000) == 0 && (sb_snum & 0x4000) == 0) {
                p.return_to_center = (short)(p.return_to_center - 1);
                p.horiz = Main.IsOriginalDemo() ? (p.horiz += (float)(33 - (int)p.horiz / 3)) : (p.horiz += 33.0f - p.horiz / 3.0f);
            }
            if (p.hard_landing > 0) {
                p.hard_landing = (short)(p.hard_landing - 1);
                p.horiz -= (float)(p.hard_landing << 4);
            }
            if (p.aim_mode != 0) {
                p.horiz = Main.IsOriginalDemo() ? (p.horiz += (float)((int)Globals.sync[snum].horz >> 1)) : (p.horiz += Globals.sync[snum].horz / 2.0f);
            } else {
                if (p.horiz > 95.0f && p.horiz < 105.0f) {
                    p.horiz = 100.0f;
                }
                if (p.horizoff > -5 && p.horizoff < 5) {
                    p.horizoff = 0;
                }
            }
            if (p.horiz > 299.0f) {
                p.horiz = 299.0f;
            } else if (p.horiz < -99.0f) {
                p.horiz = -99.0f;
            }
            if (p.show_empty_weapon > 0) {
                p.show_empty_weapon = (short)(p.show_empty_weapon - 1);
                if (p.show_empty_weapon == 0) {
                    if (p.last_full_weapon == 11) {
                        p.subweapon = (short)(p.subweapon | 0x800);
                    } else if (p.last_full_weapon == 6) {
                        p.subweapon = (short)(p.subweapon & 0xFFFFF7FF);
                    }
                    Weapons.addweapon(p, p.last_full_weapon);
                    return;
                }
            }
            if (p.knee_incs > 0) {
                p.knee_incs = (short)(p.knee_incs + 1);
                p.horiz -= 48.0f;
                p.return_to_center = (short)9;
                if (p.knee_incs > 15) {
                    p.knee_incs = 0;
                    p.holster_weapon = 0;
                    if (p.weapon_pos < 0) {
                        p.weapon_pos = -p.weapon_pos;
                    }
                    if (p.actorsqu >= 0 && Sector.dist(Engine.sprite[pi], Engine.sprite[p.actorsqu]) < 1400) {
                        Spawn.guts(Engine.sprite[p.actorsqu], 2286, 7, Mmulti.myconnectindex);
                        Spawn.spawn(p.actorsqu, 1226);
                        Sounds.spritesound(69, p.actorsqu);
                        switch (Engine.sprite[p.actorsqu].picnum) {
                            case 603: 
                            case 753: 
                            case 1294: 
                            case 1312: 
                            case 1317: 
                            case 1321: 
                            case 1323: 
                            case 1325: 
                            case 1334: 
                            case 1336: 
                            case 1395: 
                            case 3450: 
                            case 4864: {
                                if (Engine.sprite[p.actorsqu].yvel == 0) break;
                                Sector.operaterespawns(Engine.sprite[p.actorsqu].yvel);
                            }
                        }
                        if (Engine.sprite[p.actorsqu].picnum == 1405) {
                            Player.quickkill(Globals.ps[Engine.sprite[p.actorsqu].yvel]);
                            Globals.ps[Engine.sprite[p.actorsqu].yvel].frag_ps = (short)snum;
                        } else if (Actors.badguy(Engine.sprite[p.actorsqu])) {
                            Main.engine.deletesprite(p.actorsqu);
                            Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                        } else {
                            Main.engine.deletesprite(p.actorsqu);
                        }
                    }
                    p.actorsqu = (short)-1;
                } else if (p.actorsqu >= 0) {
                    p.ang += Gamedef.getincangle(p.ang, (float)Main.engine.getangle(Engine.sprite[p.actorsqu].x - p.posx, Engine.sprite[p.actorsqu].y - p.posy)) / 4.0f;
                }
            }
            if (Player.doincrements(p)) {
                return;
            }
            if (p.weapon_pos != 0) {
                if (p.weapon_pos == -9) {
                    if (p.last_weapon >= 0) {
                        p.weapon_pos = (short)10;
                        p.last_weapon = (short)-1;
                    } else if (p.holster_weapon == 0) {
                        p.weapon_pos = (short)10;
                    }
                } else {
                    p.weapon_pos = (short)(p.weapon_pos - 1);
                }
            }
        }
        if (!shrunk) {
            Weapons.weaponprocess(snum);
        }
    }

    public static int getspritescore(int snum, int dapicnum) {
        switch (dapicnum) {
            case 21: {
                return 5;
            }
            case 22: {
                return 50;
            }
            case 23: {
                return 200;
            }
            case 24: {
                return 25;
            }
            case 25: {
                return 80;
            }
            case 26: {
                return 60;
            }
            case 27: {
                return 50;
            }
            case 28: {
                return 120;
            }
            case 29: {
                return 120;
            }
            case 37: {
                if (Globals.ps[snum].ammo_amount[9] < Globals.currentGame.getCON().max_ammo_amount[9]) {
                    return 10;
                }
                return 0;
            }
            case 5135: {
                if (Globals.ps[snum].ammo_amount[12] < Globals.currentGame.getCON().max_ammo_amount[12]) {
                    return 10;
                }
                return 0;
            }
            case 40: {
                if (Globals.ps[snum].ammo_amount[2] < Globals.currentGame.getCON().max_ammo_amount[2]) {
                    return 10;
                }
                return 0;
            }
            case 41: {
                if (Globals.ps[snum].ammo_amount[3] < Globals.currentGame.getCON().max_ammo_amount[3]) {
                    return 20;
                }
                return 0;
            }
            case 42: {
                if (Globals.ps[snum].ammo_amount[7] < Globals.currentGame.getCON().max_ammo_amount[7]) {
                    return 25;
                }
                return 0;
            }
            case 44: {
                if (Globals.ps[snum].ammo_amount[4] < Globals.currentGame.getCON().max_ammo_amount[4]) {
                    return 50;
                }
                return 0;
            }
            case 46: {
                if (Globals.ps[snum].ammo_amount[6] < Globals.currentGame.getCON().max_ammo_amount[6]) {
                    return 10;
                }
                return 0;
            }
            case 47: {
                if (Globals.ps[snum].ammo_amount[5] < Globals.currentGame.getCON().max_ammo_amount[5]) {
                    return 30;
                }
                return 0;
            }
            case 49: {
                if (Globals.ps[snum].ammo_amount[2] < Globals.currentGame.getCON().max_ammo_amount[2]) {
                    return 25;
                }
                return 0;
            }
            case 51: {
                if (Engine.sprite[Globals.ps[snum].i].extra < 100) {
                    return 10;
                }
                return 0;
            }
            case 52: {
                if (Engine.sprite[Globals.ps[snum].i].extra < 100) {
                    return 30;
                }
                return 0;
            }
            case 53: {
                if (Globals.ps[snum].firstaid_amount < 100) {
                    return 100;
                }
                return 0;
            }
            case 54: {
                if (Globals.ps[snum].shield_amount < 100) {
                    return 50;
                }
                return 0;
            }
            case 55: {
                if (Globals.ps[snum].steroids_amount < 400) {
                    return 30;
                }
                return 0;
            }
            case 56: {
                if (Globals.ps[snum].scuba_amount < 6400) {
                    return 30;
                }
                return 0;
            }
            case 57: {
                if (Globals.ps[snum].jetpack_amount < 1600) {
                    return 100;
                }
                return 0;
            }
            case 59: {
                if (Globals.ps[snum].heat_amount < 1200) {
                    return 10;
                }
                return 0;
            }
            case 60: {
                return 1;
            }
            case 61: {
                if (Globals.ps[snum].boot_amount < 200) {
                    return 50;
                }
                return 0;
            }
            case 100: {
                if (Engine.sprite[Globals.ps[snum].i].extra < Globals.currentGame.getCON().max_player_health) {
                    return 50;
                }
                return 0;
            }
            case 1348: {
                if (Globals.ps[snum].holoduke_amount < 2400) {
                    return 30;
                }
                return 0;
            }
        }
        return 0;
    }

    public static void computergetinput(int snum, Input syn) {
        int daang;
        short dasect;
        int dx;
        int dy;
        int l;
        int z3;
        int y3;
        int x3;
        int k;
        int dist;
        int i;
        int j;
        int z2;
        int y2;
        int x2;
        PlayerStruct p = Globals.ps[snum];
        syn.fvel = 0;
        syn.svel = 0;
        syn.avel = 0.0f;
        syn.horz = 0.0f;
        syn.bits = 0;
        int x1 = Engine.sprite[p.i].x;
        int y1 = Engine.sprite[p.i].y;
        int z1 = Engine.sprite[p.i].z;
        short damyang = Engine.sprite[p.i].ang;
        short damysect = Engine.sprite[p.i].sectnum;
        if (Mmulti.numplayers >= 2 && snum == Mmulti.myconnectindex) {
            x1 = Main.game.net.predict.x;
            y1 = Main.game.net.predict.y;
            z1 = Main.game.net.predict.z + 9728;
            damyang = (short)Main.game.net.predict.ang;
            damysect = Main.game.net.predict.sectnum;
        }
        if ((Globals.numframes & 7) == 0 && !Main.engine.cansee(x1, y1, z1 - 12288, damysect, x2 = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].x, y2 = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].y, (z2 = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].z) - 12288, Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].sectnum)) {
            Player.goalplayer[snum] = snum;
        }
        if (goalplayer[snum] == snum || Globals.ps[Player.goalplayer[snum]].dead_flag != 0) {
            j = Integer.MAX_VALUE;
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (i != snum) {
                    dist = Main.engine.ksqrt((Engine.sprite[Globals.ps[i].i].x - x1) * (Engine.sprite[Globals.ps[i].i].x - x1) + (Engine.sprite[Globals.ps[i].i].y - y1) * (Engine.sprite[Globals.ps[i].i].y - y1));
                    x2 = Engine.sprite[Globals.ps[i].i].x;
                    y2 = Engine.sprite[Globals.ps[i].i].y;
                    z2 = Engine.sprite[Globals.ps[i].i].z;
                    if (!Main.engine.cansee(x1, y1, z1 - 12288, damysect, x2, y2, z2 - 12288, Engine.sprite[Globals.ps[i].i].sectnum)) {
                        dist <<= 1;
                    }
                    if (dist < j) {
                        j = dist;
                        Player.goalplayer[snum] = i;
                    }
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        x2 = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].x;
        y2 = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].y;
        z2 = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].z;
        if (p.dead_flag != 0) {
            syn.bits |= 0x20000000;
        }
        if (p.firstaid_amount > 0 && p.last_extra < 100) {
            syn.bits |= 0x10000;
        }
        j = Engine.headspritestat[4];
        while (j >= 0) {
            switch (Engine.sprite[j].picnum) {
                case 1647: {
                    k = 4;
                    break;
                }
                case 1641: {
                    k = 4;
                    break;
                }
                case 1646: {
                    k = 16;
                    break;
                }
                case 2605: {
                    k = 16;
                    break;
                }
                default: {
                    k = 0;
                }
            }
            if (k != 0) {
                x3 = Engine.sprite[j].x;
                y3 = Engine.sprite[j].y;
                z3 = Engine.sprite[j].z;
                for (l = 0; l <= 8; ++l) {
                    if (Pragmas.tmulscale(x3 - x1, x3 - x1, y3 - y1, y3 - y1, z3 - z1 >> 4, z3 - z1 >> 4, 11) < 3072) {
                        dy = Engine.sintable[Engine.sprite[j].ang & 0x7FF];
                        dx = Engine.sintable[Engine.sprite[j].ang + 512 & 0x7FF];
                        i = (x1 - x3) * dy > (y1 - y3) * dx ? -k * 512 : k * 512;
                        syn.fvel = (short)(syn.fvel - Pragmas.mulscale(dy, i, 17));
                        syn.svel = (short)(syn.svel + Pragmas.mulscale(dx, i, 17));
                    }
                    if (l < 7) {
                        x3 += Pragmas.mulscale(Engine.sprite[j].xvel, Engine.sintable[Engine.sprite[j].ang + 512 & 0x7FF], 14) << 2;
                        y3 += Pragmas.mulscale(Engine.sprite[j].xvel, Engine.sintable[Engine.sprite[j].ang & 0x7FF], 14) << 2;
                        z3 += Engine.sprite[j].zvel << 2;
                        continue;
                    }
                    Main.engine.hitscan(Engine.sprite[j].x, Engine.sprite[j].y, Engine.sprite[j].z, Engine.sprite[j].sectnum, Pragmas.mulscale(Engine.sprite[j].xvel, Engine.sintable[Engine.sprite[j].ang + 512 & 0x7FF], 14), Pragmas.mulscale(Engine.sprite[j].xvel, Engine.sintable[Engine.sprite[j].ang & 0x7FF], 14), Engine.sprite[j].zvel, Engine.pHitInfo, 0x1000040);
                    dasect = Engine.pHitInfo.hitsect;
                    x3 = Engine.pHitInfo.hitx;
                    y3 = Engine.pHitInfo.hity;
                    z3 = Engine.pHitInfo.hitz;
                }
            }
            j = Engine.nextspritestat[j];
        }
        if (Globals.ps[Player.goalplayer[snum]].dead_flag == 0 && (Main.engine.cansee(x1, y1, z1, damysect, x2, y2, z2, Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].sectnum) || Main.engine.cansee(x1, y1, z1 - 6144, damysect, x2, y2, z2 - 6144, Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].sectnum) || Main.engine.cansee(x1, y1, z1 - 12288, damysect, x2, y2, z2 - 12288, Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].sectnum))) {
            int fightdist;
            syn.bits |= 4;
            if (p.curr_weapon == 5 && (Main.engine.rand() & 7) == 0) {
                syn.bits &= 0xFFFFFFFB;
            }
            if (p.curr_weapon == 8) {
                syn.bits |= Main.engine.rand() % 13 << 8;
            }
            if (p.curr_weapon == 4) {
                Main.engine.hitscan(x1, y1, z1 - 9728, damysect, Engine.sintable[damyang + 512 & 0x7FF], Engine.sintable[damyang & 0x7FF], (int)(100.0f - p.horiz - (float)p.horizoff) * 32, Engine.pHitInfo, 0x1000040);
                dasect = Engine.pHitInfo.hitsect;
                x3 = Engine.pHitInfo.hitx;
                y3 = Engine.pHitInfo.hity;
                z3 = Engine.pHitInfo.hitz;
                if ((x3 - x1) * (x3 - x1) + (y3 - y1) * (y3 - y1) < 0x640000) {
                    syn.bits &= 0xFFFFFFFB;
                }
            }
            if ((fightdist = fdmatrix[p.curr_weapon][Globals.ps[Player.goalplayer[snum]].curr_weapon]) < 128) {
                fightdist = 128;
            }
            if ((dist = Main.engine.ksqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1))) == 0) {
                dist = 1;
            }
            short daang2 = Main.engine.getangle(x2 + (Globals.ps[Player.goalplayer[snum]].posxv >> 14) - x1, y2 + (Globals.ps[Player.goalplayer[snum]].posyv >> 14) - y1);
            int zang = 100 - (z2 - z1) * 8 / dist;
            fightdist = Math.max(fightdist, Pragmas.klabs(z2 - z1) >> 4);
            if (Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].yrepeat < 32) {
                fightdist = 0;
                syn.bits &= 0xFFFFFFFB;
            }
            if (Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].pal == 1) {
                fightdist = 0;
                syn.bits &= 0xFFFFFFFB;
            }
            if (dist < 256) {
                syn.bits |= 0x400000;
            }
            x3 = x2 + (x1 - x2) * fightdist / dist;
            y3 = y2 + (y1 - y2) * fightdist / dist;
            syn.fvel = (short)(syn.fvel + (x3 - x1) * 2047 / dist);
            syn.svel = (short)(syn.svel + (y3 - y1) * 2047 / dist);
            if (fightdist != 0) {
                j = Engine.totalclock + snum * 13468;
                i = Engine.sintable[j << 6 & 0x7FF];
                i += Engine.sintable[j + 4245 << 5 & 0x7FF];
                i += Engine.sintable[j + 6745 << 4 & 0x7FF];
                i += Engine.sintable[j + 15685 << 3 & 0x7FF];
                dy = Engine.sintable[Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].ang & 0x7FF];
                dx = Engine.sintable[Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].ang + 512 & 0x7FF];
                i = (x1 - x2) * dy > (y1 - y2) * dx ? (i += 8192) : (i -= 8192);
                syn.fvel = (short)(syn.fvel + (Engine.sintable[daang2 + 1024 & 0x7FF] * i >> 17));
                syn.svel = (short)(syn.svel + (Engine.sintable[daang2 + 512 & 0x7FF] * i >> 17));
            }
            syn.avel = (short)Math.min(Math.max((daang2 + 1024 - damyang & 0x7FF) - 1024 >> 1, -127), 127);
            syn.horz = Math.min(Math.max(((float)zang - p.horiz) / 2.0f, -127.0f), 127.0f);
            syn.bits |= 0x800000;
            return;
        }
        Player.goalsect[snum] = -1;
        if (goalsect[snum] < 0) {
            Player.goalwall[snum] = -1;
            short startsect = Engine.sprite[p.i].sectnum;
            short endsect = Engine.sprite[Globals.ps[Player.goalplayer[snum]].i].sectnum;
            Arrays.fill(dashow2dsector, (byte)0);
            Player.searchsect[0] = startsect;
            Player.searchparent[0] = -1;
            int n = startsect >> 3;
            dashow2dsector[n] = (byte)(dashow2dsector[n] | 1 << (startsect & 7));
            int send = 1;
            for (int splc = 0; splc < send; ++splc) {
                short startwall = Engine.sector[Player.searchsect[splc]].wallptr;
                int endwall = startwall + Engine.sector[Player.searchsect[splc]].wallnum;
                for (i = (int)startwall; i < endwall; ++i) {
                    WALL wal = Engine.wall[i];
                    j = wal.nextsector;
                    if (j < 0 || Main.engine.getceilzofslope((short)j, dx = Engine.wall[wal.point2].x + wal.x >> 1, dy = Engine.wall[wal.point2].y + wal.y >> 1) > Main.engine.getflorzofslope((short)j, dx, dy) - 7168 && (Engine.sector[j].lotag < 15 || Engine.sector[j].lotag > 22) || Main.engine.getflorzofslope((short)j, dx, dy) < Main.engine.getflorzofslope(searchsect[splc], dx, dy) - 18432 || (dashow2dsector[j >> 3] & 1 << (j & 7)) != 0) continue;
                    int n2 = j >> 3;
                    dashow2dsector[n2] = (byte)(dashow2dsector[n2] | 1 << (j & 7));
                    Player.searchsect[send] = (short)j;
                    Player.searchparent[send] = (short)splc;
                    ++send;
                    if (j != endsect) continue;
                    Arrays.fill(dashow2dsector, (byte)0);
                    k = send - 1;
                    while (k >= 0) {
                        int n3 = searchsect[k] >> 3;
                        dashow2dsector[n3] = (byte)(dashow2dsector[n3] | 1 << (searchsect[k] & 7));
                        k = searchparent[k];
                    }
                    k = send - 1;
                    while (k >= 0 && searchparent[k] != 0) {
                        k = searchparent[k];
                    }
                    Player.goalsect[snum] = searchsect[k];
                    startwall = Engine.sector[Player.goalsect[snum]].wallptr;
                    endwall = startwall + Engine.sector[Player.goalsect[snum]].wallnum;
                    y3 = 0;
                    x3 = 0;
                    for (i = (int)startwall; i < endwall; ++i) {
                        x3 += Engine.wall[i].x;
                        y3 += Engine.wall[i].y;
                    }
                    x3 /= endwall - startwall;
                    y3 /= endwall - startwall;
                    startwall = Engine.sector[startsect].wallptr;
                    endwall = startwall + Engine.sector[startsect].wallnum;
                    l = 0;
                    k = startwall;
                    for (i = (int)startwall; i < endwall; ++i) {
                        if (Engine.wall[i].nextsector != goalsect[snum]) continue;
                        dx = Engine.wall[Engine.wall[i].point2].x - Engine.wall[i].x;
                        dy = Engine.wall[Engine.wall[i].point2].y - Engine.wall[i].y;
                        if ((x3 - x1) * (Engine.wall[i].y - y1) <= (y3 - y1) * (Engine.wall[i].x - x1) && (x3 - x1) * (Engine.wall[Engine.wall[i].point2].y - y1) >= (y3 - y1) * (Engine.wall[Engine.wall[i].point2].x - x1)) {
                            k = i;
                            break;
                        }
                        dist = Main.engine.ksqrt(dx * dx + dy * dy);
                        if (dist <= l) continue;
                        l = dist;
                        k = i;
                    }
                    Player.goalwall[snum] = k;
                    daang = Main.engine.getangle(Engine.wall[Engine.wall[k].point2].x - Engine.wall[k].x, Engine.wall[Engine.wall[k].point2].y - Engine.wall[k].y) + 1536 & 0x7FF;
                    Player.goalx[snum] = (Engine.wall[k].x + Engine.wall[Engine.wall[k].point2].x >> 1) + (Engine.sintable[daang + 512 & 0x7FF] >> 8);
                    Player.goaly[snum] = (Engine.wall[k].y + Engine.wall[Engine.wall[k].point2].y >> 1) + (Engine.sintable[daang & 0x7FF] >> 8);
                    Player.goalz[snum] = Engine.sector[Player.goalsect[snum]].floorz - 8192;
                    break;
                }
                i = Engine.headspritesect[searchsect[splc]];
                while (i >= 0) {
                    if (Engine.sprite[i].lotag == 7 && (dashow2dsector[(j = (int)Engine.sprite[Engine.sprite[i].owner].sectnum) >> 3] & 1 << (j & 7)) == 0) {
                        int n4 = j >> 3;
                        dashow2dsector[n4] = (byte)(dashow2dsector[n4] | 1 << (j & 7));
                        Player.searchsect[send] = (short)j;
                        Player.searchparent[send] = (short)splc;
                        ++send;
                        if (j == endsect) {
                            Arrays.fill(dashow2dsector, (byte)0);
                            k = send - 1;
                            while (k >= 0) {
                                int n5 = searchsect[k] >> 3;
                                dashow2dsector[n5] = (byte)(dashow2dsector[n5] | 1 << (searchsect[k] & 7));
                                k = searchparent[k];
                            }
                            k = send - 1;
                            while (k >= 0 && searchparent[k] != 0) {
                                k = searchparent[k];
                            }
                            Player.goalsect[snum] = searchsect[k];
                            startwall = Engine.sector[startsect].wallptr;
                            endwall = startwall + Engine.sector[startsect].wallnum;
                            l = 0;
                            k = startwall;
                            for (i = (int)startwall; i < endwall; ++i) {
                                dx = Engine.wall[Engine.wall[i].point2].x - Engine.wall[i].x;
                                dy = Engine.wall[Engine.wall[i].point2].y - Engine.wall[i].y;
                                dist = Main.engine.ksqrt(dx * dx + dy * dy);
                                if (Engine.wall[i].nextsector != goalsect[snum] || dist <= l) continue;
                                l = dist;
                                k = i;
                            }
                            Player.goalwall[snum] = k;
                            daang = Main.engine.getangle(Engine.wall[Engine.wall[k].point2].x - Engine.wall[k].x, Engine.wall[Engine.wall[k].point2].y - Engine.wall[k].y) + 1536 & 0x7FF;
                            Player.goalx[snum] = (Engine.wall[k].x + Engine.wall[Engine.wall[k].point2].x >> 1) + (Engine.sintable[daang + 512 & 0x7FF] >> 8);
                            Player.goaly[snum] = (Engine.wall[k].y + Engine.wall[Engine.wall[k].point2].y >> 1) + (Engine.sintable[daang & 0x7FF] >> 8);
                            Player.goalz[snum] = Engine.sector[Player.goalsect[snum]].floorz - 8192;
                            break;
                        }
                    }
                    i = Engine.nextspritesect[i];
                }
                if (goalwall[snum] >= 0) break;
            }
        }
        if (goalsect[snum] < 0 || goalwall[snum] < 0) {
            if (goalsprite[snum] < 0) {
                block19: for (k = 0; k < 4; ++k) {
                    i = Main.engine.rand() % Engine.numsectors;
                    j = Engine.headspritesect[i];
                    while (j >= 0) {
                        if (Engine.sprite[j].xrepeat > 0 && Engine.sprite[j].yrepeat > 0 && Player.getspritescore(snum, Engine.sprite[j].picnum) > 0 && Main.engine.cansee(x1, y1, z1 - 8192, damysect, Engine.sprite[j].x, Engine.sprite[j].y, Engine.sprite[j].z - 1024, (short)i)) {
                            Player.goalx[snum] = Engine.sprite[j].x;
                            Player.goaly[snum] = Engine.sprite[j].y;
                            Player.goalz[snum] = Engine.sprite[j].z;
                            Player.goalsprite[snum] = j;
                            continue block19;
                        }
                        j = Engine.nextspritesect[j];
                    }
                }
            }
            if ((dist = Main.engine.ksqrt(((x2 = goalx[snum]) - x1) * (x2 - x1) + ((y2 = goaly[snum]) - y1) * (y2 - y1))) == 0) {
                return;
            }
            daang = Main.engine.getangle(x2 - x1, y2 - y1);
            syn.fvel = (short)(syn.fvel + (x2 - x1) * 2047 / dist);
            syn.svel = (short)(syn.svel + (y2 - y1) * 2047 / dist);
            syn.avel = (byte)Math.min(Math.max((daang + 1024 - damyang & 0x7FF) - 1024 >> 3, -127), 127);
        } else {
            Player.goalsprite[snum] = -1;
        }
        x3 = p.posx;
        y3 = p.posy;
        z3 = p.posz;
        dasect = p.cursectnum;
        i = Main.engine.clipmove(x3, y3, z3, dasect, p.posxv, p.posyv, 164, 1024, 1024, 65537);
        if (Engine.clipmove_sectnum != -1) {
            dasect = Engine.clipmove_sectnum;
            x3 = Engine.clipmove_x;
            y3 = Engine.clipmove_y;
            z3 = Engine.clipmove_z;
        }
        if (i == 0) {
            x3 = p.posx;
            y3 = p.posy;
            z3 = p.posz + 6144;
            dasect = p.cursectnum;
            i = Main.engine.clipmove(x3, y3, z3, dasect, p.posxv, p.posyv, 164, 1024, 1024, 65537);
            if (Engine.clipmove_sectnum != -1) {
                dasect = Engine.clipmove_sectnum;
                x3 = Engine.clipmove_x;
                y3 = Engine.clipmove_y;
                z3 = Engine.clipmove_z;
            }
        }
        if (i != 0) {
            int nwall;
            int n = snum;
            clipmovecount[n] = clipmovecount[n] + 1;
            j = 0;
            if ((i & 0xE000) == 32768) {
                nwall = i & 0x1FFF;
                if (Engine.wall[nwall].nextsector >= 0) {
                    if (Main.engine.getflorzofslope(Engine.wall[nwall].nextsector, p.posx, p.posy) <= p.posz + 6144) {
                        j |= 1;
                    }
                    if (Main.engine.getceilzofslope(Engine.wall[nwall].nextsector, p.posx, p.posy) >= p.posz - 6144) {
                        j |= 2;
                    }
                }
            }
            if ((i & 0xE000) == 49152) {
                j = 1;
            }
            if ((j & 1) != 0 && clipmovecount[snum] == 4) {
                syn.bits |= 1;
            }
            if ((j & 2) != 0) {
                syn.bits |= 2;
            }
            daang = Main.engine.getangle(x2 - x1, y2 - y1);
            if ((i & 0xE000) == 32768) {
                nwall = i & 0x1FFF;
                daang = Main.engine.getangle(Engine.wall[Engine.wall[nwall].point2].x - Engine.wall[nwall].x, Engine.wall[Engine.wall[nwall].point2].y - Engine.wall[nwall].y);
            }
            j = Engine.totalclock + snum * 13468;
            i = Engine.sintable[j << 6 & 0x7FF];
            i += Engine.sintable[j + 4245 << 5 & 0x7FF];
            i += Engine.sintable[j + 6745 << 4 & 0x7FF];
            syn.fvel = (short)(syn.fvel + (Engine.sintable[daang + 1024 & 0x7FF] * (i += Engine.sintable[j + 15685 << 3 & 0x7FF]) >> 17));
            syn.svel = (short)(syn.svel + (Engine.sintable[daang + 512 & 0x7FF] * i >> 17));
            if ((clipmovecount[snum] & 0x1F) == 2) {
                syn.bits |= 0x20000000;
            }
            if ((clipmovecount[snum] & 0x1F) == 17) {
                syn.bits |= 0x400000;
            }
            if (clipmovecount[snum] > 32) {
                Player.goalsect[snum] = -1;
                Player.goalwall[snum] = -1;
                Player.clipmovecount[snum] = 0;
            }
            Player.goalsprite[snum] = -1;
        } else {
            Player.clipmovecount[snum] = 0;
        }
        if (goalsect[snum] >= 0 && goalwall[snum] >= 0) {
            x2 = goalx[snum];
            y2 = goaly[snum];
            dist = Main.engine.ksqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (dist == 0) {
                return;
            }
            daang = Main.engine.getangle(x2 - x1, y2 - y1);
            if (goalwall[snum] >= 0 && dist < 4096) {
                daang = Main.engine.getangle(Engine.wall[Engine.wall[Player.goalwall[snum]].point2].x - Engine.wall[Player.goalwall[snum]].x, Engine.wall[Engine.wall[Player.goalwall[snum]].point2].y - Engine.wall[Player.goalwall[snum]].y) + 1536 & 0x7FF;
            }
            syn.fvel = (short)(syn.fvel + (x2 - x1) * 2047 / dist);
            syn.svel = (short)(syn.svel + (y2 - y1) * 2047 / dist);
            syn.avel = (byte)Math.min(Math.max((daang + 1024 - damyang & 0x7FF) - 1024 >> 3, -127), 127);
        }
    }
}

