/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Sounds;

public class EndScreen
extends ScreenAdapter {
    private final Main app;
    private int bonuscnt = 0;
    protected int gCutsClock;
    private final int[] bossmove = new int[]{0, 120, 3263, 86, 59, 220, 260, 3264, 86, 59, 260, 290, 3265, 86, 59, 290, 320, 3266, 86, 59, 320, 350, 3267, 86, 59, 350, 380, 3268, 86, 59};
    private final int[] breathe = new int[]{0, 30, 3261, 176, 59, 30, 60, 3262, 176, 59, 60, 90, 3261, 176, 59, 90, 120, 0, 176, 59};

    public EndScreen(Main app) {
        this.app = app;
    }

    @Override
    public void show() {
        if (Globals.ud.volume_number == 0) {
            Main.engine.setbrightness(Globals.ud.brightness >> 2, Player.endingpal, GLRenderer.GLInvalidateFlag.All);
        } else {
            Main.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
        }
        this.bonuscnt = 0;
        Engine.totalclock = 0;
        this.gCutsClock = 0;
    }

    @Override
    public void render(float delta) {
        Main.engine.clearview(0);
        Main.engine.sampletimer();
        switch (Globals.ud.volume_number) {
            case 0: {
                if (this.bonuscnt < 4) {
                    int t;
                    Main.engine.rotatesprite(0, 0x320000, 65536, 0, 3260, 0, 0, 218, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    if (Engine.totalclock > 390 && Engine.totalclock < 780) {
                        for (t = 0; t < this.bossmove.length; t += 5) {
                            if (this.bossmove[t + 2] == 0 || Engine.totalclock % 390 <= this.bossmove[t] || Engine.totalclock % 390 > this.bossmove[t + 1]) continue;
                            if (t == 10 && this.bonuscnt == 1) {
                                Sounds.sound(109);
                                Sounds.sound(69);
                                ++this.bonuscnt;
                            }
                            Main.engine.rotatesprite(this.bossmove[t + 3] << 16, this.bossmove[t + 4] << 16, 65536, 0, this.bossmove[t + 2], 0, 0, 218, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                        }
                    }
                    if (Engine.totalclock < 450 || Engine.totalclock >= 750) {
                        if (Engine.totalclock >= 750) {
                            Main.engine.rotatesprite(0x560000, 0x3B0000, 65536, 0, 3268, 0, 0, 218, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                            if (Engine.totalclock >= 750 && this.bonuscnt == 2) {
                                Sounds.sound(56);
                                ++this.bonuscnt;
                            }
                        }
                        for (t = 0; t < this.breathe.length; t += 5) {
                            if (this.breathe[t + 2] == 0 || Engine.totalclock % 120 <= this.breathe[t] || Engine.totalclock % 120 > this.breathe[t + 1]) continue;
                            if (t == 5 && this.bonuscnt == 0) {
                                Sounds.sound(230);
                                ++this.bonuscnt;
                            }
                            Main.engine.rotatesprite(this.breathe[t + 3] << 16, this.breathe[t + 4] << 16, 65536, 0, this.breathe[t + 2], 0, 0, 218, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                        }
                    }
                    if (!this.isSkipped()) break;
                    this.bonuscnt = 4;
                    Main.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
                    Sounds.StopAllSounds();
                    Main.game.pInput.ctrlResetKeyStatus();
                    break;
                }
                Main.engine.rotatesprite(0, 655360, 63000, 0, 3292, 0, 0, 90, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                if (!this.isSkipped()) break;
                Main.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
                Sounds.sound(14);
                Main.game.pInput.ctrlResetKeyStatus();
                Main.game.changeScreen(Main.gStatisticScreen);
                break;
            }
            case 1: {
                Main.engine.rotatesprite(0, 0, 65536, 0, 3293, 0, 0, 90, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                if (!this.isSkipped()) break;
                Main.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
                Sounds.sound(14);
                Main.game.pInput.ctrlResetKeyStatus();
                Main.game.changeScreen(Main.gStatisticScreen);
                break;
            }
            case 3: {
                this.app.getFont(2).drawText(160, 60, "THANKS TO ALL OUR", 0, 0, BuildFont.TextAlign.Center, 2, false);
                this.app.getFont(2).drawText(160, 76, "FANS FOR GIVING", 0, 0, BuildFont.TextAlign.Center, 2, false);
                this.app.getFont(2).drawText(160, 92, "US BIG HEADS.", 0, 0, BuildFont.TextAlign.Center, 2, false);
                this.app.getFont(2).drawText(160, 118, "LOOK FOR A DUKE NUKEM 3D", 0, 0, BuildFont.TextAlign.Center, 2, false);
                this.app.getFont(2).drawText(160, 134, "SEQUEL SOON.", 0, 0, BuildFont.TextAlign.Center, 2, false);
                if (!this.isSkipped()) break;
                Main.gAnmScreen.setCallback(new Runnable(){

                    @Override
                    public void run() {
                        Main.game.changeScreen(Main.gStatisticScreen);
                    }
                });
                Main.gAnmScreen.init("duketeam.anm", 4);
                Main.game.setScreen(Main.gAnmScreen.escSkipping(false));
                return;
            }
            case 4: {
                Main.engine.rotatesprite(0, 0, 65536, 0, 5367, 0, 0, 90, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                if (!this.isSkipped()) break;
                Main.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
                Sounds.sound(14);
                Main.game.pInput.ctrlResetKeyStatus();
                Main.game.changeScreen(Main.gStatisticScreen);
            }
        }
        if (Main.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        if (Engine.totalclock - this.gCutsClock < 200) {
            this.DrawEscText(Main.game.getFont(0), 251);
        }
        Main.engine.nextpage();
    }

    protected void DrawEscText(BuildFont font, int pal) {
        int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        font.drawText(160, 5, "Press ESC to skip", shade, pal, BuildFont.TextAlign.Center, 2, true);
    }

    public void episode1() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Globals.ud.volume_number = 0;
                Main.game.setScreen(Main.gEndScreen);
            }
        });
    }

    public void episode2() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Globals.ud.volume_number = 1;
                Sounds.sndStopMusic();
                Main.gAnmScreen.init("cineov2.anm", 1);
                Main.gAnmScreen.setCallback(new Runnable(){

                    @Override
                    public void run() {
                        Main.game.setScreen(Main.gEndScreen);
                    }
                });
                Main.game.setScreen(Main.gAnmScreen.escSkipping(true));
            }
        });
    }

    public void episode3() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Globals.ud.volume_number = 2;
                Sounds.sndStopMusic();
                Main.gAnmScreen.init("cineov3.anm", 2);
                Main.gAnmScreen.setCallback(new Runnable(){

                    @Override
                    public void run() {
                        Main.gAnmScreen.init("radlogo.anm", 3);
                        Main.gAnmScreen.setCallback(new Runnable(){

                            @Override
                            public void run() {
                                Main.game.changeScreen(Main.gStatisticScreen);
                            }
                        });
                        Main.gAnmScreen.escSkipping(true);
                    }
                });
                Main.game.setScreen(Main.gAnmScreen.escSkipping(true));
            }
        });
    }

    public void episode4() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Globals.ud.volume_number = 3;
                Sounds.sndStopMusic();
                Main.gAnmScreen.init("vol4e1.anm", 8);
                Main.gAnmScreen.setCallback(new Runnable(){

                    @Override
                    public void run() {
                        Sounds.sound(288);
                        Main.game.setScreen(Main.gEndScreen);
                    }
                });
                Main.game.setScreen(Main.gAnmScreen.escSkipping(true));
            }
        });
    }

    public void episode5() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Globals.ud.volume_number = 4;
                Sounds.sndStopMusic();
                Sounds.sound(401);
                Main.game.setScreen(Main.gEndScreen);
            }
        });
    }

    public boolean isSkipped() {
        return Main.game.pInput.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true) || Main.game.pInput.ctrlPadStatusOnce(BuildConfig.GameKeys.Menu_Toggle);
    }
}

