/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Premap;

public class PrecacheScreen
extends PrecacheAdapter {
    private final Main app;

    public PrecacheScreen(Main app) {
        super(app);
        this.app = app;
        this.addQueue("Preload sounds...", new Runnable(){

            @Override
            public void run() {
                PrecacheScreen.this.precachenecessarysounds();
            }
        });
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int i;
                for (i = 0; i < Engine.numsectors; ++i) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                }
                PrecacheScreen.this.doprecache(0);
                for (i = 0; i < Engine.numsectors; ++i) {
                    if ((Engine.sector[i].ceilingstat & 1) == 0) continue;
                    if (Engine.sector[i].ceilingpicnum == 89) {
                        for (int j = 0; j < 5; ++j) {
                            PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum + j);
                        }
                        continue;
                    }
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                block8: for (int i = 0; i < Engine.numwalls; ++i) {
                    int j;
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    switch (Engine.wall[i].picnum) {
                        case 336: {
                            for (j = 0; j < 3; ++j) {
                                PrecacheScreen.this.addTile(Engine.wall[i].picnum + j);
                            }
                            break;
                        }
                        case 120: 
                        case 122: {
                            PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                            break;
                        }
                        case 268: 
                        case 269: 
                        case 270: {
                            for (int k = 268; k < 271; ++k) {
                                PrecacheScreen.this.addTile(k);
                            }
                            break;
                        }
                    }
                    if (Engine.wall[i].overpicnum < 0) continue;
                    PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                    switch (Engine.wall[i].overpicnum) {
                        case 663: {
                            for (j = 0; j < 3; ++j) {
                                PrecacheScreen.this.addTile(663 + j);
                            }
                            continue block8;
                        }
                    }
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                PrecacheScreen.this.cachegoodsprites();
                for (int i = 0; i < Engine.numsectors; ++i) {
                    short j = Engine.headspritesect[i];
                    while (j >= 0) {
                        if (Engine.sprite[j].xrepeat != 0 && Engine.sprite[j].yrepeat != 0 && (Engine.sprite[j].cstat & 0x8000) == 0) {
                            PrecacheScreen.this.cachespritenum(j);
                        }
                        j = Engine.nextspritesect[j];
                    }
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload other tiles...", new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Engine.MAXTILES; ++i) {
                    if (PrecacheScreen.this.engine.getTile(i).isLoaded()) continue;
                    PrecacheScreen.this.engine.loadtile(i);
                }
            }
        });
    }

    @Override
    public void draw(String title, int i) {
        if (Globals.kGameCrash) {
            this.app.show();
            return;
        }
        this.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, 3281, 0, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        if (Main.mUserFlag != Main.UserFlag.UserMap || Globals.boardfilename == null) {
            this.app.getFont(2).drawText(160, 90, Strhandler.toCharArray("Entering "), -128, 0, BuildFont.TextAlign.Center, 2, false);
            if (Globals.currentGame.episodes[Globals.ud.volume_number] != null && Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number] != null && Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number].title != null) {
                this.game.getFont(2).drawText(160, 114, Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number].title, -128, 0, BuildFont.TextAlign.Center, 2, false);
            }
        } else if (Globals.boardfilename != null) {
            this.app.getFont(2).drawText(160, 90, Strhandler.toCharArray("Entering usermap"), -128, 0, BuildFont.TextAlign.Center, 2, false);
            this.app.getFont(2).drawText(160, 114, Globals.boardfilename, -128, 0, BuildFont.TextAlign.Center, 2, false);
        }
        this.app.getFont(1).drawText(160, 146, title, -128, 10, BuildFont.TextAlign.Center, 2, false);
    }

    private void precachenecessarysounds() {
        for (int i = 0; i < 500; ++i) {
            if (Globals.Sound[i].ptr != null) continue;
            Premap.getsound(i);
        }
    }

    private void cachespritenum(int i) {
        int j;
        if (Globals.ud.monsters_off && Actors.badguy(Engine.sprite[i])) {
            return;
        }
        int maxc = 1;
        switch (Engine.sprite[i].picnum) {
            case 981: {
                this.addTile(950);
                for (j = 921; j < 925; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 569: {
                this.addTile(615);
                for (j = 921; j < 925; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 571: {
                this.addTile(573);
                for (j = 921; j < 925; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 1062: {
                maxc = 2;
                break;
            }
            case 921: {
                maxc = 4;
                break;
            }
            case 1280: {
                maxc = 44;
                break;
            }
            case 1680: 
            case 1681: 
            case 1715: 
            case 1725: 
            case 1741: 
            case 1744: {
                for (j = 1680; j < 1752; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                for (j = 1768; j < 1779; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 0;
                break;
            }
            case 904: {
                maxc = 5;
                for (j = 1026; j < 1030; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 4610: 
            case 4611: {
                maxc = 90;
                break;
            }
            case 2630: 
            case 2710: 
            case 2760: {
                maxc = 30;
                break;
            }
            case 1820: 
            case 1821: 
            case 1920: 
            case 1921: {
                maxc = 38;
                break;
            }
            case 1960: {
                maxc = 13;
                break;
            }
            case 2000: 
            case 2045: {
                maxc = 61;
                break;
            }
            case 1550: {
                maxc = 30;
                break;
            }
            case 2120: 
            case 2150: 
            case 2160: 
            case 2165: {
                for (j = 2201; j < 2212; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                maxc = 80;
                break;
            }
            case 1405: {
                maxc = 0;
                if (Globals.ud.multimode <= 1) break;
                maxc = 5;
                for (j = 1420; j < 1526; j = (int)((short)(j + 1))) {
                    this.addTile(j);
                }
                break;
            }
            case 100: {
                maxc = 14;
                break;
            }
            case 1880: {
                maxc = 10;
                break;
            }
            case 1079: 
            case 1238: 
            case 1247: {
                maxc = 3;
                break;
            }
            case 621: 
            case 1227: {
                maxc = 5;
            }
        }
        for (j = (int)Engine.sprite[i].picnum; j < Engine.sprite[i].picnum + maxc; j = (int)((short)(j + 1))) {
            this.addTile(j);
        }
    }

    private void cachegoodsprites() {
        int i;
        if (Globals.ud.screen_size >= 2) {
            this.addTile(2462);
            if (Globals.ud.multimode > 1) {
                this.addTile(2465);
                for (i = 3072; i < 3135; i = (int)((short)(i + 1))) {
                    this.addTile(i);
                }
            }
        }
        this.addTile(502);
        for (i = 2822; i < 2916; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 550; i < 553; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2940; i < 3022; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2270; i < 2284; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2310; i < 2324; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2324; i < 2328; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2524; i < 2527; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 1890; i < 1911; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(952);
        for (i = 2528; i < 2536; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        this.addTile(550);
        for (i = 2245; i < 2270; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2400; i < 2419; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
        for (i = 2329; i < 2333; i = (int)((short)(i + 1))) {
            this.addTile(i);
        }
    }
}

