/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.io.File;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Audio.SoundData;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Audio.SourceCallback;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.SoundDefs;
import ru.m210projects.Duke3D.Types.Sample;
import ru.m210projects.Duke3D.Types.SoundOwner;
import ru.m210projects.Duke3D.Types.VOC;

public class Sounds {
    public static final int LOUDESTVOLUME = 150;
    public static final int NUM_SOUNDS = 500;
    public static int backflag;
    public static int numenvsnds;
    public static FileEntry userMusic;
    public static MusicSource currMusic;
    public static String currSong;
    private static final SourceCallback<Integer> callback;
    private static float lastMusicVolume;
    private static final int[][] PitchTable;
    private static final int MAXDETUNE = 25;
    public static DirectoryEntry pDukeLegacyDir;
    public static Commentary pCommentary;
    private static final SourceCallback<Integer> pCommentaryCallback;

    public static void check_fta_sounds(int i) {
        if (Engine.sprite[i].extra > 0) {
            switch (Engine.sprite[i].picnum) {
                case 1680: 
                case 1681: 
                case 1715: 
                case 1725: 
                case 1741: 
                case 1742: 
                case 1744: {
                    Sounds.spritesound(111, i);
                    break;
                }
                case 2120: 
                case 2150: 
                case 2160: 
                case 2165: {
                    Sounds.spritesound(117, i);
                    break;
                }
                case 2000: 
                case 2045: {
                    Sounds.spritesound(121, i);
                    break;
                }
                case 1960: {
                    Sounds.spritesound(126, i);
                    break;
                }
                case 1880: {
                    Sounds.spritesound(131, i);
                    break;
                }
                case 1920: 
                case 1921: {
                    Sounds.spritesound(136, i);
                    break;
                }
                case 2420: {
                    Sounds.spritesound(146, i);
                    break;
                }
                case 1820: 
                case 1821: {
                    Sounds.spritesound(141, i);
                    break;
                }
                case 2630: {
                    Sounds.sound(97);
                    break;
                }
                case 2710: {
                    if (Engine.sprite[i].pal == 1) {
                        Sounds.sound(102);
                        break;
                    }
                    Sounds.sound(294);
                    break;
                }
                case 2760: {
                    if (Engine.sprite[i].pal == 1) {
                        Sounds.sound(151);
                        break;
                    }
                    Sounds.sound(284);
                    break;
                }
                case 4740: 
                case 4741: {
                    if (Engine.sprite[i].pal == 1) {
                        Sounds.sound(342);
                    }
                    Sounds.sound(371);
                    break;
                }
                case 2370: {
                    Sounds.spritesound(26, i);
                }
            }
        }
    }

    public static boolean midRestart() {
        Sounds.sndStopMusic();
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Music) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            Sounds.StopAllSounds();
        } else if (!Main.cfg.muteMusic && currMusic != null) {
            currMusic.resume();
        }
    }

    public static void sndStopMusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currMusic = null;
        currSong = null;
    }

    public static FileEntry sndCheckMusic(FileEntry map) {
        if (map != null) {
            String musName = map.getName().substring(0, map.getName().indexOf(map.getExtension()) - 1) + ".ogg";
            userMusic = map.getParent().checkFile(musName);
        }
        return userMusic;
    }

    public static void sndPlayMusic(String name) {
        String himus;
        lastMusicVolume = Sounds.calcMusicVolume();
        BuildGdx.audio.setVolume(BuildAudio.Driver.Music, lastMusicVolume);
        if (Main.cfg.musicType != 0 && userMusic != null) {
            if (currMusic != null && currMusic.isPlaying() && currSong == userMusic.getPath()) {
                return;
            }
            Sounds.sndStopMusic();
            currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, userMusic.getPath());
            if (currMusic != null) {
                currSong = userMusic.getPath();
                currMusic.play(true);
                return;
            }
        }
        if (Main.cfg.musicType == 1 && Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo(name)) != null) {
            if (currMusic != null && currMusic.isPlaying() && currSong == himus) {
                return;
            }
            Sounds.sndStopMusic();
            currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, himus);
            if (currMusic != null) {
                currSong = himus;
                currMusic.play(true);
                return;
            }
        }
        Sounds.playmusic(name);
    }

    public static void playmusic(String fn) {
        byte[] pRaw;
        if (fn == null) {
            return;
        }
        if (currMusic != null && currMusic.isPlaying() && currSong == fn) {
            return;
        }
        boolean isOGG = FileUtils.getExtension(fn).equalsIgnoreCase("ogg");
        if (isOGG) {
            boolean midExist = false;
            String path = fn;
            if (Main.cfg.musicType == 0 && BuildGdx.cache.contains(path = FileUtils.getNameWithoutExtension(fn) + ".mid", 0)) {
                fn = path;
                midExist = true;
            }
            if (Main.cfg.musicType != 0 || !midExist) {
                Sounds.sndStopMusic();
                if (Globals.currentGame.getCON().type == 20) {
                    path = FileUtils.getCorrectPath("music/" + fn);
                }
                if ((currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, path)) != null) {
                    currSong = fn;
                    currMusic.play(true);
                    return;
                }
            }
        }
        if ((pRaw = BuildGdx.cache.getBytes(fn, 0)) == null || pRaw.length <= 0) {
            return;
        }
        Sounds.sndStopMusic();
        currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Midi, pRaw);
        if (currMusic != null) {
            currMusic.play(true);
            currSong = fn;
        }
    }

    public static boolean sndRestart(int nvoices, int resampler) {
        BuildGdx.audio.getSound().stopAllSounds();
        BuildGdx.audio.getSound().uninit();
        Main.cfg.maxvoices = nvoices;
        Console.Println("Sound restarting...");
        if (!BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, nvoices, resampler)) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        return true;
    }

    public static void SoundStartup() {
        pDukeLegacyDir = BuildGdx.compat.checkDirectory("sound" + File.separator + "Legacy_DukeTalk_OGG");
        for (int i = 0; i < 500; ++i) {
            Globals.Sound[i] = new Sample();
            for (int j = 0; j < 4; ++j) {
                Globals.SoundOwner[i][j] = new SoundOwner();
            }
        }
        if (BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, Main.cfg.maxvoices, Main.cfg.resampler_num)) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        } else {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
        }
    }

    public static void MusicStartup() {
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Music) + " initialization failed", Console.OSDTEXT_RED);
        }
        lastMusicVolume = Sounds.calcMusicVolume();
        BuildGdx.audio.setVolume(BuildAudio.Driver.Music, lastMusicVolume);
    }

    public static float calcMusicVolume() {
        float vol = Main.cfg.musicVolume;
        if (Main.cfg.muteMusic) {
            vol = 0.0f;
        }
        if (pCommentary != null && Sounds.pCommentary.handle != null && Sounds.pCommentary.handle.isActive()) {
            vol /= 4.0f;
        }
        return vol;
    }

    public static void MusicUpdate() {
        float vol = Sounds.calcMusicVolume();
        if (vol != lastMusicVolume) {
            lastMusicVolume = vol;
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, lastMusicVolume);
        }
    }

    public static int loadsound(int num) {
        FileEntry fil;
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return 0;
        }
        if (num < 0 || num >= 500 || Main.cfg.noSound) {
            return 0;
        }
        Resource fp = null;
        String filename = Globals.currentGame.getCON().sounds[num];
        if (Main.cfg.bLegacyDukeTalk && pDukeLegacyDir != null && (Globals.currentGame.getCON().soundm[num] & 4) != 0 && (fil = BuildGdx.compat.checkFile(filename)) != null) {
            filename = pDukeLegacyDir.getRelativePath() + File.separator + fil.getName();
        }
        if (filename != null) {
            fp = BuildGdx.cache.open(filename, Globals.loadfromgrouponly);
        }
        if (fp == null) {
            Console.Println("Sound (" + num + ") not found.");
            return 0;
        }
        Globals.soundsiz[num] = fp.size();
        Globals.Sound[num].lock = 2;
        byte[] tmp = fp.getBytes();
        Sounds.loadSample(tmp, num);
        fp.close();
        return 1;
    }

    public static Source xyzsound(int num, int i, int x, int y, int z) {
        Source voice;
        int pitchs;
        short pitche;
        if (num < 0 || num >= 500 || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || (Globals.currentGame.getCON().soundm[num] & 8) != 0 && Globals.ud.lockout != 0 || Main.cfg.noSound || Globals.Sound[num].num > 3 || !BuildGdx.audio.getSound().isAvailable(Globals.currentGame.getCON().soundpr[num]) || Globals.ps[Mmulti.myconnectindex].timebeforeexit > 0 && Globals.ps[Mmulti.myconnectindex].timebeforeexit <= 78 || Main.game.menu.gShowMenu) {
            return null;
        }
        if ((Globals.currentGame.getCON().soundm[num] & 0x80) != 0) {
            Sounds.sound(num);
            return null;
        }
        if ((Globals.currentGame.getCON().soundm[num] & 4) != 0) {
            if (!Main.cfg.VoiceToggle || Globals.ud.multimode > 1 && Engine.sprite[i].picnum == 1405 && Engine.sprite[i].yvel != Globals.screenpeek && Globals.ud.coop != 1) {
                return null;
            }
            for (int j = 0; j < 500; ++j) {
                for (int k = 0; k < Globals.Sound[j].num; ++k) {
                    if (Globals.Sound[j].num <= 0 || (Globals.currentGame.getCON().soundm[j] & 4) == 0) continue;
                    return null;
                }
            }
        }
        int cx = Globals.ps[Globals.screenpeek].oposx;
        int cy = Globals.ps[Globals.screenpeek].oposy;
        int cz = Globals.ps[Globals.screenpeek].oposz;
        short cs = Globals.ps[Globals.screenpeek].cursectnum;
        int sndist = Gameutils.FindDistance3D(cx - x, cy - y, cz - z >> 4);
        if (i >= 0 && ru.m210projects.Build.Gameutils.isValidSector(Engine.sprite[i].sectnum) && (Globals.currentGame.getCON().soundm[num] & 0x10) == 0 && Engine.sprite[i].picnum == 5 && Engine.sprite[i].lotag < 999 && Engine.sector[Engine.sprite[i].sectnum].lotag < 9) {
            sndist = Pragmas.divscale(sndist, Engine.sprite[i].hitag + 1, 14);
        }
        int pitch = (cx = Pragmas.klabs((pitche = Globals.currentGame.getCON().soundpe[num]) - (pitchs = Globals.currentGame.getCON().soundps[num]))) != 0 ? (pitchs < pitche ? pitchs + Main.engine.rand() % cx : pitche + Main.engine.rand() % cx) : pitchs;
        if ((sndist += Globals.currentGame.getCON().soundvo[num]) < 0) {
            sndist = 0;
        }
        if (sndist != 0 && Engine.sprite[i].picnum != 5 && !Main.engine.cansee(cx, cy, cz - 6144, cs, Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z - 6144, Engine.sprite[i].sectnum)) {
            sndist += sndist >> 2;
        }
        switch (num) {
            case 9: 
            case 14: 
            case 17: {
                if (sndist > 6144) {
                    sndist = 6144;
                }
                if (!ru.m210projects.Build.Gameutils.isValidSector(cs) || Engine.sector[cs].lotag != 2) break;
                pitch -= 1024;
                break;
            }
            default: {
                if (ru.m210projects.Build.Gameutils.isValidSector(cs) && Engine.sector[cs].lotag == 2 && (Globals.currentGame.getCON().soundm[num] & 4) == 0) {
                    pitch = -768;
                }
                if (sndist <= 31444 || Engine.sprite[i].picnum == 5) break;
                return null;
            }
        }
        if (Globals.Sound[num].num > 0 && Engine.sprite[i].picnum != 5) {
            if (Globals.SoundOwner[num][0].i == i) {
                Sounds.stopsound(num);
            } else if (Globals.Sound[num].num > 1) {
                Sounds.stopsound(num);
            } else if (Actors.badguy(Engine.sprite[i]) && Engine.sprite[i].extra <= 0) {
                Sounds.stopsound(num);
            }
        }
        if (Engine.sprite[i].picnum == 1405 && Engine.sprite[i].yvel == Globals.screenpeek) {
            sndist = 0;
        }
        if (Globals.Sound[num].ptr == null) {
            if (Sounds.loadsound(num) == 0) {
                return null;
            }
        } else {
            Globals.Sound[num].lock = Globals.Sound[num].lock < 200 ? 200 : ++Globals.Sound[num].lock;
            Globals.Sound[num].ptr.rewind();
        }
        if ((Globals.currentGame.getCON().soundm[num] & 0x10) != 0) {
            sndist = 0;
        }
        if (sndist < 6720) {
            sndist = 6720;
        }
        if ((Globals.currentGame.getCON().soundm[num] & 1) != 0) {
            if (Globals.Sound[num].num > 0) {
                return null;
            }
            voice = BuildGdx.audio.newSound(Globals.Sound[num].ptr, Pragmas.mulscale(Globals.Sound[num].rate, Sounds.PITCH_GetScale(pitch), 16), Globals.Sound[num].bits, Globals.currentGame.getCON().soundpr[num]);
            if (voice != null) {
                voice.setLooping(true, 0, -1);
            }
        } else {
            voice = BuildGdx.audio.newSound(Globals.Sound[num].ptr, Pragmas.mulscale(Globals.Sound[num].rate, Sounds.PITCH_GetScale(pitch), 16), Globals.Sound[num].bits, Globals.currentGame.getCON().soundpr[num]);
        }
        if (voice != null) {
            Globals.SoundOwner[num][Globals.Sound[num].num].i = i;
            Globals.SoundOwner[num][Globals.Sound[num].num].voice = voice;
            voice.setCallback(callback, num);
            voice.setPosition(x, z >> 4, y);
            voice.play(Sounds.calcVolume(sndist));
            ++Globals.Sound[num].num;
        } else {
            --Globals.Sound[num].lock;
        }
        return voice;
    }

    public static Source sound(int num) {
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return null;
        }
        if (Main.cfg.noSound) {
            return null;
        }
        if (num < 0 || num >= 500) {
            return null;
        }
        if (!Main.cfg.VoiceToggle && (Globals.currentGame.getCON().soundm[num] & 4) != 0) {
            return null;
        }
        if ((Globals.currentGame.getCON().soundm[num] & 8) != 0 && Globals.ud.lockout != 0) {
            return null;
        }
        if (!BuildGdx.audio.getSound().isAvailable(Globals.currentGame.getCON().soundpr[num])) {
            return null;
        }
        short pitche = Globals.currentGame.getCON().soundpe[num];
        int pitchs = Globals.currentGame.getCON().soundps[num];
        int cx = Pragmas.klabs(pitche - pitchs);
        int pitch = cx != 0 ? (pitchs < pitche ? pitchs + Main.engine.rand() % cx : pitche + Main.engine.rand() % cx) : pitchs;
        if (Globals.Sound[num].ptr == null) {
            if (Sounds.loadsound(num) == 0) {
                return null;
            }
        } else {
            Globals.Sound[num].lock = Globals.Sound[num].lock < 200 ? 200 : ++Globals.Sound[num].lock;
            Globals.Sound[num].ptr.rewind();
        }
        if ((Globals.currentGame.getCON().soundm[num] & 1) != 0) {
            Source voice = BuildGdx.audio.newSound(Globals.Sound[num].ptr, Pragmas.mulscale(Globals.Sound[num].rate, Sounds.PITCH_GetScale(pitch), 16), Globals.Sound[num].bits, Globals.currentGame.getCON().soundpr[num]);
            if (voice != null) {
                voice.setLooping(true, 0, -1);
                voice.setGlobal(1);
                voice.setCallback(callback, num);
                voice.play(Sounds.calcVolume(150));
                return voice;
            }
        } else {
            Source voice = BuildGdx.audio.newSound(Globals.Sound[num].ptr, Pragmas.mulscale(Globals.Sound[num].rate, Sounds.PITCH_GetScale(pitch), 16), Globals.Sound[num].bits, Globals.currentGame.getCON().soundpr[num]);
            if (voice != null) {
                voice.setGlobal(1);
                voice.setCallback(callback, num);
                voice.play(Sounds.calcVolume(105));
                return voice;
            }
        }
        --Globals.Sound[num].lock;
        return null;
    }

    public static void loadSample(byte[] data, int num) {
        if (data[0] == 67) {
            VOC voc = new VOC(data);
            Globals.Sound[num].bits = voc.samplesize;
            Globals.Sound[num].rate = voc.samplerate;
            Globals.Sound[num].ptr = voc.sampledata;
        } else {
            SoundData snd = BuildGdx.audio.decodeSound(data);
            if (snd != null) {
                Globals.Sound[num].bits = snd.bits;
                Globals.Sound[num].rate = snd.rate;
                Globals.Sound[num].ptr = snd.data;
                return;
            }
            Console.Println("Can't load sound[" + num + "]", Console.OSDTEXT_RED);
            Globals.Sound[num].ptr = ByteBuffer.allocateDirect(0);
            Globals.Sound[num].rate = 0;
            Globals.Sound[num].bits = 8;
        }
    }

    public static Source spritesound(int num, int i) {
        if (num < 0 || num >= 500) {
            return null;
        }
        return Sounds.xyzsound(num, i, Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z);
    }

    public static void stopsound(int num) {
        if (num < 0 || num >= 500) {
            return;
        }
        if (Globals.Sound[num].num > 0) {
            Globals.SoundOwner[num][Globals.Sound[num].num - 1].voice.dispose();
        }
    }

    public static void stopsound(int num, int i) {
        if (num < 0 || num >= 500) {
            return;
        }
        if (Globals.Sound[num].num > 0 && (i == -1 || i == Globals.SoundOwner[num][Globals.Sound[num].num - 1].i)) {
            Globals.SoundOwner[num][Globals.Sound[num].num - 1].voice.dispose();
        }
    }

    public static void StopAllSounds() {
        for (int i = 0; i < 500; ++i) {
            Sounds.stopsound(i);
        }
        Sounds.StopCommentary(pCommentary);
        BuildGdx.audio.getSound().stopAllSounds();
    }

    public static void stopenvsound(int num, int i) {
        if (num < 0 || num >= 500) {
            return;
        }
        if (Globals.Sound[num].num > 0) {
            int k = Globals.Sound[num].num;
            for (int j = 0; j < k; ++j) {
                if (Globals.SoundOwner[num][j].i != i) continue;
                Globals.SoundOwner[num][j].voice.dispose();
                break;
            }
        }
    }

    public static void pan3dsound() {
        short ca;
        short cs;
        int cz;
        int cy;
        int cx;
        numenvsnds = 0;
        if (Globals.ud.camerasprite == -1) {
            cx = Globals.ps[Globals.screenpeek].oposx;
            cy = Globals.ps[Globals.screenpeek].oposy;
            cz = Globals.ps[Globals.screenpeek].oposz;
            cs = Globals.ps[Globals.screenpeek].cursectnum;
            ca = (short)(Globals.ps[Globals.screenpeek].ang + (float)Globals.ps[Globals.screenpeek].look_ang);
        } else {
            cx = Engine.sprite[Globals.ud.camerasprite].x;
            cy = Engine.sprite[Globals.ud.camerasprite].y;
            cz = Engine.sprite[Globals.ud.camerasprite].z;
            cs = Engine.sprite[Globals.ud.camerasprite].sectnum;
            ca = Engine.sprite[Globals.ud.camerasprite].ang;
        }
        BuildGdx.audio.getSound().setListener(cx, cz >> 4, cy, ca);
        for (int j = 0; j < 500; ++j) {
            block4: for (int k = 0; k < Globals.Sound[j].num; ++k) {
                int sndist;
                int i = Globals.SoundOwner[j][k].i;
                int sx = Engine.sprite[i].x;
                int sy = Engine.sprite[i].y;
                int sz = Engine.sprite[i].z;
                if (Globals.SoundOwner[j][k].voice.isGlobal() || Engine.sprite[i].picnum == 1405 && Engine.sprite[i].yvel == Globals.screenpeek) {
                    sndist = 0;
                } else {
                    sndist = Gameutils.FindDistance3D(cx - sx, cy - sy, cz - sz >> 4);
                    if (Engine.sprite[i].sectnum >= 0 && Engine.sprite[i].sectnum < Engine.MAXSECTORS && i >= 0 && (Globals.currentGame.getCON().soundm[j] & 0x10) == 0 && Engine.sprite[i].picnum == 5 && Engine.sprite[i].lotag < 999 && (Engine.sector[Engine.sprite[i].sectnum].lotag & 0xFF) < 9) {
                        sndist = Pragmas.divscale(sndist, Engine.sprite[i].hitag + 1, 14);
                    }
                }
                if ((sndist += Globals.currentGame.getCON().soundvo[j]) < 0) {
                    sndist = 0;
                }
                if (sndist != 0 && Engine.sprite[i].picnum != 5 && !Main.engine.cansee(cx, cy, cz - 6144, cs, sx, sy, sz - 6144, Engine.sprite[i].sectnum)) {
                    sndist += sndist >> 5;
                }
                if (Engine.sprite[i].picnum == 5 && Engine.sprite[i].lotag < 999) {
                    ++numenvsnds;
                }
                switch (j) {
                    case 9: 
                    case 14: 
                    case 17: {
                        if (sndist <= 6144) break;
                        sndist = 6144;
                        break;
                    }
                    default: {
                        if (sndist <= 31444 || Engine.sprite[i].picnum == 5) break;
                        Sounds.stopsound(j);
                        continue block4;
                    }
                }
                if (Globals.Sound[j].ptr == null && Sounds.loadsound(j) == 0) continue;
                if ((Globals.currentGame.getCON().soundm[j] & 0x10) != 0) {
                    sndist = 0;
                }
                if (sndist < 6720) {
                    sndist = 6720;
                }
                Globals.SoundOwner[j][k].voice.setPosition(sx, sz >> 4, sy);
                Globals.SoundOwner[j][k].voice.setVolume(Sounds.calcVolume(sndist));
            }
        }
    }

    private static float calcVolume(int dist) {
        float vol = (float)(dist >> 6) / 255.0f;
        vol = Math.min(Math.max(vol, 0.0f), 1.0f);
        if (!Main.game.menu.gShowMenu && pCommentary != null && Sounds.pCommentary.handle != null && Sounds.pCommentary.handle.isActive()) {
            vol = 0.93f;
        }
        return 1.0f - vol;
    }

    public static void clearsoundlocks() {
        for (int i = 0; i < 500; ++i) {
            if (Globals.Sound[i].lock < 200) continue;
            Globals.Sound[i].lock = 199;
        }
    }

    private static int PITCH_GetScale(int pitchoffset) {
        if (pitchoffset == 0) {
            return PitchTable[0][0];
        }
        int noteshift = pitchoffset % 1200;
        if (noteshift < 0) {
            noteshift += 1200;
        }
        int note = noteshift / 100;
        int detune = noteshift % 100 / 4;
        int octaveshift = (pitchoffset - noteshift) / 1200;
        if (detune < 0) {
            detune += 4;
            if (--note < 0) {
                note += 12;
                --octaveshift;
            }
        }
        int scale = PitchTable[note][detune];
        scale = octaveshift < 0 ? (scale >>= -octaveshift) : (scale <<= octaveshift);
        return scale;
    }

    public static boolean StartCommentary(int num, int spr) {
        SoundData snd;
        if (pCommentary != null && Main.cfg.bDevCommentry && (snd = Sounds.LoadCommentary(num)) != null) {
            Sounds.StopCommentary(pCommentary);
            Source voice = BuildGdx.audio.newSound(snd.data, snd.rate, snd.bits, Integer.MAX_VALUE);
            if (voice != null) {
                for (int i = 0; i < 500; ++i) {
                    if (Globals.Sound[i].num <= 0) continue;
                    Globals.SoundOwner[i][Globals.Sound[i].num - 1].voice.setVolume(0.07f);
                }
                voice.setGlobal(1);
                voice.play(Main.cfg.soundVolume);
                voice.setCallback(pCommentaryCallback, num);
                Sounds.pCommentary.handle = voice;
                Sounds.pCommentary.spr = spr;
                Sounds.pCommentary.picnum = Engine.sprite[spr].picnum;
                return true;
            }
        }
        return false;
    }

    public static void StopCommentary(Commentary commentary) {
        if (commentary != null && commentary.handle != null) {
            Engine.sprite[commentary.spr].picnum = commentary.picnum;
            commentary.handle.dispose();
            commentary.handle = null;
            commentary.spr = -1;
        }
    }

    public static void CommentaryVolume(Commentary commentary, float volume) {
        if (commentary != null && commentary.handle != null) {
            commentary.handle.setVolume(volume);
        }
    }

    public static SoundData LoadCommentary(int num) {
        if (SoundDefs.commentaries == null || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || Main.cfg.noSound) {
            return null;
        }
        FileResource fp = BuildGdx.compat.open(SoundDefs.commentaries.get(num));
        if (fp == null) {
            Console.Println("Commentary (" + num + ") not found.");
            return null;
        }
        SoundData snd = BuildGdx.audio.decodeSound(fp.getBytes());
        fp.close();
        return snd;
    }

    static {
        callback = new SourceCallback<Integer>(){

            @Override
            public void run(Integer num) {
                if (num < 0) {
                    return;
                }
                int tempk = Globals.Sound[num.intValue()].num;
                if (tempk > 0) {
                    if ((Globals.currentGame.getCON().soundm[num] & 0x10) == 0) {
                        for (int tempj = 0; tempj < tempk; ++tempj) {
                            int tempi = Globals.SoundOwner[num.intValue()][tempj].i;
                            if (Engine.sprite[tempi].picnum != 5 || !ru.m210projects.Build.Gameutils.isValidSector(Engine.sprite[tempi].sectnum) || Engine.sector[Engine.sprite[tempi].sectnum].lotag >= 3 || Engine.sprite[tempi].lotag >= 999) continue;
                            Globals.hittype[tempi].temp_data[0] = 0;
                            if (tempj + 1 >= tempk) break;
                            Globals.SoundOwner[num.intValue()][tempj].voice = Globals.SoundOwner[num.intValue()][tempk - 1].voice;
                            Globals.SoundOwner[num.intValue()][tempj].i = Globals.SoundOwner[num.intValue()][tempk - 1].i;
                            break;
                        }
                    }
                    --Globals.Sound[num.intValue()].num;
                    Globals.SoundOwner[num.intValue()][tempk - 1].i = -1;
                }
                --Globals.Sound[num.intValue()].lock;
            }
        };
        lastMusicVolume = 0.0f;
        PitchTable = new int[][]{{65536, 65687, 65839, 65991, 66144, 66297, 66450, 66604, 66758, 66913, 67067, 67222, 67378, 67534, 67690, 67847, 68004, 68161, 68319, 68477, 68635, 68794, 68953, 69112, 69272}, {69432, 69593, 69754, 69915, 70077, 70239, 70402, 70565, 70728, 70891, 71055, 71220, 71384, 71550, 71715, 71881, 72047, 72214, 72381, 72548, 72716, 72884, 73053, 73222, 73391}, {73561, 73731, 73902, 74073, 74244, 74416, 74588, 74761, 74934, 75107, 75281, 75455, 75629, 75804, 75980, 76155, 76331, 76508, 76685, 76862, 77040, 77218, 77397, 77576, 77756}, {77935, 78116, 78296, 78477, 78659, 78841, 79023, 79206, 79389, 79573, 79757, 79942, 80126, 80312, 80498, 80684, 80870, 81057, 81245, 81433, 81621, 81810, 81999, 82189, 82379}, {82570, 82761, 82952, 83144, 83336, 83529, 83722, 83916, 84110, 84305, 84500, 84695, 84891, 85087, 85284, 85482, 85679, 85877, 86076, 86275, 86475, 86675, 86875, 87076, 87278}, {87480, 87682, 87885, 88088, 88292, 88496, 88701, 88906, 89112, 89318, 89524, 89731, 89939, 90147, 90356, 90565, 90774, 90984, 91194, 91405, 91617, 91829, 92041, 92254, 92468}, {92681, 92896, 93111, 93326, 93542, 93758, 93975, 94193, 94410, 94629, 94848, 95067, 95287, 95507, 95728, 95950, 96172, 96394, 96617, 96841, 97065, 97289, 97514, 97740, 97966}, {98193, 98420, 98647, 98876, 99104, 99334, 99563, 99794, 100024, 100256, 100488, 100720, 100953, 101187, 101421, 101655, 101890, 102126, 102362, 102599, 102837, 103074, 103313, 103552, 103791}, {104031, 104272, 104513, 104755, 104997, 105240, 105484, 105728, 105972, 106217, 106463, 106709, 106956, 107204, 107452, 107700, 107949, 108199, 108449, 108700, 108952, 109204, 109456, 109709, 109963}, {110217, 110472, 110728, 110984, 111241, 111498, 111756, 112015, 112274, 112533, 112794, 113055, 113316, 113578, 113841, 114104, 114368, 114633, 114898, 115164, 115430, 115697, 115965, 116233, 116502}, {116771, 117041, 117312, 117584, 117856, 118128, 118401, 118675, 118950, 119225, 119501, 119777, 120054, 120332, 120610, 120889, 121169, 121449, 121730, 122012, 122294, 122577, 122860, 123145, 123429}, {123715, 124001, 124288, 124576, 124864, 125152, 125442, 125732, 126023, 126315, 126607, 126900, 127193, 127487, 127782, 128078, 128374, 128671, 128969, 129267, 129566, 129866, 130166, 130467, 130769}};
        pCommentaryCallback = new SourceCallback<Integer>(){

            @Override
            public void run(Integer num) {
                Sounds.StopCommentary(pCommentary);
            }
        };
    }

    public static class Commentary {
        public Source handle;
        public int spr;
        public short picnum;
    }
}

