/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Types.ANIMATION;
import ru.m210projects.Duke3D.Types.Animwalltype;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.PlayerOrig;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.Types.Weaponhit;

public class SafeLoader {
    public String boardfilename;
    public GameInfo addon;
    public String addonFileName;
    public byte warp_on;
    private String message;
    public int gAnimationCount = 0;
    public ANIMATION[] gAnimationData = new ANIMATION[512];
    public short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public short[] connectpoint2 = new short[16];
    public int randomseed;
    public int visibility;
    public byte automapping;
    public byte[] show2dsector = new byte[Engine.MAXSECTORS + 7 >> 3];
    public short numsectors;
    public short numwalls;
    public short[] headspritesect;
    public short[] headspritestat;
    public short[] prevspritesect;
    public short[] prevspritestat;
    public short[] nextspritesect;
    public short[] nextspritestat;
    public SECTOR[] sector = new SECTOR[Engine.MAXSECTORS];
    public WALL[] wall = new WALL[Engine.MAXWALLS];
    public SPRITE[] sprite = new SPRITE[Engine.MAXSPRITES];
    public PlayerStruct[] ps = new PlayerStruct[16];
    public PlayerOrig[] po = new PlayerOrig[16];
    public Weaponhit[] hittype = new Weaponhit[Engine.MAXSPRITES];
    public int multimode;
    public int volume_number;
    public int level_number;
    public int player_skill;
    public int from_bonus;
    public int secretlevel;
    public boolean respawn_monsters;
    public boolean respawn_items;
    public boolean respawn_inventory;
    public boolean god;
    public boolean monsters_off;
    public int auto_run;
    public int crosshair;
    public int last_level;
    public int eog;
    public int coop;
    public int marker;
    public int ffire;
    public short numplayersprites;
    public short global_random;
    public short earthquaketime;
    public short camsprite;
    public short[][] frags = new short[16][16];
    public int[] msx = new int[2048];
    public int[] msy = new int[2048];
    public Animwalltype[] animwall = new Animwalltype[512];
    public short[][] cyclers = new short[256][6];
    public short numcyclers;
    public short numanimwalls;
    public short[] spriteq = new short[1024];
    public short spriteqloc;
    public short spriteqamount;
    public short[] mirrorwall = new short[64];
    public short[] mirrorsector = new short[64];
    public short mirrorcnt;
    public short numclouds;
    public short[] clouds = new short[128];
    public short[] cloudx = new short[128];
    public short[] cloudy = new short[128];
    public int[] actorscrptr = new int[Engine.MAXTILES];
    public short[] actortype = new short[Engine.MAXTILES];
    public int[] script = new int[20460];

    public SafeLoader() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.ps[i] = new PlayerStruct();
            this.po[i] = new PlayerOrig();
        }
        for (i = 0; i < 512; ++i) {
            this.animwall[i] = new Animwalltype();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.hittype[i] = new Weaponhit();
        }
        this.headspritesect = new short[Engine.MAXSECTORS + 1];
        this.headspritestat = new short[1025];
        this.prevspritesect = new short[Engine.MAXSPRITES];
        this.prevspritestat = new short[Engine.MAXSPRITES];
        this.nextspritesect = new short[Engine.MAXSPRITES];
        this.nextspritestat = new short[Engine.MAXSPRITES];
        for (i = 0; i < 512; ++i) {
            this.gAnimationData[i] = new ANIMATION();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.sprite[i] = new SPRITE();
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            this.sector[i] = new SECTOR();
        }
        for (i = 0; i < Engine.MAXWALLS; ++i) {
            this.wall[i] = new WALL();
        }
    }

    public GameInfo LoadGDXHeader(Resource fil) {
        this.volume_number = -1;
        this.level_number = -1;
        this.player_skill = -1;
        this.warp_on = 0;
        this.addon = null;
        this.addonFileName = null;
        try {
            fil.seek(LoadSave.SAVEHEADER - 16, Resource.Whence.Set);
            this.multimode = fil.readInt();
            this.volume_number = fil.readInt();
            this.level_number = fil.readInt();
            this.player_skill = fil.readInt();
            fil.seek(LoadSave.SAVEHEADER + 16000, Resource.Whence.Set);
            this.LoadGDXBlock(fil);
            if (this.warp_on == 1) {
                this.addon = ResourceHandler.levelGetEpisode(this.addonFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addon;
    }

    public void LoadGDXBlock(Resource bb) {
        int pos = bb.position();
        this.warp_on = bb.readByte();
        if (this.warp_on == 1) {
            this.addonFileName = Strhandler.toLowerCase(bb.readString(144).trim());
        }
        bb.seek(pos + 16128, Resource.Whence.Set);
    }

    public void MapLoad(Resource bb) {
        int i;
        this.boardfilename = null;
        String name = bb.readString(144).trim();
        if (!name.isEmpty()) {
            this.boardfilename = name;
        }
        this.numwalls = bb.readShort();
        for (int w = 0; w < this.numwalls; ++w) {
            this.wall[w].buildWall(bb);
        }
        this.numsectors = bb.readShort();
        for (int s = 0; s < this.numsectors; ++s) {
            this.sector[s].buildSector(bb);
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.sprite[i].buildSprite(bb);
        }
        for (i = 0; i <= Engine.MAXSECTORS; ++i) {
            this.headspritesect[i] = bb.readShort();
        }
        for (i = 0; i <= 1024; ++i) {
            this.headspritestat[i] = bb.readShort();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.prevspritesect[i] = bb.readShort();
            this.prevspritestat[i] = bb.readShort();
            this.nextspritesect[i] = bb.readShort();
            this.nextspritestat[i] = bb.readShort();
        }
    }

    public void AnimationLoad(Resource bb) {
        for (int i = 0; i < 512; ++i) {
            short index = bb.readShort();
            byte type = bb.readByte();
            this.gAnimationData[i].id = index;
            this.gAnimationData[i].type = type;
            this.gAnimationData[i].ptr = null;
            this.gAnimationData[i].goal = bb.readInt();
            this.gAnimationData[i].vel = bb.readInt();
            this.gAnimationData[i].sect = bb.readShort().shortValue();
        }
        this.gAnimationCount = bb.readInt();
    }

    public void Stuff2Load(Resource bb) {
        int i;
        this.pskybits = bb.readShort();
        this.parallaxyscale = bb.readInt();
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = bb.readShort();
        }
        this.earthquaketime = bb.readShort();
        this.from_bonus = bb.readShort().shortValue();
        this.secretlevel = bb.readShort().shortValue();
        this.respawn_monsters = bb.readBoolean();
        this.respawn_items = bb.readBoolean();
        this.respawn_inventory = bb.readBoolean();
        this.god = bb.readBoolean();
        this.auto_run = bb.readInt() == 1 ? 1 : 0;
        this.crosshair = bb.readInt() == 1 ? 1 : 0;
        this.monsters_off = bb.readBoolean();
        this.last_level = bb.readInt();
        this.eog = bb.readInt();
        this.coop = bb.readInt();
        this.marker = bb.readInt();
        this.ffire = bb.readInt();
        this.camsprite = bb.readShort();
        this.connecthead = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.connectpoint2[i] = bb.readShort();
        }
        this.numplayersprites = bb.readShort();
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.frags[i][j] = bb.readShort();
            }
        }
        this.randomseed = bb.readInt();
        this.global_random = bb.readShort();
    }

    public void StuffLoad(Resource bb) {
        int i;
        this.numcyclers = bb.readShort();
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.cyclers[i][j] = bb.readShort();
            }
        }
        for (i = 0; i < 16; ++i) {
            this.ps[i].set(bb);
        }
        for (i = 0; i < 16; ++i) {
            this.po[i].set(bb);
        }
        this.numanimwalls = bb.readShort();
        for (i = 0; i < 512; ++i) {
            this.animwall[i].wallnum = bb.readShort();
            this.animwall[i].tag = bb.readInt();
        }
        for (i = 0; i < 2048; ++i) {
            this.msx[i] = bb.readInt();
        }
        for (i = 0; i < 2048; ++i) {
            this.msy[i] = bb.readInt();
        }
        this.spriteqloc = bb.readShort();
        this.spriteqamount = bb.readShort();
        for (i = 0; i < 1024; ++i) {
            this.spriteq[i] = bb.readShort();
        }
        this.mirrorcnt = bb.readShort();
        for (i = 0; i < 64; ++i) {
            this.mirrorwall[i] = bb.readShort();
        }
        for (i = 0; i < 64; ++i) {
            this.mirrorsector[i] = bb.readShort();
        }
        bb.read(this.show2dsector);
        this.numclouds = bb.readShort();
        for (i = 0; i < 128; ++i) {
            this.clouds[i] = bb.readShort();
        }
        for (i = 0; i < 128; ++i) {
            this.cloudx[i] = bb.readShort();
        }
        for (i = 0; i < 128; ++i) {
            this.cloudy[i] = bb.readShort();
        }
    }

    public void ConLoad(Resource bb) {
        int i;
        for (i = 0; i < Engine.MAXTILES; ++i) {
            this.actortype[i] = (short)(bb.readByte() & 0xFF);
        }
        for (i = 0; i < 20460; ++i) {
            this.script[i] = bb.readInt();
        }
        for (i = 0; i < Engine.MAXTILES; ++i) {
            this.actorscrptr[i] = bb.readInt();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.hittype[i].set(bb);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public boolean load(Resource bb) {
        this.addon = null;
        this.addonFileName = null;
        this.message = null;
        this.warp_on = 0;
        try {
            bb.seek(LoadSave.SAVEHEADER - 16, Resource.Whence.Set);
            this.multimode = bb.readInt();
            this.volume_number = bb.readInt();
            this.level_number = bb.readInt();
            this.player_skill = bb.readInt();
            bb.seek(LoadSave.SAVEHEADER + 16000, Resource.Whence.Set);
            this.LoadGDXBlock(bb);
            this.MapLoad(bb);
            this.StuffLoad(bb);
            this.ConLoad(bb);
            this.AnimationLoad(bb);
            this.Stuff2Load(bb);
            if (this.warp_on == 1) {
                this.addon = ResourceHandler.levelGetEpisode(this.addonFileName);
                if (this.addon == null) {
                    this.message = "Can't find user episode file: " + this.addonFileName;
                    this.warp_on = (byte)2;
                    this.volume_number = 0;
                    this.level_number = 7;
                }
            }
            if (bb.position() == bb.size()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

