/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.LSP.Animate;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Factory.LSPEngine;
import ru.m210projects.LSP.Factory.LSPFactory;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.LoadSave;
import ru.m210projects.LSP.Menus.AdvertisingMenu;
import ru.m210projects.LSP.Menus.GameMenu;
import ru.m210projects.LSP.Menus.LSPMenuAudio;
import ru.m210projects.LSP.Menus.LSPMenuLoad;
import ru.m210projects.LSP.Menus.LSPMenuSave;
import ru.m210projects.LSP.Menus.MainMenu;
import ru.m210projects.LSP.Menus.MenuCorruptGame;
import ru.m210projects.LSP.Menus.MenuLastLoad;
import ru.m210projects.LSP.Menus.MenuOptions;
import ru.m210projects.LSP.Menus.MenuQuit;
import ru.m210projects.LSP.Quotes;
import ru.m210projects.LSP.Screens.DemoScreen;
import ru.m210projects.LSP.Screens.GameScreen;
import ru.m210projects.LSP.Screens.IntroScreen;
import ru.m210projects.LSP.Screens.LoadingScreen;
import ru.m210projects.LSP.Screens.MenuScreen;
import ru.m210projects.LSP.Screens.MovieScreen;
import ru.m210projects.LSP.Screens.PrecacheScreen;
import ru.m210projects.LSP.Screens.StatisticScreen;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Types.LSPGroup;
import ru.m210projects.LSP.Types.PlayerStruct;
import ru.m210projects.LSP.Types.SwingDoor;

public class Main
extends BuildGame {
    public static final String appdef = "LSPGDX.def";
    public static Main game;
    public static LSPEngine engine;
    public static Config cfg;
    public LSPMenuHandler menu;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static MovieScreen gMovieScreen;
    public static IntroScreen gIntroScreen;
    public static MenuScreen gMenuScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static StatisticScreen gStatisticScreen;
    public static DemoScreen gDemoScreen;
    public static LSPGroup gMapGroup;
    public static LSPGroup gResGroup;
    public Runnable toMenu = new Runnable(){

        @Override
        public void run() {
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.size() == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };

    public Main(BuildConfig bcfg, String appname, String sversion, boolean isRelease) {
        super(bcfg, appname, sversion, isRelease);
        game = this;
        cfg = (Config)bcfg;
    }

    public Main(BuildConfig bcfg, String appname, String sversion) {
        this(bcfg, appname, sversion, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new LSPFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        int i;
        Console.Println("Initializing timer");
        engine.inittimer(120);
        this.ConsoleInit();
        Sounds.sndInit();
        for (i = 0; i < 16; ++i) {
            Globals.gPlayer[i] = new PlayerStruct();
        }
        for (i = 0; i < 32; ++i) {
            Globals.swingdoor[i] = new SwingDoor();
        }
        Animate.initanimations();
        Quotes.InitQuotes();
        Main.game.pNet.ResetTimers();
        Console.Println("Initializing def-scripts...");
        Gameutils.loadGdxDef(this.baseDef, appdef, "lspgdx.dat");
        if (this.pCfg.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    if (file.getExtension().equals("zip")) {
                        GroupResource def;
                        Group group = BuildGdx.cache.add(file.getPath());
                        if (group == null || (def = group.open(appdef)) == null) continue;
                        byte[] buf = def.getBytes();
                        this.baseDef.loadScript(file.getName(), buf);
                        def.close();
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        if ((filgdx = BuildGdx.compat.checkFile(appdef)) != null) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        LoadSave.FindSaves();
        this.menu.mMenus[3] = new LSPMenuLoad(this);
        this.menu.mMenus[4] = new LSPMenuSave(this);
        this.menu.mMenus[8] = new LSPMenuAudio(this);
        this.menu.mMenus[10] = new MenuOptions(this);
        this.menu.mMenus[6] = new MenuQuit(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[13] = new AdvertisingMenu();
        this.menu.mMenus[14] = new MenuLastLoad(this);
        this.menu.mMenus[15] = new MenuCorruptGame(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gMovieScreen = new MovieScreen(this);
        gIntroScreen = new IntroScreen(this);
        gMenuScreen = new MenuScreen(this);
        gPrecacheScreen = new PrecacheScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gDemoScreen = new DemoScreen(this);
        gDemoScreen.demoscan();
        System.gc();
        MemLog.log("create");
        return true;
    }

    private void ConsoleInit() {
        Console.Println("Initializing on-screen display system");
        Console.setParameters(0, 0, 0, 0, 0, 0);
        Console.setVersion(this.appname + " " + this.sversion, 10, Console.OSDTEXT_GOLD);
        Console.RegisterCvar(new OSDCOMMAND("noclip", "noclip", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    Globals.gPlayer[Mmulti.myconnectindex].noclip = !Globals.gPlayer[Mmulti.myconnectindex].noclip;
                    Console.Println("Noclip: " + (Globals.gPlayer[Mmulti.myconnectindex].noclip ? "ON" : "OFF"));
                } else {
                    Console.Println("noclip: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("god", "god", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    Globals.gPlayer[Mmulti.myconnectindex].nPlayerStatus = Globals.gPlayer[Mmulti.myconnectindex].nPlayerStatus != 5 ? (short)5 : (short)0;
                    Console.Println("God mode: " + (Globals.gPlayer[Mmulti.myconnectindex].nPlayerStatus == 5 ? "ON" : "OFF"));
                } else {
                    Console.Println("god: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("changemap", "changemap: map number", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    if (Console.osd_argc != 2) {
                        Console.Println("changemap: map number");
                        return;
                    }
                    try {
                        int num = Integer.parseInt(Console.osd_argv[1]);
                        gGameScreen.changemap(num);
                    }
                    catch (Exception e) {
                        Console.Println("type out of range");
                    }
                } else {
                    Console.Println("changemap: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("recordemo", "recordemo: map number", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("recordemo: map number");
                    return;
                }
                try {
                    int num = Integer.parseInt(Console.osd_argv[1]);
                    Globals.m_recstat = 1;
                    gGameScreen.newgame(num);
                }
                catch (Exception e) {
                    Console.Println("type out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("savemap", "savemap: map name", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    if (Console.osd_argc != 2) {
                        Console.Println("savemap: map name with .map");
                        return;
                    }
                    try {
                        String name = Console.osd_argv[1];
                        FileResource fil = BuildGdx.compat.open(name, Compat.Path.Game, FileResource.Mode.Write);
                        PlayerStruct pos = Globals.gPlayer[Mmulti.myconnectindex];
                        engine.saveboard(fil, pos.x, pos.y, pos.z, (int)pos.ang, pos.sectnum);
                        fil.close();
                        Console.Println("Map saved to file " + name);
                    }
                    catch (Exception e) {
                        Console.Println("type out of range");
                    }
                } else {
                    Console.Println("savemap: not in a game");
                }
            }
        }));
    }

    @Override
    public void show() {
        if (Globals.recstat == 1 && Globals.rec != null) {
            Globals.rec.close();
        }
        engine.setTilesPath(0);
        game.changeScreen(gIntroScreen.setSkipping(this.toMenu));
    }

    @Override
    protected byte[] reportData() {
        String report = "Map: " + Globals.mapnum;
        report = report + "\r\n";
        report = report + "Skill " + Globals.nDifficult;
        report = report + "\r\n";
        if (Globals.gPlayer[Mmulti.myconnectindex] != null) {
            report = report + "PlayerX " + Globals.gPlayer[Mmulti.myconnectindex].x;
            report = report + "\r\n";
            report = report + "PlayerY " + Globals.gPlayer[Mmulti.myconnectindex].y;
            report = report + "\r\n";
            report = report + "PlayerZ " + Globals.gPlayer[Mmulti.myconnectindex].z;
            report = report + "\r\n";
            report = report + "PlayerAng " + Globals.gPlayer[Mmulti.myconnectindex].ang;
            report = report + "\r\n";
            report = report + "PlayerSect " + Globals.gPlayer[Mmulti.myconnectindex].sectnum;
            report = report + "\r\n";
        }
        return report.getBytes();
    }

    @Override
    public void dispose() {
        if (Globals.rec != null) {
            Globals.rec.close();
        }
        super.dispose();
    }

    public static enum UserFlag {
        None,
        UserMap;

    }
}

