/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Types.MovieFile;

public class MovieScreen
extends SkippableAdapter {
    private MovieFile fil;
    private Runnable callback;
    private int gCutsClock;
    private int frame;
    private long time;
    private long LastMS;
    private int whitepal;

    public MovieScreen(BuildGame game) {
        super(game);
    }

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.engine.sampletimer();
        this.LastMS = this.engine.getticks();
        Engine.totalclock = 0;
        this.gCutsClock = 0;
    }

    @Override
    public void hide() {
        this.engine.setbrightness(BuildSettings.paletteGamma.get(), Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    @Override
    public void skip() {
        this.close();
        super.skip();
    }

    public MovieScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    public boolean init(String fn) {
        if (this.fil != null) {
            return false;
        }
        try {
            this.fil = new MovieFile(fn);
            Tile pic = this.engine.getTile(Globals.TILE_ANIM);
            pic.setWidth(this.fil.getHeight());
            pic.setHeight(this.fil.getWidth());
            this.frame = 0;
            this.time = 0L;
            this.LastMS = -1L;
            pic.data = null;
            if (this.fil.getPalette() != null) {
                this.changepalette(this.fil.getPalette());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean play() {
        if (this.fil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.time += dt;
            float tick = 1000.0f / (float)this.fil.getRate();
            Tile pic = this.engine.getTile(Globals.TILE_ANIM);
            if ((float)this.time >= tick) {
                if (this.frame < this.fil.numFrames()) {
                    pic.data = this.fil.draw(this.frame);
                    this.engine.getrender().invalidatetile(Globals.TILE_ANIM, 251, 16);
                    ++this.frame;
                }
                this.time = (long)((float)this.time - tick);
            }
            this.LastMS = ms;
            if (pic.getWidth() <= 0) {
                return false;
            }
            if (pic.data != null) {
                this.engine.rotatesprite(0, 0, 65536, 512, Globals.TILE_ANIM, 0, 251, 94, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            return this.frame < this.fil.numFrames();
        }
        return false;
    }

    private void close() {
        this.fil.close();
        this.fil = null;
    }

    public void changepalette(byte[] pal) {
        this.engine.changepalette(pal);
        this.whitepal = -1;
        int k = 0;
        for (int i = 0; i < 256; i += 3) {
            int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
            if (j <= k) continue;
            k = j;
            this.whitepal = i;
        }
    }

    @Override
    public void draw(float delta) {
        if (!this.play() && this.skipCallback != null) {
            this.close();
            if (this.callback != null) {
                BuildGdx.app.postRunnable(this.callback);
                this.callback = null;
            }
        }
        if (this.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        if (Engine.totalclock - this.gCutsClock < 200 && this.escSkip) {
            this.game.getFont(1).drawText(160, 5, "Press ESC to skip", shade, this.whitepal, BuildFont.TextAlign.Center, 10, true);
        }
    }
}

