/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.FileNotFoundException;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;

public class MovieFile {
    private byte[] pal;
    private byte[] buffer;
    private Frame[] frames;
    private int rate;
    private Resource fil;
    private int width;
    private int height;

    public MovieFile(String path) throws Exception {
        this.fil = BuildGdx.cache.open(path, 0);
        if (this.fil == null) {
            throw new FileNotFoundException(path + " not found!");
        }
        int size = this.fil.readInt();
        if (size != this.fil.size()) {
            throw new Exception("Wrong size");
        }
        short type = this.fil.readShort();
        if (type != -20719) {
            throw new Exception("Wrong type");
        }
        int numframes = this.fil.readShort().shortValue();
        this.width = this.fil.readShort().shortValue();
        this.height = this.fil.readShort().shortValue();
        this.rate = this.fil.readShort().shortValue();
        this.fil.readShort();
        this.fil.readShort();
        this.fil.seek(110L, Resource.Whence.Current);
        this.buffer = new byte[this.width * this.height];
        this.frames = new Frame[numframes];
        for (int i = 0; i < numframes; ++i) {
            this.frames[i] = new Frame(this.fil);
            if (this.pal == null) {
                for (int j = 0; j < this.frames[i].chunks; ++j) {
                    this.fil.seek(4L, Resource.Whence.Current);
                    if (this.fil.readShort() != 11) continue;
                    this.pal = new byte[768];
                    this.decode_palette(this.fil);
                }
            }
            this.fil.seek(this.frames[i].offset + this.frames[i].size - 16, Resource.Whence.Set);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int numFrames() {
        if (this.frames != null) {
            return this.frames.length;
        }
        return 0;
    }

    public byte[] getPalette() {
        return this.pal;
    }

    public int getRate() {
        return this.rate;
    }

    public void close() {
        if (this.fil != null) {
            this.fil.close();
        }
        this.buffer = null;
        this.pal = null;
        this.frames = null;
    }

    public byte[] draw(int frame) {
        Frame fr = this.frames[frame];
        this.fil.seek(fr.offset, Resource.Whence.Set);
        if (fr.type != -3590) {
            return null;
        }
        block6: for (int j = 0; j < fr.chunks; ++j) {
            int chunk_size = this.fil.readInt();
            short chunk_type = this.fil.readShort();
            switch (chunk_type) {
                case 11: {
                    this.decode_palette(this.fil);
                    continue block6;
                }
                case 12: {
                    this.decode_block_0c(this.fil);
                    continue block6;
                }
                case 15: {
                    this.decode_block_0f(this.fil);
                    continue block6;
                }
                case 16: {
                    this.fil.read(this.buffer, 0, chunk_size - 4);
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        return this.buffer;
    }

    private void decode_palette(Resource fil) {
        fil.seek(4L, Resource.Whence.Current);
        fil.read(this.pal);
        int p = 0;
        while (p < 768) {
            int n = p++;
            this.pal[n] = (byte)(this.pal[n] << 2);
        }
    }

    private void decode_block_0c(Resource fil) {
        int line;
        int nextline = line = 320 * fil.readShort();
        int width = fil.readShort().shortValue();
        for (int j = 0; j < width; ++j) {
            nextline += 320;
            int v21 = fil.readByte() & 0xFF;
            if (v21 > 0) {
                for (int i = 0; i < v21; ++i) {
                    line += fil.readByte() & 0xFF;
                    int v20 = fil.readByte() & 0xFF;
                    if (v20 < 128) {
                        for (int p = 0; p < v20; ++p) {
                            this.buffer[line + p] = fil.readByte();
                        }
                        line += v20;
                    }
                    if (v20 <= 128) continue;
                    byte col = fil.readByte();
                    for (int p = 0; p < 256 - v20; ++p) {
                        this.buffer[line + p] = col;
                    }
                    line += 256 - v20;
                }
            }
            line = nextline;
        }
    }

    private void decode_block_0f(Resource fil) {
        int line = 0;
        for (int i = 1; i <= 200; ++i) {
            int v18 = fil.readByte() & 0xFF;
            if (v18 > 0) {
                for (int j = 0; j < v18; ++j) {
                    int v8 = fil.readByte() & 0xFF;
                    if (v8 > 128) {
                        for (int p = 0; p < 256 - v8; ++p) {
                            this.buffer[line + p] = fil.readByte();
                        }
                        line += 256 - v8;
                    }
                    if (v8 >= 128) continue;
                    byte col = fil.readByte();
                    for (int p = 0; p < v8; ++p) {
                        this.buffer[line + p] = col;
                    }
                    line += v8;
                }
            }
            line = 320 * i;
        }
    }

    private class Frame {
        public static final int sizeof = 16;
        int size;
        int type;
        int chunks;
        int offset;

        public Frame(Resource fil) {
            this.size = fil.readInt();
            this.type = fil.readShort().shortValue();
            this.chunks = fil.readShort().shortValue();
            fil.seek(8L, Resource.Whence.Current);
            this.offset = fil.position();
        }
    }
}

