/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;

public class PCXFile {
    private int width;
    private int height;
    private int pos;
    private byte[] buffer;
    private byte[] palette;

    public PCXFile(Resource fil) throws Exception {
        byte manufacturer = fil.readByte();
        byte version = fil.readByte();
        byte rle = fil.readByte();
        byte bpp = fil.readByte();
        if (manufacturer != 10 || version != 5 || rle != 1 || bpp != 8) {
            throw new UnsupportedOperationException("Couldn't read the file. Unsupported version");
        }
        fil.seek(4L, Resource.Whence.Current);
        this.width = fil.readShort() + 1;
        this.height = fil.readShort() + 1;
        fil.seek(116L, Resource.Whence.Current);
        this.pos = 0;
        this.buffer = new byte[this.width * this.height];
        for (int y = 0; y < this.height; ++y) {
            this.decodeLine(fil);
        }
        fil.readByte();
        if (fil.remaining() == 768) {
            this.palette = new byte[768];
            fil.read(this.palette);
        }
        fil.close();
    }

    private void decodeLine(Resource fil) {
        int i = 0;
        block3: while (i < this.width) {
            byte header = fil.readByte();
            switch (header & 0xC0) {
                case 192: {
                    int len = header & 0x3F;
                    Gameutils.fill(this.buffer, this.pos, this.pos += len, fil.readByte().byteValue());
                    i += len;
                    continue block3;
                }
            }
            this.buffer[this.pos++] = header;
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getData() {
        return this.buffer;
    }

    public byte[] getPalette() {
        return this.palette;
    }
}

