/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components.Buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ru.m210projects.Launcher.desktop.Components.Buttons.FrameButton;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.JLauncher;

public class AboutButton
extends FrameButton {
    private static final long serialVersionUID = 1L;
    private final ActionListener showAbout;
    private final ActionListener goBack;
    private GameEntry lastEntry;

    public AboutButton(final JLauncher main, String logoName, String panelName) {
        super(main, logoName, panelName);
        this.setText("About");
        this.setEnabled(false);
        this.showAbout = this.getActionListeners()[0];
        this.goBack = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AboutButton.this.lastEntry != null) {
                    main.showEntry(AboutButton.this.lastEntry);
                }
            }
        };
    }

    public void setEntry(GameEntry entry) {
        this.lastEntry = entry;
        this.setEnabled(entry != null);
    }

    public void setAction(boolean back) {
        this.removeListeners();
        this.setSize(80, this.getHeight());
        this.setPreferredSize(this.getSize());
        if (!back) {
            this.setText("About");
            this.addActionListener(this.showAbout);
        } else if (this.lastEntry != null) {
            this.setText("Back");
            this.addActionListener(this.goBack);
        }
    }

    private void removeListeners() {
        for (ActionListener al : this.getActionListeners()) {
            this.removeActionListener(al);
        }
    }
}

