/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.BoundsPopupMenuListener;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.ComboItem;
import ru.m210projects.Launcher.desktop.Components.Buttons.OpenButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.SettingsButton;
import ru.m210projects.Launcher.desktop.Components.DirectoryBrowser;
import ru.m210projects.Launcher.desktop.Components.GamePanel;
import ru.m210projects.Launcher.desktop.GameEntries.DukeEntry;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameServices;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;

public class DukePanel
extends GamePanel {
    private static final long serialVersionUID = 1L;
    private JTextField pathField;
    private JButton launchButton;
    private OpenButton openButton;
    private JLauncher main;
    private JComboBox<ComboItem> gameFoldersList;
    private JLabel messageField = new JLabel();
    private boolean isPortable;
    private boolean Init = false;
    private boolean initialized = false;

    public DukePanel(JLauncher main, DukeEntry entry, boolean isPortable) {
        super(entry);
        this.main = main;
        this.isPortable = isPortable;
        main.services.registerGame(GameServices.Service.GOG, entry, "[GOG]:\\GOGDUKE3D");
        main.services.registerGame(GameServices.Service.Steam, entry, "[WT Steam]:\\Duke Nukem 3D Twentieth Anniversary World Tour", "[Megaton Steam]:\\Duke Nukem 3D" + File.separator + "gameroot", "[3DRA Steam]:\\Duke Nukem 3D" + File.separator + "Duke Nukem 3D");
        main.services.registerGame(GameServices.Service.Other, entry, "[Zoom]:\\HKLM\\Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{701DE32E-4F6E-4524-9966-837165B91EB9}_is1", "[Zoom]:\\HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{701DE32E-4F6E-4524-9966-837165B91EB9}_is1", "[Anthology]:\\HKLM\\SOFTWARE\\WOW6432Node\\3DRealms\\Anthology", "[Anthology]:\\HKLM\\SOFTWARE\\3DRealms\\Anthology", "[Anthology]:\\HKLM\\SOFTWARE\\WOW6432Node\\3DRealms\\Duke Nukem 3D", "[Anthology]:\\HKLM\\SOFTWARE\\3DRealms\\Duke Nukem 3D");
    }

    @Override
    public void init() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow][]"));
        if (!this.isPortable) {
            final ArrayList<GameServices.GameLabel> labels = new ArrayList<GameServices.GameLabel>(this.main.services.getPaths(this.entry));
            if (labels.size() > 0) {
                this.gameFoldersList = new JComboBox();
                final BuildConfig cfg = this.entry.getConfig();
                final ComboItem cfgPath = new ComboItem(cfg.path, cfg.path);
                if (cfg.path != null) {
                    this.gameFoldersList.addItem(cfgPath);
                }
                PopupMenuListener popupMenuListener = new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        if (!DukePanel.this.Init) {
                            for (GameServices.GameLabel label : labels) {
                                if (label.label.equals("[Anthology]") && !label.path.endsWith("Duke Nukem 3D\\")) {
                                    label.path = label.path + "Duke Nukem 3D\\";
                                }
                                ComboItem path = new ComboItem(label.path, label.label + " " + label.path);
                                if (Objects.equals(label.path, cfg.path)) {
                                    DukePanel.this.gameFoldersList.insertItemAt(path, 0);
                                    DukePanel.this.gameFoldersList.removeItem(cfgPath);
                                    continue;
                                }
                                DukePanel.this.gameFoldersList.addItem(path);
                            }
                            DukePanel.this.Init = true;
                        }
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                };
                this.gameFoldersList.addPopupMenuListener(popupMenuListener);
                this.gameFoldersList.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DukePanel.this.path = ((ComboItem)DukePanel.this.gameFoldersList.getSelectedItem()).getValue();
                        CheckFiles result = DukePanel.this.entry.checkResources(DukePanel.this.path, true);
                        boolean access = result.getValue();
                        DukePanel.this.messageField.setText(result.getLabel());
                        DukePanel.this.entry.getConfig().path = DukePanel.this.path;
                        DukePanel.this.startButtonStatus(access);
                    }
                });
                BoundsPopupMenuListener listener = new BoundsPopupMenuListener(true, false);
                this.gameFoldersList.addPopupMenuListener(listener);
                this.gameFoldersList.setPrototypeDisplayValue(new ComboItem("", ""));
                this.add(this.gameFoldersList, "cell 0 0,grow");
            } else {
                this.pathField = new JTextField();
                this.pathField.setToolTipText("Path to " + this.entry.getResourceName() + " files");
                this.pathField.setEditable(false);
                this.add((Component)this.pathField, "cell 0 0,grow");
                this.pathField.setColumns(10);
            }
        }
        JButton browseTW = new JButton("...");
        browseTW.setToolTipText("Choose folder");
        browseTW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DirectoryBrowser.showDirectoryChooser(Main.fr.getFrame(), DukePanel.this.path, DukePanel.this.entry.getResourceName(), DukePanel.this.entry.getIcon16());
                if (f != null) {
                    DukePanel.this.path = f.getAbsolutePath() + File.separator;
                }
                if (DukePanel.this.gameFoldersList != null) {
                    ComboItem addedPath = new ComboItem(DukePanel.this.path, DukePanel.this.path);
                    DukePanel.this.gameFoldersList.addItem(addedPath);
                    DukePanel.this.gameFoldersList.setSelectedItem(addedPath);
                } else if (DukePanel.this.pathField != null) {
                    DukePanel.this.pathField.setText(DukePanel.this.path);
                }
                CheckFiles result = DukePanel.this.entry.checkResources(DukePanel.this.path, true);
                boolean access = result.getValue();
                DukePanel.this.messageField.setText(result.getLabel());
                DukePanel.this.entry.getConfig().path = DukePanel.this.path;
                DukePanel.this.startButtonStatus(access);
            }
        });
        if (!this.isPortable) {
            this.add((Component)browseTW, "cell 2 0,grow");
        }
        this.openButton = new OpenButton();
        this.add((Component)this.openButton, "cell 3 0,grow");
        this.add((Component)this.messageField, "cell 0 1 4, grow");
        this.messageField.setVerticalAlignment(1);
        this.launchButton = new JButton();
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DukePanel.this.launchButton.setText("Loading...");
                DukePanel.this.launchButton.setEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DukePanel.this.entry.startGame(DukePanel.this.path);
                    }
                });
            }
        });
        this.add((Component)this.launchButton, "cell 0 3 3 1,grow");
        this.add((Component)new SettingsButton(this.main, this.entry, null, "Settings"), "cell 3 3,alignx right,growy");
    }

    @Override
    public void update() {
        BuildConfig cfg = this.entry.getConfig();
        this.path = cfg.path != null ? cfg.path : GameEntry.getDirPath();
        this.openButton.update(this.path);
        if (!this.initialized) {
            CheckFiles result = this.entry.checkResources(this.path, true);
            boolean access = result.getValue();
            this.messageField.setText(result.getLabel());
            this.startButtonStatus(access);
            if (this.pathField != null) {
                this.pathField.setText(this.path);
            }
            this.initialized = true;
        }
    }

    public void startButtonStatus(boolean access) {
        this.launchButton.setEnabled(access);
        if (access) {
            this.launchButton.setText("Play " + this.entry.getResourceName());
        } else {
            this.launchButton.setText(this.entry.getResourceName() + " resources not found!");
        }
    }
}

