/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.BoundsPopupMenuListener;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.ComboItem;
import ru.m210projects.Launcher.desktop.Components.Buttons.OpenButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.SettingsButton;
import ru.m210projects.Launcher.desktop.Components.DirectoryBrowser;
import ru.m210projects.Launcher.desktop.Components.GamePanel;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.PSlaveEntry;
import ru.m210projects.Launcher.desktop.GameServices;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;

public class PSPanel
extends GamePanel {
    private static final long serialVersionUID = 1L;
    private JTextField pathField;
    private JButton launchButton;
    private OpenButton openButton;
    private JLauncher main;
    private JComboBox<ComboItem> gameFoldersList;
    private JLabel messageField = new JLabel();
    private boolean isPortable;
    private boolean Init = false;
    private boolean initialized = false;

    public PSPanel(JLauncher main, PSlaveEntry entry, boolean isPortable) {
        super(entry);
        this.main = main;
        this.isPortable = isPortable;
        main.services.registerGame(GameServices.Service.GOG, entry, "[GOG]:\\Games\\2132611980");
        main.services.registerGame(GameServices.Service.Steam, entry, "[Steam]:\\PowerslaveCE" + File.separator + "PWRSLAVE");
    }

    @Override
    public void init() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow][]"));
        if (!this.isPortable) {
            final ArrayList<GameServices.GameLabel> labels = new ArrayList<GameServices.GameLabel>(this.main.services.getPaths(this.entry));
            if (labels.size() > 0) {
                this.gameFoldersList = new JComboBox();
                final BuildConfig cfg = this.entry.getConfig();
                final ComboItem cfgPath = new ComboItem(cfg.path, cfg.path);
                if (cfg.path != null) {
                    this.gameFoldersList.addItem(cfgPath);
                }
                PopupMenuListener popupMenuListener = new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        if (!PSPanel.this.Init) {
                            for (GameServices.GameLabel label : labels) {
                                ComboItem path = new ComboItem(label.path, label.label + " " + label.path);
                                if (Objects.equals(label.path, cfg.path)) {
                                    PSPanel.this.gameFoldersList.insertItemAt(path, 0);
                                    PSPanel.this.gameFoldersList.removeItem(cfgPath);
                                    continue;
                                }
                                PSPanel.this.gameFoldersList.addItem(path);
                            }
                            PSPanel.this.Init = true;
                        }
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                };
                this.gameFoldersList.addPopupMenuListener(popupMenuListener);
                this.gameFoldersList.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PSPanel.this.path = ((ComboItem)PSPanel.this.gameFoldersList.getSelectedItem()).getValue();
                        CheckFiles result = PSPanel.this.entry.checkResources(PSPanel.this.path, true);
                        boolean access = result.getValue();
                        PSPanel.this.messageField.setText(result.getLabel());
                        PSPanel.this.entry.getConfig().path = PSPanel.this.path;
                        PSPanel.this.startButtonStatus(access);
                    }
                });
                BoundsPopupMenuListener listener = new BoundsPopupMenuListener(true, false);
                this.gameFoldersList.addPopupMenuListener(listener);
                this.gameFoldersList.setPrototypeDisplayValue(new ComboItem("", ""));
                this.add(this.gameFoldersList, "cell 0 0,grow");
            } else {
                this.pathField = new JTextField();
                this.pathField.setToolTipText("Path to " + this.entry.getResourceName() + " files");
                this.pathField.setEditable(false);
                this.add((Component)this.pathField, "cell 0 0,grow");
                this.pathField.setColumns(10);
            }
        }
        JButton browseTW = new JButton("...");
        browseTW.setToolTipText("Choose folder");
        browseTW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DirectoryBrowser.showDirectoryChooser(Main.fr.getFrame(), PSPanel.this.path, PSPanel.this.entry.getResourceName(), PSPanel.this.entry.getIcon16());
                if (f != null) {
                    PSPanel.this.path = f.getAbsolutePath() + File.separator;
                }
                if (PSPanel.this.gameFoldersList != null) {
                    ComboItem addedPath = new ComboItem(PSPanel.this.path, PSPanel.this.path);
                    PSPanel.this.gameFoldersList.addItem(addedPath);
                    PSPanel.this.gameFoldersList.setSelectedItem(addedPath);
                } else if (PSPanel.this.pathField != null) {
                    PSPanel.this.pathField.setText(PSPanel.this.path);
                }
                CheckFiles result = PSPanel.this.entry.checkResources(PSPanel.this.path, true);
                boolean access = result.getValue();
                PSPanel.this.messageField.setText(result.getLabel());
                if (access) {
                    PSPanel.this.entry.getConfig().path = PSPanel.this.path;
                }
                PSPanel.this.startButtonStatus(access);
            }
        });
        if (!this.isPortable) {
            this.add((Component)browseTW, "cell 2 0,grow");
        }
        this.openButton = new OpenButton();
        this.add((Component)this.openButton, "cell 3 0,grow");
        this.add((Component)this.messageField, "cell 0 1 4, grow");
        this.messageField.setVerticalAlignment(1);
        this.launchButton = new JButton();
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PSPanel.this.launchButton.setText("Loading...");
                PSPanel.this.launchButton.setEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PSPanel.this.entry.startGame(PSPanel.this.path);
                    }
                });
            }
        });
        this.add((Component)this.launchButton, "cell 0 3 3 1,grow");
        this.add((Component)new SettingsButton(this.main, this.entry, null, "Settings"), "cell 3 3,alignx right,growy");
    }

    @Override
    public void update() {
        BuildConfig cfg = this.entry.getConfig();
        this.path = cfg.path != null ? cfg.path : GameEntry.getDirPath();
        this.openButton.update(this.path);
        if (!this.initialized) {
            CheckFiles result = this.entry.checkResources(this.path, true);
            boolean access = result.getValue();
            if (result.getLabel() != null) {
                this.messageField.setText(result.getLabel());
            }
            this.startButtonStatus(access);
            if (this.pathField != null) {
                this.pathField.setText(this.path);
            }
            this.initialized = true;
        }
    }

    public void startButtonStatus(boolean access) {
        this.launchButton.setEnabled(access);
        if (access) {
            this.launchButton.setText("Play " + this.entry.getResourceName());
        } else {
            this.launchButton.setText(this.entry.getResourceName() + " resources not found!");
        }
    }
}

