/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop;

import java.io.File;
import javax.swing.UIManager;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;

public class Frame {
    public boolean forcePortable = false;
    private int currentEntry;
    private JLauncher frame;

    public Frame(String path, boolean showSettings, GameEntry ... entry) {
        if (this.checkPortable(path, showSettings, entry)) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.frame = new JLauncher("BuildGDX " + Main.appversion, this.currentEntry, entry);
        this.frame.start();
        if (this.currentEntry != -1) {
            this.frame.showEntry(entry[this.currentEntry]);
        }
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public JLauncher getFrame() {
        return this.frame;
    }

    private boolean checkPortable(String path, boolean showSettings, GameEntry ... entry) {
        String currentPath = path != null ? path : GameEntry.getDirPath();
        this.currentEntry = -1;
        if (this.checkPortablePath(currentPath)) {
            for (int i = 0; i < entry.length; ++i) {
                if (!entry[i].checkResources(currentPath, false).getValue()) continue;
                this.currentEntry = i;
                break;
            }
        }
        if (this.currentEntry != -1) {
            BuildConfig currentConfig = entry[this.currentEntry].buildConfig(currentPath);
            currentConfig.path = currentPath;
            if (!currentConfig.startup || path != null && !showSettings) {
                entry[this.currentEntry].startGame(currentPath);
                return true;
            }
        }
        return false;
    }

    private boolean checkPortablePath(String path) {
        File[] fileArray;
        int n;
        int n2;
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList != null && (n2 = 0) < (n = (fileArray = fList).length)) {
            File file = fileArray[n2];
            if (file.getName().toLowerCase().equals("portable")) {
                this.forcePortable = true;
            }
            return true;
        }
        File f = new File(path + "tmp_check.write");
        if (f.exists()) {
            return f.delete();
        }
        try {
            if (f.createNewFile()) {
                return f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

