/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.WinReg;

public class GameServices {
    private ArrayList<String> steamLibraries;
    private ArrayList<String> gogLibraries;
    private HashMap<GameEntry, String[]> steamGamePaths = new HashMap();
    private HashMap<GameEntry, String[]> gogGamePaths = new HashMap();
    private HashMap<GameEntry, String[]> otherGamePaths = new HashMap();
    private ArrayList<GameLabel> result = new ArrayList();
    private BuildApplication.Platform platform;

    public GameServices(BuildApplication.Platform platform) {
        this.getSteamLibraries(platform);
        this.getGOGLibraries(platform);
        this.platform = platform;
    }

    private String getSteamFolder(BuildApplication.Platform platform) {
        File folder;
        String steamInstall = null;
        switch (platform) {
            case Linux: {
                steamInstall = System.getProperty("user.home") + File.separator + ".steam" + File.separator + "steam";
                steamInstall = steamInstall + File.separator + "steamapps" + File.separator;
                break;
            }
            case Windows: {
                steamInstall = WinReg.getRegKey("HKCU\\Software\\Valve\\Steam", "SteamPath");
                if (steamInstall == null) break;
                steamInstall = (steamInstall + File.separator + "steamapps" + File.separator).replace("/", File.separator);
                break;
            }
            default: {
                return null;
            }
        }
        if (steamInstall != null && !(folder = new File(steamInstall)).exists()) {
            return null;
        }
        return steamInstall;
    }

    private void getSteamLibraries(BuildApplication.Platform platform) {
        String steamInstall = this.getSteamFolder(platform);
        if (steamInstall != null) {
            System.out.println("Found Steam folder");
            this.steamLibraries = new ArrayList();
            this.steamLibraries.add(steamInstall + "common" + File.separator);
            System.out.println(this.steamLibraries.get(0));
            String pathToVdf = steamInstall + "libraryfolders.vdf";
            Scanner input = null;
            try {
                input = new Scanner(new File(pathToVdf));
                String message = input.nextLine();
                if (message.equals("\"LibraryFolders\"")) {
                    while (input.hasNextLine()) {
                        message = input.nextLine();
                        if (!message.startsWith("\t\"") || !Character.isDigit(message.charAt(2))) continue;
                        String[] sentences = message.split("\t");
                        String s = sentences[sentences.length - 1];
                        s = s.replace("\"", "");
                        s = s.replace("\\\\", File.separator);
                        s = s + File.separator + "steamapps" + File.separator + "common" + File.separator;
                        this.steamLibraries.add(s);
                        System.out.println(s);
                    }
                } else if (message.equals("\"libraryfolders\"")) {
                    while (input.hasNextLine()) {
                        message = input.nextLine();
                        if (!message.startsWith("\t\t\"path\"")) continue;
                        String[] sentences = message.split("\t");
                        String s = sentences[sentences.length - 1];
                        s = s.replace("\"", "");
                        s = s.replace("\\\\", File.separator);
                        s = s + File.separator + "steamapps" + File.separator + "common" + File.separator;
                        this.steamLibraries.add(s);
                        System.out.println(s);
                    }
                }
                input.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        System.out.println("Steam folder not found");
    }

    private void getGOGLibraries(BuildApplication.Platform platform) {
        switch (platform) {
            case Linux: {
                break;
            }
            case Windows: {
                String[] gogpaths;
                for (String path : gogpaths = new String[]{"HKLM\\Software\\WOW6432Node\\GOG.com", "HKLM\\Software\\GOG.com"}) {
                    if (WinReg.getRegKey(path, "") == null) continue;
                    if (this.gogLibraries == null) {
                        this.gogLibraries = new ArrayList();
                    }
                    this.gogLibraries.add(path);
                }
                break;
            }
            default: {
                return;
            }
        }
        if (this.gogLibraries != null) {
            System.out.println("Found GOG folder");
        }
    }

    public void registerGame(Service service, GameEntry entry, String ... path) {
        if (service == Service.Steam) {
            this.steamGamePaths.put(entry, path);
        } else if (service == Service.GOG) {
            this.gogGamePaths.put(entry, path);
        } else if (service == Service.Other) {
            this.otherGamePaths.put(entry, path);
        }
    }

    public ArrayList<GameLabel> getPaths(GameEntry entry) {
        String pathToGame;
        String path;
        String label;
        int index;
        String s;
        int n;
        int n2;
        String[] stringArray;
        int i;
        String[] paths;
        this.result.clear();
        if (this.steamLibraries != null && this.steamLibraries.size() > 0 && (paths = this.steamGamePaths.get(entry)) != null) {
            for (i = 0; i < this.steamLibraries.size(); ++i) {
                stringArray = paths;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    s = stringArray[n];
                    index = s.indexOf(":\\");
                    label = s.substring(0, index);
                    path = this.steamLibraries.get(i) + s.substring(index + 2).trim() + File.separator;
                    if (!new File(path).exists()) continue;
                    this.result.add(new GameLabel(label, path));
                }
            }
        }
        if (this.gogLibraries != null && this.gogGamePaths.size() > 0 && (paths = this.gogGamePaths.get(entry)) != null) {
            for (i = 0; i < this.gogLibraries.size(); ++i) {
                stringArray = paths;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    s = stringArray[n];
                    index = s.indexOf(":\\");
                    label = s.substring(0, index);
                    path = s.substring(index + 2).trim();
                    if (this.platform != BuildApplication.Platform.Windows || (pathToGame = WinReg.getRegKey(this.gogLibraries.get(i) + "\\" + path, "path")) == null || !new File(pathToGame).exists()) continue;
                    if (!pathToGame.endsWith(File.separator)) {
                        pathToGame = pathToGame + File.separator;
                    }
                    this.result.add(new GameLabel(label, pathToGame));
                }
            }
        }
        if (this.otherGamePaths.size() > 0 && (paths = this.otherGamePaths.get(entry)) != null) {
            for (String s2 : paths) {
                int index2 = s2.indexOf(":\\");
                String label2 = s2.substring(0, index2);
                String path2 = s2.substring(index2 + 2).trim();
                if (this.platform != BuildApplication.Platform.Windows) continue;
                String regKey = "";
                if (label2.equals("[Zoom]")) {
                    regKey = "InstallLocation";
                }
                if ((pathToGame = WinReg.getRegKey(path2, regKey)) == null || !new File(pathToGame).exists()) continue;
                if (!pathToGame.endsWith(File.separator)) {
                    pathToGame = pathToGame + File.separator;
                }
                this.result.add(new GameLabel(label2, pathToGame));
            }
        }
        return this.result;
    }

    public static enum Service {
        Steam,
        GOG,
        Other;

    }

    public static class GameLabel {
        public String label;
        public String path;

        public GameLabel(String label, String path) {
            this.label = label;
            this.path = path;
        }
    }
}

