/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop;

import com.badlogic.gdx.Files;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildConfiguration;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.VideoMode;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.desktop.DesktopFactory;
import ru.m210projects.Build.desktop.audio.midi.MidiMusicModule;
import ru.m210projects.Launcher.desktop.Frame;
import ru.m210projects.Launcher.desktop.GameEntries.BloodEntry;
import ru.m210projects.Launcher.desktop.GameEntries.DukeEntry;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.LSPEntry;
import ru.m210projects.Launcher.desktop.GameEntries.NamEntry;
import ru.m210projects.Launcher.desktop.GameEntries.PSlaveEntry;
import ru.m210projects.Launcher.desktop.GameEntries.RREntry;
import ru.m210projects.Launcher.desktop.GameEntries.RRRAEntry;
import ru.m210projects.Launcher.desktop.GameEntries.SWEntry;
import ru.m210projects.Launcher.desktop.GameEntries.TekwarEntry;
import ru.m210projects.Launcher.desktop.GameEntries.WH2Entry;
import ru.m210projects.Launcher.desktop.GameEntries.WHEntry;

public class Main {
    public static String appversion = "v1.16";
    public static final String headerPath = "Headers";
    public static final String iconPath = "Games";
    public static final BuildApplication.Platform platform = Main.getPlatform();
    public static final boolean isWindows = platform == BuildApplication.Platform.Windows;
    public static Frame fr;

    public static void main(final String[] args) {
        DesktopFactory.InitSoundDrivers();
        String path = null;
        boolean isSilent = false;
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.equals("-path") && i + 1 < args.length) {
                path = args[++i];
                continue;
            }
            if (!s.equals("-silent")) continue;
            isSilent = true;
        }
        fr = new Frame(path, !isSilent, new BloodEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new DukeEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new NamEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new SWEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new RREntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new RRRAEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new PSlaveEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new TekwarEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new WHEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new WH2Entry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        }, new LSPEntry(){

            @Override
            public void startGame(String gamePath) {
                Main.launchPort(args, gamePath, this);
            }
        });
    }

    private static void launchPort(String[] args, String gamePath, GameEntry entry) {
        BuildConfiguration appcfg = new BuildConfiguration();
        BuildConfig cfg = entry.getConfig();
        BuildGdx.compat = new Compat(gamePath, fr != null && Main.fr.forcePortable ? gamePath : cfg.cfgPath);
        BuildGdx.cache = new Cache1D(BuildGdx.compat);
        appcfg.fullscreen = VideoMode.setFullscreen(cfg.ScreenWidth, cfg.ScreenHeight, cfg.fullscreen == 1);
        appcfg.width = cfg.ScreenWidth;
        appcfg.height = cfg.ScreenHeight;
        appcfg.backgroundFPS = cfg.fpslimit;
        appcfg.foregroundFPS = cfg.fpslimit;
        appcfg.vsync = cfg.gVSync;
        appcfg.borderless = cfg.borderless;
        DesktopFactory factory = new DesktopFactory(appcfg);
        String apptitle = entry.appname + " " + entry.sversion;
        String newver = null;
        if (cfg.checkVersion && (newver = Main.checkVersion("buildgdx.ver", appversion)) != null) {
            apptitle = apptitle + " (new BuildGDX " + newver + ")";
        }
        appcfg.title = apptitle;
        String[] icons = entry.getIcons();
        for (int i = 0; i < icons.length; ++i) {
            appcfg.addIcon(icons[i], Files.FileType.Internal);
        }
        if (cfg.midiSynth < 0 || cfg.midiSynth >= MidiMusicModule.getDevices().size()) {
            cfg.midiSynth = 0;
        }
        BuildAudio.registerDriver(BuildAudio.Driver.Music, new MidiMusicModule(cfg.midiSynth, cfg.soundBank));
        DesktopFactory.InitVideoModes();
        new BuildApplication(entry.getGame(args), factory, cfg.renderType);
        if (fr != null) {
            fr.dispose();
        }
    }

    public static String checkVersion(String filename, String version) {
        String newver = null;
        try {
            String verstd = Main.getVersion(filename);
            int webver = Integer.parseInt(verstd);
            int appver = Integer.parseInt(version.replaceAll("[^0-9]", ""));
            if (webver > appver) {
                newver = verstd = "v" + verstd.substring(0, 1) + "." + verstd.substring(1, verstd.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newver != null) {
            Main.showMessage("Please update!", "New version available: " + newver + "\r\n" + Main.getChangelog());
        } else {
            Console.Println("You are using the latest version");
        }
        return newver;
    }

    private static String getVersion(String filename) throws Exception {
        URL version = new URL("http://m210.ucoz.ru/Files/" + filename);
        BufferedReader in = new BufferedReader(new InputStreamReader(version.openStream()));
        String inputLine = in.readLine();
        in.close();
        return inputLine;
    }

    private static String getChangelog() {
        String msg = "";
        try {
            String inputLine;
            URL version = new URL("http://m210.ucoz.ru/Files/changelog.gdx");
            BufferedReader in = new BufferedReader(new InputStreamReader(version.openStream()));
            while ((inputLine = in.readLine()) != null) {
                msg = msg + inputLine + "\r\n";
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    private static void showMessage(String header, String message) {
        JOptionPane frame = new JOptionPane();
        frame.setMessage(message);
        frame.setMessageType(1);
        JDialog dlog = frame.createDialog(null, header);
        frame.setBackground(dlog.getBackground());
        dlog.setAlwaysOnTop(true);
        dlog.setVisible(true);
        Console.Println(message, Console.OSDTEXT_GOLD);
    }

    private static BuildApplication.Platform getPlatform() {
        String osName = System.getProperty("os.name");
        BuildApplication.Platform platform = osName.startsWith("Windows") ? BuildApplication.Platform.Windows : (osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("SunOS") || osName.startsWith("Unix") || osName.indexOf("aix") > 0 ? BuildApplication.Platform.Linux : (osName.startsWith("Mac OS X") || osName.startsWith("Darwin") ? BuildApplication.Platform.MacOSX : null));
        return platform;
    }
}

