/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.math.Vector2;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BulletInfo;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Weapons;

public class Bullet {
    private static Vector2 tmpVec = new Vector2();
    private static BulletStruct tmpBullet = new BulletStruct();
    private static int nBulletCount;
    private static int nBulletsFree;
    private static short[] BulletFree;
    private static short[] nBulletEnemy;
    private static BulletStruct[] BulletList;
    public static int lasthitx;
    public static int lasthity;
    public static int lasthitz;
    public static int lasthitsect;
    public static int lasthitwall;
    public static int lasthitsprite;
    public static final BulletInfo[] BulletInfo;

    public static void InitBullets() {
        nBulletCount = 0;
        nBulletsFree = 500;
        for (int i = 0; i < 500; ++i) {
            Bullet.BulletFree[i] = (short)i;
            Bullet.BulletList[i] = new BulletStruct();
        }
        Arrays.fill(nBulletEnemy, (short)-1);
    }

    public static ByteBuffer saveBullets() {
        ByteBuffer bb = ByteBuffer.allocate(18022);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)nBulletCount);
        bb.putShort((short)nBulletsFree);
        for (int i = 0; i < 500; ++i) {
            bb.putShort(BulletFree[i]);
            bb.putShort(nBulletEnemy[i]);
            BulletList[i].save(bb);
        }
        bb.putInt(lasthitx);
        bb.putInt(lasthity);
        bb.putInt(lasthitz);
        bb.putShort((short)lasthitsect);
        bb.putShort((short)lasthitwall);
        bb.putShort((short)lasthitsprite);
        return bb;
    }

    public static void loadBullets(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nBulletCount = bb.readShort().shortValue();
            loader.nBulletsFree = bb.readShort().shortValue();
            for (int i = 0; i < 500; ++i) {
                loader.BulletFree[i] = bb.readShort();
                loader.nBulletEnemy[i] = bb.readShort();
                if (loader.BulletList[i] == null) {
                    loader.BulletList[i] = new BulletStruct();
                }
                loader.BulletList[i].load(bb);
            }
            loader.lasthitx = bb.readInt();
            loader.lasthity = bb.readInt();
            loader.lasthitz = bb.readInt();
            loader.lasthitsect = bb.readShort().shortValue();
            loader.lasthitwall = bb.readShort().shortValue();
            loader.lasthitsprite = bb.readShort().shortValue();
        } else {
            nBulletCount = loader.nBulletCount;
            nBulletsFree = loader.nBulletsFree;
            System.arraycopy(loader.BulletFree, 0, BulletFree, 0, 500);
            System.arraycopy(loader.nBulletEnemy, 0, nBulletEnemy, 0, 500);
            for (int i = 0; i < 500; ++i) {
                if (BulletList[i] == null) {
                    Bullet.BulletList[i] = new BulletStruct();
                }
                BulletList[i].copy(loader.BulletList[i]);
            }
            lasthitx = loader.lasthitx;
            lasthity = loader.lasthity;
            lasthitz = loader.lasthitz;
            lasthitsect = loader.lasthitsect;
            lasthitwall = loader.lasthitwall;
            lasthitsprite = loader.lasthitsprite;
        }
    }

    public static int GrabBullet() {
        return BulletFree[--nBulletsFree];
    }

    public static int DestroyBullet(int nBullet) {
        short nSprite = Bullet.BulletList[nBullet].nSprite;
        RunList.DoSubRunRec(Bullet.BulletList[nBullet].bull_6);
        RunList.DoSubRunRec(Engine.sprite[nSprite].lotag - 1);
        RunList.SubRunRec(Bullet.BulletList[nBullet].bull_8);
        Sound.StopSpriteSound(nSprite);
        Main.engine.mydeletesprite(nSprite);
        Bullet.BulletFree[Bullet.nBulletsFree] = (short)nBullet;
        return ++nBulletsFree;
    }

    public static void IgniteSprite(int nSprite) {
        Engine.sprite[nSprite].hitag = (short)(Engine.sprite[nSprite].hitag + 2);
        int v5 = Anim.GetAnimSprite(Anim.BuildAnim(-1, 38, 0, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, Engine.sprite[nSprite].sectnum, 40, 20));
        Engine.sprite[v5].hitag = (short)nSprite;
        Main.engine.changespritestat((short)v5, 404);
        Engine.sprite[v5].yrepeat = (short)Math.max(32 * Main.engine.getTile(Engine.sprite[v5].picnum).getHeight() / Globals.nFlameHeight, 1);
    }

    public static void BulletHitsSprite(BulletStruct pBullet, int nSource, int nDest, int x, int y, int z, int sectnum) {
        BulletInfo pBulletInfo = BulletInfo[pBullet.type];
        short type = pBullet.type;
        short statnum = Engine.sprite[nDest].statnum;
        switch (type) {
            case 14: {
                if (statnum > 107 || statnum == 98) {
                    return;
                }
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                if (statnum == 0 || statnum > 98) break;
                SPRITE pDest = Engine.sprite[nDest];
                SPRITE pSprite = Engine.sprite[pBullet.nSprite];
                if (statnum == 98) {
                    int v20 = pSprite.ang + 256 - Random.RandomSize(9);
                    pDest.xvel = (short)(2 * Engine.sintable[v20 + 512 & 0x7FF]);
                    pDest.yvel = (short)(2 * Engine.sintable[v20 & 0x7FF]);
                    pDest.zvel = (short)(-256 * (Random.RandomSize(3) + 1));
                    break;
                }
                short v15 = pDest.xvel;
                short v17 = pDest.yvel;
                pDest.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 2);
                pDest.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 2);
                Enemy.MoveCreature(nDest);
                pDest.xvel = v15;
                pDest.yvel = v17;
                break;
            }
            case 3: {
                if (statnum <= 107 && statnum != 98) {
                    Engine.sprite[nDest].hitag = (short)(Engine.sprite[nDest].hitag + 1);
                    if (Engine.sprite[nDest].hitag == 15) {
                        Bullet.IgniteSprite(nDest);
                    }
                    if (Random.RandomSize(2) == 0) {
                        Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, x, y, z, sectnum, 40, pBulletInfo.inf_E);
                        return;
                    }
                }
                return;
            }
        }
        int damage = pBulletInfo.force;
        if (pBullet.bull_13 > 1) {
            damage *= 2;
        }
        Sprites.DamageEnemy(nDest, nSource, damage);
        if (statnum > 90 && statnum < 199) {
            switch (statnum) {
                case 97: {
                    return;
                }
                case 98: 
                case 102: 
                case 141: 
                case 152: {
                    Anim.BuildAnim(-1, 12, 0, x, y, z, sectnum, 40, 0);
                    return;
                }
            }
            Anim.BuildAnim(-1, 39, 0, x, y, z, sectnum, 40, 0);
            if (pBullet.type <= 2) {
                return;
            }
            Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, x, y, z, sectnum, 40, pBulletInfo.inf_E);
            return;
        }
        Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, x, y, z, sectnum, 40, pBulletInfo.inf_E);
    }

    public static Vector2 BackUpBullet(int a1, int a2, int a3) {
        return tmpVec.set(a1 -= Engine.sintable[a3 + 512 & 0x7FF] >> 11, a2 -= Engine.sintable[a3 & 0x7FF] >> 11);
    }

    public static void SetBulletEnemy(short a1, int a2) {
        if (a1 >= 0) {
            Bullet.nBulletEnemy[a1] = (short)a2;
        }
    }

    public static int BuildBullet(int a1, int nType, int a3, int a4, int wz, int a6, int zAngle, int a8) {
        int spr;
        BulletInfo pBullet = BulletInfo[nType];
        if (pBullet.inf_4 > 30000 && zAngle >= 10000) {
            int v88 = zAngle - 10000;
            SPRITE v11 = Engine.sprite[v88];
            if ((v11.cstat & 0x101) != 0 && Gameutils.isValidSector(v11.sectnum)) {
                short i = Main.engine.insertsprite(Engine.sprite[a1].sectnum, 200);
                Engine.sprite[i].ang = (short)a6;
                Bullet.tmpBullet.nSprite = i;
                Bullet.tmpBullet.type = (short)nType;
                Bullet.tmpBullet.bull_13 = (byte)a8;
                Bullet.BulletHitsSprite(tmpBullet, a1 & 0xFFFF, v88, v11.x, v11.y, v11.z - (Sprites.GetSpriteHeight(v88) >> 1), v11.sectnum);
                Main.engine.mydeletesprite(i);
                return -1;
            }
            zAngle = v11.cstat & 0x101;
        }
        if (nBulletsFree == 0) {
            return -1;
        }
        short v19 = Engine.sprite[a1].sectnum;
        if (Engine.sprite[a1].statnum == 100) {
            v19 = Globals.nPlayerViewSect[Player.GetPlayerFromSprite(a1)];
        }
        if ((spr = Main.engine.insertsprite(v19, 200)) < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return -1;
        }
        int v21 = Sprites.GetSpriteHeight(a1);
        if (wz == -1) {
            wz = -(v21 - (v21 >> 2));
        }
        Engine.sprite[spr].x = Engine.sprite[a1].x;
        Engine.sprite[spr].y = Engine.sprite[a1].y;
        Engine.sprite[spr].z = Engine.sprite[a1].z;
        int nBullet = Bullet.GrabBullet();
        BulletStruct v35 = BulletList[nBullet];
        Bullet.nBulletEnemy[nBullet] = -1;
        Engine.sprite[spr].cstat = 0;
        Engine.sprite[spr].shade = (byte)-64;
        Engine.sprite[spr].pal = (pBullet.inf_E & 4) != 0 ? (short)4 : (short)0;
        Engine.sprite[spr].clipdist = 25;
        int v31 = pBullet.inf_12;
        if (v31 < 0) {
            v31 = 30;
        }
        Engine.sprite[spr].xrepeat = (short)v31;
        Engine.sprite[spr].yrepeat = (short)v31;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = (short)a6;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].owner = (short)a1;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        Engine.sprite[spr].hitag = 0;
        v35.bull_10 = 0;
        v35.bull_E = pBullet.inf_2;
        v35.frmOffset = 0;
        if (pBullet.inf_8 == -1) {
            v35.bull_12 = 1;
            v35.baseSeq = pBullet.inf_A;
        } else {
            v35.bull_12 = 0;
            v35.baseSeq = pBullet.inf_8;
        }
        Engine.sprite[spr].picnum = Seq.GetSeqPicnum(v35.baseSeq, 0, 0);
        if (v35.baseSeq == 31) {
            Engine.sprite[spr].cstat = (short)(Engine.sprite[spr].cstat | 0x8000);
        }
        v35.zang = (short)zAngle;
        v35.type = (short)nType;
        v35.nSprite = spr;
        v35.bull_6 = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0xB0000 | nBullet);
        v35.bull_8 = (short)RunList.AddRunRec(RunList.NewRun, 0xB0000 | nBullet);
        v35.bull_13 = (byte)a8;
        Engine.sprite[spr].z += wz;
        short sect = Engine.sprite[spr].sectnum;
        while (Engine.sprite[spr].z < Engine.sector[sect].ceilingz) {
            if (Globals.SectAbove[sect] == -1) {
                Engine.sprite[spr].z = Engine.sector[sect].ceilingz;
                break;
            }
            Main.engine.mychangespritesect((short)spr, Globals.SectAbove[sect]);
            sect = Globals.SectAbove[sect];
        }
        int zvec = 0;
        if (zAngle >= 10000) {
            int v89 = zAngle - 10000;
            if (pBullet.inf_4 > 30000) {
                Bullet.nBulletEnemy[nBullet] = (short)v89;
            } else {
                int dy;
                int dx;
                int v51 = Sprites.GetSpriteHeight(v89);
                int v53 = Engine.sprite[v89].statnum == 100 ? v51 >> 2 : v51 >> 1;
                int dz = Engine.sprite[v89].z - (v51 - v53);
                if (a1 == -1 || Engine.sprite[a1].statnum == 100) {
                    dx = Engine.sprite[v89].x - Engine.sprite[spr].x;
                    dy = Engine.sprite[v89].y - Engine.sprite[spr].y;
                } else {
                    int sx = Engine.sprite[v89].x;
                    int sy = Engine.sprite[v89].y;
                    if (Engine.sprite[v89].statnum == 100) {
                        short plr = Player.GetPlayerFromSprite(v89);
                        if (plr > -1) {
                            int pxvel = 15 * Globals.nPlayerDX[plr];
                            int pyvel = 15 * Globals.nPlayerDY[plr];
                            if (!Globals.isOriginal()) {
                                pxvel = Gameutils.BClipRange(pxvel, -1000, 1000);
                                pyvel = Gameutils.BClipRange(pyvel, -1000, 1000);
                            }
                            sx += pxvel;
                            sy += pyvel;
                        }
                    } else {
                        sx += 20 * Engine.sprite[v89].xvel >> 6;
                        sy += 20 * Engine.sprite[v89].yvel >> 6;
                    }
                    dy = sy - Engine.sprite[spr].y;
                    dx = sx - Engine.sprite[spr].x;
                    a6 = Main.engine.GetMyAngle(dx, dy);
                    Engine.sprite[a1].ang = (short)a6;
                }
                int v67 = Main.engine.ksqrt(dx * dx + dy * dy);
                zvec = v67 != 0 ? (dz - Engine.sprite[spr].z) * pBullet.inf_4 / v67 : 0;
            }
        } else {
            zvec = Globals.isOriginal() ? pBullet.inf_4 * -Engine.sintable[zAngle & 0x7FF] >> 11 : -(zAngle / 32) * pBullet.inf_4;
        }
        int dist = 4 * Engine.sprite[a1].clipdist;
        v35.xvec = dist * Engine.sintable[a6 + 512 & 0x7FF];
        v35.yvec = dist * Engine.sintable[a6 & 0x7FF];
        v35.zvec = 0;
        Bullet.nBulletEnemy[nBullet] = -1;
        if (Bullet.MoveBullet(nBullet)) {
            spr = -1;
        } else {
            v35.bull_10 = (short)pBullet.inf_4;
            v35.xvec = pBullet.inf_4 * (Engine.sintable[a6 + 512 & 0x7FF] >> 3);
            v35.yvec = pBullet.inf_4 * (Engine.sintable[a6 & 0x7FF] >> 3);
            v35.zvec = zvec >> 3;
        }
        return spr | nBullet << 16;
    }

    private static boolean MoveBullet(int nBullet) {
        BulletStruct pBullet = BulletList[nBullet];
        short type = pBullet.type;
        BulletInfo pBulletInfo = BulletInfo[type];
        short nSprite = pBullet.nSprite;
        SPRITE pSprite = Engine.sprite[pBullet.nSprite];
        if (!Gameutils.isValidSector(pSprite.sectnum)) {
            return false;
        }
        short nSectFlag = Globals.SectFlag[pSprite.sectnum];
        int hitsec = -1;
        int hitwall = -1;
        int hitspr = -1;
        int hitx = 0;
        int hity = 0;
        int hitz = 0;
        boolean out = false;
        if ((pBullet.bull_10 & 0xFFFF) >= 30000) {
            out = true;
            if (nBulletEnemy[nBullet] == -1) {
                int zvel = Globals.isOriginal() ? -8 * Engine.sintable[pBullet.zang & 0x7FF] : -16 * pBullet.zang * 32;
                Main.engine.hitscan(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sintable[pSprite.ang + 512 & 0x7FF], Engine.sintable[pSprite.ang], zvel, Engine.pHitInfo, 0x1000040);
                hitx = Engine.pHitInfo.hitx;
                hity = Engine.pHitInfo.hity;
                hitz = Engine.pHitInfo.hitz;
                hitsec = Engine.pHitInfo.hitsect;
                hitwall = Engine.pHitInfo.hitwall;
                hitspr = Engine.pHitInfo.hitsprite;
            } else {
                int nEnemy = nBulletEnemy[nBullet];
                hitx = Engine.sprite[nEnemy].x;
                hity = Engine.sprite[nEnemy].y;
                hitz = Engine.sprite[nEnemy].z - (Sprites.GetSpriteHeight(nEnemy) >> 1);
                hitsec = Engine.sprite[nEnemy].sectnum;
                hitspr = nEnemy;
            }
            lasthitx = hitx;
            lasthity = hity;
            lasthitz = hitz;
            lasthitsect = hitsec;
            lasthitwall = hitwall;
            lasthitsprite = hitspr;
        } else {
            short v9 = nBulletEnemy[nBullet];
            int moveHit = 0;
            if (v9 == -1 || (Engine.sprite[v9].cstat & 0x101) == 0) {
                Bullet.nBulletEnemy[nBullet] = -1;
                if (type == 3) {
                    if (pBullet.bull_E >= 8) {
                        pSprite.xrepeat = (short)(pSprite.xrepeat + 4);
                        pSprite.yrepeat = (short)(pSprite.yrepeat + 4);
                    } else {
                        pSprite.xrepeat = (short)(pSprite.xrepeat - 1);
                        pSprite.yrepeat = (short)(pSprite.yrepeat + 8);
                        pBullet.zvec -= 200;
                        if (pSprite.shade < 90) {
                            pSprite.shade = (byte)(pSprite.shade + 35);
                        }
                        if (pBullet.bull_E == 3) {
                            pBullet.baseSeq = (short)45;
                            pBullet.frmOffset = 0;
                            pSprite.xrepeat = (short)40;
                            pSprite.yrepeat = (short)40;
                            pSprite.shade = 0;
                            pSprite.z += 512;
                        }
                    }
                }
                moveHit = Main.engine.movesprite(nSprite, pBullet.xvec, pBullet.yvec, pBullet.zvec, pSprite.clipdist >> 1, pSprite.clipdist >> 1, 1);
            } else {
                moveHit = Sprites.AngleChase(nSprite, v9, pBullet.bull_10 & 0xFFFF, 0, 16);
            }
            boolean bl = out = moveHit != 0;
            if (out) {
                hitx = pSprite.x;
                hity = pSprite.y;
                hitz = pSprite.z;
                hitsec = pSprite.sectnum;
                if ((moveHit & 0x30000) != 0 || (moveHit & 0xC000) == 32768) {
                    hitwall = moveHit & 0x3FFF;
                } else if ((moveHit & 0xC000) == 49152) {
                    hitspr = moveHit & 0x3FFF;
                }
            }
            if (hitwall == -1 && hitspr == -1) {
                if (((nSectFlag ^ Globals.SectFlag[pSprite.sectnum]) >> 8 & 0x20) != 0) {
                    Bullet.DestroyBullet(nBullet);
                    out = true;
                }
                if (!out && type != 15 && type != 3) {
                    Light.AddFlash(Engine.sprite[nSprite].sectnum, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, 0);
                    if (Engine.sprite[nSprite].pal != 5) {
                        Engine.sprite[nSprite].pal = 1;
                    }
                }
                return out;
            }
        }
        if (hitspr != -1) {
            if (pSprite.pal != 5 || Engine.sprite[hitspr].statnum != 100) {
                Bullet.BulletHitsSprite(pBullet, pSprite.owner, hitspr, hitx, hity, hitz, hitsec);
            } else {
                short plr = Player.GetPlayerFromSprite(hitspr);
                if (Globals.PlayerList[plr].mummified == 0) {
                    Globals.PlayerList[plr].mummified = 1;
                    Weapons.SetNewWeapon(plr, 7);
                }
            }
        } else if (hitwall != -1 && Engine.wall[hitwall].picnum == 3604 && Engine.wall[hitwall].nextsector > -1) {
            int v31 = Bullet.BulletInfo[pBullet.type].force;
            if (pBullet.bull_13 > 1) {
                v31 *= 2;
            }
            Sprites.DamageEnemy(Engine.sector[Engine.wall[hitwall].nextsector].extra, Main.engine.GetWallNormal(hitwall) & 0x7FF, v31);
        }
        if (hitsec != -1) {
            if (hitwall != -1 || hitspr != -1) {
                if (hitwall == -1) {
                    pSprite.x = hitx;
                    pSprite.y = hity;
                    pSprite.z = hitz;
                    Main.engine.mychangespritesect(nSprite, (short)hitsec);
                } else {
                    Vector2 vec = Bullet.BackUpBullet(hitx, hity, pSprite.ang);
                    hitx = (int)vec.x;
                    hity = (int)vec.y;
                    if (type != 3 || Random.RandomSize(2) == 0) {
                        int v38 = Random.RandomSize(8);
                        int v37 = Random.RandomBit();
                        int v39 = 8 * v38;
                        if (v37 == 0) {
                            v39 = -v39;
                        }
                        Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, hitx, hity, hitz + v39, hitsec, 40, pBulletInfo.inf_E);
                    }
                }
                if (pBulletInfo.inf_10 != 0) {
                    Globals.nRadialBullet = type;
                    Sprites.RadialDamageEnemy(nSprite, pBulletInfo.force, pBulletInfo.inf_10);
                    Globals.nRadialBullet = (short)-1;
                    Light.AddFlash(pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 128);
                }
            } else if (Globals.SectBelow[hitsec] >= 0 && (Globals.SectFlag[Globals.SectBelow[hitsec]] & 0x2000) != 0 || Globals.SectDepth[hitsec] != 0) {
                pSprite.x = hitx;
                pSprite.y = hity;
                pSprite.z = hitz;
                Sprites.BuildSplash(nSprite, hitsec);
            } else {
                Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, hitx, hity, hitz, hitsec, 40, pBulletInfo.inf_E);
            }
        }
        Bullet.DestroyBullet(nBullet);
        return out;
    }

    public static void FuncBullet(int a1, int a2, int RunPtr) {
        short nBullet = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nBullet < 0 || nBullet >= 500) {
            Main.game.ThrowError("nBullet>=0 && nBullet<MAX_BULLETS");
            return;
        }
        BulletStruct pBullet = BulletList[nBullet];
        short nSprite = pBullet.nSprite;
        if ((a1 & 0x7F0000) == 131072) {
            int v17 = Seq.SeqOffsets[pBullet.baseSeq];
            short v8 = pBullet.frmOffset;
            Seq.MoveSequence(nSprite, v17, v8);
            if ((Seq.FrameFlag[v8 + Seq.SeqBase[v17]] & 0x80) != 0) {
                Anim.BuildAnim(-1, 45, 0, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, Engine.sprite[nSprite].sectnum, Engine.sprite[nSprite].xrepeat, 0);
            }
            pBullet.frmOffset = (short)(pBullet.frmOffset + 1);
            if (pBullet.frmOffset >= Seq.SeqSize[v17]) {
                if (pBullet.bull_12 == 0) {
                    pBullet.baseSeq = Bullet.BulletInfo[pBullet.type].inf_A;
                    pBullet.bull_12 = (byte)(pBullet.bull_12 + 1);
                }
                pBullet.frmOffset = 0;
            }
            if (pBullet.bull_E == -1 || (pBullet.bull_E = (short)(pBullet.bull_E - 1)) != 0) {
                Bullet.MoveBullet(nBullet);
            } else {
                Bullet.DestroyBullet(nBullet);
            }
        } else if ((a1 & 0x7F0000) == 589824) {
            int spr = a1 & 0xFFFF;
            Engine.tsprite[spr].statnum = (short)1000;
            if (pBullet.type == 15) {
                Seq.PlotArrowSequence(spr, Seq.SeqOffsets[pBullet.baseSeq], pBullet.frmOffset);
            } else {
                Seq.PlotSequence(spr, Seq.SeqOffsets[pBullet.baseSeq], pBullet.frmOffset, 0);
                Engine.tsprite[spr].owner = (short)-1;
            }
        }
    }

    static {
        BulletFree = new short[500];
        nBulletEnemy = new short[500];
        BulletList = new BulletStruct[500];
        BulletInfo = new BulletInfo[]{new BulletInfo(25, 1, 20, 65535, 65535, 13, 0, 0, 65535), new BulletInfo(25, 65535, 65000, 65535, 31, 73, 0, 0, 65535), new BulletInfo(15, 65535, 60000, 65535, 31, 73, 0, 0, 65535), new BulletInfo(5, 15, 2000, 65535, 14, 38, 4, 5, 3), new BulletInfo(250, 100, 2000, 65535, 33, 34, 4, 20, 65535), new BulletInfo(200, 65535, 2000, 65535, 20, 23, 4, 10, 65535), new BulletInfo(200, 65535, 60000, 68, 68, 65535, 65535, 0, 65535), new BulletInfo(300, 1, 0, 65535, 65535, 65535, 0, 50, 65535), new BulletInfo(18, 65535, 2000, 65535, 18, 29, 4, 0, 65535), new BulletInfo(20, 65535, 2000, 37, 11, 30, 4, 0, 65535), new BulletInfo(25, 65535, 3000, 65535, 44, 36, 4, 15, 90), new BulletInfo(30, 65535, 1000, 65535, 52, 53, 4, 20, 48), new BulletInfo(20, 65535, 3500, 65535, 54, 55, 4, 30, 65535), new BulletInfo(10, 65535, 5000, 65535, 57, 76, 4, 0, 65535), new BulletInfo(40, 65535, 1500, 65535, 63, 38, 4, 10, 40), new BulletInfo(20, 65535, 2000, 65535, 60, 12, 0, 0, 65535), new BulletInfo(5, 65535, 60000, 65535, 31, 76, 0, 0, 65535)};
    }
}

