/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Sound;

public class Cinema {
    private static int line;
    private static int linecount;
    private static final short[] nBeforeScene;
    private static final short[] nAfterScene;
    public static int nCrawlY;
    public static int nHeight;
    public static int nextclock;
    private static short[] nLeft;

    public static void ReadyCinemaText(int a1) {
        line = Main.game.FindGString("CINEMAS");
        if (line >= 0) {
            while (a1 != 0) {
                while (!Globals.gString[line].equals("END")) {
                    ++line;
                }
                ++line;
                --a1;
            }
            Cinema.ComputeCinemaText(line);
        }
    }

    public static boolean CheckBeforeScene(int nNewLevel, Runnable run) {
        if (nNewLevel == 20) {
            return Cinema.DoLastLevelCinema(run);
        }
        short num = nBeforeScene[Math.max(nNewLevel - 1, 0)];
        if (num != 0) {
            return Cinema.GoToTheCinema(num, run);
        }
        return false;
    }

    public static boolean DoAfterCinemaScene(int nLevel, Runnable run) {
        short num = nAfterScene[Math.max(nLevel - 1, 0)];
        if (num != 0) {
            return Cinema.GoToTheCinema(num, run);
        }
        return false;
    }

    public static boolean DoLastLevelCinema(Runnable run) {
        Main.gCinemaScreen.setNum(8).setSkipping(run).escSkipping(true);
        Main.game.changeScreen(Main.gCinemaScreen);
        return true;
    }

    public static boolean GoToTheCinema(int num, Runnable run) {
        Main.gCinemaScreen.setNum(num).setSkipping(run).escSkipping(true);
        Main.game.changeScreen(Main.gCinemaScreen);
        return true;
    }

    public static void ComputeCinemaText(int line) {
        linecount = 0;
        while (!Globals.gString[line + linecount].equals("END")) {
            Cinema.nLeft[Cinema.linecount] = (short)(160 - Main.game.getFont(0).getWidth(Globals.gString[line + linecount]) / 2);
            ++linecount;
        }
        nCrawlY = 199;
        nHeight = (Main.game.getFont(0).getHeight() + 4) * linecount;
        nextclock = Engine.totalclock;
    }

    public static boolean AdvanceCinemaText() {
        int height = Main.game.getFont(0).getHeight() + 4;
        int i = 0;
        for (int y = nCrawlY; i < linecount && y <= 199; ++i, y += height) {
            if (y < -height) continue;
            Cinema.myprintext(nLeft[i], y, Globals.gString[i + line], 0);
        }
        return nHeight + nCrawlY > 0;
    }

    public static int myprintext(int x, int y, String text, int shade) {
        if (y < -15 || y >= 200) {
            return 0;
        }
        return Main.game.getFont(0).drawText(x, y, text, 65536, 0, 0, BuildFont.TextAlign.Left, 18, true);
    }

    public static void DoFailedFinalScene() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Cinema.GoToTheCinema(4, Main.game.rMenu);
            }
        });
    }

    public static void DoGameOverScene() {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Palette.LoadCinemaPalette(16);
                Sound.PlayGameOverSound();
                Main.engine.setbrightness(BuildSettings.paletteGamma.get(), Palette.cinemapal, GLRenderer.GLInvalidateFlag.All);
                Main.game.changeScreen(Main.gLogoScreen.setTime(10.0f).setTile(3591).setCallback(Main.game.rMenu).setSkipping(Main.game.rMenu));
            }
        });
    }

    static {
        nBeforeScene = new short[]{0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        nAfterScene = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 7, 0, 0, 0, 0, 6};
        nLeft = new short[50];
    }
}

