/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Lion {
    public static final int MAXLION = 40;
    private static int LionCount;
    private static LionStruct[] LionList;
    private static final short[][] ActionSeq_X_13;

    public static void InitLion() {
        LionCount = 40;
    }

    public static ByteBuffer saveLion() {
        ByteBuffer bb = ByteBuffer.allocate((40 - LionCount) * 18 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)LionCount);
        for (int i = LionCount; i < 40; ++i) {
            LionList[i].save(bb);
        }
        return bb;
    }

    public static void loadLion(SafeLoader loader, Resource bb) {
        if (bb != null) {
            for (int i = loader.LionCount = (int)bb.readShort().shortValue(); i < 40; ++i) {
                if (loader.LionList[i] == null) {
                    loader.LionList[i] = new LionStruct();
                }
                loader.LionList[i].load(bb);
            }
        } else {
            LionCount = loader.LionCount;
            for (int i = loader.LionCount; i < 40; ++i) {
                if (LionList[i] == null) {
                    Lion.LionList[i] = new LionStruct();
                }
                LionList[i].copy(loader.LionList[i]);
            }
        }
    }

    public static void BuildLion(int spr, int x, int y, int z, int sectnum, int ang) {
        int count;
        if ((count = --LionCount) < 0) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, 104);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 104);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xrepeat = (short)40;
        Engine.sprite[spr].yrepeat = (short)40;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 60;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (LionList[count] == null) {
            Lion.LionList[count] = new LionStruct();
        }
        Lion.LionList[count].nState = 0;
        Lion.LionList[count].nHealth = (short)500;
        Lion.LionList[count].nSeq = 0;
        Lion.LionList[count].nSprite = (short)spr;
        Lion.LionList[count].nTarget = (short)-1;
        Lion.LionList[count].field_C = 0;
        Lion.LionList[count].field_A = (short)count;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x130000 | count);
        Lion.LionList[count].MoveHook = (short)RunList.AddRunRec(RunList.NewRun, 0x130000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncLion(int a1, int nDamage, int RunPtr) {
        short nLion = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nLion < 0 || nLion >= 40) {
            Main.game.ThrowError("lion>=0 && lion<MAXLION");
            return;
        }
        LionStruct pLion = LionList[nLion];
        short nSprite = pLion.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        boolean v114 = false;
        short nState = pLion.nState;
        short nTarget = pLion.nTarget;
        short nObject = (short)(a1 & 0xFFFF);
        switch (a1 & 0x7F0000) {
            case 131072: {
                if (nState != 7) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_13[nState][0] + Seq.SeqOffsets[40];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pLion.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pLion.nSeq);
                pLion.nSeq = (short)(pLion.nSeq + 1);
                if (pLion.nSeq >= Seq.SeqSize[nSeq]) {
                    pLion.nSeq = 0;
                    v114 = true;
                }
                short nFlags = Seq.FrameFlag[pLion.nSeq + Seq.SeqBase[nSeq]];
                int moveHit = Enemy.MoveCreatureWithCaution(nSprite);
                switch (nState) {
                    case 0: 
                    case 1: {
                        int nTarg = -1;
                        if ((pLion.field_A & 0x1F) != (Globals.totalmoves & 0x1F) || nTarget >= 0 || (nTarg = Enemy.FindPlayer(nSprite, 40)) < 0) {
                            if (nState != 0 && (pLion.field_C = (short)(pLion.field_C - 1)) <= 0) {
                                if (Random.RandomBit() != 0) {
                                    pSprite.ang = (short)(Random.RandomWord() & 0x7FF);
                                    pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                                    pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 1);
                                } else {
                                    pSprite.xvel = 0;
                                    pSprite.yvel = 0;
                                }
                                pLion.field_C = (short)100;
                            }
                        } else {
                            Sound.D3PlayFX(Sound.StaticSound[24], nSprite);
                            pLion.nState = (short)2;
                            pLion.nSeq = 0;
                            pLion.nTarget = (short)nTarg;
                            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                            pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 1);
                        }
                        return;
                    }
                    case 2: {
                        if ((Globals.totalmoves & 0x1F) == (pLion.field_A & 0x1F)) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            int ang = pSprite.ang & 0xFFF8;
                            if ((pSprite.cstat & 0x8000) != 0) {
                                pSprite.xvel = (short)(2 * Engine.sintable[ang + 512 & 0x7FF]);
                                pSprite.yvel = (short)(2 * Engine.sintable[ang & 0x7FF]);
                            } else {
                                pSprite.xvel = (short)(Engine.sintable[ang + 512 & 0x7FF] >> 1);
                                pSprite.yvel = (short)(Engine.sintable[ang & 0x7FF] >> 1);
                            }
                        }
                        switch (moveHit & 0xC000) {
                            case 49152: {
                                if ((moveHit & 0x3FFF) == nTarget) {
                                    if ((pSprite.cstat & 0x8000) != 0) {
                                        pLion.nState = (short)9;
                                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFF7FFF);
                                        pSprite.xvel = 0;
                                        pSprite.yvel = 0;
                                    } else if (Sprites.AngleDiff(pSprite.ang, Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) < 64) {
                                        pLion.nState = (short)3;
                                    }
                                    pLion.nSeq = 0;
                                }
                            }
                            case 32768: {
                                pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
                                pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                                pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 1);
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (nTarget == -1) {
                            pLion.nState = 1;
                            pLion.field_C = (short)50;
                            break;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pLion.nState = (short)2;
                            break;
                        }
                        if ((nFlags & 0x80) == 0) break;
                        Sprites.DamageEnemy(nTarget, nSprite, 10);
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (v114) {
                            RunList.SubRunRec(pSprite.owner);
                            RunList.SubRunRec(pLion.MoveHook);
                            pSprite.cstat = Short.MIN_VALUE;
                        }
                        return;
                    }
                    case 4: {
                        if (v114) {
                            pLion.nState = (short)2;
                            pLion.nSeq = 0;
                        }
                        if ((moveHit & 0x200) != 0) {
                            pSprite.xvel = (short)(pSprite.xvel >> 1);
                            pSprite.yvel = (short)(pSprite.yvel >> 1);
                        }
                        return;
                    }
                    case 8: {
                        if (v114) {
                            pLion.nSeq = 0;
                            pLion.nState = (short)2;
                            pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                        }
                        return;
                    }
                    case 9: {
                        if (v114) {
                            pLion.nSeq = 0;
                            pLion.nState = (short)2;
                            pSprite.cstat = (short)(pSprite.cstat | 0x101);
                        }
                        return;
                    }
                    case 6: {
                        if ((moveHit & 0x30000) != 0) {
                            pLion.nState = (short)2;
                            pLion.nSeq = 0;
                        } else if ((moveHit & 0xC000) == 32768) {
                            pLion.nState = (short)7;
                            pSprite.ang = (short)(Main.engine.GetWallNormal(moveHit & 0x3FFF) + 1024 & 0x7FF);
                            pLion.field_C = (short)Random.RandomSize(4);
                        } else if ((moveHit & 0xC000) == 49152) {
                            if ((moveHit & 0x3FFF) == nTarget) {
                                if (Sprites.AngleDiff(pSprite.ang, Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) < 64) {
                                    pLion.nState = (short)3;
                                    pLion.nSeq = 0;
                                }
                            } else {
                                pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
                                pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                                pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 1);
                                break;
                            }
                        }
                        return;
                    }
                    case 5: 
                    case 7: {
                        pLion.field_C = (short)(pLion.field_C - 1);
                        if (pLion.field_C <= 0) {
                            pLion.field_C = 0;
                            if (nState == 7) {
                                if (nTarget <= -1) {
                                    pSprite.ang = (short)(pSprite.ang + Random.RandomSize(9) & 0x7FF);
                                } else {
                                    Enemy.PlotCourseToSprite(nSprite, nTarget);
                                }
                                pSprite.zvel = (short)-1000;
                            } else {
                                pSprite.zvel = (short)-4000;
                                short ang = pSprite.ang;
                                int hita = ang - 512 & 0x7FF;
                                int xs = pSprite.x;
                                int ys = pSprite.y;
                                int zs = pSprite.z - Sprites.GetSpriteHeight(nSprite) >> 1;
                                short sectnum = pSprite.sectnum;
                                int v104 = Integer.MAX_VALUE;
                                for (int i = 0; i < 5; ++i) {
                                    int v70;
                                    Main.engine.hitscan(xs, ys, zs, sectnum, Engine.sintable[hita + 512 & 0x7FF], Engine.sintable[hita & 0x7FF], 0, Engine.pHitInfo, 0x1000040);
                                    if (Engine.pHitInfo.hitwall != -1 && (v70 = Pragmas.klabs(Engine.pHitInfo.hitx - xs) + Pragmas.klabs(Engine.pHitInfo.hity - ys)) < v104) {
                                        v104 = v70;
                                        ang = (short)hita;
                                    }
                                    hita = hita + 256 & 0x7FF;
                                }
                                pSprite.ang = ang;
                            }
                            pLion.nState = (short)6;
                            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] - (Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 3));
                            pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] - (Engine.sintable[pSprite.ang & 0x7FF] >> 3));
                            Sound.D3PlayFX(Sound.StaticSound[24], nSprite);
                        }
                        return;
                    }
                }
                if (nState != 1 && nTarget != -1 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
                    pLion.nState = 1;
                    pLion.nSeq = 0;
                    pLion.field_C = (short)100;
                    pLion.nTarget = (short)-1;
                    pSprite.xvel = 0;
                    pSprite.yvel = 0;
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_13[nState][0] + Seq.SeqOffsets[40], pLion.nSeq, ActionSeq_X_13[nState][1]);
                return;
            }
            case 655360: {
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pLion.nHealth > 0) {
                    pLion.nHealth = (short)(pLion.nHealth - nDamage);
                    if (pLion.nHealth > 0) {
                        if (nObject >= 0) {
                            if (Engine.sprite[nObject].statnum < 199) {
                                pLion.nTarget = nObject;
                            }
                            if (nState != 6) {
                                if (Random.RandomSize(8) <= pLion.nHealth) {
                                    pLion.nState = (short)4;
                                    pSprite.xvel = 0;
                                    pSprite.yvel = 0;
                                } else if (Random.RandomSize(1) != 0) {
                                    Enemy.PlotCourseToSprite(nSprite, nObject);
                                    pSprite.ang = (short)(pSprite.ang - (Random.RandomSize(1) << 8));
                                    pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(1) << 8));
                                    pSprite.ang = (short)(pSprite.ang & 0x7FF);
                                    pLion.nState = (short)5;
                                    pLion.field_C = (short)Random.RandomSize(3);
                                } else {
                                    pSprite.xvel = 0;
                                    pSprite.yvel = 0;
                                    pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                                    pLion.nState = (short)8;
                                }
                                pLion.nSeq = 0;
                            }
                        }
                    } else {
                        pSprite.xvel = 0;
                        pSprite.yvel = 0;
                        pSprite.zvel = 0;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        pLion.nHealth = 0;
                        if (pLion.nState < 10) {
                            Enemy.DropMagic(nSprite);
                            pLion.nState = (short)(((a1 & 0x7F0000) == 655360 ? 1 : 0) + 10);
                            pLion.nSeq = 0;
                        }
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
    }

    static {
        LionList = new LionStruct[40];
        ActionSeq_X_13 = new short[][]{{54, 1}, {18, 0}, {0, 0}, {10, 0}, {44, 0}, {18, 0}, {26, 0}, {34, 0}, {8, 1}, {9, 1}, {52, 1}, {53, 1}};
    }

    public static class LionStruct
    extends Enemy.EnemyStruct {
        public static final int size = 18;
        public short MoveHook;

        @Override
        public void save(ByteBuffer bb) {
            super.save(bb);
            bb.putShort(this.MoveHook);
        }

        @Override
        public void load(Resource bb) {
            super.load(bb);
            this.MoveHook = bb.readShort();
        }

        public LionStruct copy(LionStruct src) {
            super.copy(src);
            this.MoveHook = src.MoveHook;
            return this;
        }
    }
}

